/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.ColumnSpec;
import org.openconcerto.ui.light.ColumnsSpec;
import org.openconcerto.ui.light.IUserControl;
import org.openconcerto.ui.light.IUserControlContainer;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIContainer;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.Row;
import org.openconcerto.ui.light.TableContent;
import org.openconcerto.ui.light.TableSpec;
import org.openconcerto.utils.io.JSONConverter;

public class LightUITable
extends LightUIElement
implements IUserControlContainer {
    private Boolean dynamicLoad = false;
    private Boolean verticallyScrollable = false;
    private Boolean allowSelection = false;
    private TableSpec tableSpec = null;
    private String elementCode = null;
    private List<ActionListener> selectionListeners = new ArrayList<ActionListener>();
    private int linePerRow = 1;

    public LightUITable(JSONObject json) {
        super(json);
    }

    public LightUITable(LightUITable tableElement) {
        super(tableElement);
        this.verticallyScrollable = tableElement.verticallyScrollable;
        this.tableSpec = tableElement.tableSpec;
        this.elementCode = tableElement.elementCode;
        this.allowSelection = tableElement.allowSelection;
    }

    public LightUITable(String id) {
        super(id);
        this.setType(4);
        this.setWeightX(1);
        this.setFillWidth(true);
    }

    public int getIndexfromRowID(int rowID) {
        TableContent content = this.getTableSpec().getContent();
        int i = 0;
        while (i < content.getRows().size()) {
            Row r = content.getRows().get(i);
            if (r.getId() == (long)rowID) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.tableSpec.setId(id);
        this.tableSpec.getSelection().setTableId(id);
    }

    public String getElementCode() {
        return this.elementCode;
    }

    public void setElementCode(String elementCode) {
        this.elementCode = elementCode;
    }

    public void setLinePerRow(int linePerRow) {
        this.linePerRow = linePerRow;
    }

    public int getLinePerRow() {
        return this.linePerRow;
    }

    public TableSpec getTableSpec() {
        return this.tableSpec;
    }

    public void setTableSpec(TableSpec tableSpec) {
        this.tableSpec = tableSpec;
    }

    public Boolean isAllowSelection() {
        return this.allowSelection;
    }

    public void setAllowSelection(boolean allowSelection) {
        this.allowSelection = allowSelection;
    }

    public Boolean isDynamicLoad() {
        return this.dynamicLoad;
    }

    public void setDynamicLoad(boolean dynamicLoad) {
        this.dynamicLoad = dynamicLoad;
    }

    public Boolean isVerticallyScrollable() {
        return this.verticallyScrollable;
    }

    public void setVerticallyScrollable(Boolean verticallyScrollable) {
        this.verticallyScrollable = verticallyScrollable;
    }

    public boolean replaceChild(LightUIElement pChild) {
        List<Row> tableRows = this.getTableSpec().getContent().getRows();
        int tableRowsCount = tableRows.size();
        pChild.setReadOnly(this.isReadOnly());
        int i = 0;
        while (i < tableRowsCount) {
            Row tableRow = tableRows.get(i);
            List<Object> tableRowValues = tableRow.getValues();
            int tableRowValuesCount = tableRowValues.size();
            int j = 0;
            while (j < tableRowValuesCount) {
                Object tableRowValue = tableRowValues.get(j);
                if (tableRowValue instanceof LightUIElement) {
                    LightUIElement child = (LightUIElement)tableRowValue;
                    if (child.getId().equals(pChild.getId())) {
                        tableRowValues.set(i, pChild);
                        child.setParent(this);
                        return true;
                    }
                    if (child instanceof LightUIContainer && ((LightUIContainer)child).replaceChild(pChild)) {
                        return true;
                    }
                    if (child instanceof LightUITable && ((LightUITable)child).replaceChild(pChild)) {
                        return true;
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public LightUIElement findElement(String searchParam, boolean byUUID) {
        return this.findElement(searchParam, byUUID, LightUIElement.class);
    }

    public <T extends LightUIElement> T findElement(String searchParam, boolean byUUID, Class<T> objectClass) {
        if (this.tableSpec != null) {
            TableContent content = this.tableSpec.getContent();
            if (content != null) {
                List<Row> listRows = content.getRows();
                if (listRows != null) {
                    for (Row row : listRows) {
                        List<Object> rowValues = row.getValues();
                        for (Object value : rowValues) {
                            T resultElement;
                            if (value instanceof LightUIContainer) {
                                LightUIContainer panel = (LightUIContainer)value;
                                T element = panel.findChild(searchParam, byUUID, objectClass);
                                if (element == null) continue;
                                return element;
                            }
                            if (!(value instanceof LightUIElement)) continue;
                            LightUIElement element = (LightUIElement)value;
                            if (byUUID) {
                                if (element.getUUID().equals(searchParam)) {
                                    if (objectClass.isAssignableFrom(element.getClass())) {
                                        return (T)((LightUIElement)objectClass.cast(element));
                                    }
                                    throw new IllegalArgumentException("Element found at is not an instance of " + objectClass.getName() + ", element class: " + element.getClass().getName() + " element ID: " + element.getId());
                                }
                            } else if (element.getId().equals(searchParam)) {
                                if (objectClass.isAssignableFrom(element.getClass())) {
                                    return (T)((LightUIElement)objectClass.cast(element));
                                }
                                throw new IllegalArgumentException("Element found at is not an instance of " + objectClass.getName() + ", element class: " + element.getClass().getName() + " element ID: " + element.getId());
                            }
                            if (!(element instanceof LightUITable) || (resultElement = ((LightUITable)element).findElement(searchParam, byUUID, objectClass)) == null) continue;
                            return resultElement;
                        }
                    }
                } else {
                    System.out.println("LightUITable.getElementById() - No rows for table: " + this.getId());
                }
            } else {
                System.out.println("LightUITable.getElementById() - Null TableContent for table: " + this.getId());
            }
        } else {
            System.out.println("LightUITable.getElementById() - Null TableSpec for table: " + this.getId());
        }
        return null;
    }

    public void addSelectionListener(ActionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListeners() {
        this.selectionListeners.clear();
    }

    public void fireSelectionChange() {
        for (ActionListener listener : this.selectionListeners) {
            listener.actionPerformed(new ActionEvent(this, 1, "selection"));
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        List<Row> rows = this.tableSpec.getContent().getRows();
        if (rows != null) {
            int rowCount = rows.size();
            int i = 0;
            while (i < rowCount) {
                Row row = rows.get(i);
                List<Object> values = row.getValues();
                for (Object value : values) {
                    if (value == null || !(value instanceof LightUIElement)) continue;
                    ((LightUIElement)value).setReadOnly(readOnly);
                }
                ++i;
            }
        }
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUITable(json);
            }
        };
    }

    @Override
    public void setValueFromContext(Object value) {
        if (value != null) {
            JSONArray jsonContext = JSONConverter.getObjectFromJSON(value, JSONArray.class);
            ColumnsSpec columnsSpec = this.getTableSpec().getColumns();
            int columnsCount = columnsSpec.getColumnCount();
            ArrayList<Integer> editorsIndex = new ArrayList<Integer>();
            int i = 0;
            while (i < columnsCount) {
                ColumnSpec columnSpec = columnsSpec.getColumn(i);
                if (columnSpec.getEditor() != null) {
                    editorsIndex.add(i);
                }
                ++i;
            }
            TableContent tableContent = this.getTableSpec().getContent();
            if (tableContent != null) {
                List<Row> rows = tableContent.getRows();
                int i2 = 0;
                while (i2 < rows.size()) {
                    Row row = rows.get(i2);
                    JSONObject jsonLineContext = JSONConverter.getObjectFromJSON(jsonContext.get(i2), JSONObject.class);
                    Long rowId = JSONConverter.getParameterFromJSON(jsonLineContext, "row.id", Long.class);
                    String rowExtendId = JSONConverter.getParameterFromJSON(jsonLineContext, "row.extend.id", String.class);
                    if (rowId.longValue() == row.getId() && (row.getExtendId() == null || row.getExtendId() != null && rowExtendId.equals(row.getExtendId()))) {
                        if (row.isFillWidth().booleanValue()) {
                            LightUIElement element;
                            if (!row.getValues().isEmpty() && row.getValues().get(0) instanceof IUserControl && (element = (LightUIElement)row.getValues().get(0)) instanceof IUserControl) {
                                if (jsonLineContext.containsKey(element.getUUID())) {
                                    ((IUserControl)((Object)element)).setValueFromContext(jsonLineContext.get(element.getUUID()));
                                } else {
                                    System.out.println("LightUITable.setValueFromContext() - Unable to find element : id - " + element.getId() + " uuid - " + element.getUUID());
                                    System.out.println("LightUITable.setValueFromContext() - In JSON                : " + jsonLineContext.toJSONString());
                                }
                            }
                        } else {
                            int k = 0;
                            while (k < editorsIndex.size()) {
                                Object objEditor = row.getValues().get((Integer)editorsIndex.get(k));
                                if (!(objEditor instanceof IUserControl)) {
                                    throw new IllegalArgumentException("Impossible to find editor for row: " + rowId.toString() + " at position: " + String.valueOf(k));
                                }
                                LightUIElement editor = (LightUIElement)objEditor;
                                if (!(editor instanceof IUserControl) || !jsonLineContext.containsKey(editor.getUUID())) {
                                    throw new IllegalArgumentException("Impossible to find value for editor: " + editor.getId() + " for row: " + rowId.toString() + " at position: " + String.valueOf(k));
                                }
                                ((IUserControl)((Object)editor)).setValueFromContext(jsonLineContext.get(editor.getUUID()));
                                ++k;
                            }
                        }
                    } else {
                        throw new IllegalArgumentException("Impossible to find row: " + rowId.toString());
                    }
                    ++i2;
                }
            }
        }
    }

    @Override
    public LightUIElement clone() {
        return new LightUITable(this);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.allowSelection.booleanValue()) {
            json.put("allow-selection", true);
        }
        if (this.dynamicLoad.booleanValue()) {
            json.put("dynamic-load", true);
        }
        if (this.verticallyScrollable.booleanValue()) {
            json.put("vertically-scrollable", true);
        }
        if (this.tableSpec != null) {
            json.put("table-spec", this.tableSpec.toJSON());
        }
        if (this.elementCode != null) {
            json.put("element-code", this.elementCode);
        }
        json.put("line-per-row", this.linePerRow);
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.allowSelection = JSONConverter.getParameterFromJSON(json, "allow-selection", Boolean.class, false);
        this.dynamicLoad = JSONConverter.getParameterFromJSON(json, "dynamic-load", Boolean.class, false);
        this.verticallyScrollable = JSONConverter.getParameterFromJSON(json, "vertically-scrollable", Boolean.class, false);
        this.elementCode = JSONConverter.getParameterFromJSON(json, "element-code", String.class);
        this.linePerRow = JSONConverter.getParameterFromJSON(json, "line-per-row", Integer.class);
        JSONObject jsonRawContent = JSONConverter.getParameterFromJSON(json, "table-spec", JSONObject.class);
        if (jsonRawContent != null) {
            this.tableSpec = new TableSpec(jsonRawContent);
        }
    }
}

