/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIImage;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.utils.io.HTMLable;

public class LightUIStrippedImageLine
extends LightUILine
implements HTMLable {
    private static final long serialVersionUID = 4132718509484530455L;
    private List<LightUIImage> images = new ArrayList<LightUIImage>(0);

    public LightUIStrippedImageLine(List<LightUIImage> images) {
        this.images = images;
        for (LightUIImage image : images) {
            this.addChild(image);
        }
    }

    public LightUIStrippedImageLine(JSONObject json) {
        super(json);
    }

    public LightUIStrippedImageLine(LightUIStrippedImageLine line) {
        super(line);
    }

    @Override
    public LightUIElement clone() {
        return new LightUIStrippedImageLine(this);
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIStrippedImageLine)) {
            throw new InvalidClassException(this.getClassName(), element.getClassName(), element.getId());
        }
        LightUIStrippedImageLine line = (LightUIStrippedImageLine)element;
        this.images = line.images;
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIStrippedImageLine(json);
            }
        };
    }

    @Override
    public String getHTML() {
        StringBuilder b = new StringBuilder();
        for (LightUIImage image : this.images) {
            b.append("<img src=\"");
            b.append(image.getValue());
            b.append("\" ");
            if (image.getWidth() != null) {
                b.append("width=\"");
                b.append(image.getWidth());
                b.append("\" ");
            }
            if (image.getHeight() != null) {
                b.append("height=\"");
                b.append(image.getHeight());
                b.append("\" ");
            }
            if (this.getElementMargin() != null && this.getElementMargin() > 0) {
                b.append("style=\"margin:");
                b.append(this.getElementMargin());
                b.append("px \" ");
            }
            b.append("/> ");
        }
        return b.toString();
    }
}

