/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.awt.Color;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.IUserControl;
import org.openconcerto.ui.light.IUserControlContainer;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightControler;
import org.openconcerto.ui.light.LightUIContainer;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;

public class LightUIPanel
extends LightUIContainer
implements IUserControlContainer,
Transferable {
    private static final long serialVersionUID = -3399395824294128572L;
    private String title;
    private boolean verticallyScrollable = false;
    private Color titleColor;
    private Color titleBackgroundColor;
    private final List<LightControler> controlers = new ArrayList<LightControler>();

    public LightUIPanel(JSONObject json) {
        super(json);
    }

    public LightUIPanel(LightUIPanel panelElement) {
        super(panelElement);
    }

    public LightUIPanel(String id) {
        super(id);
        this.setType(8);
        this.setWeightX(1);
        this.setFillWidth(true);
    }

    public final LightUILine getLastLine() {
        int childCount = this.getChildrenCount();
        if (childCount == 0) {
            LightUILine l = new LightUILine();
            this.addChild(l);
            return l;
        }
        return this.getChild(childCount - 1, LightUILine.class);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isVerticallyScrollable() {
        return this.verticallyScrollable;
    }

    public void setVerticallyScrollable(boolean verticallyScrollable) {
        this.verticallyScrollable = verticallyScrollable;
    }

    public void setTitleColor(Color c) {
        this.titleColor = c;
    }

    public void setTitleBackgoundColor(Color c) {
        this.titleBackgroundColor = c;
    }

    public void addControler(LightControler controler) {
        this.controlers.add(controler);
    }

    public List<LightControler> getControlers() {
        return this.controlers;
    }

    public void dumpControllers(PrintStream out) {
        this.dumpControllers(out, 0);
    }

    public void dumpControllers(PrintStream out, int depth) {
        this.addSpacer(out, depth);
        out.println("Contollers for id:" + this.getId() + " title: " + this.title);
        for (LightControler controler : this.controlers) {
            this.addSpacer(out, depth);
            out.println(controler);
        }
        int lineCount = this.getChildrenCount();
        this.addSpacer(out, depth);
        out.println(String.valueOf(this.getId()) + " : " + this.title);
        this.addSpacer(out, depth);
        out.println("LightUIPanel " + lineCount + " lines ");
        int i = 0;
        while (i < lineCount) {
            LightUILine line = this.getChild(i, LightUILine.class);
            int j = 0;
            while (j < line.getChildrenCount()) {
                LightUIElement e = line.getChild(j);
                if (e instanceof LightUIPanel) {
                    ((LightUIPanel)e).dumpControllers(out, depth + 1);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIPanel)) {
            throw new InvalidClassException(LightUIPanel.class.getName(), element.getClassName(), element.getId());
        }
        LightUIPanel panelElement = (LightUIPanel)element;
        this.title = panelElement.title;
        this.verticallyScrollable = panelElement.verticallyScrollable;
        this.titleColor = panelElement.titleColor;
        this.titleBackgroundColor = panelElement.titleBackgroundColor;
        this.controlers.addAll(panelElement.controlers);
    }

    @Override
    public void clear() {
        super.clear();
        this.controlers.clear();
    }

    @Override
    public void addChild(LightUIElement line) {
        if (!(line instanceof LightUILine)) {
            throw new IllegalArgumentException("Only LightUILine are accepted in LightUIPanel");
        }
        line.setId(LightUILine.createId(this));
        super.addChild(line);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        int lineCount = this.getChildrenCount();
        int i = 0;
        while (i < lineCount) {
            LightUILine line = this.getChild(i, LightUILine.class);
            line.setReadOnly(readOnly);
            ++i;
        }
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIPanel(json);
            }
        };
    }

    @Override
    public void dump(PrintStream out, int depth) {
        this.addSpacer(out, depth);
        out.println("------LightUIPanel-----");
        this.addSpacer(out, depth);
        out.println("Title : " + this.title);
        this.addSpacer(out, depth);
        out.println("v-scroll : " + this.verticallyScrollable + " title-color: " + this.titleColor.toString() + " bg-title-color: " + this.titleBackgroundColor.toString());
        super.dump(out, depth);
        this.addSpacer(out, depth);
        out.println("------------------------");
    }

    @Override
    public void setValueFromContext(Object value) {
        JSONObject jsonContext = JSONConverter.getObjectFromJSON(value, JSONObject.class);
        int childCount = this.getChildrenCount();
        int i = 0;
        while (i < childCount) {
            LightUILine line = this.getChild(i, LightUILine.class);
            int lineChildCount = line.getChildrenCount();
            int j = 0;
            while (j < lineChildCount) {
                LightUIElement lineChild = line.getChild(j);
                if (lineChild instanceof IUserControlContainer) {
                    if (!jsonContext.containsKey(lineChild.getUUID())) {
                        throw new IllegalArgumentException("Impossible to find key " + lineChild.getUUID() + " in context, LightUIElement id: " + lineChild.getId());
                    }
                    ((IUserControlContainer)((Object)lineChild)).setValueFromContext(jsonContext.get(lineChild.getUUID()));
                } else if (lineChild instanceof IUserControl) {
                    if (!jsonContext.containsKey(lineChild.getUUID())) {
                        throw new IllegalArgumentException("Impossible to find key " + lineChild.getUUID() + " in context, LightUIElement id: " + lineChild.getId());
                    }
                    ((IUserControl)((Object)lineChild)).setValueFromContext(jsonContext.get(lineChild.getUUID()));
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public LightUIElement clone() {
        return new LightUIPanel(this);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = super.toJSON();
        if (this.title != null) {
            result.put("title", this.title);
        }
        if (this.titleColor != null) {
            result.put("title-color", JSONConverter.getJSON(this.titleColor));
        }
        if (this.titleBackgroundColor != null) {
            result.put("title-bgcolor", JSONConverter.getJSON(this.titleBackgroundColor));
        }
        if (this.verticallyScrollable) {
            result.put("vertically-scrollable", true);
        }
        if (!this.controlers.isEmpty()) {
            result.put("controlers", JSONConverter.getJSON(this.controlers));
        }
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.title = JSONConverter.getParameterFromJSON(json, "title", String.class, null);
        this.verticallyScrollable = JSONConverter.getParameterFromJSON(json, "vertically-scrollable", Boolean.class, false);
        this.titleColor = JSONConverter.getParameterFromJSON(json, "title-color", Color.class, null);
        this.titleBackgroundColor = JSONConverter.getParameterFromJSON(json, "title-bgcolor", Color.class, null);
        JSONArray jsonControlers = JSONConverter.getParameterFromJSON(json, "controlers", JSONArray.class);
        if (jsonControlers != null) {
            int controlersSize = jsonControlers.size();
            int i = 0;
            while (i < controlersSize) {
                JSONObject jsonControler = JSONConverter.getObjectFromJSON(jsonControlers.get(i), JSONObject.class);
                this.controlers.add(new LightControler(jsonControler));
                ++i;
            }
        }
    }

    @Override
    public void setFoldable(boolean foldable) {
        super.setFoldable(foldable);
        if (foldable && this.title == null) {
            this.title = "missing title on panel " + this.getId();
        }
    }
}

