/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.ui.StringWithId;

public class LightUIList
extends LightUIElement {
    private ArrayList<StringWithId> values = new ArrayList();

    public LightUIList(JSONObject json) {
        super(json);
    }

    public LightUIList(LightUIList listElement) {
        super(listElement);
        this.values = listElement.values;
    }

    public LightUIList(String id, ArrayList<StringWithId> values) {
        super(id);
        this.setType(11);
        this.values = values;
    }

    public List<StringWithId> getValues() {
        return CollectionUtils.castList((List)this.values.clone(), StringWithId.class);
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIList(json);
            }
        };
    }

    @Override
    public LightUIElement clone() {
        return new LightUIList(this);
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIList)) {
            throw new InvalidClassException(this.getClassName(), element.getClassName(), element.getId());
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put("class", "LightUIList");
        if (this.values != null && this.values.size() > 0) {
            json.put("values", this.values);
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        JSONArray jsonValues = JSONConverter.getParameterFromJSON(json, "values", JSONArray.class);
        this.values = new ArrayList();
        if (jsonValues != null) {
            for (Object jsonValue : jsonValues) {
                if (!(jsonValue instanceof JSONObject)) {
                    throw new IllegalArgumentException("values of list must be json of StringWithId");
                }
                this.values.add(new StringWithId((JSONObject)jsonValue));
            }
        }
    }
}

