/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.LightUIContainer;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;

public class LightUILine
extends LightUIContainer
implements Transferable {
    private static final long serialVersionUID = 4132718509484530435L;
    public static final int ALIGN_GRID = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    private int gridAlignment = 0;
    private Integer elementPadding;
    private Integer elementMargin;

    public LightUILine() {
        super("");
        this.setType(16);
    }

    public LightUILine(JSONObject json) {
        super(json);
    }

    public LightUILine(LightUILine line) {
        super(line);
    }

    public void setElementPadding(Integer elementPadding) {
        this.elementPadding = elementPadding;
    }

    public Integer getElementPadding() {
        return this.elementPadding;
    }

    public void setElementMargin(Integer elementMargin) {
        this.elementMargin = elementMargin;
    }

    public Integer getElementMargin() {
        return this.elementMargin;
    }

    public int getGridAlignment() {
        return this.gridAlignment;
    }

    public void setGridAlignment(int gridAlignment) {
        this.gridAlignment = gridAlignment;
    }

    @Override
    public Integer getHeight() {
        Integer h = 0;
        int size = this.getChildrenCount();
        int i = 0;
        while (i < size) {
            h = h + this.getChild(i).getHeight();
            ++i;
        }
        return h;
    }

    @Override
    public Integer getWidth() {
        Integer w = 0;
        int size = this.getChildrenCount();
        int i = 0;
        while (i < size) {
            w = w + this.getChild(i).getGridWidth();
            ++i;
        }
        return w;
    }

    public static String createId(LightUIPanel parent) {
        return String.valueOf(parent.getId()) + ".line." + parent.getChildrenCount();
    }

    @Override
    public LightUIElement clone() {
        return new LightUILine(this);
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUILine)) {
            throw new InvalidClassException(this.getClassName(), element.getClassName(), element.getId());
        }
        LightUILine line = (LightUILine)element;
        this.elementMargin = line.elementMargin;
        this.elementPadding = line.elementPadding;
        this.gridAlignment = line.gridAlignment;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = super.toJSON();
        result.put("class", "LightUILine");
        if (this.elementPadding != null) {
            result.put("element-padding", this.elementPadding);
        }
        if (this.elementMargin != null) {
            result.put("element-margin", this.elementMargin);
        }
        if (this.gridAlignment != 0) {
            result.put("grid-alignment", this.gridAlignment);
        }
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.elementPadding = JSONConverter.getParameterFromJSON(json, "element-padding", Integer.class);
        this.elementMargin = JSONConverter.getParameterFromJSON(json, "element-margin", Integer.class);
        this.gridAlignment = JSONConverter.getParameterFromJSON(json, "grid-alignment", Integer.class, 0);
    }
}

