/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIContainer;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIFrame
extends LightUIContainer {
    private Boolean active = false;
    private String title;
    private final LightUIPanel footerPanel = new LightUIPanel(String.valueOf(this.getId()) + ".footer.panel");
    private List<LightUIFrame> childrenFrame;

    public LightUIFrame(JSONObject json) {
        super(json);
    }

    public LightUIFrame(LightUIFrame frame) {
        super(frame);
        this.active = frame.active;
        this.title = frame.title;
        this.footerPanel.copy(frame.footerPanel);
        this.childrenFrame = frame.childrenFrame;
    }

    public LightUIFrame(String id) {
        super(id);
        this.setType(13);
        this.childrenFrame = new ArrayList<LightUIFrame>();
        this.addChild(new LightUIPanel(String.valueOf(this.getId()) + ".main.panel"));
        this.footerPanel.setParent(this);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LightUIPanel getFooterPanel() {
        return this.footerPanel;
    }

    public void updateFooterPanel(LightUIPanel footerPanel) {
        if (footerPanel != null) {
            this.footerPanel.copy(footerPanel);
        } else {
            this.footerPanel.clear();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getPanelId() {
        return String.valueOf(this.getId()) + ".main.panel";
    }

    public void removeChildFrame(LightUIFrame childFrame) {
        this.childrenFrame.remove(childFrame);
    }

    public void removeChildFrame(int index) {
        this.childrenFrame.remove(index);
    }

    public void clearChildrenFrame() {
        this.childrenFrame.clear();
    }

    @Override
    public void setParent(LightUIElement parent) {
        if (!(parent instanceof LightUIFrame)) {
            throw new InvalidClassException(LightUIFrame.class.getName(), parent.getClassName(), parent.getId());
        }
        super.setParent(parent);
        ((LightUIFrame)parent).childrenFrame.add(this);
    }

    @Override
    public <T extends LightUIElement> T findChild(String searchParam, boolean byUUID, Class<T> childClass) {
        T result = super.findChild(searchParam, byUUID, childClass);
        if (result != null) {
            return result;
        }
        return this.footerPanel.findChild(searchParam, byUUID, childClass);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.footerPanel.setReadOnly(readOnly);
    }

    @Override
    public void addChild(LightUIElement child) throws InvalidClassException {
        if (!(child instanceof LightUIPanel)) {
            throw new InvalidClassException(LightUIPanel.class.getName(), child.getClassName(), child.getId());
        }
        child.setId(this.getPanelId());
        this.clear();
        super.addChild(child);
    }

    @Override
    public void insertChild(int index, LightUIElement child) throws InvalidClassException {
        if (!(child instanceof LightUIPanel)) {
            throw new InvalidClassException(LightUIPanel.class.getName(), child.getClassName(), child.getId());
        }
        child.setId(this.getPanelId());
        this.clear();
        super.insertChild(index, child);
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIFrame(json);
            }
        };
    }

    @Override
    public void dump(PrintStream out, int depth) {
        out.println("------------- LightUIFrame -------------");
        super.dump(out, 0);
        out.println("footer-panel: ");
        if (this.footerPanel != null) {
            this.footerPanel.dump(out, 0);
        } else {
            out.println("null");
        }
        out.println("--------------------------");
    }

    @Override
    public LightUIElement clone() {
        LightUIFrame clone = new LightUIFrame(this);
        clone.getFooterPanel().setParent(clone);
        return clone;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.active.booleanValue()) {
            json.put("active", true);
        }
        if (this.title != null) {
            json.put("title", this.title);
        }
        json.put("footer-panel", this.footerPanel.toJSON());
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.active = JSONConverter.getParameterFromJSON(json, "active", Boolean.class, false);
        this.title = JSONConverter.getParameterFromJSON(json, "title", String.class);
        JSONObject jsonFooterPanel = JSONConverter.getParameterFromJSON(json, "footer-panel", JSONObject.class, null);
        if (jsonFooterPanel != null) {
            this.footerPanel.fromJSON(jsonFooterPanel);
        }
        JSONArray jsonChildrenFrame = JSONConverter.getParameterFromJSON(json, "children-frame", JSONArray.class, null);
        this.childrenFrame = new ArrayList<LightUIFrame>();
        if (jsonChildrenFrame != null) {
            for (Object objJsonFrame : jsonChildrenFrame) {
                JSONObject jsonFrame = JSONConverter.getObjectFromJSON(objJsonFrame, JSONObject.class);
                LightUIFrame childFrame = new LightUIFrame(jsonFrame);
                this.childrenFrame.add(childFrame);
            }
        }
    }
}

