/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertorManager;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUITable;
import org.openconcerto.utils.io.JSONConverter;

public abstract class LightUIContainer
extends LightUIElement {
    private List<LightUIElement> children;

    public LightUIContainer(String id) {
        super(id);
        this.children = new ArrayList<LightUIElement>();
    }

    public LightUIContainer(JSONObject json) {
        super(json);
    }

    public LightUIContainer(LightUIContainer container) {
        super(container);
    }

    public void addChild(LightUIElement child) {
        if (child == null) {
            throw new IllegalArgumentException("Attempt to put null child in container, id:" + this.getId());
        }
        child.setReadOnly(this.isReadOnly());
        child.setParent(this);
        this.children.add(child);
    }

    public void insertChild(int index, LightUIElement child) {
        if (child == null) {
            throw new IllegalArgumentException("Attempt to put null child in container, id:" + this.getId());
        }
        child.setReadOnly(this.isReadOnly());
        child.setParent(this);
        this.children.add(index, child);
    }

    public void removeChild(LightUIElement child) {
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public void removeChild(int index) {
        if (this.children != null) {
            this.children.remove(index);
        }
    }

    public LightUIElement getChild(int index) {
        return this.getChild(index, LightUIElement.class);
    }

    public <T extends LightUIElement> T getChild(int index, Class<T> expectedClass) {
        if (this.children != null) {
            return (T)((LightUIElement)expectedClass.cast(this.children.get(index)));
        }
        return null;
    }

    public <T extends LightUIElement> T getFirstChild(Class<T> expectedClass) {
        if (this.getChildrenCount() > 0) {
            return (T)((LightUIElement)expectedClass.cast(this.children.get(0)));
        }
        return null;
    }

    public int getChildrenCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    public void clear() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public boolean replaceChild(LightUIElement pChild) {
        int childCount = this.getChildrenCount();
        pChild.setReadOnly(this.isReadOnly());
        int i = 0;
        while (i < childCount) {
            LightUIElement child = this.children.get(i);
            if (child.getId().equals(pChild.getId())) {
                this.children.set(i, pChild);
                child.setParent(this);
                return true;
            }
            if (child instanceof LightUIContainer && ((LightUIContainer)child).replaceChild(pChild)) {
                return true;
            }
            if (child instanceof LightUITable && ((LightUITable)child).replaceChild(pChild)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public LightUIElement findChild(String searchParam, boolean byUUID) {
        return this.findChild(searchParam, byUUID, LightUIElement.class);
    }

    public <T extends LightUIElement> T findChild(String searchParam, boolean byUUID, Class<T> expectedClass) {
        int childCount = this.getChildrenCount();
        Object result = null;
        int i = 0;
        while (i < childCount) {
            LightUIElement child = this.getChild(i);
            if (byUUID) {
                if (child.getUUID().equals(searchParam)) {
                    result = child;
                    break;
                }
            } else if (child.getId().equals(searchParam)) {
                result = child;
                break;
            }
            if (child instanceof LightUIContainer && (result = ((LightUIContainer)child).findChild(searchParam, byUUID, expectedClass)) != null || child instanceof LightUITable && (result = ((LightUITable)child).findElement(searchParam, byUUID, expectedClass)) != null) break;
            ++i;
        }
        if (result != null) {
            if (expectedClass.isAssignableFrom(result.getClass())) {
                return (T)((LightUIElement)expectedClass.cast(result));
            }
            throw new InvalidClassException(expectedClass.getName(), result.getClass().getName(), ((LightUIElement)result).getId());
        }
        return null;
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIContainer)) {
            throw new InvalidClassException(LightUIContainer.class.getName(), element.getClassName(), element.getId());
        }
        this.clear();
        LightUIContainer container = (LightUIContainer)element;
        this.children = new ArrayList<LightUIElement>(container.children);
        for (LightUIElement child : this.children) {
            child.setParent(this);
        }
    }

    @Override
    public void dump(PrintStream out, int depth) {
        super.dump(out, depth);
        for (LightUIElement child : this.children) {
            child.dump(out, depth + 1);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        int childCount = this.getChildrenCount();
        int i = 0;
        while (i < childCount) {
            LightUIElement child = this.getChild(i);
            child.setReadOnly(readOnly);
            ++i;
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = super.toJSON();
        if (this.children == null || !this.children.isEmpty()) {
            result.put("childs", JSONConverter.getJSON(this.children));
        }
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.clear();
        JSONArray jsonElements = JSONConverter.getParameterFromJSON(json, "childs", JSONArray.class);
        this.children = new ArrayList<LightUIElement>();
        if (jsonElements != null) {
            for (Object o : jsonElements) {
                JSONObject jsonElement = JSONConverter.getObjectFromJSON(o, JSONObject.class);
                if (jsonElement == null) {
                    throw new IllegalArgumentException("null element in json parameter");
                }
                LightUIElement lightElement = JSONToLightUIConvertorManager.getInstance().createUIElementFromJSON(jsonElement);
                this.children.add(lightElement);
            }
        }
    }
}

