/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.IUserControl;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIComboBoxElement;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.utils.i18n.TranslationManager;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIComboBox
extends LightUIElement
implements IUserControl {
    public static final int TYPE_COMBO_STANDARD = 1;
    public static final int TYPE_COMBO_AUTOCOMPLETE = 2;
    public static final int TYPE_COMBO_AUTOCOMPLETE_WITH_ACTION = 3;
    public static final int COMBO_ACTION_SEARCH = 1;
    public static final int COMBO_ACTION_ADD = 2;
    public static final int COMBO_ACTION_MODIFY = 3;
    private int comboType = 1;
    private boolean alreadyFill = false;
    private boolean hasNotSpecifedLine = false;
    private List<LightUIComboBoxElement> values = new ArrayList<LightUIComboBoxElement>();
    private LightUIComboBoxElement selectedValue = null;
    private List<Integer> comboActions = new ArrayList<Integer>();

    public LightUIComboBox(JSONObject json) {
        super(json);
    }

    public LightUIComboBox(LightUIComboBox combo) {
        super(combo);
    }

    public LightUIComboBox(String id) {
        super(id);
        this.setType(3);
    }

    public int getComboType() {
        return this.comboType;
    }

    public void setComboType(int comboType) {
        this.comboType = comboType;
    }

    public void addValue(LightUIComboBoxElement values) {
        this.values.add(values);
    }

    public void addValues(List<LightUIComboBoxElement> values) {
        this.values.addAll(values);
    }

    public List<Integer> getComboActions() {
        return this.comboActions;
    }

    public void addComboAction(Integer comboAction) {
        this.comboActions.add(comboAction);
    }

    public static LightUIComboBoxElement getDefaultValue() {
        String defaultLabelKey = "not.specified.label";
        String defaultLabel = TranslationManager.getInstance().getTranslationForItem("not.specified.label");
        LightUIComboBoxElement defaultElement = new LightUIComboBoxElement(0);
        if (defaultLabel != null) {
            defaultElement.setValue1(defaultLabel);
        } else {
            defaultElement.setValue1("not.specified.label");
        }
        return defaultElement;
    }

    public List<LightUIComboBoxElement> getValues() {
        return this.values;
    }

    public boolean hasSelectedValue() {
        return this.selectedValue != null && this.selectedValue.getId() != 0;
    }

    public LightUIComboBoxElement getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(LightUIComboBoxElement selectedValue) {
        this.selectedValue = selectedValue;
    }

    public void clearValues() {
        this.selectedValue = null;
        this.values.clear();
    }

    public void setAlreadyFill(boolean alreadyFill) {
        this.alreadyFill = alreadyFill;
    }

    public boolean isAlreadyFill() {
        return this.alreadyFill;
    }

    public void setHasNotSpecifedLine(boolean hasNotSpecifedLine) {
        this.hasNotSpecifedLine = hasNotSpecifedLine;
    }

    public boolean hasNotSpecifedLine() {
        return this.hasNotSpecifedLine;
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIComboBox)) {
            throw new InvalidClassException(this.getClassName(), element.getClassName(), element.getId());
        }
        LightUIComboBox combo = (LightUIComboBox)element;
        this.comboType = combo.comboType;
        this.alreadyFill = combo.alreadyFill;
        this.values = combo.values;
        this.selectedValue = combo.selectedValue;
        this.comboActions = combo.comboActions;
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIComboBox(json);
            }
        };
    }

    @Override
    public LightUIElement clone() {
        return new LightUIComboBox(this);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.values != null && this.values.size() > 0) {
            JSONArray jsonValues = new JSONArray();
            for (LightUIComboBoxElement value : this.values) {
                jsonValues.add(value.toJSON());
            }
            json.put("values", jsonValues);
        }
        if (this.comboType != 1) {
            json.put("combo-type", this.comboType);
        }
        if (this.alreadyFill) {
            json.put("already-fill", true);
        }
        if (this.selectedValue != null) {
            json.put("selected-value", this.selectedValue.toJSON());
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.comboType = JSONConverter.getParameterFromJSON(json, "combo-type", Integer.class, 1);
        this.alreadyFill = JSONConverter.getParameterFromJSON(json, "already-fill", Boolean.class, false);
        JSONObject jsonSelectedValue = JSONConverter.getParameterFromJSON(json, "", JSONObject.class);
        if (jsonSelectedValue != null) {
            this.selectedValue = new LightUIComboBoxElement(jsonSelectedValue);
        }
        JSONArray jsonValues = JSONConverter.getParameterFromJSON(json, "values", JSONArray.class);
        this.values = new ArrayList<LightUIComboBoxElement>();
        if (jsonValues != null) {
            for (Object jsonValue : jsonValues) {
                if (!(jsonValue instanceof JSONObject)) {
                    throw new IllegalArgumentException("value for 'values' is invalid");
                }
                this.values.add(new LightUIComboBoxElement((JSONObject)jsonValue));
            }
        }
    }

    @Override
    public Object getValueFromContext() {
        if (this.hasSelectedValue()) {
            return this.getSelectedValue();
        }
        return null;
    }

    @Override
    public void setValueFromContext(Object value) {
        if (value != null) {
            JSONObject jsonSelectedValue = JSONConverter.getObjectFromJSON(value, JSONObject.class);
            this.selectedValue = new LightUIComboBoxElement(jsonSelectedValue);
        } else {
            this.selectedValue = null;
        }
    }
}

