/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.utils.convertor.ValueConvertor;

public abstract class ComboValueConvertor<K>
implements ValueConvertor<K, String> {
    private boolean hasNotSpecifedLine = false;
    protected Map<K, String> values = new LinkedHashMap<K, String>();

    public ComboValueConvertor() {
        this.init();
    }

    public ComboValueConvertor(boolean hasNotSpecifedLine) {
        this.hasNotSpecifedLine = hasNotSpecifedLine;
        this.init();
    }

    protected abstract void init();

    public boolean hasNotSpecifiedLine() {
        return this.hasNotSpecifedLine;
    }

    public void fillCombo(LightUIComboBox combo) {
        if (this.hasNotSpecifedLine) {
            combo.addValue(LightUIComboBox.getDefaultValue());
        }
        this.fillComboWithValue(combo);
        combo.setAlreadyFill(true);
    }

    protected abstract void fillComboWithValue(LightUIComboBox var1);

    @Override
    public String convert(K key) {
        if (key == null) {
            return null;
        }
        return this.values.get(key);
    }

    @Override
    public K unconvert(String value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<K, String> entry : this.values.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }
}

