/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.jdom2.Document;
import org.jdom2.Element;
import org.openconcerto.ui.light.ColumnSpec;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;

public class ColumnsSpec
implements Externalizable,
Transferable {
    private String id;
    private List<ColumnSpec> columns = new ArrayList<ColumnSpec>();
    private List<String> possibleColumnIds = new ArrayList<String>();
    private List<String> sortedIds = new ArrayList<String>();
    private int fixedColumns;
    private Boolean adaptWidth = false;
    private Boolean allowMove = false;
    private Boolean allowResize = false;

    public ColumnsSpec() {
    }

    public ColumnsSpec(JSONObject json) {
        this.fromJSON(json);
    }

    public ColumnsSpec(String id, List<ColumnSpec> columns, List<String> possibleColumnIds, List<String> sortedIds) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("null id");
        }
        this.id = id;
        if (columns == null) {
            throw new IllegalArgumentException("null columns");
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("empty columns");
        }
        this.columns = columns;
        if (possibleColumnIds == null) {
            throw new IllegalArgumentException("null possible column ids");
        }
        if (possibleColumnIds.isEmpty()) {
            throw new IllegalArgumentException("empty possible column ids");
        }
        this.possibleColumnIds = possibleColumnIds;
        this.sortedIds = sortedIds;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getPossibleColumnIds() {
        return this.possibleColumnIds;
    }

    public List<String> getSortedIds() {
        return this.sortedIds;
    }

    public int getFixedColumns() {
        return this.fixedColumns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public ColumnSpec getColumn(int i) {
        return this.columns.get(i);
    }

    public ColumnSpec setColumn(int i, ColumnSpec column) {
        return this.columns.set(i, column);
    }

    public Boolean isAdaptWidth() {
        return this.adaptWidth;
    }

    public void setAdaptWidth(boolean adaptWidth) {
        this.adaptWidth = adaptWidth;
    }

    public Boolean isAllowMove() {
        return this.allowMove;
    }

    public void setAllowMove(boolean allowMove) {
        this.allowMove = allowMove;
    }

    public Boolean isAllowResize() {
        return this.allowResize;
    }

    public void setAllowResize(boolean allowResize) {
        this.allowResize = allowResize;
    }

    public List<String> getColumnsIds() {
        ArrayList<String> result = new ArrayList<String>(this.columns.size());
        for (ColumnSpec c : this.columns) {
            result.add(c.getId());
        }
        return result;
    }

    public void setUserPrefs(Document columnsPrefs) {
        if (columnsPrefs != null) {
            Element rootElement = columnsPrefs.getRootElement();
            if (!rootElement.getName().equals("list")) {
                throw new IllegalArgumentException("invalid xml, roots node list expected but " + rootElement.getName() + " found");
            }
            List<Element> xmlColumns = rootElement.getChildren();
            int columnsCount = this.columns.size();
            if (xmlColumns.size() == columnsCount) {
                int i = 0;
                while (i < columnsCount) {
                    ColumnSpec columnSpec = this.columns.get(i);
                    String columnId = columnSpec.getId();
                    boolean find = false;
                    int j = 0;
                    while (j < columnsCount) {
                        Element xmlColumn = xmlColumns.get(j);
                        String xmlColumnId = xmlColumn.getAttribute("id").getValue();
                        if (xmlColumnId.equals(columnId)) {
                            if (!xmlColumn.getName().equals("column")) {
                                throw new IllegalArgumentException("ColumnSpec setPrefs - Invalid xml, element node column expected but " + xmlColumn.getName() + " found");
                            }
                            if (xmlColumn.getAttribute("width") == null || xmlColumn.getAttribute("min-width") == null || xmlColumn.getAttribute("max-width") == null) {
                                throw new IllegalArgumentException("ColumnSpec setPrefs - Invalid column node for " + columnId + ", it must have attribute width, min-width, max-width");
                            }
                            int width = Integer.parseInt(xmlColumn.getAttribute("width").getValue());
                            int maxWidth = Integer.parseInt(xmlColumn.getAttribute("max-width").getValue());
                            int minWidth = Integer.parseInt(xmlColumn.getAttribute("min-width").getValue());
                            columnSpec.setPrefs(width, maxWidth, minWidth);
                            if (i != j) {
                                ColumnSpec swap = this.columns.get(i);
                                this.columns.set(i, this.columns.get(j));
                                this.columns.set(j, swap);
                            }
                            find = true;
                            break;
                        }
                        ++j;
                    }
                    if (!find) {
                        System.out.println("XML columns preferences does'nt contain this column: " + columnId);
                    }
                    ++i;
                }
            } else {
                System.out.println("ColumnsSpec.setUserPrefs() - Incorrect columns count in XML for ColumnsSpec: " + this.id);
            }
        }
    }

    public Document createDefaultXmlPref() {
        Element rootElement = new Element("list");
        for (ColumnSpec column : this.columns) {
            Element columnElement = column.createXmlColumnPref();
            rootElement.addContent(columnElement);
        }
        Document xmlConf = new Document(rootElement);
        return xmlConf;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeInt(this.fixedColumns);
        out.writeObject(this.columns);
        out.writeObject(this.possibleColumnIds);
        out.writeObject(this.sortedIds);
        out.writeBoolean(this.allowMove);
        out.writeBoolean(this.allowResize);
        out.writeBoolean(this.adaptWidth);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.fixedColumns = in.readInt();
        this.columns = CollectionUtils.castList((List)in.readObject(), ColumnSpec.class);
        this.possibleColumnIds = CollectionUtils.castList((List)in.readObject(), String.class);
        this.sortedIds = CollectionUtils.castList((List)in.readObject(), String.class);
        this.allowMove = in.readBoolean();
        this.allowResize = in.readBoolean();
        this.adaptWidth = in.readBoolean();
    }

    public List<Object> getDefaultValues() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (ColumnSpec column : this.columns) {
            Object v = column.getDefaultValue();
            l.add(v);
        }
        return l;
    }

    public ColumnSpec getColumn(String id) {
        for (ColumnSpec c : this.columns) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    public ColumnSpec getColumnWithEditor(String id) {
        for (ColumnSpec c : this.columns) {
            LightUIElement editor = c.getEditor();
            if (editor == null || !c.getEditor().getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put("class", "ColumnsSpec");
        result.put("id", this.id);
        result.put("fixed-columns", this.fixedColumns);
        if (this.sortedIds != null && this.sortedIds.size() > 0) {
            result.put("sorted-ids", this.sortedIds);
        }
        if (this.possibleColumnIds != null && this.possibleColumnIds.size() > 0) {
            result.put("possible-column-ids", this.possibleColumnIds);
        }
        if (this.columns != null && this.columns.size() > 0) {
            result.put("columns", JSONConverter.getJSON(this.columns));
        }
        if (this.adaptWidth.booleanValue()) {
            result.put("adapt-width", JSONConverter.getJSON(true));
        }
        if (this.allowMove.booleanValue()) {
            result.put("allow-move", JSONConverter.getJSON(true));
        }
        if (this.allowResize.booleanValue()) {
            result.put("allow-resize", JSONConverter.getJSON(true));
        }
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.id = JSONConverter.getParameterFromJSON(json, "id", String.class);
        this.fixedColumns = JSONConverter.getParameterFromJSON(json, "fixed-columns", Integer.class);
        this.adaptWidth = JSONConverter.getParameterFromJSON(json, "adapt-width", Boolean.class, false);
        this.allowMove = JSONConverter.getParameterFromJSON(json, "allow-move", Boolean.class, false);
        this.allowResize = JSONConverter.getParameterFromJSON(json, "allow-resize", Boolean.class, false);
        this.sortedIds = CollectionUtils.castList(JSONConverter.getParameterFromJSON(json, "sorted-ids", List.class, null), String.class);
        this.possibleColumnIds = CollectionUtils.castList(JSONConverter.getParameterFromJSON(json, "possible-column-ids", List.class, null), String.class);
        List<JSONObject> jsonColumns = CollectionUtils.castList(JSONConverter.getParameterFromJSON(json, "columns", JSONArray.class, null), JSONObject.class);
        if (jsonColumns != null) {
            for (JSONObject jsonColumn : jsonColumns) {
                this.columns.add(new ColumnSpec(jsonColumn));
            }
        }
    }
}

