/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.minidev.json.JSONObject;
import org.jdom2.Element;
import org.openconcerto.ui.light.JSONToLightUIConvertorManager;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;
import org.openconcerto.utils.ui.StringWithId;

public class ColumnSpec
implements Externalizable,
Transferable {
    private String id;
    private Class<?> valueClass;
    private String columnName;
    private Object defaultValue;
    private int width;
    private int maxWidth;
    private int minWidth;
    private boolean editable;
    private LightUIElement editors;

    public ColumnSpec() {
    }

    public ColumnSpec(JSONObject json) {
        this.fromJSON(json);
    }

    public ColumnSpec(String id, Class<?> valueClass, String columnName, Object defaultValue, int width, boolean editable, LightUIElement editors) {
        this.init(id, valueClass, columnName, defaultValue, editable, editors);
        this.width = width;
        int minWidth = width - 200;
        int maxWidth = width + 200;
        this.minWidth = minWidth < 10 ? 10 : minWidth;
        this.maxWidth = maxWidth;
    }

    public ColumnSpec(String id, Class<?> valueClass, String columnName, Object defaultValue, boolean editable, LightUIElement editors) {
        this.init(id, valueClass, columnName, defaultValue, editable, editors);
        this.setDefaultPrefs();
    }

    private void init(String id, Class<?> valueClass, String columnName, Object defaultValue, boolean editable, LightUIElement editors) {
        this.id = id;
        this.valueClass = valueClass;
        this.columnName = columnName;
        this.defaultValue = defaultValue;
        this.editable = editable;
        this.editors = editors;
    }

    public void setPrefs(int width, int maxWidth, int minWidth) {
        this.width = width;
        this.maxWidth = maxWidth;
        this.minWidth = minWidth;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public LightUIElement getEditor() {
        return this.editors;
    }

    public void setEditors(LightUIElement editors) {
        this.editors = editors;
    }

    private void setDefaultPrefs() {
        this.width = 200;
        this.maxWidth = 500;
        this.minWidth = 50;
    }

    public Element createXmlColumnPref() {
        Element columnElement = new Element("column");
        columnElement.setAttribute("id", this.getId());
        columnElement.setAttribute("max-width", String.valueOf(this.getMaxWidth()));
        columnElement.setAttribute("min-width", String.valueOf(this.getMinWidth()));
        columnElement.setAttribute("width", String.valueOf(this.getWidth()));
        return columnElement;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeUTF(this.columnName);
        out.writeInt(this.width);
        out.writeInt(this.maxWidth);
        out.writeInt(this.minWidth);
        out.writeObject(this.defaultValue);
        out.writeBoolean(this.editable);
        out.writeObject(this.editors);
        out.writeObject(this.valueClass);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.columnName = in.readUTF();
        this.width = in.readInt();
        this.maxWidth = in.readInt();
        this.minWidth = in.readInt();
        this.defaultValue = in.readObject();
        this.editable = in.readBoolean();
        this.editors = (LightUIElement)in.readObject();
        this.valueClass = (Class)in.readObject();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put("class", "ColumnSpec");
        result.put("id", this.id);
        result.put("column-name", this.columnName);
        result.put("width", this.width);
        result.put("max-width", this.maxWidth);
        result.put("min-width", this.minWidth);
        if (this.defaultValue != null) {
            result.put("default-value", JSONConverter.getJSON(this.defaultValue));
        }
        if (this.editable) {
            result.put("editable", true);
        }
        if (this.editors != null) {
            result.put("editors", JSONConverter.getJSON(this.editors));
        }
        result.put("value-class", JSONConverter.getJSON(this.valueClass));
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        String sValueClass;
        JSONObject jsonEditors;
        String defaultValueClassName;
        this.id = JSONConverter.getParameterFromJSON(json, "id", String.class);
        this.columnName = JSONConverter.getParameterFromJSON(json, "column-name", String.class);
        this.width = JSONConverter.getParameterFromJSON(json, "width", Integer.class);
        this.maxWidth = JSONConverter.getParameterFromJSON(json, "max-width", Integer.class);
        this.minWidth = JSONConverter.getParameterFromJSON(json, "min-width", Integer.class);
        this.editable = JSONConverter.getParameterFromJSON(json, "editable", Boolean.class, Boolean.FALSE);
        JSONObject jsonDefaultValue = JSONConverter.getParameterFromJSON(json, "default-value", JSONObject.class);
        if (jsonDefaultValue != null && (defaultValueClassName = JSONConverter.getParameterFromJSON(jsonDefaultValue, "class", String.class)).equals(StringWithId.class.getSimpleName())) {
            this.defaultValue = new StringWithId(jsonDefaultValue);
        }
        if ((jsonEditors = JSONConverter.getParameterFromJSON(json, "editors", JSONObject.class)) != null) {
            this.editors = JSONToLightUIConvertorManager.getInstance().createUIElementFromJSON(jsonEditors);
        }
        if ((sValueClass = JSONConverter.getParameterFromJSON(json, "value-class", String.class)) != null) {
            try {
                this.valueClass = Class.forName(sValueClass);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("invalid value for 'value-class', " + ex.getMessage());
            }
        }
    }
}

