/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.date;

import java.util.Calendar;
import java.util.EnumSet;

enum DayOfWeek {
    SUNDAY(1),
    MONDAY(2),
    TUESDAY(3),
    WEDNESDAY(4),
    THURSDAY(5),
    FRIDAY(6),
    SATURDAY(7);

    public static final EnumSet<DayOfWeek> WORKING_DAYS;
    private final int calendarField;

    static {
        WORKING_DAYS = EnumSet.complementOf(EnumSet.of(SATURDAY, SUNDAY));
    }

    private DayOfWeek(int field) {
        this.calendarField = field;
    }

    public final int getCalendarField() {
        return this.calendarField;
    }

    public static DayOfWeek fromCalendarField(int field) {
        DayOfWeek[] dayOfWeekArray = DayOfWeek.values();
        int n = dayOfWeekArray.length;
        int n2 = 0;
        while (n2 < n) {
            DayOfWeek d = dayOfWeekArray[n2];
            if (d.getCalendarField() == field) {
                return d;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown field : " + field);
    }

    public static DayOfWeek fromCalendar(Calendar c) {
        return DayOfWeek.fromCalendarField(c.get(7));
    }

    public static DayOfWeek[] valuesStartingAt(DayOfWeek d) {
        DayOfWeek[] all = DayOfWeek.values();
        if (d.ordinal() == 0) {
            return all;
        }
        DayOfWeek[] res = new DayOfWeek[all.length];
        System.arraycopy(all, d.ordinal(), res, 0, all.length - d.ordinal());
        System.arraycopy(all, 0, res, all.length - d.ordinal(), d.ordinal());
        return res;
    }

    public static DayOfWeek[] getWeek(Calendar c) {
        return DayOfWeek.valuesStartingAt(DayOfWeek.fromCalendarField(c.getFirstDayOfWeek()));
    }
}

