/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.Component;
import java.awt.TextComponent;
import javax.swing.text.JTextComponent;

public enum InteractionMode {
    DISABLED(false, false),
    READ_ONLY(true, false),
    READ_WRITE(true, true);

    private final boolean enabled;
    private final boolean editable;

    private InteractionMode(boolean enabled, boolean editable) {
        this.enabled = enabled;
        this.editable = editable;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public Component applyTo(Component comp) {
        if (comp instanceof InteractionComponent) {
            ((InteractionComponent)((Object)comp)).setInteractionMode(this);
        } else if (comp instanceof JTextComponent) {
            comp.setEnabled(this.isEnabled());
            ((JTextComponent)comp).setEditable(this.isEditable());
        } else if (comp instanceof TextComponent) {
            comp.setEnabled(this.isEnabled());
            ((TextComponent)comp).setEditable(this.isEditable());
        } else {
            comp.setEnabled(this.isEditable());
        }
        return comp;
    }

    public static InteractionMode from(Component comp) {
        if (comp instanceof InteractionComponent) {
            return ((InteractionComponent)((Object)comp)).getInteractionMode();
        }
        if (comp instanceof TextComponent || comp instanceof JTextComponent) {
            boolean enabled = comp.isEnabled();
            if (!enabled) {
                return DISABLED;
            }
            boolean editable = comp instanceof TextComponent && ((TextComponent)comp).isEditable() || comp instanceof JTextComponent && ((JTextComponent)comp).isEditable();
            return InteractionMode.from(enabled, editable);
        }
        return comp.isEnabled() ? READ_WRITE : DISABLED;
    }

    public static InteractionMode from(boolean enabled, boolean editable) {
        if (!enabled) {
            return DISABLED;
        }
        if (editable) {
            return READ_WRITE;
        }
        return READ_ONLY;
    }

    public static interface InteractionComponent {
        public void setInteractionMode(InteractionMode var1);

        public InteractionMode getInteractionMode();
    }
}

