/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import javax.swing.SwingUtilities;
import org.openconcerto.ui.Timer;

public class DelayTimer
extends Timer {
    private final QRunnable qr;

    public DelayTimer(Runnable r, int delay) {
        this(r, delay, 0, delay);
    }

    public DelayTimer(Runnable r, int delay, int accel, int min) {
        this(r, delay, accel, min, null);
    }

    public DelayTimer(Runnable r, int delay, int accel, int min, Runnable finalizer) {
        super(r, delay, accel, min, finalizer);
        this.qr = new QRunnable(this.r);
    }

    @Override
    protected void invokeTask() {
        SwingUtilities.invokeLater(this.qr);
    }

    @Override
    protected void waitForTask() throws InterruptedException {
        this.qr.join();
    }

    public class QRunnable
    implements Runnable {
        private final Runnable r;
        private boolean done;

        public QRunnable(Runnable r) {
            this.r = r;
            this.done = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            block18: {
                if (DelayTimer.this.canceled()) {
                    return;
                }
                QRunnable qRunnable = this;
                synchronized (qRunnable) {
                    this.done = false;
                }
                try {
                    try {
                        this.r.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        QRunnable qRunnable2 = this;
                        synchronized (qRunnable2) {
                            this.done = true;
                            this.notifyAll();
                            break block18;
                        }
                    }
                }
                catch (Throwable throwable) {
                    QRunnable qRunnable3 = this;
                    synchronized (qRunnable3) {
                        this.done = true;
                        this.notifyAll();
                    }
                    throw throwable;
                }
                QRunnable qRunnable4 = this;
                synchronized (qRunnable4) {
                    this.done = true;
                    this.notifyAll();
                }
            }
        }

        public synchronized void join() throws InterruptedException {
            while (!this.done) {
                this.wait();
            }
            return;
        }
    }
}

