/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ProductInfo;

public class TaskPropsConfiguration
extends ComptaBasePropsConfiguration {
    private static final ProductInfo PRODUCT_INFO = new ProductInfo("OpenConcerto");

    public static TaskPropsConfiguration create() {
        File wd = new File(System.getProperty("user.dir"));
        Properties defaults = new Properties();
        defaults.setProperty("wd", wd.getParent());
        defaults.setProperty("base.root", "Common");
        try {
            File confFile = TaskPropsConfiguration.getConfFile(PRODUCT_INFO.getName());
            Properties props = confFile.exists() ? TaskPropsConfiguration.create(new FileInputStream(confFile), defaults) : TaskPropsConfiguration.create(TaskPropsConfiguration.class.getResourceAsStream("main.properties"), defaults);
            return new TaskPropsConfiguration(props);
        }
        catch (IOException e) {
            throw ExceptionHandler.die("Impossible de lire le fichier de configuration.", e);
        }
    }

    private TaskPropsConfiguration(Properties props) {
        super(props, PRODUCT_INFO);
    }

    @Override
    protected String getLogin() {
        return "openconcerto";
    }

    @Override
    protected String getPassword() {
        return "openconcerto";
    }

    @Override
    public String getSSLUserName() {
        return "tasknx";
    }

    @Override
    protected void initDS(SQLDataSource ds) {
        super.initDS(ds);
        ds.setLoginTimeout(1);
        ds.setRetryWait(-1);
    }

    @Override
    public void setUpSocieteDataBaseConnexion(int base) {
    }
}

