/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.OrderComparator;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.ChangeFKRunnable;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.MoveQueue;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOffline;
import org.openconcerto.sql.view.list.SQLTableModelSourceStateOffline;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.ITransformer;

public class SQLTableModelLinesSourceOffline
extends SQLTableModelLinesSource {
    private final SQLTableModelSourceOffline parent;
    private final List<Row> lines = new LinkedList<Row>();
    private int freeID = -10;
    private final Map<Number, Row> id2line = new HashMap<Number, Row>();
    private final SQLRowValues modifiableVals;
    private final Map<Row, SQLRowValues> dbVals;
    private final Set<Number> deleted;
    private boolean dbOrder = true;

    public SQLTableModelLinesSourceOffline(SQLTableModelSourceOffline parent, ITableModel model) {
        super(model);
        this.parent = parent;
        this.modifiableVals = this.getParent().getElem().getPrivateGraph().toImmutable();
        if (this.modifiableVals.getGraphSize() > 1) {
            if (this.modifiableVals.hasReferents()) {
                throw new IllegalArgumentException("Referents are not supported");
            }
            this.modifiableVals.getGraph().walk(this.modifiableVals, null, new ITransformer<SQLRowValuesCluster.State<Object>, Object>(){

                @Override
                public Object transformChecked(SQLRowValuesCluster.State<Object> input) {
                    if (input.isBackwards()) {
                        throw new IllegalArgumentException("Referents are not supported");
                    }
                    return null;
                }
            }, new SQLRowValuesCluster.WalkOptions(Link.Direction.ANY).setRecursionType(RecursionType.BREADTH_FIRST).setStartIncluded(false));
        }
        this.dbVals = new HashMap<Row, SQLRowValues>();
        this.deleted = new HashSet<Number>();
    }

    @Override
    public final SQLTableModelSourceOffline getParent() {
        return this.parent;
    }

    private synchronized boolean checkUpdateThread() {
        return this.getModel().getUpdateQ().currentlyInQueue();
    }

    private final Row getRow(Number id) {
        return this.getRow(id, false);
    }

    private final Row getRow(Number id, boolean required) {
        return this.getRow(id, required, null);
    }

    private final Row getRow(Number id, boolean required, Object idSource) {
        Row res = this.id2line.get(id);
        if (required && res == null) {
            throw new IllegalArgumentException("Not in the list : " + (idSource == null ? id : idSource));
        }
        return res;
    }

    protected final int getSize() {
        return this.lines.size();
    }

    private final int indexOf(Row r) {
        return this.lines.indexOf(r);
    }

    protected final List<ListSQLLine> getLines() {
        ArrayList<ListSQLLine> res = new ArrayList<ListSQLLine>();
        for (Row r : this.lines) {
            ListSQLLine l = this.createLine(r);
            if (l == null) continue;
            res.add(l);
        }
        return res;
    }

    private final boolean isDBOrder() {
        return this.dbOrder;
    }

    private final boolean setDBOrder(boolean dbOrder) {
        assert (this.checkUpdateThread());
        if (this.dbOrder != dbOrder) {
            this.dbOrder = dbOrder;
            return true;
        }
        return false;
    }

    private final Number getOrder(Row r) {
        if (this.isDBOrder()) {
            return null;
        }
        return this.indexOf(r);
    }

    private final ListSQLLine createLine(Row r) {
        if (r == null) {
            return null;
        }
        ListSQLLine res = this.createLine(r.vals, r.id);
        if (res != null) {
            res.setOrder(this.getOrder(r));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(ListSQLLine l1, ListSQLLine l2) {
        Number order2;
        Number order1;
        if (l1 == l2) {
            return 0;
        }
        SQLTableModelLinesSource src = l1.getSrc();
        List<ListSQLLine> list = src.getModel().getUpdateQ().getFullList();
        synchronized (list) {
            order1 = l1.getOrder();
            order2 = l2.getOrder();
        }
        if (order1 != null) {
            if (order2 == null) {
                throw new IllegalStateException("Order mismatch :\n" + order1 + " for " + l1 + " not coherent with\n" + order2 + " for " + l2);
            }
            return NumberUtils.compare(order1, order2);
        }
        if (order2 != null) {
            throw new IllegalStateException("Order mismatch :\n" + order1 + " for " + l1 + " not coherent with\n" + order2 + " for " + l2);
        }
        return OrderComparator.INSTANCE.compare(l1.getRow(), l2.getRow());
    }

    protected final SQLRowValuesListFetcher getFetcher() {
        return ((SQLTableModelSourceStateOffline)this.getModel().getUpdateQ().getState()).getFetcher();
    }

    protected final List<SQLRowValues> fetch(Where w) {
        return this.getFetcher().fetch(w, true);
    }

    @Override
    public List<ListSQLLine> getAll() {
        assert (this.checkUpdateThread());
        List<SQLRowValues> dbRows = this.fetch(null);
        if (this.lines.isEmpty()) {
            for (SQLRowValues dbRow : dbRows) {
                this._add(dbRow, false, false);
            }
        } else {
            HashSet<Number> dbIDs = new HashSet<Number>();
            for (SQLRowValues dbRow : dbRows) {
                dbIDs.add(dbRow.getIDNumber(true));
            }
            HashSet<Number> deletedIDs = new HashSet<Number>(this.id2line.keySet());
            deletedIDs.removeAll(dbIDs);
            for (Number id : deletedIDs) {
                if (id.intValue() < 0) continue;
                Value<ListSQLLine> val = this.updateRow(id.intValue(), null);
                assert (val.getValue() == null);
            }
            for (SQLRowValues dbRow : dbRows) {
                this.updateRow(dbRow.getID(), dbRow);
            }
        }
        return this.getLines();
    }

    private final Value<ListSQLLine> updateRow(int id, SQLRowValues row) {
        Row newRow;
        Row existingLine = this.getRow(id);
        if (row != null && existingLine != null && this.dbVals.containsKey(existingLine)) {
            return Value.getNone();
        }
        if (row == null) {
            this._rm(existingLine);
            newRow = null;
        } else if (existingLine != null) {
            existingLine.setRow(row);
            newRow = existingLine;
        } else {
            newRow = this._add(row, false, false);
        }
        return Value.getSome(this.createLine(newRow));
    }

    @Override
    public Value<ListSQLLine> get(int id) {
        assert (this.checkUpdateThread());
        Where w = new Where((FieldRef)this.getParent().getPrimaryTable().getKey(), "=", id);
        SQLRowValues row = CollectionUtils.getSole(this.fetch(w));
        return this.updateRow(id, row);
    }

    public final Future<Number> add(SQLRowValues vals) {
        final AtomicReference<SQLRowValues> copy = new AtomicReference<SQLRowValues>(vals.deepCopy());
        return this.getModel().getUpdateQ().execute(new FutureTask<Number>(new OfflineCallable<Number>(){

            @Override
            public Number call() throws Exception {
                return SQLTableModelLinesSourceOffline.this._add((SQLRowValues)copy.get(), true, true).getID();
            }
        }));
    }

    protected Row _add(SQLRowValues vals, boolean grow, boolean fireAdd) {
        List<Number> order;
        assert (this.checkUpdateThread());
        if (grow) {
            vals.grow(this.getFetcher().getGraph(), false);
        }
        vals.getGraph().freeze();
        boolean fromDB = vals.hasID();
        Row r = new Row(fromDB ? (Number)vals.getIDNumber() : (Number)this.freeID--, vals);
        this.id2line.put(r.getID(), r);
        this.lines.add(r);
        if (!fromDB && this.setDBOrder(false)) {
            order = this.getIDsOrder();
            assert (order != null);
        } else {
            order = null;
        }
        if (order != null) {
            this.getModel().getUpdateQ().reorder(order);
        }
        if (fireAdd) {
            ListSQLLine line = this.createLine(r);
            this.getModel().getUpdateQ().replaceLine(r.getID().intValue(), line);
        }
        return r;
    }

    public final Future<SQLRowValues> remove(final Number id) {
        return this.getModel().getUpdateQ().execute(new FutureTask<SQLRowValues>(new OfflineCallable<SQLRowValues>(){

            @Override
            public SQLRowValues call() throws Exception {
                Row r = SQLTableModelLinesSourceOffline.this.getRow(id);
                return r == null ? null : SQLTableModelLinesSourceOffline.this.rm(r).vals;
            }
        }));
    }

    private Row rm(Row r) {
        if (r != null) {
            this._rm(r);
            if (r.vals.hasID()) {
                this.deleted.add(r.vals.getIDNumber());
            }
            this.getModel().getUpdateQ().replaceLine(r.getID().intValue(), null);
        }
        return r;
    }

    private void _rm(Row l) {
        assert (this.checkUpdateThread());
        if (l != null) {
            this.lines.remove(l);
            this.id2line.remove(l.id);
            this.dbVals.remove(l);
        }
    }

    @Override
    public void commit(final ListSQLLine l, final Path path, SQLRowValues vals) {
        this.checkCanModif(path);
        if (!vals.isFrozen()) {
            throw new IllegalArgumentException("Not frozen");
        }
        final AtomicReference<SQLRowValues> copy = new AtomicReference<SQLRowValues>(vals);
        this.getModel().getUpdateQ().put(new OfflineRunnable(){

            @Override
            public void run() {
                SQLTableModelLinesSourceOffline.this.getModel().getUpdateQ().updateLine(l, path, ((SQLRowValues)copy.get()).getID(), (SQLRowValues)copy.get());
                SQLTableModelLinesSourceOffline.this.recordOriginal(SQLTableModelLinesSourceOffline.this.getRow(l.getID()), l);
            }
        });
    }

    public Future<?> updateRow(final Number id, final Path path, SQLRowValues vals) {
        this.checkCanModif(path);
        final AtomicReference<SQLRowValues> copy = new AtomicReference<SQLRowValues>(vals.toImmutable());
        return this.getModel().getUpdateQ().put(new OfflineRunnable(){

            @Override
            public void run() {
                ListSQLLine l = SQLTableModelLinesSourceOffline.this.getModel().getUpdateQ().getLine(id);
                SQLTableModelLinesSourceOffline.this.getModel().getUpdateQ().updateLine(l, path, ((SQLRowValues)copy.get()).getID(), (SQLRowValues)copy.get());
                SQLTableModelLinesSourceOffline.this.recordOriginal(SQLTableModelLinesSourceOffline.this.getRow(id), l);
            }
        });
    }

    private void checkCanModif(Path path) {
        if (this.modifiableVals.followPath(path) == null) {
            throw new IllegalArgumentException("can only modify " + this.modifiableVals);
        }
    }

    private void recordOriginal(Row r, ListSQLLine l) {
        assert (r.getID().intValue() == l.getID());
        if (r.getRow().hasID() && !this.dbVals.containsKey(r)) {
            this.dbVals.put(r, r.getRow());
        }
        r.setRow(l.getRow());
    }

    public void changeFK(final Number lineID, final Path p, final int id) {
        this.checkCanModif(p.minusLast());
        if (this.modifiableVals.followPath(p) != null) {
            throw new IllegalArgumentException("can only modify a foreign key of " + this.modifiableVals);
        }
        this.getModel().getUpdateQ().put(new OfflineRunnable(){

            @Override
            public void run() {
                ListSQLLine line = SQLTableModelLinesSourceOffline.this.getModel().getUpdateQ().getLine(lineID);
                new ChangeFKRunnable(line, p, id).run();
                SQLTableModelLinesSourceOffline.this.recordOriginal(SQLTableModelLinesSourceOffline.this.getRow(lineID, true), line);
            }
        });
    }

    @Override
    public Future<?> moveBy(List<? extends SQLRowAccessor> list, final int inc) {
        if (inc == 0 || list.size() == 0) {
            return null;
        }
        final CopyOnWriteArrayList<? extends SQLRowAccessor> copy = new CopyOnWriteArrayList<SQLRowAccessor>(list);
        return this.getModel().getUpdateQ().put(new OfflineRunnable(){

            @Override
            public void run() {
                SQLTableModelLinesSourceOffline.this._moveBy(copy, inc);
            }
        });
    }

    protected void _moveBy(List<? extends SQLRowAccessor> list, int inc) {
        assert (this.checkUpdateThread());
        int count = this.lines.size();
        boolean after = inc > 0;
        int outerIndex = -1;
        ArrayList<Row> ourLines = new ArrayList<Row>(list.size());
        for (SQLRowAccessor sQLRowAccessor : list) {
            Row ourLine = this.getRow(sQLRowAccessor.getIDNumber(), true, sQLRowAccessor);
            int index = this.indexOf(ourLine);
            ourLines.add(ourLine);
            if (outerIndex >= 0 && (!after || index <= outerIndex) && (after || index >= outerIndex)) continue;
            outerIndex = index;
        }
        assert (outerIndex >= 0 && ourLines.size() == list.size());
        this.lines.removeAll(ourLines);
        assert (this.lines.size() == count - ourLines.size());
        int n = after ? outerIndex + inc - list.size() + 1 : outerIndex + inc;
        this.lines.addAll(n, ourLines);
        assert (this.lines.size() == count) : "Move has changed the number of rows from " + count + " to " + this.lines.size();
        this.setDBOrder(false);
        List<Number> order = this.getIDsOrder();
        this.getModel().getUpdateQ().reorder(order);
    }

    private List<Number> getIDsOrder() {
        ArrayList<Number> ids = new ArrayList<Number>();
        for (Row r : this.lines) {
            ids.add(r.getID());
        }
        return ids;
    }

    @Override
    public Future<?> moveTo(final List<? extends Number> ids, final int index) {
        return this.getModel().getUpdateQ().put(new OfflineRunnable(){

            @Override
            public void run() {
                SQLTableModelLinesSourceOffline.this._moveTo(ids, index);
            }
        });
    }

    protected void _moveTo(List<?> ids, int index) {
        assert (this.checkUpdateThread());
        int count = this.lines.size();
        ArrayList<Row> list = new ArrayList<Row>(ids.size());
        for (Object o : ids) {
            Number id = o instanceof SQLRowAccessor ? (Number)((SQLRowAccessor)o).getIDNumber() : (Number)((Number)o);
            list.add(this.getRow(id, true, o));
        }
        if (index <= 0) {
            this.lines.removeAll(list);
            this.lines.addAll(0, list);
        } else if (index >= this.lines.size()) {
            this.lines.removeAll(list);
            this.lines.addAll(list);
        } else {
            Row destLine = null;
            int i = index;
            boolean contains = true;
            while (i < this.lines.size() && contains) {
                destLine = this.lines.get(i);
                contains = list.contains(destLine);
                if (!contains) continue;
                ++i;
            }
            if (contains) {
                this.lines.removeAll(list);
                this.lines.addAll(list);
            } else {
                this.lines.removeAll(list);
                int newIndex = this.indexOf(destLine);
                this.lines.addAll(newIndex, list);
            }
        }
        assert (this.lines.size() == count) : "Move has changed the number of rows from " + count + " to " + this.lines.size();
        this.setDBOrder(false);
        List<Number> order = this.getIDsOrder();
        this.getModel().getUpdateQ().reorder(order);
    }

    public final Future<?> reset() {
        return this.getModel().getUpdateQ().put(new OfflineRunnable(){

            @Override
            public void run() {
                SQLTableModelLinesSourceOffline.this._reset();
            }
        });
    }

    protected void _reset() {
        assert (this.checkUpdateThread());
        this.lines.clear();
        this.id2line.clear();
        this.dbVals.clear();
        this.deleted.clear();
        this.setDBOrder(true);
        for (SQLRowValues r : this.fetch(null)) {
            this._add(r, false, false);
        }
        this.getModel().getUpdateQ().setFullList(this.getLines(), null);
    }

    public final Future<?> commit() {
        return this.getModel().getUpdateQ().execute(new FutureTask<Object>(new OfflineCallable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLTableModelLinesSourceOffline.this._commit();
                return null;
            }
        }));
    }

    protected final void _commit() throws SQLException {
        assert (this.checkUpdateThread());
        this.getModel().getUpdateQ().rmTableListener();
        try {
            SQLUtils.executeAtomic(this.getParent().getPrimaryTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException {
                    SQLTableModelLinesSourceOffline.this.coreCommit();
                    return null;
                }
            });
        }
        finally {
            this.getModel().getUpdateQ().addTableListener();
        }
        this._reset();
    }

    protected void coreCommit() throws SQLException {
        LinkedHashMap<Row, SQLRow> newRows = new LinkedHashMap<Row, SQLRow>();
        for (Row row : this.lines) {
            SQLRow newRow = !row.getRow().hasID() ? row.getRow().prune(this.modifiableVals).commit() : row.getRow().asRow();
            newRows.put(row, newRow);
        }
        for (Map.Entry entry : this.dbVals.entrySet()) {
            Row l = (Row)entry.getKey();
            assert (newRows.containsKey(l));
            newRows.put(l, this.getParent().getElem().update((SQLRowValues)entry.getValue(), l.getRow()).exec());
        }
        this.dbVals.clear();
        ArrayList arrayList = new ArrayList(newRows.values());
        ArrayList dbOrder = new ArrayList(newRows.values());
        Collections.sort(dbOrder, OrderComparator.INSTANCE);
        if (!arrayList.equals(dbOrder)) {
            MoveQueue.moveAtOnce(arrayList.subList(1, arrayList.size()), true, (SQLRow)arrayList.get(0));
        }
        for (Number id : this.deleted) {
            this.getParent().getElem().archive(id.intValue());
        }
        this.deleted.clear();
    }

    private static abstract class OfflineCallable<V>
    implements Callable<V> {
        private OfflineCallable() {
        }
    }

    private static abstract class OfflineRunnable
    extends OfflineCallable<Object>
    implements Runnable {
        private OfflineRunnable() {
        }

        @Override
        public final Object call() throws Exception {
            this.run();
            return null;
        }
    }

    private static final class Row {
        private final Number id;
        private SQLRowValues vals;

        private Row(Number id, SQLRowValues vals) {
            this.id = id;
            this.setRow(vals);
        }

        public final Number getID() {
            return this.id;
        }

        public final SQLRowValues getRow() {
            return this.vals;
        }

        public final void setRow(SQLRowValues newVals) {
            if (!newVals.isFrozen()) {
                throw new IllegalArgumentException("Not frozen : " + newVals);
            }
            this.vals = newVals;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " of " + this.getID();
        }
    }
}

