/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.MutableRowItemView;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.sqlobject.itemview.BaseRowItemView;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.list.RowValuesTableHeader;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.EnhancedTable;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.state.JTableStateManager;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.FocusAwareEditor;
import org.openconcerto.ui.table.XTableColumnModel;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;

public class RowValuesTable
extends EnhancedTable
implements AncestorListener,
MutableRowItemView {
    private JTableStateManager stateManager;
    private RowValuesTableModel model;
    private XTableColumnModel columnModel = new XTableColumnModel();
    private boolean editorAndRendererDone;
    private List<String> clearElementList = new ArrayList<String>();
    private List<SQLField> fields;
    private String sqlName;

    public RowValuesTable(RowValuesTableModel model, File f) {
        this(model, f, false);
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component c = super.prepareEditor(editor, row, column);
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).selectAll();
        }
        return c;
    }

    public void addClearCloneTableElement(String elt) {
        this.clearElementList.add(elt);
    }

    public List<String> getClearCloneTableElement() {
        return this.clearElementList;
    }

    public RowValuesTable(RowValuesTableModel model, File f, boolean tiny) {
        this(model, f, tiny, new XTableColumnModel());
    }

    public RowValuesTable(RowValuesTableModel model, File f, boolean tiny, XTableColumnModel colModel) {
        super(model, colModel);
        this.setTableHeader(new RowValuesTableHeader(colModel));
        if (f == null) {
            f = IListPanel.getConfigFile(model.getSQLElement(), this.getClass());
        }
        this.stateManager = new JTableStateManager(this, f, true);
        this.columnModel = colModel;
        this.model = model;
        this.createDefaultColumnsFromModel();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                RowValuesTable.this.updateEditorAndRenderer();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        int height = 150;
        if (tiny) {
            height = 80;
        }
        this.setMinimumSize(new Dimension(this.getMinimumSize().width, Math.max(height, this.getMinimumSize().height)));
        this.getModel().addTableModelListener(this);
        this.getTableHeader().setReorderingAllowed(false);
        this.addAncestorListener(this);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 512), "addLine");
        this.getActionMap().put("addLine", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowValuesTable.this.getRowValuesTableModel().addNewRow();
            }
        });
        final KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Component c = focusManager.getPermanentFocusOwner();
                while (c != null) {
                    if (c == RowValuesTable.this) {
                        return;
                    }
                    if (c instanceof Window || c instanceof Applet && c.getParent() == null) {
                        if (c != SwingUtilities.getRoot(RowValuesTable.this) || RowValuesTable.this.getCellEditor() == null || RowValuesTable.this.getCellEditor() instanceof FocusAwareEditor || RowValuesTable.this.getCellEditor().stopCellEditing()) break;
                        RowValuesTable.this.getCellEditor().cancelCellEditing();
                        break;
                    }
                    c = c.getParent();
                }
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        this.updateEditorAndRenderer();
        super.paint(g);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.getParent() instanceof JViewport && ((JViewport)this.getParent()).getWidth() < preferredSize.width) {
            return new Dimension(this.getMinimumSize().width, preferredSize.height);
        }
        return preferredSize;
    }

    private final synchronized void updateEditorAndRenderer() {
        if (!this.editorAndRendererDone) {
            this.editorAndRendererDone = true;
            List<TableColumn> list = this.columnModel.getColumns(false);
            List<SQLTableElement> listReal = this.model.getList();
            for (TableColumn aColumn : list) {
                SQLTableElement sqlTableElement = listReal.get(aColumn.getModelIndex());
                TableCellRenderer renderer = sqlTableElement.getTableCellRenderer();
                aColumn.setCellRenderer(renderer);
                AlternateTableCellRenderer.setRendererAndListen(aColumn);
                TableCellEditor editor = sqlTableElement.getTableCellEditor(this);
                if (editor == null) continue;
                aColumn.setCellEditor(editor);
            }
        }
    }

    public void setEditorAndRendererDone(boolean b) {
        this.editorAndRendererDone = false;
    }

    public void loadState(String filename) {
        this.stateManager.loadState(new File(filename));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getType() == 1) {
            this.scrollRectToVisible(new Rectangle(this.getCellRect(e.getFirstRow(), 0, true)));
        }
    }

    public RowValuesTableModel getRowValuesTableModel() {
        return this.model;
    }

    public void updateField(String field, SQLRowValues rowVals) {
        this.model.updateField(field, rowVals);
        this.clear();
    }

    public void updateField(String field, int id) {
        this.model.updateField(field, id);
        this.clear();
    }

    public void updateField(String field, int id, String fieldCondition) {
        this.model.updateField(field, id, fieldCondition);
        this.clear();
    }

    public void updateField(String field, SQLRowValues rowVals, String fieldCondition) {
        this.model.updateField(field, rowVals, fieldCondition);
        this.clear();
    }

    public void insertFrom(String field, int id, int exceptID) {
        this.model.insertFrom(field, id, exceptID);
        this.revalidate();
        this.repaint();
    }

    public void insertFrom(String field, int id) {
        this.model.insertFrom(field, id);
        this.revalidate();
        this.repaint();
    }

    public void insertFrom(SQLRowAccessor rowVals) {
        this.model.insertFrom(rowVals);
        this.revalidate();
        this.repaint();
    }

    public void insertFrom(String field, SQLRowValues rowVals) {
        this.model.insertFrom(rowVals);
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    @Override
    public void resizeAndRepaint() {
        super.resizeAndRepaint();
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (this.editCellAt(rowIndex, columnIndex)) {
            this.getEditorComponent().requestFocusInWindow();
            this.getEditorComponent().requestFocus();
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null) {
            editor = this.getDefaultEditor(this.getColumnClass(column));
        }
        return editor;
    }

    public final void clear() {
        this.model.clearRows();
        List<SQLTableElement> l = this.model.getList();
        for (SQLTableElement tableElement : l) {
            tableElement.clear();
        }
    }

    public void readState() {
        this.stateManager.loadState();
    }

    public void writeState() {
        try {
            this.stateManager.saveState();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.updateEditorAndRenderer();
        this.stateManager.loadState();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    public SQLRowValues getSelectedRowValues() {
        try {
            return this.model.getRowValuesAt(this.getSelectedRow());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public XTableColumnModel getColumnModel() {
        return (XTableColumnModel)super.getColumnModel();
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
    }

    @Override
    public void removeValueListener(PropertyChangeListener l) {
    }

    @Override
    public Component getComp() {
        return this;
    }

    @Override
    public final SQLField getField() {
        return BaseRowItemView.getOnlyOne(this.fields);
    }

    @Override
    public List<SQLField> getFields() {
        return this.fields;
    }

    @Override
    public String getSQLName() {
        return this.sqlName;
    }

    @Override
    public void insert(SQLRowValues vals) {
        System.err.println("Insert");
    }

    @Override
    public void resetValue() {
    }

    @Override
    public void setEditable(InteractionMode mode) {
        this.model.setEditable(mode.isEditable());
        super.setEnabled(mode.isEnabled());
    }

    public void setEditable(boolean b) {
        this.setEnabled(b);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.setEditable(enabled ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
        }
    }

    @Override
    public void show(SQLRowAccessor r) {
    }

    @Override
    public void update(SQLRowValues vals) {
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
    }

    @Override
    public void removeEmptyListener(EmptyListener l) {
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }

    @Override
    public ValidState getValidState() {
        if (this.model.isValidated()) {
            return ValidState.getTrueInstance();
        }
        SQLFieldTranslator trans = Configuration.getInstance().getTranslator();
        String fields = "(";
        for (SQLField field : this.model.getRequiredsField()) {
            fields = String.valueOf(fields) + trans.getLabelFor(field) + ",";
        }
        fields = String.valueOf(fields) + ")";
        String text = "au moins " + this.model.getSQLElement().getSingularName() + " n'a pas le(s) champ(s) requis \"" + fields + "\" rempli(s)";
        return new ValidState(false, text);
    }

    @Override
    public void init(String sqlName, Set<SQLField> fields) {
        this.fields = fields.size() > 0 ? new ArrayList<SQLField>(fields) : Collections.singletonList(this.model.getRequiredField());
        this.sqlName = sqlName;
    }
}

