/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPath;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.cc.IClosure;

abstract class MySQLXML2 {
    MySQLXML2() {
    }

    public void convert(File xmlFile, OutputStream outputStream) throws JDOMException, IOException {
        Document doc = new SAXBuilder().build(xmlFile);
        this.fixXML(doc);
        this.xml2sql(doc, outputStream);
    }

    public void convert(File xmlFile) throws JDOMException, IOException {
        this.convert(xmlFile, System.err);
    }

    protected void fixXML(Document doc) throws JDOMException {
        this.fixType(doc, "starts-with", "int(", "int");
        this.fixType(doc, "starts-with", "bigint(", "bigint");
        this.fixType(doc, "starts-with", "datetime", "timestamp");
    }

    private final void xml2sql(Document doc, OutputStream outputStream) throws JDOMException, IOException {
        List<Element> children = doc.getRootElement().getChildren("database");
        if (children.size() == 1) {
            PrintWriter out = new PrintWriter(outputStream);
            Element dbElem = children.get(0);
            String dbName = dbElem.getAttributeValue("name");
            this.db2sql(out, dbElem, this.getIdentifier(dbName));
            out.flush();
        } else {
            File dir = new File(this.getClass().getSimpleName());
            FileUtils.mkdir_p(dir);
            PrintWriter outdb = new PrintWriter(new File(dir, "createdbs.sql"));
            Iterator<Element> iterator = children.iterator();
            while (iterator.hasNext()) {
                Element obj;
                Element dbElem = obj = iterator.next();
                String dbName = dbElem.getAttributeValue("name");
                outdb.println("CREATE DATABASE " + this.getIdentifier(dbName) + ";");
                PrintWriter out = new PrintWriter(new File(dir, String.valueOf(dbName) + ".sql"));
                this.db2sql(out, dbElem, this.getIdentifier(dbName));
                out.close();
            }
            outdb.close();
        }
    }

    private void db2sql(PrintWriter out, Element dbElem, String schemaName) throws JDOMException {
        for (Element tableElem : dbElem.getChildren("table_structure")) {
            out.println("CREATE TABLE " + schemaName + "." + this.getIdentifier(tableElem.getAttributeValue("name")) + " (");
            ArrayList<String> lines = new ArrayList<String>();
            for (Element fieldElem : tableElem.getChildren("field")) {
                lines.add(this.field2sql(fieldElem));
            }
            XPath primaryPath = XPath.newInstance("./field[@Key = 'PRI']");
            Element primaryField = (Element)primaryPath.selectSingleNode(tableElem);
            if (primaryField != null) {
                lines.add("PRIMARY KEY (" + this.getIdentifier(primaryField.getAttributeValue("Field")) + ")");
            }
            out.println(CollectionUtils.join(lines, ",\n"));
            out.println(");");
            if (!this.wantIndexes()) continue;
            XPath fkPath = XPath.newInstance("./key[@Non_unique = '1']");
            for (Element fkElem : fkPath.selectNodes(tableElem)) {
                String tableName = fkElem.getAttributeValue("Table");
                out.println("CREATE INDEX " + this.getIdentifier(fkElem.getAttributeValue("Key_name")) + " ON \"" + tableName + "\" (\"" + fkElem.getAttributeValue("Column_name") + "\");");
            }
        }
    }

    protected boolean wantIndexes() {
        return false;
    }

    protected String getIdentifier(String name) {
        return SQLBase.quoteIdentifier(name);
    }

    private String field2sql(Element fieldElem) {
        String type = fieldElem.getAttributeValue("Type");
        String res = String.valueOf(this.getIdentifier(fieldElem.getAttributeValue("Field"))) + " " + type;
        String defAttr = fieldElem.getAttributeValue("Default");
        if (defAttr != null) {
            String def;
            if (type.indexOf("bool") >= 0 || type.indexOf("int") >= 0 || type.indexOf("float") >= 0 || this.isFunc(type, defAttr)) {
                def = defAttr;
            } else {
                SQLType t = SQLType.get(12, 250);
                def = t.toString(defAttr);
            }
            res = String.valueOf(res) + " default " + def;
        }
        res = String.valueOf(res) + " " + fieldElem.getAttributeValue("Extra");
        return res;
    }

    private boolean isFunc(String type, String defAttr) {
        return (type.indexOf("date") >= 0 || type.indexOf("timestamp") >= 0) && this.isFirstAlpha(defAttr);
    }

    private boolean isFirstAlpha(String defAttr) {
        if (defAttr.length() == 0) {
            return false;
        }
        char first = defAttr.charAt(0);
        return first >= 'A' && first <= 'z';
    }

    protected final void fixType(Document doc, String func, String testVal, String replacement) throws JDOMException {
        this.fixAttr(doc, "Type", func, testVal, replacement);
    }

    protected final void fixAttr(Document doc, final String attrName, String func, String testVal, final String replacement) throws JDOMException {
        this.fixAttr(doc, attrName, func, testVal, new IClosure<Element>(){

            @Override
            public void executeChecked(Element fieldElem) {
                fieldElem.setAttribute(attrName, replacement);
            }
        });
    }

    protected final void fixAttr(Document doc, String attrName, String func, String testVal, IClosure<Element> c) throws JDOMException {
        XPath intLengthPath = XPath.newInstance("//table_structure/field[" + func + "(@" + attrName + ", '" + testVal + "')]");
        for (Element fieldElem : intLengthPath.selectNodes(doc)) {
            c.executeChecked(fieldElem);
        }
    }
}

