/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jedit.JEditTextArea;
import org.jedit.JavaTokenMarker;
import org.jedit.TokenMarker;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ClassGenerator;
import org.openconcerto.sql.utils.RowBackedCodeGenerator;
import org.openconcerto.sql.utils.SQL_URL;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.utils.ClipboardUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.LogUtils;

public class ModelCreator
extends JFrame
implements ListSelectionListener {
    JTabbedPane pane = new JTabbedPane();
    private JList list;
    private final Preferences pref;
    private JButton buttonConnect;
    final JTextField rootTF = new JTextField();

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        Logger.getLogger("org.openconcerto.sql").setLevel(Level.WARNING);
        ModelCreator m = new ModelCreator();
        m.setDefaultCloseOperation(3);
        m.setSize(1000, 800);
        m.setVisible(true);
    }

    ModelCreator() {
        super("FrameWork SQL Toolbox");
        this.pref = Preferences.userRoot().node("/ilm/sql/" + this.getClass().getSimpleName());
        JPanel confPanel = new JPanel();
        confPanel.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        confPanel.add((Component)new JLabel("Root name:"), c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        this.rootTF.setText(this.pref.get("url", "psql://login:password@192.168.1.10:5432/OpenConcerto/OpenConcerto42"));
        confPanel.add((Component)this.rootTF, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 4;
        this.buttonConnect = new JButton("Connexion");
        confPanel.add((Component)this.buttonConnect, c);
        final DefaultListModel model = new DefaultListModel();
        this.list = new JList(model);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SQLTable t = (SQLTable)value;
                String v = t.getSQLName().toString();
                return super.getListCellRendererComponent((JList<?>)list, v, index, isSelected, cellHasFocus);
            }
        });
        JSplitPane split = new JSplitPane(1);
        split.setLeftComponent(new JScrollPane(this.list));
        split.setRightComponent(this.pane);
        split.setDividerLocation(360);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        confPanel.add((Component)split, c);
        this.setContentPane(confPanel);
        this.buttonConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelCreator.this.rootTF.setEnabled(false);
                ModelCreator.this.buttonConnect.setText("Connexion en cours");
                ModelCreator.this.buttonConnect.setEnabled(false);
                final String url = ModelCreator.this.rootTF.getText();
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ModelCreator.this.connect(model, url);
                    }
                });
                t.setDaemon(true);
                t.start();
            }
        });
        this.list.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.pane.removeAll();
        SQLTable table = (SQLTable)this.list.getSelectedValue();
        if (table.getContentFields().size() > 0) {
            String c = RowBackedCodeGenerator.getJavaName(table.getName());
            this.pane.add("Code RowBacked", this.createTA(RowBackedCodeGenerator.getCode(table, c, null)));
            this.pane.add("Code BaseSQLElement", this.createTA(ClassGenerator.generateAutoLayoutedJComponent(table, String.valueOf(c) + "SQLElement", null)));
            this.pane.add("Code SQLConfElement", this.createTA(ClassGenerator.generateSQLConfElement(table, String.valueOf(c) + "SQLElement", null)));
            this.pane.add("Code Group", this.createTA(ClassGenerator.generateGroup(table, String.valueOf(c) + "EditGroup", null)));
            this.pane.add("Field Mapping", this.createTA(ClassGenerator.generateFieldMapping(table, c, null)));
            this.pane.add("Mapping XML", this.createTA(ClassGenerator.generateMappingXML(table, c)));
        }
    }

    private final JPanel createTA(String text) {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        final JEditTextArea res = new JEditTextArea();
        res.setEditable(false);
        res.setTokenMarker((TokenMarker)new JavaTokenMarker());
        res.setText(text);
        res.setCaretPosition(0);
        p.add((Component)res, c);
        JButton b = new JButton("Copy to clipboard");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipboardUtils.setClipboardContents(res.getText());
            }
        });
        ++c.gridy;
        c.fill = 0;
        c.weighty = 0.0;
        p.add((Component)b, c);
        return p;
    }

    private void connect(DefaultListModel model, String textUrl) {
        this.pref.put("url", textUrl);
        try {
            SQL_URL url = SQL_URL.create(textUrl);
            ArrayList<String> roots = new ArrayList<String>();
            roots.add("Common");
            DBSystemRoot sysRoot = SQLServer.create(url, roots, null);
            ArrayList<SQLTable> tables = new ArrayList<SQLTable>(sysRoot.getRoot(url.getRootName()).getDescs(SQLTable.class));
            Collections.sort(tables, new Comparator<SQLTable>(){

                @Override
                public int compare(SQLTable o1, SQLTable o2) {
                    String v1 = o1.getSQLName().toString();
                    String v2 = o2.getSQLName().toString();
                    return v1.compareTo(v2);
                }
            });
            model.removeAllElements();
            model.addAll(tables);
        }
        catch (Exception e1) {
            ExceptionHandler.handle(this, "erreur d'URL", e1);
            JOptionPane.showMessageDialog(this, e1.getMessage(), "Erreur de connexion", 0);
        }
        this.buttonConnect.setEnabled(true);
        this.buttonConnect.setText("Connexion");
        this.rootTF.setEnabled(true);
    }
}

