/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.Map;
import ognl.NoSuchPropertyException;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.jdom2.Element;
import org.openconcerto.sql.element.RowBacked;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;

public abstract class GenerationUtils {
    public static void setPropertyAccessors() {
        OgnlRuntime.setPropertyAccessor(SQLRowAccessor.class, (PropertyAccessor)new PropertyAccessor(){

            public Object getProperty(Map context, Object target, Object name) throws OgnlException {
                SQLField field;
                SQLRowAccessor r = (SQLRowAccessor)target;
                String nom = (String)name;
                SQLTable table = r.getTable();
                SQLField realField = table.getFieldRaw(nom);
                SQLField sQLField = field = realField != null ? realField : table.getFieldRaw(nom.toUpperCase());
                if (field != null) {
                    if (table.getForeignKeys().contains(field)) {
                        return r.getForeign(field.getName());
                    }
                    return r.getObject(field.getName());
                }
                SQLTable refTable = table.getDBSystemRoot().getGraph().findReferentTable(table, nom, new String[0]);
                if (refTable != null) {
                    return r.getReferentRows(refTable);
                }
                throw new OgnlException("'" + name + "' n'est ni un champ, ni une table r\u00e9f\u00e9rente de " + r);
            }

            public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
                throw new OgnlException("", (Throwable)new UnsupportedOperationException("setProperty not supported on SQL rows"));
            }
        });
        OgnlRuntime.setPropertyAccessor(Element.class, (PropertyAccessor)new PropertyAccessor(){

            public Object getProperty(Map context, Object target, Object name) {
                Element elem = (Element)target;
                String n = (String)name;
                String attributeValue = elem.getAttributeValue(n);
                if (attributeValue != null) {
                    return attributeValue;
                }
                return elem.getChild(n);
            }

            public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
                throw new OgnlException("", (Throwable)new UnsupportedOperationException("setProperty not supported on XML elements"));
            }
        });
        OgnlRuntime.setPropertyAccessor(RowBacked.class, (PropertyAccessor)new ObjectPropertyAccessor(){

            public Object getProperty(Map context, Object target, Object name) throws OgnlException {
                try {
                    return super.getProperty(context, target, name);
                }
                catch (NoSuchPropertyException e) {
                    RowBacked elem = (RowBacked)target;
                    String n = (String)name;
                    return elem.get(n.toUpperCase());
                }
            }
        });
    }
}

