/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;

public final class DropTable
extends ChangeTable<DropTable> {
    private final SQLTable t;

    public DropTable(SQLTable t) {
        super(t.getServer().getSQLSystem().getSyntax(), t.getDBRoot().getName(), t.getName());
        this.t = t;
    }

    private final AlterTable getAlterTable() {
        AlterTable alterTable = new AlterTable(this.t);
        for (Link foreignLink : this.t.getForeignLinks()) {
            if (foreignLink.getName() == null) {
                throw new IllegalStateException(foreignLink + " is not a real constraint, use AddFK");
            }
            alterTable.dropForeignConstraint(foreignLink.getName());
        }
        return alterTable;
    }

    @Override
    public String asString(ChangeTable.NameTransformer transf) {
        return "DROP TABLE " + transf.transformTableName(new SQLName(this.getRootName(), this.getName())).quote() + ";";
    }

    @Override
    protected String asString(ChangeTable.NameTransformer transf, ChangeTable.ConcatStep step) {
        switch (step) {
            case DROP_FOREIGN: {
                return this.getAlterTable().asString(transf, step);
            }
            case ALTER_TABLE: {
                return this.asString(transf);
            }
        }
        return null;
    }

    @Override
    public DropTable addColumn(String name, String definition) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getConstraintPrefix() {
        throw new UnsupportedOperationException();
    }
}

