/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.SetMap;

public class ChangePrivileges {
    private final String name;
    private final SetMap<SQLName, TablePrivilege> privilegesToGrant;
    private final SetMap<SQLName, TablePrivilege> privilegesToRevoke;

    public ChangePrivileges(String userName) {
        this.name = userName;
        this.privilegesToGrant = new SetMap(CollectionMap2.Mode.NULL_MEANS_ALL);
        this.privilegesToRevoke = new SetMap(CollectionMap2.Mode.NULL_MEANS_ALL);
    }

    public final ChangePrivileges grantTablePrivilege(SQLName t, TablePrivilege priv) {
        return this.changeTablePrivilege(PrivelegeAction.GRANT, t, priv);
    }

    public final ChangePrivileges revokeTablePrivilege(SQLName t, TablePrivilege priv) {
        return this.changeTablePrivilege(PrivelegeAction.REVOKE, t, priv);
    }

    public final ChangePrivileges changeTablePrivilege(PrivelegeAction grant, DBRoot r, TablePrivilege priv) {
        this.changeTablePrivilege(grant, new SQLName(r.getName()), priv);
        return this;
    }

    public final ChangePrivileges changeTablePrivilege(PrivelegeAction grant, SQLTable t, TablePrivilege priv) {
        return this.changeTablePrivilege(grant, t.getSQLNameUntilDBRoot(true), priv);
    }

    public final ChangePrivileges changeTablePrivilege(PrivelegeAction grant, SQLName t, TablePrivilege priv) throws IllegalArgumentException {
        return this.addTablePrivilege(grant == PrivelegeAction.GRANT ? this.privilegesToGrant : this.privilegesToRevoke, t, priv);
    }

    private final ChangePrivileges addTablePrivilege(SetMap<SQLName, TablePrivilege> m, SQLName t, TablePrivilege priv) throws IllegalArgumentException {
        if (t.getItemCount() == 0 || t.getItemCount() > 2) {
            throw new IllegalArgumentException("not root.table :" + t);
        }
        if (priv == null) {
            m.put(t, null);
        } else {
            m.add(t, priv);
        }
        return this;
    }

    public final ChangePrivileges removeTablePrivilege(SQLName t) {
        if (t.getItemCount() != 2) {
            throw new IllegalArgumentException("not root.table :" + t);
        }
        this.privilegesToGrant.remove(t);
        this.privilegesToRevoke.remove(t);
        return this;
    }

    private final Set<String> getTableNames(DBSystemRoot sysRoot, SQLName name) {
        Set<String> tables;
        String rootName = name.getFirst();
        if (name.getItemCount() == 2) {
            tables = Collections.singleton(name.getName());
        } else {
            assert (name.getItemCount() == 1);
            tables = sysRoot.getRoot(rootName).getChildrenNames();
        }
        return tables;
    }

    public final List<String> getStatements(DBSystemRoot sysRoot) {
        ArrayList<String> res = new ArrayList<String>();
        String qName = SQLBase.quoteIdentifier(this.name);
        HashSet<String> roots = new HashSet<String>();
        for (Map.Entry e : this.privilegesToGrant.entrySet()) {
            String privs = e.getValue() == null ? "ALL" : CollectionUtils.join((Collection)e.getValue(), ", ");
            SQLName name = (SQLName)e.getKey();
            String rootName = name.getFirst();
            for (String tableName : this.getTableNames(sysRoot, name)) {
                res.add("GRANT " + privs + " ON " + new SQLName(rootName, tableName).quote() + " TO " + qName);
            }
            roots.add(rootName);
        }
        if (sysRoot.getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
            for (String schema : roots) {
                res.add(0, "GRANT USAGE ON SCHEMA " + SQLBase.quoteIdentifier(schema) + " TO " + qName);
            }
        }
        roots.clear();
        for (Map.Entry e : this.privilegesToRevoke.entrySet()) {
            boolean allPriv = e.getValue() == null;
            String privs = allPriv ? "ALL" : CollectionUtils.join((Collection)e.getValue(), ", ");
            SQLName name = (SQLName)e.getKey();
            String rootName = name.getFirst();
            for (String tableName : this.getTableNames(sysRoot, name)) {
                res.add("REVOKE " + privs + " ON " + new SQLName(rootName, tableName).quote() + " FROM " + qName);
            }
            if (!allPriv || name.getItemCount() != 1) continue;
            roots.add(rootName);
        }
        if (sysRoot.getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
            for (String schema : roots) {
                res.add(0, "REVOKE USAGE ON SCHEMA " + SQLBase.quoteIdentifier(schema) + " FROM " + qName);
            }
        }
        return res;
    }

    public final void execute(DBSystemRoot sysRoot) {
        SQLDataSource ds = sysRoot.getDataSource();
        for (String s : this.getStatements(sysRoot)) {
            ds.execute(s);
        }
    }

    public static enum PrivelegeAction {
        GRANT,
        REVOKE;

    }

    public static enum TablePrivilege {
        SELECT,
        INSERT,
        UPDATE,
        DELETE;

    }
}

