/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.sqlobject.ElementComboBoxUtils;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIComboBoxElement;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIPanelFiller {
    private final LightUIPanel panel;

    public LightUIPanelFiller(LightUIPanel panel) {
        this.panel = panel;
    }

    public void fillWithDefaultValues() {
        int panelChildCount = this.panel.getChildrenCount();
        int i = 0;
        while (i < panelChildCount) {
            LightUILine panelChild = this.panel.getChild(i, LightUILine.class);
            int lineChildCount = panelChild.getChildrenCount();
            int j = 0;
            while (j < lineChildCount) {
                LightUIElement element = panelChild.getChild(j);
                if (element.getType() == 2) {
                    element.setValue(JSONConverter.getJSON(new Date(System.currentTimeMillis())).toString());
                }
                ++j;
            }
            ++i;
        }
    }

    public void fillFromRow(PropsConfiguration configuration, SQLRowAccessor row) {
        this.fillFromRow(this.panel, configuration, row);
    }

    private void fillFromRow(LightUIPanel panel, PropsConfiguration configuration, SQLRowAccessor sqlRow) {
        int panelChildCount = panel.getChildrenCount();
        if (sqlRow.hasID()) {
            sqlRow = sqlRow.asRow();
        }
        int i = 0;
        while (i < panelChildCount) {
            LightUILine panelChild = panel.getChild(i, LightUILine.class);
            int lineChildCount = panelChild.getChildrenCount();
            int j = 0;
            while (j < lineChildCount) {
                Integer value;
                LightUIElement element = panelChild.getChild(j);
                SQLField sqlField = configuration.getFieldMapper().getSQLFieldForItem(element.getId());
                SQLRowAccessor sqlRowTmp = this.getSQLRowForField(sqlRow, sqlField);
                if (sqlRowTmp == null) {
                    throw new IllegalArgumentException("Impossible to reach the field: " + sqlField.getName() + " from table " + sqlRow.getTable().getName());
                }
                int type = element.getType();
                if (type == 1 || type == 27) {
                    if (sqlField == null) {
                        Log.get().severe("No field found for text field : " + element.getId());
                    } else {
                        element.setValue(sqlRowTmp.getString(sqlField.getName()));
                    }
                } else if (type == 3) {
                    LightUIComboBox combo = (LightUIComboBox)element;
                    if (!combo.isAlreadyFill()) {
                        SQLTable foreignTable = sqlField.getForeignTable();
                        Collection fieldsToFetch = configuration.getDirectory().getElement(foreignTable).getComboRequest().getFields();
                        if (sqlRowTmp.getObject(sqlField.getName()) != null) {
                            Where where = new Where((FieldRef)foreignTable.getKey(), "=", sqlRowTmp.getForeignID(sqlField.getName()));
                            SQLRowValues graph = ElementComboBoxUtils.getGraphToFetch(configuration, foreignTable, (List<SQLField>)fieldsToFetch);
                            List<Tuple2<Path, List<FieldPath>>> expanded = ElementComboBoxUtils.expandGroupBy(graph, configuration.getDirectory());
                            List<SQLRowValues> fetchedRows = ElementComboBoxUtils.fetchRows(graph, where);
                            if (fetchedRows.size() > 1) {
                                throw new IllegalStateException("multiple rows fetched, id: " + (sqlRowTmp.hasID() ? Integer.valueOf(sqlRowTmp.getID()) : "undefined") + " table: " + sqlRowTmp.getTable().getName());
                            }
                            for (SQLRowValues vals : fetchedRows) {
                                LightUIComboBoxElement value2 = ElementComboBoxUtils.createLightUIItem(expanded, vals);
                                combo.setSelectedValue(value2);
                            }
                        } else {
                            element.setValue(null);
                        }
                    }
                } else if (type == 5) {
                    if (sqlRowTmp.getBoolean(sqlField.getName()).booleanValue()) {
                        element.setValue("true");
                    } else {
                        element.setValue("false");
                    }
                } else if (type == 2) {
                    Calendar date = sqlRowTmp.getDate(sqlField.getName());
                    if (date != null) {
                        element.setValue(JSONConverter.getJSON(date).toString());
                    }
                } else if (type == 8) {
                    this.fillFromRow((LightUIPanel)element, configuration, sqlRowTmp);
                } else if (type == 18 && (value = Integer.valueOf(sqlRowTmp.getInt(sqlField.getName()))) != null) {
                    element.setValue(value.toString());
                }
                ++j;
            }
            ++i;
        }
    }

    public SQLRowAccessor getSQLRowForField(SQLRowAccessor sqlRow, SQLField sqlField) {
        SQLRowAccessor sqlRowResult = sqlRow;
        if (sqlField != null && !sqlField.getTable().getName().equals(sqlRow.getTable().getName())) {
            sqlRowResult = this.findSQLRow(sqlRow, sqlField);
        }
        return sqlRowResult;
    }

    public SQLRowAccessor findSQLRow(SQLRowAccessor sqlRow, SQLField sqlField) {
        Set<Constraint> constraints = sqlRow.getTable().getAllConstraints();
        for (Constraint constraint : constraints) {
            if (!constraint.getType().equals((Object)SQLSyntax.ConstraintType.FOREIGN_KEY)) continue;
            String firstFkCols = constraint.getCols().get(0);
            SQLRowAccessor fkRow = sqlRow.getForeign(firstFkCols);
            if (fkRow.getTable().getName().equals(sqlField.getTable().getName())) {
                return fkRow;
            }
            SQLRowAccessor sqlRowResult = this.findSQLRow(fkRow, sqlField);
            if (sqlRowResult == null) continue;
            return sqlRowResult;
        }
        return null;
    }
}

