/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUITable;
import org.openconcerto.ui.light.Row;
import org.openconcerto.ui.light.TableContent;
import org.openconcerto.utils.io.JSONConverter;

public class LightRowValuesTable
extends LightUITable {
    List<SQLRowValues> listRowValues = new ArrayList<SQLRowValues>();
    String fieldRefName;
    private SQLRowAccessor refRow;
    private boolean autoCommit = false;
    private List<Integer> deletedIds = new ArrayList<Integer>();

    public LightRowValuesTable(JSONObject json) {
        super(json);
        this.init();
    }

    public LightRowValuesTable(LightRowValuesTable tableElement) {
        super(tableElement);
        this.listRowValues = tableElement.listRowValues;
        this.fieldRefName = tableElement.fieldRefName;
        this.deletedIds = tableElement.deletedIds;
        this.refRow = tableElement.refRow;
        this.init();
    }

    public LightRowValuesTable(LightUITable table, String fieldRefName) {
        super(table);
        this.fieldRefName = fieldRefName;
        this.init();
    }

    public String getFieldRefName() {
        return this.fieldRefName;
    }

    public SQLRowValues getRowValues(int index) {
        return this.listRowValues.get(index);
    }

    public int getRowValuesCount() {
        return this.listRowValues.size();
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        if (autoCommit && this.refRow == null) {
            throw new IllegalArgumentException("Set parent row before put this table in auto commit mode");
        }
        this.autoCommit = autoCommit;
    }

    public void setParentSQLRow(Configuration configuration, SQLElement sqlElement, SQLRowAccessor sqlRow) {
        TableContent content = new TableContent(this.getId());
        content.setRows(new ArrayList<Row>());
        this.getTableSpec().setContent(content);
        this.refRow = sqlRow;
        this.refetchTable(configuration, sqlElement);
    }

    public void refetchTable(Configuration configuration, SQLElement sqlElement) {
        this.getTableSpec().getContent().getRows().clear();
        this.listRowValues.clear();
        if (this.refRow != null && !this.refRow.isUndefined()) {
            SQLTableModelSourceOnline tableSource = sqlElement.getTableSource(true);
            ListSQLRequest req = tableSource.getReq();
            req.setWhere(new Where((FieldRef)sqlElement.getTable().getField(this.getFieldRefName()), "=", this.refRow.getID()));
            List<SQLRowValues> listRowValues = req.getValues();
            for (SQLRowValues rowValues : listRowValues) {
                this.addRowValues(configuration, rowValues);
            }
        }
    }

    public SQLRowAccessor getRefRow() {
        return this.refRow;
    }

    public void clearRowValues() {
        this.getTableSpec().getContent().getRows().clear();
        this.listRowValues.clear();
    }

    public void removeRowValuesAt(int index) {
        TableContent content = this.getTableSpec().getContent();
        content.getRows().remove(index);
        this.listRowValues.remove(index);
    }

    public void addRowValues(Configuration configuration, SQLRowValues rowValues) {
        TableContent content = this.getTableSpec().getContent();
        this.listRowValues.add(rowValues);
        content.getRows().add(this.createRowFromRowValues(configuration, rowValues, this.listRowValues.size() - 1));
    }

    public void setRowValues(Configuration configuration, SQLRowValues rowValues, int index) {
        TableContent content = this.getTableSpec().getContent();
        this.listRowValues.set(index, rowValues);
        content.getRows().set(index, this.createRowFromRowValues(configuration, rowValues, index));
    }

    public void archiveDeletedRows(Configuration configuration) {
        SQLElement sqlElement = configuration.getDirectory().getElementForCode(this.getElementCode());
        for (Integer deletedId : this.deletedIds) {
            try {
                sqlElement.archive(deletedId);
            }
            catch (SQLException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }
    }

    public void addDeletedId(int idToDelete) {
        this.deletedIds.add(idToDelete);
    }

    protected Row createRowFromRowValues(Configuration configuration, SQLRowValues sqlRow, int index) {
        SQLElement element = configuration.getDirectory().getElementForCode(this.getElementCode());
        if (element == null) {
            throw new IllegalArgumentException("Unable to find element for code: " + this.getElementCode());
        }
        SQLTableModelSourceOnline tableSource = element.getTableSource(true);
        List<SQLTableModelColumn> allCols = tableSource.getColumns();
        Row row = element.createRowFromSQLRow(sqlRow, allCols, this.getTableSpec().getColumns());
        row.setId(index);
        return row;
    }

    private void init() {
        if (this.getTableSpec().getContent() == null) {
            this.getTableSpec().setContent(new TableContent(this.getId()));
        }
    }

    @Override
    public LightUIElement clone() {
        return new LightRowValuesTable(this);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.listRowValues != null && !this.listRowValues.isEmpty()) {
            json.put("list-row-values", null);
        }
        if (this.deletedIds != null && !this.deletedIds.isEmpty()) {
            json.put("deleted-ids", JSONConverter.getJSON(this.deletedIds));
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        JSONArray jsonListRowValues = JSONConverter.getParameterFromJSON(json, "list-row-values", JSONArray.class);
        this.listRowValues = new ArrayList<SQLRowValues>();
        if (this.getTableSpec().getContent() != null) {
            this.getTableSpec().getContent().getRows().clear();
        }
        JSONArray jsonDeletedIds = JSONConverter.getParameterFromJSON(json, "deleted-ids", JSONArray.class);
        this.deletedIds = new ArrayList<Integer>();
        if (jsonDeletedIds != null) {
            for (Object jsonDeletedId : jsonDeletedIds) {
                this.deletedIds.add(JSONConverter.getObjectFromJSON(jsonDeletedId, Integer.class));
            }
        }
    }
}

