/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldMapper;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.ui.light.LightRowValuesTable;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.light.ComboValueConvertor;
import org.openconcerto.ui.light.CustomEditorProvider;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUICheckBox;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIDate;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIFrame;
import org.openconcerto.ui.light.StringValueConvertor;
import org.openconcerto.utils.io.JSONConverter;

public class LightEditFrame
extends LightUIFrame {
    private static final String EDIT_MODE_JSON_KEY = "edit-mode";
    private Group group;
    private SQLRowValues sqlRow;
    private EditPanel.EditMode editMode = EditPanel.EditMode.READONLY;

    public LightEditFrame(JSONObject json) {
        super(json);
    }

    public LightEditFrame(LightEditFrame frame) {
        super(frame);
        this.sqlRow = frame.sqlRow;
        this.group = frame.group;
        this.editMode = frame.editMode;
    }

    public LightEditFrame(Configuration conf, Group group, SQLRowValues sqlRow, LightUIFrame parentFrame, EditPanel.EditMode editMode) {
        super(String.valueOf(group.getId()) + ".edit.frame");
        this.setType(13);
        this.setParent(parentFrame);
        this.sqlRow = sqlRow;
        this.group = group;
        this.setEditMode(editMode);
    }

    public void setEditMode(EditPanel.EditMode editMode) {
        this.editMode = editMode;
        if (editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            this.setReadOnly(true);
        } else {
            this.setReadOnly(false);
        }
    }

    public SQLRow commitSqlRow(Configuration configuration) {
        if (this.editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            throw new IllegalArgumentException("Impossible to commit values when the frame is read only");
        }
        SQLElement sqlElement = configuration.getDirectory().getElement(this.sqlRow.getTable());
        try {
            return this.sqlRow.prune(sqlElement.getPrivateGraph()).commit();
        }
        catch (SQLException ex) {
            throw new IllegalArgumentException("Unable to commit SQLRowValues, edit frame ID: " + this.getId(), ex);
        }
    }

    public EditPanel.EditMode getEditMode() {
        return this.editMode;
    }

    public Group getGroup() {
        return this.group;
    }

    public SQLRowValues getSqlRow() {
        return this.sqlRow;
    }

    public void updateRow(Configuration configuration, String sessionSecurityToken, int userId) {
        if (this.editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            throw new IllegalArgumentException("Impossible to update values when the frame is read only");
        }
        this.updateRow(configuration, this.group, sessionSecurityToken, userId);
    }

    private void updateRow(Configuration configuration, Group group, String sessionSecurityToken, int userId) {
        FieldMapper fieldMapper = configuration.getFieldMapper();
        if (fieldMapper == null) {
            throw new IllegalStateException("null field mapper");
        }
        SQLElement sqlElement = configuration.getDirectory().getElement(this.sqlRow.getTable());
        Map<String, ComboValueConvertor<?>> valueConvertors = sqlElement.getComboConvertors();
        Map<String, CustomEditorProvider> customEditors = null;
        customEditors = this.editMode.equals((Object)EditPanel.EditMode.CREATION) ? sqlElement.getCustomEditorProviderForCreation(configuration, sessionSecurityToken) : sqlElement.getCustomEditorProviderForModification(configuration, this.sqlRow, sessionSecurityToken);
        this.createRowValues(configuration, sqlElement, fieldMapper, this.group, valueConvertors, customEditors);
        this.setMetaData(userId);
    }

    protected final void createRowValues(Configuration conf, SQLElement sqlElement, FieldMapper fieldMapper, Group group, Map<String, ComboValueConvertor<?>> valueConvertors, Map<String, CustomEditorProvider> customEditors) {
        int itemCount = group.getSize();
        int i = 0;
        while (i < itemCount) {
            Item item = group.getItem(i);
            if (item instanceof Group) {
                this.createRowValues(conf, sqlElement, fieldMapper, (Group)item, valueConvertors, customEditors);
            } else {
                SQLField field = fieldMapper.getSQLFieldForItem(item.getId());
                if (field != null) {
                    LightUIElement uiElement = this.findChild(item.getId(), false);
                    if (uiElement == null) {
                        throw new IllegalArgumentException("Impossible to find UI Element with id: " + item.getId());
                    }
                    if (!uiElement.isNotSaved()) {
                        if (!valueConvertors.containsKey(item.getId())) {
                            this.putValueFromUserControl(conf, sqlElement, field, uiElement);
                        } else {
                            if (!(uiElement instanceof LightUIComboBox)) {
                                throw new IllegalArgumentException("The UI Element with ID " + item.getId() + ", must be an instance of LightUIComboBox");
                            }
                            LightUIComboBox combo = (LightUIComboBox)uiElement;
                            if (combo.hasSelectedValue() && combo.getSelectedValue().getId() != 0) {
                                ComboValueConvertor<?> valueConvertor = valueConvertors.get(item.getId());
                                if (valueConvertor instanceof StringValueConvertor) {
                                    this.sqlRow.put(field.getFieldName(), ((StringValueConvertor)valueConvertor).getIdFromIndex(combo.getSelectedValue().getId()));
                                } else {
                                    int selectedId = combo.getSelectedValue().getId();
                                    this.sqlRow.put(field.getFieldName(), selectedId);
                                }
                            } else {
                                this.sqlRow.put(field.getFieldName(), null);
                            }
                        }
                    }
                } else {
                    Log.get().warning("No field attached to " + item.getId());
                }
            }
            ++i;
        }
    }

    protected final void putValueFromUserControl(Configuration conf, SQLElement sqlElement, SQLField field, LightUIElement uiElement) {
        if (!uiElement.isNotSaved()) {
            Class<?> fieldType = field.getType().getJavaType();
            if (field.isKey()) {
                if (!(uiElement instanceof LightUIComboBox)) {
                    throw new IllegalArgumentException("Invalid UI Element for field: " + field.getName() + ". When field is foreign key, UI Element must be a LightUIDate");
                }
                LightUIComboBox combo = (LightUIComboBox)uiElement;
                if (combo.hasSelectedValue()) {
                    this.sqlRow.put(field.getFieldName(), (Object)sqlElement.getValuesOfShowAs(conf, field, combo.getSelectedValue().getId()));
                } else {
                    this.sqlRow.put(field.getFieldName(), null);
                }
            } else if (fieldType.equals(String.class)) {
                this.sqlRow.put(field.getFieldName(), uiElement.getValue());
            } else if (fieldType.equals(Date.class)) {
                if (!(uiElement instanceof LightUIDate)) {
                    throw new IllegalArgumentException("Invalid UI Element for field: " + field.getName() + ". When field is Date, UI Element must be a LightUIDate");
                }
                this.sqlRow.put(field.getFieldName(), ((LightUIDate)uiElement).getValueAsDate());
            } else if (fieldType.equals(Boolean.class)) {
                if (!(uiElement instanceof LightUICheckBox)) {
                    throw new IllegalArgumentException("Invalid UI Element for field: " + field.getName() + ". When field is Boolean, UI Element must be a LightUICheckBox");
                }
                this.sqlRow.put(field.getFieldName(), ((LightUICheckBox)uiElement).isChecked());
            } else if (fieldType.equals(Timestamp.class)) {
                if (!(uiElement instanceof LightUIDate)) {
                    throw new IllegalArgumentException("Invalid UI Element for field: " + field.getName() + ". When field is Date, UI Element must be a LightUIDate");
                }
                this.sqlRow.put(field.getFieldName(), ((LightUIDate)uiElement).getValueAsDate());
            } else if (fieldType.equals(Integer.class)) {
                if (uiElement.getValue() != null && !uiElement.getValue().trim().isEmpty()) {
                    if (!uiElement.getValue().matches("^-?\\d+$")) {
                        throw new IllegalArgumentException("Invalid value for field: " + field.getName() + " value: " + uiElement.getValue());
                    }
                    this.sqlRow.put(field.getFieldName(), Integer.parseInt(uiElement.getValue()));
                } else {
                    this.sqlRow.put(field.getFieldName(), null);
                }
            } else if (fieldType.equals(Double.class) || fieldType.equals(Float.class) || fieldType.equals(BigDecimal.class)) {
                if (uiElement.getValue() != null && !uiElement.getValue().trim().isEmpty()) {
                    try {
                        this.sqlRow.put(field.getFieldName(), new BigDecimal(uiElement.getValue()));
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Invalid value for field: " + field.getName() + " value: " + uiElement.getValue());
                    }
                } else {
                    this.sqlRow.put(field.getFieldName(), null);
                }
            } else {
                Log.get().warning("unsupported type " + fieldType.getName());
            }
        }
    }

    public final void saveReferentRows(Configuration configuration, SQLRow parentSqlRow, Map<String, CustomEditorProvider> customEditors, String sessionSecurityToken) {
        this.saveReferentRows(configuration, this.group, parentSqlRow, customEditors, sessionSecurityToken);
    }

    private final void saveReferentRows(Configuration configuration, Group group, SQLRow parentSqlRow, Map<String, CustomEditorProvider> customEditors, String sessionSecurityToken) {
        int i = 0;
        while (i < group.getSize()) {
            LightUIElement element;
            Item item = group.getItem(i);
            if (item instanceof Group) {
                this.saveReferentRows(configuration, (Group)item, parentSqlRow, customEditors, sessionSecurityToken);
            } else if (customEditors.containsKey(item.getId()) && (element = this.findChild(item.getId(), false)) instanceof LightRowValuesTable) {
                LightRowValuesTable rowValsTable = (LightRowValuesTable)element;
                int rowValuesCount = rowValsTable.getRowValuesCount();
                int j = 0;
                while (j < rowValuesCount) {
                    SQLRowValues rowValues = rowValsTable.getRowValues(j);
                    if (!rowValues.isFrozen()) {
                        rowValues.put(rowValsTable.getFieldRefName(), parentSqlRow.getID());
                        try {
                            SQLElement el = configuration.getDirectory().getElement(rowValues.getTable());
                            boolean insertion = !rowValues.hasID();
                            SQLRow rowInserted = rowValues.prune(el.getPrivateGraph()).commit();
                            if (insertion) {
                                el.doAfterLightInsert(rowInserted, sessionSecurityToken);
                            }
                        }
                        catch (SQLException e) {
                            throw new IllegalArgumentException(e.getMessage(), e);
                        }
                    }
                    ++j;
                }
                rowValsTable.archiveDeletedRows(configuration);
            }
            ++i;
        }
    }

    protected final void setMetaData(int userId) {
        SQLTable sqlTable = this.sqlRow.getTable();
        if (this.sqlRow.getObject(sqlTable.getCreationUserField().getName()) == null || this.sqlRow.getObject(sqlTable.getCreationDateField().getName()) == null) {
            this.sqlRow.put(sqlTable.getCreationUserField().getName(), userId);
            this.sqlRow.put(sqlTable.getCreationDateField().getName(), new Date());
        }
        this.sqlRow.put(sqlTable.getModifUserField().getName(), userId);
        this.sqlRow.put(sqlTable.getModifDateField().getName(), new Date());
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightEditFrame(json);
            }
        };
    }

    @Override
    public LightUIElement clone() {
        return new LightEditFrame(this);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (!this.editMode.equals((Object)EditPanel.EditMode.READONLY)) {
            if (this.editMode.equals((Object)EditPanel.EditMode.CREATION)) {
                json.put(EDIT_MODE_JSON_KEY, 1);
            } else if (this.editMode.equals((Object)EditPanel.EditMode.MODIFICATION)) {
                json.put(EDIT_MODE_JSON_KEY, 2);
            }
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        int jsonEditMode = JSONConverter.getParameterFromJSON(json, EDIT_MODE_JSON_KEY, Integer.class, 3);
        if (jsonEditMode == 1) {
            this.editMode = EditPanel.EditMode.CREATION;
        } else if (jsonEditMode == 2) {
            this.editMode = EditPanel.EditMode.MODIFICATION;
        } else if (jsonEditMode == 3) {
            this.editMode = EditPanel.EditMode.READONLY;
        }
    }
}

