/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldMapper;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.ui.light.LightEditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;
import org.openconcerto.ui.light.CustomEditorProvider;
import org.openconcerto.ui.light.LightUICheckBox;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIDate;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIFrame;
import org.openconcerto.ui.light.LightUILabel;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.ui.light.LightUITextArea;
import org.openconcerto.ui.light.LightUITextField;
import org.openconcerto.utils.i18n.TranslationManager;

public class GroupToLightUIConvertor {
    private final int maxColumnCount;
    private PropsConfiguration configuration;
    private FieldMapper mapper;
    private Map<String, CustomEditorProvider> customEditorProviders = new HashMap<String, CustomEditorProvider>();

    public GroupToLightUIConvertor(PropsConfiguration conf) {
        this(conf, 4);
    }

    public GroupToLightUIConvertor(PropsConfiguration conf, int columns) {
        this.maxColumnCount = columns;
        this.configuration = conf;
        this.mapper = this.configuration.getFieldMapper();
        if (this.mapper == null) {
            throw new IllegalArgumentException("null mapper");
        }
    }

    public LightEditFrame convert(Group group, SQLRowValues defaultRow, LightUIFrame parentFrame, EditPanel.EditMode editMode) {
        if (group == null) {
            throw new IllegalArgumentException("Null Group");
        }
        if (defaultRow == null) {
            throw new IllegalArgumentException("Null default SQLRowValues");
        }
        SQLElement sqlElement = this.configuration.getDirectory().getElement(defaultRow.getTable());
        if (!sqlElement.getGroupForCreation().equals(group) && sqlElement.getGroupForModification().equals(group)) {
            throw new IllegalArgumentException("This group isn't attached to this SQLElement, group ID: " + group.getId() + " element code: " + sqlElement.getCode());
        }
        LightEditFrame editFrame = new LightEditFrame(this.configuration, group, defaultRow, parentFrame, editMode);
        LightUIPanel framePanel = editFrame.getFirstChild(LightUIPanel.class);
        this.append(framePanel, group);
        String frameTitle = TranslationManager.getInstance().getTranslationForItem(group.getId());
        if (frameTitle == null) {
            frameTitle = group.getId();
        }
        editFrame.setTitle(frameTitle);
        Log.get().warning("No translation for " + group.getId());
        return editFrame;
    }

    private void append(LightUIPanel panel, Item item) {
        if (item instanceof Group) {
            Group gr = (Group)item;
            int size = gr.getSize();
            String groupTitle = TranslationManager.getInstance().getTranslationForItem(gr.getId());
            if (gr.getLocalHint().isFoldable()) {
                LightUIPanel childPanel = new LightUIPanel(gr.getId());
                childPanel.setTitle(groupTitle);
                childPanel.setFoldable(true);
                childPanel.setGridWidth(4);
                childPanel.setFillWidth(true);
                int i = 0;
                while (i < size) {
                    this.append(childPanel, gr.getItem(i));
                    ++i;
                }
                LightUILine line = new LightUILine();
                line.addChild(childPanel);
                panel.addChild(line);
            } else {
                if (groupTitle != null) {
                    LightUILine titleLine = new LightUILine();
                    LightUILabel titleLabel = new LightUILabel(String.valueOf(gr.getId()) + ".title.label");
                    titleLabel.setFontBold(true);
                    titleLabel.setLabel(groupTitle);
                    titleLabel.setFillWidth(true);
                    titleLine.addChild(titleLabel);
                    panel.addChild(titleLine);
                    LightUILine line = new LightUILine();
                    panel.addChild(line);
                }
                int i = 0;
                while (i < size) {
                    Item it = gr.getItem(i);
                    this.append(panel, it);
                    ++i;
                }
            }
        } else {
            LightUIElement elementEditor;
            LayoutHints localHint = item.getLocalHint();
            LightUILine currentLine = panel.getLastLine();
            currentLine.setMarginTop(1);
            currentLine.setMarginBottom(1);
            if (localHint.isSeparated() && currentLine.getWidth() > 0) {
                currentLine = new LightUILine();
                panel.addChild(currentLine);
            }
            if (localHint.fillHeight()) {
                currentLine.setFillHeight(true);
            }
            if (localHint.largeHeight()) {
                currentLine.setWeightY(1);
            }
            if (currentLine.getWidth() >= this.maxColumnCount) {
                currentLine = new LightUILine();
                panel.addChild(currentLine);
            }
            SQLField field = this.mapper.getSQLFieldForItem(item.getId());
            LightUILabel elementLabel = null;
            String label = this.getLabelForItem(field, item);
            if (label == null) {
                label = item.getId();
                Log.get().warning("No translation for " + item.getId());
            }
            if (localHint.showLabel()) {
                currentLine.setElementPadding(5);
                elementLabel = new LightUILabel(String.valueOf(item.getId()) + ".label");
                elementLabel.setHorizontalAlignement(0);
                elementLabel.setLabel(label);
                if (localHint.isSplit()) {
                    elementLabel.setHorizontalAlignement(2);
                    if (currentLine.getChildrenCount() != 0) {
                        currentLine = new LightUILine();
                        panel.addChild(currentLine);
                    }
                    elementLabel.setGridWidth(4);
                } else {
                    elementLabel.setGridWidth(1);
                }
                currentLine.addChild(elementLabel);
            }
            if ((elementEditor = this.getCustomEditor(item.getId())) == null) {
                if (field != null) {
                    Class<?> javaType = field.getType().getJavaType();
                    if (field.isKey()) {
                        elementEditor = new LightUIComboBox(item.getId());
                        elementEditor.setMinInputSize(20);
                        elementEditor.setValueType(3);
                    } else if (javaType.equals(String.class)) {
                        if (field.getType().getSize() > 1000) {
                            elementEditor = new LightUITextArea(item.getId());
                            elementEditor.setValue("");
                            elementEditor.setMinInputSize(10);
                        } else {
                            elementEditor = new LightUITextField(item.getId());
                            elementEditor.setValue("");
                            elementEditor.setMinInputSize(10);
                        }
                        elementEditor.setValueType(0);
                    } else if (javaType.equals(Boolean.class)) {
                        elementEditor = new LightUICheckBox(item.getId(), "");
                        elementEditor.setLabel(label);
                        elementEditor.setValueType(6);
                        elementLabel.setLabel("");
                    } else if (javaType.equals(Date.class)) {
                        elementEditor = new LightUIDate(item.getId());
                        elementEditor.setValueType(2);
                    } else if (javaType.equals(Timestamp.class)) {
                        elementEditor = new LightUIDate(item.getId());
                        elementEditor.setValueType(2);
                    } else if (javaType.equals(Integer.class) || javaType.equals(Long.class) || javaType.equals(Short.class) || javaType.equals(BigInteger.class)) {
                        elementEditor = new LightUITextField(item.getId());
                        elementEditor.setValueType(1);
                    } else if (javaType.equals(BigDecimal.class) || javaType.equals(Float.class) || javaType.equals(Double.class)) {
                        elementEditor = new LightUITextField(item.getId());
                        elementEditor.setValueType(5);
                    } else {
                        elementEditor = new LightUITextField(item.getId());
                        Log.get().warning("unsupported type " + javaType.getName());
                        elementEditor.setValue("unsupported type " + javaType.getName());
                    }
                } else {
                    elementEditor = new LightUITextField(item.getId());
                    elementEditor.setMinInputSize(10);
                    elementEditor.setToolTip("No field attached to " + item.getId());
                    elementEditor.setValueType(0);
                    Log.get().warning("No field attached to " + item.getId());
                    if (elementLabel != null) {
                        elementLabel.setBackgroundColor(Color.ORANGE);
                        elementLabel.setToolTip("No field attached to " + item.getId());
                    }
                }
            }
            if (elementEditor != null) {
                elementEditor.setWeightX(1);
            }
            if (localHint.isSplit() && currentLine.getWidth() > 0) {
                currentLine = new LightUILine();
                panel.addChild(currentLine);
            }
            if (localHint.isSplit()) {
                elementEditor.setGridWidth(4);
            } else if (localHint.largeWidth()) {
                if (localHint.showLabel()) {
                    elementEditor.setGridWidth(3);
                } else {
                    elementEditor.setGridWidth(4);
                }
            } else {
                elementEditor.setGridWidth(1);
            }
            elementEditor.setFillWidth(localHint.fillWidth());
            currentLine.addChild(elementEditor);
        }
    }

    private String getLabelForItem(SQLField field, Item item) {
        RowItemDesc desc;
        String label = TranslationManager.getInstance().getTranslationForItem(item.getId());
        if (label == null && field != null && (desc = this.configuration.getTranslator().getDescFor(field.getTable(), field.getName())) != null) {
            label = desc.getLabel();
        }
        return label;
    }

    private LightUIElement getCustomEditor(String id) {
        CustomEditorProvider customEditorProvider = this.customEditorProviders.get(id);
        if (customEditorProvider != null) {
            LightUIElement element = customEditorProvider.createUIElement(id);
            if (element.getId() == null) {
                throw new IllegalStateException("Null id for custom editor for id: " + id);
            }
            return element;
        }
        return null;
    }

    public void putCustomEditorProvider(String id, CustomEditorProvider provider) {
        this.customEditorProviders.put(id, provider);
    }

    public void putAllCustomEditorProvider(Map<String, CustomEditorProvider> map) {
        this.customEditorProviders.putAll(map);
    }
}

