/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.component.JRadioButtons;
import org.openconcerto.utils.SwingWorker2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.Transformer;
import org.openconcerto.utils.i18n.TM;

public class RadioButtons
extends JRadioButtons<Integer>
implements RowItemViewComponent {
    private final String colName;
    private SQLField field;
    private ITransformer<? super String, String> tm;

    public RadioButtons() {
        this("LABEL");
    }

    public RadioButtons(String colName) {
        this.colName = colName;
        this.tm = Transformer.nopTransformer();
    }

    public final RadioButtons initLocalization(final TM tm) {
        return this.initLocalization((ITransformer<? super String, String>)new ITransformer<String, String>(){

            @Override
            public String transformChecked(String input) {
                return tm.translate(input, new Object[0]);
            }
        });
    }

    public final RadioButtons initLocalization(ITransformer<? super String, String> tm) {
        if (this.isInited()) {
            throw new IllegalStateException("Already inited");
        }
        this.tm = tm;
        return this;
    }

    private final Map<Integer, String> createChoices() {
        LinkedHashMap<Integer, String> res = new LinkedHashMap<Integer, String>();
        SQLTable choiceTable = this.getForeignTable();
        if (choiceTable == null) {
            throw new IllegalArgumentException("The field:" + this.field + " is not a foreign key");
        }
        SQLSelect sel = new SQLSelect();
        sel.addSelect(choiceTable.getKey());
        sel.addSelect(choiceTable.getField(this.colName));
        sel.addOrderSilent(choiceTable.getName());
        sel.addFieldOrder(choiceTable.getKey());
        for (SQLRow choice : SQLRowListRSH.execute(sel)) {
            String choiceLabel = choice.getString(this.colName);
            res.put(choice.getID(), this.tm.transformChecked(choiceLabel));
        }
        return res;
    }

    @Override
    public final void init(SQLRowItemView v) {
        this.field = v.getField();
        new SwingWorker2<Map<Integer, String>, Object>(){

            @Override
            protected Map<Integer, String> doInBackground() throws RuntimeException {
                return RadioButtons.this.createChoices();
            }

            @Override
            protected void done() {
                try {
                    RadioButtons.this.init(RadioButtons.this.getForeignTable().getUndefinedID(), (Map)this.get());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    throw (RuntimeException)e.getCause();
                }
            }
        }.execute();
    }

    private final SQLTable getForeignTable() {
        if (this.getField() == null) {
            throw new IllegalStateException(this + " not initialized.");
        }
        return this.getTable().getForeignTable(this.field.getName());
    }

    private final SQLTable getTable() {
        return this.field.getTable();
    }

    private final SQLField getField() {
        return this.field;
    }
}

