/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject.itemview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.element.RIVPanel;
import org.openconcerto.sql.element.SQLComponentItem;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.SQLForeignRowItemView;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.BaseRowItemView;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.checks.ChainValidListener;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.EmptyObjFromVO;
import org.openconcerto.utils.checks.EmptyObjHelper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;

public abstract class VWRowItemView<T>
extends BaseRowItemView
implements SQLComponentItem {
    private static final String VALUE_PROPNAME = "value";
    private final ValueWrapper<T> wrapper;
    private final PropertyChangeSupport supp;
    private final PropertyChangeListener valueL;
    private EmptyObjHelper helper;

    public VWRowItemView(ValueWrapper<T> wrapper) {
        this.wrapper = wrapper;
        this.supp = new PropertyChangeSupport(this);
        this.valueL = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                VWRowItemView.this.fireValueChange(evt);
            }
        };
    }

    public final ValueWrapper<T> getWrapper() {
        return this.wrapper;
    }

    @Override
    protected void init() {
        this.helper = this.createHelper();
    }

    @Override
    public void added(RIVPanel comp, SQLRowItemView v) {
        assert (v == this);
        if (this.getWrapper() instanceof SQLComponentItem) {
            ((SQLComponentItem)((Object)this.getWrapper())).added(comp, v);
        }
    }

    private final EmptyObjHelper createHelper() {
        EmptyObj eo = this.getWrapper() instanceof EmptyObj ? (EmptyObjFromVO<T>)((Object)this.getWrapper()) : (this.getWrapper().getComp() instanceof EmptyObj ? (EmptyObj)((Object)this.getWrapper().getComp()) : new EmptyObjFromVO<T>(this.getWrapper(), this.getEmptyPredicate()));
        return new EmptyObjHelper(this, eo);
    }

    protected IPredicate<T> getEmptyPredicate() {
        return EmptyObjFromVO.getDefaultPredicate();
    }

    @Override
    public void resetValue() {
        this.getWrapper().resetValue();
    }

    @Override
    public void show(SQLRowAccessor r) {
        if (r instanceof SQLRowValues && ((SQLRowValues)r).isDefault(this.getField().getName())) {
            this.getWrapper().setValue(null);
        } else if (r.getFields().contains(this.getField().getName())) {
            Object object = r.getObject(this.getField().getName());
            if (object instanceof SQLRowAccessor && this.getWrapper() instanceof SQLForeignRowItemView) {
                ((SQLForeignRowItemView)((Object)this.getWrapper())).setValue((SQLRowAccessor)object);
            } else {
                try {
                    Object casted = object;
                    this.getWrapper().setValue(casted);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot set value of  " + this.getWrapper() + " to " + object + " (from " + this.getField() + ")", e);
                }
            }
        }
    }

    @Override
    public void update(SQLRowValues vals) {
        vals.put(this.getField().getName(), this.isEmpty() ? SQLRowValues.SQL_DEFAULT : this.getWrapper().getValue());
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.supp.hasListeners(VALUE_PROPNAME)) {
            this.getWrapper().addValueListener(this.valueL);
        }
        this.supp.addPropertyChangeListener(VALUE_PROPNAME, l);
    }

    private final void fireValueChange(PropertyChangeEvent evt) {
        PropertyChangeEvent ourEvt = new PropertyChangeEvent(this, VALUE_PROPNAME, evt.getOldValue(), evt.getNewValue());
        ourEvt.setPropagationId(evt.getPropagationId());
        this.supp.firePropertyChange(ourEvt);
    }

    @Override
    public void removeValueListener(PropertyChangeListener l) {
        assert (SwingUtilities.isEventDispatchThread());
        this.supp.removePropertyChangeListener(VALUE_PROPNAME, l);
        if (!this.supp.hasListeners(VALUE_PROPNAME)) {
            this.getWrapper().rmValueListener(this.valueL);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " using " + this.getWrapper();
    }

    @Override
    public final boolean isEmpty() {
        return this.helper.isEmpty();
    }

    @Override
    public final void addEmptyListener(EmptyListener l) {
        this.helper.addEmptyListener(l);
    }

    @Override
    public void removeEmptyListener(EmptyListener l) {
        this.helper.removeEmptyListener(l);
    }

    @Override
    public ValidState getValidState() {
        return this.getWrapper().getValidState();
    }

    @Override
    public final void addValidListener(ValidListener l) {
        this.getWrapper().addValidListener(new ChainValidListener(this, l));
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.getWrapper().removeValidListener(new ChainValidListener(this, l));
    }

    @Override
    public final Component getComp() {
        return this.getWrapper().getComp();
    }

    @Override
    public void setEditable(InteractionMode mode) {
        Component comp = this.getComp();
        if (comp != null) {
            mode.applyTo(comp);
        }
    }
}

