/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.MultipleSQLSelectExecutor;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.sqlobject.IComboSelectionItemListener;
import org.openconcerto.sql.sqlobject.ITextWithCompletionPopUp;
import org.openconcerto.sql.sqlobject.SelectionRowListener;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.OrderedSet;
import org.openconcerto.utils.SwingWorker2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.MutableValueObject;
import org.openconcerto.utils.model.DefaultIMutableListModel;
import org.openconcerto.utils.text.DocumentFilterList;
import org.openconcerto.utils.text.LimitedSizeDocumentFilter;

public class ITextArticleWithCompletion
extends JPanel
implements DocumentListener,
IComboSelectionItemListener,
TextComponent,
MutableValueObject<String> {
    public static int SQL_RESULT_LIMIT = 50;
    public static final int MODE_STARTWITH = 1;
    public static final int MODE_CONTAINS = 2;
    private JTextComponent text;
    private DefaultIMutableListModel<IComboSelectionItem> model = new DefaultIMutableListModel();
    private boolean completionEnabled = true;
    private SQLRowAccessor selectedRow = null;
    private boolean selectAuto = true;
    protected ITextWithCompletionPopUp popup;
    OrderedSet<SelectionRowListener> listeners = new OrderedSet();
    Component popupInvoker;
    private boolean isLoading = false;
    private SQLRowAccessor rowToSelect = null;
    private String fillWith = "CODE";
    private final PropertyChangeSupport supp;
    private final SQLTable tableArticle;
    private final SQLTable tableArticleFournisseur;
    private Thread searchThread;
    private int autoCheckDelay = 1000;
    private boolean disposed = false;
    private Stack<String> searchStack = new Stack();
    private boolean autoselectIfMatch;
    private static final int PAUSE_MS = 150;
    private Where whereAdditionnal;
    private ITransformer<SQLSelect, SQLSelect> selTransformer;
    private boolean isDispatching = false;

    public ITextArticleWithCompletion(SQLTable tableArticle, SQLTable tableARticleFournisseur) {
        this.tableArticle = tableArticle;
        this.tableArticleFournisseur = tableARticleFournisseur;
        this.supp = new PropertyChangeSupport(this);
        this.popup = new ITextWithCompletionPopUp(this.model, this);
        this.text = new JTextField();
        this.setLayout(new GridLayout(1, 1));
        this.add(this.text);
        this.setTextEditor(this.text);
        this.setPopupInvoker(this);
        this.disposed = false;
        this.searchThread = new Thread(){

            @Override
            public void run() {
                while (!ITextArticleWithCompletion.this.disposed) {
                    if (ITextArticleWithCompletion.this.autoCheckDelay == 0) {
                        ITextArticleWithCompletion.this.autoCheckDelay = -1;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ITextArticleWithCompletion.this.loadAutoCompletion();
                            }
                        });
                    } else if (ITextArticleWithCompletion.this.autoCheckDelay > 0) {
                        ITextArticleWithCompletion iTextArticleWithCompletion = ITextArticleWithCompletion.this;
                        iTextArticleWithCompletion.autoCheckDelay = iTextArticleWithCompletion.autoCheckDelay - 150;
                    }
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.searchThread.setName("ITextArticleWithCompletion thread");
        this.searchThread.setPriority(1);
        this.searchThread.setDaemon(true);
        this.searchThread.start();
    }

    public void setPopupListEnabled(boolean b) {
        this.popup.setListEnabled(b);
    }

    public void setWhere(Where w) {
        this.whereAdditionnal = w;
    }

    public void setSelectTransformer(ITransformer<SQLSelect, SQLSelect> selTransformer) {
        this.selTransformer = selTransformer;
    }

    public void setTextEditor(final JTextComponent atext) {
        if (atext == null) {
            throw new IllegalArgumentException("null textEditor");
        }
        this.text = atext;
        atext.getDocument().addDocumentListener(this);
        atext.addKeyListener(new KeyListener(){
            private boolean consume;

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    ITextArticleWithCompletion.this.updateAutoCompletion(true);
                    e.consume();
                } else if (e.getKeyCode() == 40) {
                    if (ITextArticleWithCompletion.this.popup.isShowing()) {
                        ITextArticleWithCompletion.this.popup.selectNext();
                        e.consume();
                    } else if (ITextArticleWithCompletion.this.getSelectedRow() == null) {
                        ITextArticleWithCompletion.this.showPopup();
                    }
                } else if (e.getKeyCode() == 38) {
                    if (ITextArticleWithCompletion.this.popup.isShowing()) {
                        ITextArticleWithCompletion.this.popup.selectPrevious();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    if (ITextArticleWithCompletion.this.popup.isShowing()) {
                        ITextArticleWithCompletion.this.popup.validateSelection();
                        e.consume();
                    } else {
                        ITextArticleWithCompletion.this.autoselectIfMatch = true;
                        e.consume();
                    }
                } else if (e.getKeyCode() == 34) {
                    if (ITextArticleWithCompletion.this.popup.isShowing()) {
                        ITextArticleWithCompletion.this.popup.selectNextPage();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 33) {
                    if (ITextArticleWithCompletion.this.popup.isShowing()) {
                        ITextArticleWithCompletion.this.popup.selectPreviousPage();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 27 && ITextArticleWithCompletion.this.popup.isShowing()) {
                    ITextArticleWithCompletion.this.hidePopup();
                }
                if (ITextArticleWithCompletion.this.text.getDocument().getLength() == 0 && (e.getKeyCode() == 127 || e.getKeyCode() == 8)) {
                    System.err.println("consume");
                    this.consume = true;
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.consume) {
                    e.consume();
                    this.consume = false;
                }
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ITextArticleWithCompletion.this.popup.setMinWith(atext.getBounds().width);
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        atext.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ITextArticleWithCompletion.this.hidePopup();
            }
        });
    }

    List<IComboSelectionItem> getPossibleValues(String aText) throws SQLException {
        Vector<IComboSelectionItem> result = new Vector<IComboSelectionItem>();
        if (aText.isEmpty()) {
            return result;
        }
        if ((aText = aText.trim()).length() > 0) {
            ArrayList<SQLSelect> listSel = new ArrayList<SQLSelect>();
            SQLSelect selMatchingCode = new SQLSelect();
            selMatchingCode.addSelect(this.tableArticle.getKey());
            selMatchingCode.addSelect(this.tableArticle.getField("CODE"));
            selMatchingCode.addSelect(this.tableArticle.getField("NOM"));
            selMatchingCode.addSelect(this.tableArticle.getField("CODE_BARRE"));
            Where wMatchingCode = new Where((FieldRef)this.tableArticle.getField("CODE"), "=", (Object)aText);
            wMatchingCode = wMatchingCode.or(new Where((FieldRef)this.tableArticle.getField("NOM"), "=", (Object)aText));
            wMatchingCode = wMatchingCode.or(new Where((FieldRef)this.tableArticle.getField("CODE_BARRE"), "=", (Object)aText));
            if (this.whereAdditionnal != null) {
                wMatchingCode = wMatchingCode.and(this.whereAdditionnal);
            }
            selMatchingCode.setWhere(wMatchingCode);
            if (this.selTransformer != null) {
                selMatchingCode = this.selTransformer.transformChecked(selMatchingCode);
            }
            listSel.add(selMatchingCode);
            SQLSelect selContains = new SQLSelect();
            selContains.addSelect(this.tableArticle.getKey());
            selContains.addSelect(this.tableArticle.getField("CODE"));
            selContains.addSelect(this.tableArticle.getField("NOM"));
            selContains.addSelect(this.tableArticle.getField("CODE_BARRE"));
            Where wContains = new Where((FieldRef)this.tableArticle.getField("CODE"), "LIKE", (Object)("%" + aText + "%"));
            wContains = wContains.or(new Where((FieldRef)this.tableArticle.getField("NOM"), "LIKE", (Object)("%" + aText + "%")));
            wContains = wContains.or(new Where((FieldRef)this.tableArticle.getField("CODE_BARRE"), "LIKE", (Object)("%" + aText + "%")));
            if (this.whereAdditionnal != null) {
                wContains = wContains.and(this.whereAdditionnal);
            }
            selContains.setWhere(wContains.and(wMatchingCode.not()));
            selContains.setExcludeUndefined(false, this.tableArticle.getForeignTable("ID_STOCK"));
            selContains.setLimit(SQL_RESULT_LIMIT);
            if (this.selTransformer != null) {
                selContains = this.selTransformer.transformChecked(selContains);
            }
            listSel.add(selContains);
            Where wNotSync = new Where((FieldRef)this.tableArticleFournisseur.getField("ID_ARTICLE"), "IS", (Object)null).or(new Where((FieldRef)this.tableArticleFournisseur.getField("ID_ARTICLE"), "=", this.tableArticleFournisseur.getUndefinedID()));
            SQLSelect selMatchingCodeF = new SQLSelect();
            selMatchingCodeF.addSelect(this.tableArticleFournisseur.getKey());
            selMatchingCodeF.addSelect(this.tableArticleFournisseur.getField("CODE"));
            selMatchingCodeF.addSelect(this.tableArticleFournisseur.getField("NOM"));
            selMatchingCodeF.addSelect(this.tableArticleFournisseur.getField("CODE_BARRE"));
            Where wMatchingCodeF = new Where((FieldRef)this.tableArticleFournisseur.getField("CODE"), "=", (Object)aText);
            wMatchingCodeF = wMatchingCodeF.or(new Where((FieldRef)this.tableArticleFournisseur.getField("CODE_BARRE"), "=", (Object)aText));
            wMatchingCodeF = wMatchingCodeF.or(new Where((FieldRef)this.tableArticleFournisseur.getField("NOM"), "=", (Object)aText));
            selMatchingCodeF.setWhere(wMatchingCodeF.and(wNotSync));
            listSel.add(selMatchingCodeF);
            SQLSelect selContainsCodeF = new SQLSelect();
            selContainsCodeF.addSelect(this.tableArticleFournisseur.getKey());
            selContainsCodeF.addSelect(this.tableArticleFournisseur.getField("CODE"));
            selContainsCodeF.addSelect(this.tableArticleFournisseur.getField("NOM"));
            selContainsCodeF.addSelect(this.tableArticleFournisseur.getField("CODE_BARRE"));
            Where wContainsCodeF = new Where((FieldRef)this.tableArticleFournisseur.getField("CODE"), "LIKE", (Object)("%" + aText + "%"));
            wContainsCodeF = wContainsCodeF.or(new Where((FieldRef)this.tableArticleFournisseur.getField("CODE_BARRE"), "LIKE", (Object)("%" + aText + "%")));
            wContainsCodeF = wContainsCodeF.or(new Where((FieldRef)this.tableArticleFournisseur.getField("NOM"), "LIKE", (Object)("%" + aText + "%")));
            selContainsCodeF.setWhere(wContainsCodeF.and(wMatchingCodeF.not()).and(wNotSync));
            selContainsCodeF.setLimit(SQL_RESULT_LIMIT);
            listSel.add(selContainsCodeF);
            MultipleSQLSelectExecutor mult = new MultipleSQLSelectExecutor(this.tableArticle.getDBSystemRoot(), listSel);
            List<List<SQLRow>> resultList = mult.execute();
            for (List<SQLRow> list : resultList) {
                for (SQLRow sqlRow : list) {
                    StringBuffer buf = new StringBuffer();
                    if (sqlRow.getString("CODE_BARRE") != null && sqlRow.getString("CODE_BARRE").trim().length() > 0) {
                        buf.append(String.valueOf(sqlRow.getString("CODE_BARRE")) + " -- ");
                    }
                    buf.append(String.valueOf(sqlRow.getString("CODE")) + " -- ");
                    buf.append(sqlRow.getString("NOM"));
                    result.add(new IComboSelectionItem(sqlRow, buf.toString()));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAutoCompletion(boolean autoselectIfMatch) {
        this.autoselectIfMatch = autoselectIfMatch;
        this.autoCheckDelay = 300;
        Stack<String> stack = this.searchStack;
        synchronized (stack) {
            this.searchStack.push(this.text.getText().trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAutoCompletion() {
        String t;
        if (!this.isCompletionEnabled() || this.isLoading) {
            return;
        }
        Stack<String> stack = this.searchStack;
        synchronized (stack) {
            if (this.searchStack.isEmpty()) {
                return;
            }
            t = this.searchStack.pop();
            this.searchStack.clear();
        }
        SwingWorker2<List<IComboSelectionItem>, Object> worker = new SwingWorker2<List<IComboSelectionItem>, Object>(){

            @Override
            protected List<IComboSelectionItem> doInBackground() throws Exception {
                List<IComboSelectionItem> l = ITextArticleWithCompletion.this.getPossibleValues(t);
                return l;
            }

            @Override
            protected void done() {
                ArrayList l;
                try {
                    l = (ArrayList)this.get();
                }
                catch (Exception e) {
                    l = new ArrayList(0);
                    e.printStackTrace();
                }
                if (l.size() != ITextArticleWithCompletion.this.model.getSize() && l.size() <= 10) {
                    ITextArticleWithCompletion.this.hidePopup();
                }
                ITextArticleWithCompletion.this.model.removeAllElements();
                ITextArticleWithCompletion.this.model.addAll(l);
                if (l.size() > 0) {
                    ITextArticleWithCompletion.this.showPopup();
                } else {
                    ITextArticleWithCompletion.this.hidePopup();
                }
                SQLRowAccessor newRow = ITextArticleWithCompletion.this.selectedRow;
                IComboSelectionItem newSelectedItem = null;
                boolean found = false;
                for (IComboSelectionItem element : l) {
                    if (!element.getRow().getString("CODE_BARRE").toLowerCase().equals(t.toLowerCase()) && !element.getRow().getString("CODE").toLowerCase().equals(t.toLowerCase()) || !ITextArticleWithCompletion.this.autoselectIfMatch) continue;
                    newRow = element.getRow();
                    newSelectedItem = element;
                    ITextArticleWithCompletion.this.hidePopup();
                    found = true;
                    break;
                }
                if (ITextArticleWithCompletion.this.selectAuto && found && !CompareUtils.equals(newRow, ITextArticleWithCompletion.this.selectedRow)) {
                    final IComboSelectionItem selectedItem = newSelectedItem;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ITextArticleWithCompletion.this.itemSelected(selectedItem);
                        }
                    });
                }
                if (!found) {
                    ITextArticleWithCompletion.this.selectedRow = null;
                    ITextArticleWithCompletion.this.itemSelected(null);
                }
            }
        };
        worker.execute();
    }

    public synchronized void hidePopup() {
        this.popup.setVisible(false);
    }

    private synchronized void showPopup() {
        if (this.model.getSize() > 0 && this.popupInvoker.isShowing()) {
            this.popup.show(this.popupInvoker, 0, this.text.getBounds().height);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateAutoCompletion(false);
        this.supp.firePropertyChange("value", null, this.getText());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateAutoCompletion(false);
        this.supp.firePropertyChange("value", null, this.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateAutoCompletion(false);
        this.supp.firePropertyChange("value", null, this.getText());
    }

    public SQLRowAccessor getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(SQLRowAccessor row) {
        this.selectedRow = row;
    }

    private void clearText() {
        this.setText("");
    }

    public void setEditable(boolean b) {
        this.text.setEditable(b);
    }

    public void setFillWithField(String s) {
        this.fillWith = s;
    }

    public SQLField getFillWithField() {
        return this.tableArticle.getField(this.fillWith);
    }

    public void selectItem(IComboSelectionItem item) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Not in Swing!");
        }
        if (item != null) {
            if (this.fillWith != null) {
                SQLRowAccessor row = item.getRow();
                this.setText(row.getObject(this.fillWith).toString());
            } else {
                this.setText(item.getLabel());
            }
        } else {
            this.clearText();
        }
        this.hidePopup();
    }

    public void setText(String label) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Not in Swing!");
        }
        this.setCompletionEnabled(false);
        this.text.setText(label);
        if (label != null) {
            this.text.setCaretPosition(label.length());
        }
        this.text.repaint();
        this.setCompletionEnabled(true);
    }

    public void addSelectionListener(SelectionRowListener l) {
        this.listeners.add(l);
    }

    public void removeSelectionListener(SelectionRowListener l) {
        this.listeners.remove(l);
    }

    private void fireSelectionRow(SQLRowAccessor row) {
        if (!this.isDispatching) {
            this.isDispatching = true;
            for (SelectionRowListener element : this.listeners) {
                element.rowSelected(row, this);
            }
            this.isDispatching = false;
        }
    }

    boolean isCompletionEnabled() {
        return this.completionEnabled;
    }

    void setCompletionEnabled(boolean completionEnabled) {
        this.completionEnabled = completionEnabled;
    }

    public Object getText() {
        return this.text.getText();
    }

    public void setPopupInvoker(Component popupInvoker) {
        this.popupInvoker = popupInvoker;
    }

    @Override
    public JTextComponent getTextComp() {
        return this.text;
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    public void setSelectionAutoEnabled(boolean b) {
        this.selectAuto = b;
    }

    public void setLimitedSize(int nbChar) {
        DocumentFilterList dfl = DocumentFilterList.get((AbstractDocument)this.text.getDocument());
        Iterator<DocumentFilter> iter = dfl.getFilters().iterator();
        while (iter.hasNext()) {
            DocumentFilter df = iter.next();
            if (!(df instanceof LimitedSizeDocumentFilter)) continue;
            iter.remove();
        }
        DocumentFilterList.add((AbstractDocument)this.text.getDocument(), new LimitedSizeDocumentFilter(nbChar), DocumentFilterList.FilterType.SIMPLE_FILTER);
    }

    @Override
    public void resetValue() {
        this.setText("");
    }

    @Override
    public void setValue(String val) {
        this.setText(val);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public String getValue() {
        return (String)this.getText();
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    @Override
    public void itemSelected(IComboSelectionItem item) {
        if (item == null) {
            this.fireSelectionRow(null);
        } else {
            SQLRowAccessor row = item.getRow();
            if (this.isLoading) {
                this.rowToSelect = row;
            } else if (!CompareUtils.equals(this.selectedRow, row)) {
                this.setSelectedRow(row);
                this.selectItem(item);
                this.fireSelectionRow(row);
            }
        }
    }
}

