/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TransfFieldExpander;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.ui.light.LightUIComboBoxElement;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.ui.StringWithId;

public class ElementComboBoxUtils {
    public static final SQLRowValues getGraphToFetch(Configuration conf, SQLTable table, List<SQLField> fieldsToFetch) {
        if (fieldsToFetch == null) {
            return null;
        }
        SQLRowValues vals = new SQLRowValues(table);
        for (SQLField f : fieldsToFetch) {
            vals.put(f.getName(), null);
        }
        for (Path orderP : Collections.singletonList(new Path(table))) {
            SQLRowValues orderVals = vals.followPath(orderP);
            if (orderVals == null || !orderVals.getTable().isOrdered()) continue;
            orderVals.put(orderVals.getTable().getOrderField().getName(), null);
        }
        ElementComboBoxUtils.getShowAs(conf).expand(vals);
        return vals;
    }

    public static final StringWithId createItem(List<Tuple2<Path, List<FieldPath>>> expanded, final SQLRowValues rs) {
        String desc = rs.isUndefined() ? "?" : CollectionUtils.join(expanded, " \u25c4 ", new ITransformer<Tuple2<Path, List<FieldPath>>, Object>(){

            @Override
            public Object transformChecked(Tuple2<Path, List<FieldPath>> ancestorFields) {
                List filtered = CollectionUtils.transformAndFilter((Collection)ancestorFields.get1(), new ITransformer<FieldPath, String>(){

                    @Override
                    public String transformChecked(FieldPath input) {
                        return input.getString(rs);
                    }
                }, IPredicate.notNullPredicate(), new ArrayList());
                return CollectionUtils.join(filtered, " ");
            }
        });
        StringWithId res = new StringWithId(rs.getID(), desc);
        return res;
    }

    public static final LightUIComboBoxElement createLightUIItem(List<Tuple2<Path, List<FieldPath>>> expanded, SQLRowValues rs) {
        if (rs.getTable().isOrdered()) {
            rs.remove(rs.getTable().getOrderField().getName());
        }
        StringWithId createItem = ElementComboBoxUtils.createItem(expanded, rs);
        LightUIComboBoxElement res = new LightUIComboBoxElement(rs.getID());
        res.setValue1(createItem.getValue());
        return res;
    }

    private static Tuple2<SQLRowValues, List<FieldPath>> expandOnce(SQLRowValues vals, IFieldPath field) {
        assert (vals.getFields().contains(field.getFieldName()));
        Object foreignObj = vals.getObject(field.getFieldName());
        if (!(foreignObj instanceof SQLRowValues)) {
            return Tuple2.create(null, Collections.emptyList());
        }
        SQLRowValues foreign = (SQLRowValues)foreignObj;
        Path newPath = (Path)field.getPath().add(field.getField(), Link.Direction.FOREIGN);
        ArrayList<FieldPath> res = new ArrayList<FieldPath>();
        for (String f : foreign.getFields()) {
            res.add(new FieldPath(newPath, f));
        }
        return Tuple2.create(foreign, res);
    }

    public static final List<FieldPath> expand(SQLRowValues vals, IFieldPath field) {
        assert (vals.getTable() == field.getTable());
        ArrayList<FieldPath> fields = new ArrayList<FieldPath>();
        if (!field.getTable().getForeignKeys().contains(field.getField())) {
            fields.add(field.getFieldPath());
        } else {
            Tuple2<SQLRowValues, List<FieldPath>> tmp = ElementComboBoxUtils.expandOnce(vals, field);
            for (FieldPath f : tmp.get1()) {
                fields.addAll(ElementComboBoxUtils.expand(tmp.get0(), f));
            }
        }
        return fields;
    }

    public static final List<Tuple2<Path, List<FieldPath>>> expandGroupBy(SQLRowValues vals, SQLElementDirectory dir) {
        return ElementComboBoxUtils.expandGroupBy(new Path(vals.getTable()), vals, dir);
    }

    private static final List<Tuple2<Path, List<FieldPath>>> expandGroupBy(Path fieldsPath, SQLRowValues vals, SQLElementDirectory dir) {
        assert (fieldsPath.getLast() == vals.getTable());
        if (vals.size() == 0) {
            return Collections.emptyList();
        }
        SQLField parentFF = dir.getElement(fieldsPath.getLast()).getParentForeignField();
        ArrayList<Tuple2<Path, List<FieldPath>>> res = new ArrayList<Tuple2<Path, List<FieldPath>>>();
        ArrayList<FieldPath> currentL = new ArrayList<FieldPath>();
        res.add(Tuple2.create(fieldsPath, currentL));
        SQLRowValues parent = null;
        for (String f : vals.getFields()) {
            if (parentFF != null && f.equals(parentFF.getName())) {
                Object val = vals.getObject(f);
                parent = val instanceof SQLRowValues ? (SQLRowValues)val : null;
                continue;
            }
            currentL.addAll(ElementComboBoxUtils.expand(vals, new FieldPath(fieldsPath, f)));
        }
        if (parent != null) {
            res.addAll(ElementComboBoxUtils.expandGroupBy((Path)fieldsPath.add(parentFF, Link.Direction.FOREIGN), parent, dir));
        }
        return res;
    }

    public static final List<SQLRowValues> fetchRows(final SQLRowValues graphToFetch, final Where where) {
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(graphToFetch, false);
        final String tableName = graphToFetch.getTable().getName();
        BaseFillSQLRequest.setupForeign(fetcher);
        fetcher.appendSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                boolean lockSelect = true;
                if (lockSelect) {
                    sel.addLockedTable(tableName);
                }
                for (Path orderP : Collections.singletonList(new Path(graphToFetch.getTable()))) {
                    sel.addOrder(sel.assurePath(tableName, orderP), false);
                }
                if (where != null) {
                    sel.andWhere(where);
                }
                return sel;
            }
        });
        SQLRowValuesListFetcher comboSelect = fetcher.freeze();
        List<SQLRowValues> fetchedRows = comboSelect.fetch();
        return fetchedRows;
    }

    public static final TransfFieldExpander getShowAs(final Configuration conf) {
        TransfFieldExpander exp = new TransfFieldExpander(new ITransformer<SQLField, List<SQLField>>(){

            @Override
            public List<SQLField> transformChecked(SQLField fk) {
                SQLTable foreignTable = fk.getDBSystemRoot().getGraph().getForeignTable(fk);
                return conf.getDirectory().getElement(foreignTable).getComboRequest().getFields();
            }
        });
        return exp;
    }
}

