/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.request.BaseSQLRequest;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.cc.ITransformer;

public class SQLRowView
extends BaseSQLRequest {
    private final SQLElement element;
    private final SQLTableModifiedListener tableListener;
    private int selectedID;
    private SQLRowValues lastKnownDBVals;
    private final Map<String, SQLRowItemView> views;
    private final List<SQLRowItemView> viewsOrdered;
    private boolean readOnly;
    private boolean filling;
    private boolean updating;
    private final PropertyChangeSupport supp;

    public SQLRowView(SQLElement sqlElement) {
        if (sqlElement == null) {
            throw new NullPointerException("null SQLTable");
        }
        if (!sqlElement.getTable().isRowable()) {
            throw new IllegalArgumentException(sqlElement + " is not rowable");
        }
        this.supp = new PropertyChangeSupport(this);
        this.element = sqlElement;
        this.views = new HashMap<String, SQLRowItemView>();
        this.viewsOrdered = new LinkedList<SQLRowItemView>();
        this.readOnly = false;
        this.filling = false;
        this.updating = false;
        this.selectedID = -1;
        this.lastKnownDBVals = null;
        this.tableListener = new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                if (evt.getMode() == SQLTableEvent.Mode.ROW_UPDATED) {
                    this.rowModified(evt.getTable(), evt.getId());
                } else if (evt.getMode() == SQLTableEvent.Mode.ROW_DELETED) {
                    this.rowDeleted(evt.getTable(), evt.getId());
                }
            }

            public void rowModified(SQLTable t, int id) {
                if (!SQLRowView.this.isUpdating() && SQLRowView.this.existsInDB()) {
                    if (!t.equals(SQLRowView.this.getTable())) {
                        Thread.dumpStack();
                    } else if (SQLRowView.this.getSelectedID() == id) {
                        SQLRowView.this.select(id);
                    }
                }
            }

            public void rowDeleted(SQLTable t, int id) {
                if (!SQLRowView.this.isUpdating() && SQLRowView.this.existsInDB()) {
                    if (!t.equals(SQLRowView.this.getTable())) {
                        Thread.dumpStack();
                    } else if (SQLRowView.this.getSelectedID() == id) {
                        SwingThreadUtils.invoke(new Runnable(){

                            @Override
                            public void run() {
                                SQLRowView.this.select(null);
                            }
                        });
                    }
                }
            }
        };
    }

    public final SQLElement getElement() {
        return this.element;
    }

    private synchronized void setReadOnlySelection(boolean b) {
        if (this.readOnly != b) {
            this.readOnly = b;
            this.supp.firePropertyChange("readOnlySelection", !b, b);
        }
    }

    public synchronized boolean isReadOnlySelection() {
        return this.readOnly;
    }

    private final void checkRO() throws SQLException {
        if (this.isReadOnlySelection()) {
            throw new SQLException("Read only selection");
        }
    }

    public synchronized boolean isUpdating() {
        return this.updating;
    }

    public final void activate(boolean b) {
        if (b) {
            this.getTable().addTableModifiedListener(this.tableListener);
            if (this.existsInDB()) {
                this.select(this.getSelectedID());
            }
        } else {
            this.getTable().removeTableModifiedListener(this.tableListener);
        }
    }

    public void add(SQLRowItemView obj) {
        if (obj.getSQLName() == null) {
            throw new IllegalArgumentException("null SQL name for " + obj);
        }
        if (this.views.containsKey(obj.getSQLName())) {
            throw new IllegalStateException("2 views named " + obj.getSQLName() + ": " + this.views.get(obj.getSQLName()) + " " + obj);
        }
        this.views.put(obj.getSQLName(), obj);
        this.viewsOrdered.add(obj);
        assert (this.viewsOrdered.size() == this.views.size());
    }

    public final void setViewsOrder(Collection<String> names) {
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>(names);
        if (!this.views.keySet().equals(nameSet)) {
            throw new IllegalArgumentException("Names mismatch " + this.views.keySet() + " != " + nameSet);
        }
        LinkedList<SQLRowItemView> l = new LinkedList<SQLRowItemView>();
        for (String n : nameSet) {
            l.add(this.views.get(n));
        }
        this.viewsOrdered.clear();
        this.viewsOrdered.addAll(l);
        assert (this.viewsOrdered.size() == this.views.size());
    }

    public final SQLRowValues fetchRow(int id, final SQLSelect.LockStrength ls) {
        if (id < 0) {
            return null;
        }
        final SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(this.getElement().getPrivateGraph(null, false, true));
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                sel.setLockStrength(ls);
                sel.addLockedTable(fetcher.getGraph().getTable().getName());
                return sel;
            }
        });
        return fetcher.fetchOne(id, true);
    }

    public void select(int id) {
        final SQLRowValues row = this.fetchRow(id, SQLSelect.LockStrength.NONE);
        SwingThreadUtils.invoke(new Runnable(){

            @Override
            public void run() {
                SQLRowView.this.select(row);
            }
        });
    }

    public void select(SQLRowAccessor r) {
        this.select(r, null);
    }

    public void select(SQLRowAccessor r, Set<String> views) {
        this.setFilling(true);
        try {
            Object readOnlySel;
            if (r == null) {
                this.setSelectedID(-1);
                for (SQLRowItemView view : this.getViewsFast()) {
                    if (views != null && !views.contains(view.getSQLName())) continue;
                    view.resetValue();
                }
            } else {
                if (!this.getTable().equals(r.getTable())) {
                    throw new IllegalArgumentException("r is not of table " + this.getTable() + " : " + r);
                }
                if (r.getFields().isEmpty() && (views == null || !views.isEmpty())) {
                    Log.get().warning("Empty row with non-empty views : " + r);
                }
                if (r.hasID()) {
                    this.setSelectedID(r.getID());
                    if (r.getFields().equals(r.getTable().getFieldsName())) {
                        this.setLastKnownDBVals(r.asRowValues());
                    }
                }
                for (SQLRowItemView view : this.getViewsFast()) {
                    if (views != null && !views.contains(view.getSQLName())) continue;
                    view.show(r);
                }
            }
            if (this.getTable().contains("UI_LOCK") && (readOnlySel = r == null ? Boolean.valueOf(false) : (r.getIDNumber() == null ? null : Boolean.valueOf(SQLComponent.isReadOnly(r)))) != null) {
                this.setReadOnlySelection((Boolean)readOnlySel);
            }
        }
        finally {
            this.setFilling(false);
        }
    }

    public final void detach() {
        this.setSelectedID(-1);
        this.setReadOnlySelection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws SQLException {
        this.checkRO();
        SQLRowView sQLRowView = this;
        synchronized (sQLRowView) {
            this.updating = true;
        }
        this.update(this.getSelectedID());
        sQLRowView = this;
        synchronized (sQLRowView) {
            this.updating = false;
        }
    }

    private void update(int id) throws SQLException {
        if (id == this.getTable().getUndefinedID()) {
            throw new IllegalArgumentException("can't update undefined");
        }
        if (id == -1) {
            throw new IllegalArgumentException("NONEXISTANT_ID");
        }
        Log.get().fine("updating " + this.getTable() + " " + id);
        SQLRowValues vals = new SQLRowValues(this.getTable());
        for (SQLRowItemView view : this.getViewsFast()) {
            view.update(vals);
        }
        vals.update(id);
    }

    public SQLRow insert() throws SQLException {
        return this.fillVals().insert();
    }

    private SQLRowValues fillVals() throws SQLException {
        this.checkRO();
        SQLRowValues vals = new SQLRowValues(this.getTable());
        for (SQLRowItemView view : this.getViewsFast()) {
            view.insert(vals);
        }
        return vals;
    }

    public SQLRow insert(SQLRow order) throws SQLException {
        SQLRowValues vals = this.fillVals();
        vals.setOrder(order, true);
        return vals.insertVerbatim();
    }

    public SQLTable getTable() {
        return this.element.getTable();
    }

    public Set<SQLRowItemView> getViews() {
        return new LinkedHashSet<SQLRowItemView>(this.getViewsFast());
    }

    public Map<String, SQLRowItemView> getViewsMap() {
        return Collections.unmodifiableMap(this.views);
    }

    private final Collection<SQLRowItemView> getViewsFast() {
        return this.viewsOrdered;
    }

    public String toString() {
        return this.getClass() + " with " + this.getViewsFast();
    }

    public SQLRowItemView getView(String name) {
        return this.views.get(name);
    }

    public SQLRowItemView getView(Component comp) {
        for (SQLRowItemView view : this.getViewsFast()) {
            if (!SwingUtilities.isDescendingFrom(comp, view.getComp())) continue;
            return view;
        }
        return null;
    }

    public void resetValue() {
        this.select(null);
    }

    @Override
    public Collection<SQLField> getAllFields() {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (SQLRowItemView view : this.getViewsFast()) {
            res.addAll(view.getFields());
        }
        return res;
    }

    private void setSelectedID(int selectedID) {
        this.selectedID = selectedID;
        if (!this.existsInDB()) {
            this.setLastKnownDBVals(null);
        }
        this.supp.firePropertyChange("selectedID", null, (Object)this.selectedID);
    }

    public final int getSelectedID() {
        return this.selectedID;
    }

    public final boolean existsInDB() {
        return this.getSelectedID() != -1;
    }

    public final synchronized SQLRowValues getLastKnownDBVals() {
        return this.lastKnownDBVals;
    }

    public final boolean setLastKnownDBVals(SQLRowValues oldDBVals, SQLRowValues newDBVals) {
        return this.setLastKnownDBVals(oldDBVals, newDBVals, false);
    }

    private final boolean setLastKnownDBVals(SQLRowValues lastKnownDBVals) {
        return this.setLastKnownDBVals(null, lastKnownDBVals, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean setLastKnownDBVals(SQLRowValues oldDBVals, SQLRowValues newDBVals, boolean canChange) {
        if (!canChange && oldDBVals == null) {
            throw new NullPointerException("Missing old value");
        }
        if (newDBVals != null) {
            newDBVals = newDBVals.toImmutable();
        }
        SQLRowView sQLRowView = this;
        synchronized (sQLRowView) {
            boolean change;
            boolean bl = change = canChange || oldDBVals == this.lastKnownDBVals;
            if (change) {
                this.lastKnownDBVals = newDBVals;
            }
            return change;
        }
    }

    public final boolean isFilling() {
        return this.filling;
    }

    private final void setFilling(boolean filling) {
        this.filling = filling;
        this.supp.firePropertyChange("filling", null, (Object)this.filling);
    }

    public final void addListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    public final void rmListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public final void addListener(PropertyChangeListener l, String name) {
        this.supp.addPropertyChangeListener(name, l);
    }

    public final void rmListener(PropertyChangeListener l, String name) {
        this.supp.removePropertyChangeListener(name, l);
    }
}

