/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.sql.utils.SQLUtils;

public class Inserter {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final List<String> pk;
    private final DBSystemRoot sysRoot;
    private final SQLName tableName;

    public Inserter(SQLTable t) {
        this(t.getDBSystemRoot(), t.getSQLName(), t.getPKsNames());
    }

    public Inserter(SQLCreateTable t) {
        this(t.getRoot().getDBSystemRoot(), new SQLName(t.getRootName(), t.getName()), t.getPrimaryKey());
    }

    public Inserter(SQLCreateTableBase<?> t, DBRoot r) {
        this(r.getDBSystemRoot(), new SQLName(r.getName(), t.getName()), t.getPrimaryKey());
    }

    public Inserter(DBSystemRoot sysRoot, SQLName tableName, List<String> pk) {
        if (sysRoot == null || tableName == null) {
            throw new NullPointerException();
        }
        this.sysRoot = sysRoot;
        this.tableName = tableName;
        this.pk = pk;
    }

    protected final SQLSystem getSystem() {
        return this.sysRoot.getServer().getSQLSystem();
    }

    public final Insertion<?> insertReturnFirstField(String sql) throws SQLException {
        return this.insertReturnFirstField(sql, true);
    }

    public final Insertion<?> insertReturnFirstField(String sql, boolean requireAllRows) throws SQLException {
        return this.insert(sql, ReturnMode.FIRST_FIELD, requireAllRows);
    }

    public final Insertion<Object[]> insertReturnAllFields(String sql) throws SQLException {
        return this.insert(sql, ReturnMode.ALL_FIELDS, true);
    }

    public final int insertCount(String sql) throws SQLException {
        return this.insert(sql, ReturnMode.NO_FIELDS, false).getCount();
    }

    public final Insertion<?> insert(final String sql, final ReturnMode mode, final boolean requireAllRows) throws SQLException {
        boolean requireAllFields;
        final SQLSystem sys = this.getSystem();
        boolean bl = requireAllFields = mode != ReturnMode.NO_FIELDS && requireAllRows;
        if (requireAllFields && sys == SQLSystem.H2) {
            throw new IllegalArgumentException("H2 use IDENTITY() which only returns the last ID: " + this.tableName);
        }
        if (requireAllFields && sys == SQLSystem.MSSQL) {
            throw new IllegalArgumentException("In MS getUpdateCount() is correct but getGeneratedKeys() only returns the last ID: " + this.tableName);
        }
        return (Insertion)SQLUtils.executeAtomic(this.sysRoot.getDataSource(), new ConnectionHandlerNoSetup<Insertion<?>, SQLException>(){

            @Override
            public Insertion<?> handle(SQLDataSource ds) throws SQLException {
                Statement stmt = ds.getConnection().createStatement();
                try {
                    Insertion res;
                    List list;
                    boolean dontGetGK;
                    String insertInto = "INSERT INTO " + Inserter.this.tableName.quote() + " " + sql;
                    boolean bl = dontGetGK = mode == ReturnMode.NO_FIELDS || Inserter.this.pk.size() == 0 || sys == SQLSystem.MYSQL && Inserter.this.pk.size() != 1;
                    int count = sys == SQLSystem.POSTGRESQL ? stmt.executeUpdate(insertInto, dontGetGK ? EMPTY_ARRAY : Inserter.this.pk.toArray(EMPTY_ARRAY)) : stmt.executeUpdate(insertInto, dontGetGK ? 2 : 1);
                    if (dontGetGK) {
                        list = null;
                    } else {
                        list = (List)(mode == ReturnMode.FIRST_FIELD ? SQLDataSource.COLUMN_LIST_HANDLER : SQLDataSource.ARRAY_LIST_HANDLER).handle(stmt.getGeneratedKeys());
                        if (!$assertionsDisabled && list.size() > count) {
                            throw new AssertionError();
                        }
                        if (requireAllRows && list.size() != count) {
                            throw new IllegalStateException("Missing keys");
                        }
                    }
                    Insertion insertion = res = new Insertion(list, count);
                    return insertion;
                }
                finally {
                    stmt.close();
                }
            }
        });
    }

    public static final class Insertion<T> {
        private final List<T> list;
        private final int count;

        public Insertion(List<T> res, int count) {
            this.list = res;
            this.count = count;
            assert (res == null || res.size() <= count);
        }

        public final int getCount() {
            return this.count;
        }

        public final List<T> getRows() {
            return this.list;
        }
    }

    public static enum ReturnMode {
        NO_FIELDS,
        FIRST_FIELD,
        ALL_FIELDS;

    }
}

