/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TransfFieldExpander;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.FilteredFillSQLRequest;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.sqlobject.ElementComboBoxUtils;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;

public final class ComboSQLRequest
extends FilteredFillSQLRequest {
    private static final SQLCache<CacheKey, List<IComboSelectionItem>> cache = new SQLCache(60, -1, "items of " + ComboSQLRequest.class);
    private static final String SEP_CHILD = " \u25c4 ";
    private static String SEP_FIELD;
    private static Comparator<? super IComboSelectionItem> DEFAULT_COMPARATOR;
    private List<SQLField> comboFields;
    private final TransfFieldExpander exp;
    private String fieldSeparator = ComboSQLRequest.getDefaultFieldSeparator();
    private String undefLabel;
    private KeepMode keepRows;
    private IClosure<IComboSelectionItem> customizeItem;
    private List<Path> order;
    private Comparator<? super IComboSelectionItem> itemsOrder;

    static {
        ComboSQLRequest.setDefaultFieldSeparator(" | ");
        ComboSQLRequest.setDefaultItemsOrder(null);
    }

    public static synchronized void setDefaultFieldSeparator(String separator) {
        SEP_FIELD = separator;
    }

    public static synchronized String getDefaultFieldSeparator() {
        return SEP_FIELD;
    }

    public static synchronized void setDefaultItemsOrder(Comparator<? super IComboSelectionItem> comp) {
        DEFAULT_COMPARATOR = comp;
    }

    public static synchronized Comparator<? super IComboSelectionItem> getDefaultItemsOrder() {
        return DEFAULT_COMPARATOR;
    }

    public ComboSQLRequest(SQLTable table, List<String> l) {
        this(table, l, null);
    }

    public ComboSQLRequest(SQLTable table, List<String> l, Where where) {
        super(table, where);
        this.undefLabel = null;
        this.keepRows = KeepMode.NONE;
        this.customizeItem = null;
        this.order = null;
        this.itemsOrder = ComboSQLRequest.getDefaultItemsOrder();
        this.exp = ElementComboBoxUtils.getShowAs(Configuration.getInstance());
        this.setFields(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ComboSQLRequest(ComboSQLRequest c, boolean freeze) {
        super(c, freeze);
        this.exp = new TransfFieldExpander(c.exp);
        ComboSQLRequest comboSQLRequest = c;
        synchronized (comboSQLRequest) {
            this.comboFields = c.comboFields;
            this.order = c.order == null ? null : new ArrayList<Path>(c.order);
            this.itemsOrder = c.itemsOrder;
            this.fieldSeparator = c.fieldSeparator;
            this.undefLabel = c.undefLabel;
            this.keepRows = c.keepRows;
            this.customizeItem = c.customizeItem;
        }
    }

    @Override
    public ComboSQLRequest toUnmodifiable() {
        return (ComboSQLRequest)this.toUnmodifiableP(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComboSQLRequest clone() {
        ComboSQLRequest comboSQLRequest = this;
        synchronized (comboSQLRequest) {
            return this.clone(false);
        }
    }

    @Override
    protected ComboSQLRequest clone(boolean forFreeze) {
        return new ComboSQLRequest(this, forFreeze);
    }

    public final void setFields(Collection<String> fields) {
        ArrayList<SQLField> l = new ArrayList<SQLField>();
        for (String fName : fields) {
            l.add(this.getPrimaryTable().getField(fName));
        }
        this.setSQLFieldsUnsafe(l);
    }

    public final void setSQLFields(Collection<SQLField> fields) {
        for (SQLField f : fields) {
            if (f.getTable() == this.getPrimaryTable()) continue;
            throw new IllegalArgumentException("Not in " + this.getPrimaryTable() + " : " + f);
        }
        this.setSQLFieldsUnsafe(new ArrayList<SQLField>(fields));
    }

    private synchronized void setSQLFieldsUnsafe(List<SQLField> fields) {
        this.checkFrozen();
        this.comboFields = Collections.unmodifiableList(fields);
        this.clearGraph();
    }

    public final synchronized void setUndefLabel(String undefLabel) {
        this.checkFrozen();
        this.undefLabel = undefLabel;
    }

    public final synchronized String getUndefLabel() {
        return this.undefLabel;
    }

    public final synchronized void setItemCustomizer(IClosure<IComboSelectionItem> customizeItem) {
        this.checkFrozen();
        this.customizeItem = customizeItem;
    }

    public final IComboSelectionItem getComboItem(int id) {
        List<IComboSelectionItem> res = this.getComboItems(id, false, false);
        return this.getSole(res, id);
    }

    public final List<IComboSelectionItem> getComboItems() {
        return this.getComboItems(true);
    }

    public final List<IComboSelectionItem> getComboItems(boolean readCache) {
        return this.getComboItems(null, readCache, true);
    }

    private final List<IComboSelectionItem> getComboItems(Number id, boolean readCache, boolean writeCache) {
        SQLRowValuesListFetcher comboSelect;
        if (this.getFields().isEmpty()) {
            throw new IllegalStateException("Empty fields");
        }
        Where w = id == null ? null : new Where((FieldRef)this.getPrimaryTable().getKey(), "=", (Object)id);
        CacheKey cacheKey = this.getCacheKey(w);
        CacheResult l = cache.check(cacheKey, readCache, writeCache, (comboSelect = cacheKey.fetcher).getGraph().getGraph().getTables());
        if (l.getState() == CacheResult.State.INTERRUPTED) {
            throw new RTInterruptedException("interrupted while waiting for the cache");
        }
        if (l.getState() == CacheResult.State.VALID) {
            return (List)l.getRes();
        }
        try {
            List<Tuple2<Path, List<FieldPath>>> ancestors = ElementComboBoxUtils.expandGroupBy(cacheKey.graph, Configuration.getInstance().getDirectory());
            ArrayList<IComboSelectionItem> result = new ArrayList<IComboSelectionItem>();
            for (SQLRowValues vals : comboSelect.fetch(w)) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new RTInterruptedException("interrupted in fill");
                }
                result.add(ComboSQLRequest.createItem(vals, cacheKey, ancestors));
            }
            if (cacheKey.itemsOrder != null) {
                Collections.sort(result, cacheKey.itemsOrder);
            }
            if (writeCache) {
                cache.put(l, result);
            }
            return result;
        }
        catch (RuntimeException exn) {
            cache.removeRunning((CacheKey)((Object)l));
            throw exn;
        }
    }

    protected final CacheKey getCacheKey() {
        return this.getCacheKey(null);
    }

    private final synchronized CacheKey getCacheKey(Where w) {
        return new CacheKey(this.getGraph(), this.getFetcher(), w, this.fieldSeparator, this.undefLabel, this.customizeItem, this.keepRows, this.itemsOrder);
    }

    @Override
    protected final synchronized SQLSelect transformSelect(SQLSelect sel) {
        sel.setExcludeUndefined(this.getUndefLabel() == null, this.getPrimaryTable());
        return super.transformSelect(sel);
    }

    @Override
    protected final synchronized List<Path> getOrder() {
        if (this.order != null) {
            return this.order;
        }
        List<Tuple2<Path, List<FieldPath>>> expandGroupBy = ElementComboBoxUtils.expandGroupBy(this.getGraph(), Configuration.getInstance().getDirectory());
        ArrayList<Path> res = new ArrayList<Path>(expandGroupBy.size());
        for (Tuple2<Path, List<FieldPath>> ancestor : expandGroupBy) {
            res.add(0, ancestor.get0());
        }
        return res;
    }

    public final synchronized void setOrder(List<Path> l) {
        this.checkFrozen();
        this.order = Collections.unmodifiableList(new ArrayList<Path>(l));
        this.clearGraph();
    }

    public final void setNaturalItemsOrder(boolean b) {
        this.setItemsOrder(b ? CompareUtils.naturalOrder() : null);
    }

    public final synchronized void setItemsOrder(Comparator<? super IComboSelectionItem> comp) {
        this.checkFrozen();
        this.itemsOrder = comp;
    }

    public final synchronized Comparator<? super IComboSelectionItem> getItemsOrder() {
        return this.itemsOrder;
    }

    private static final IComboSelectionItem createItem(final SQLRowValues rs, final CacheKey ck, List<Tuple2<Path, List<FieldPath>>> ancestors) {
        String desc = ck.undefLabel != null && rs.isUndefined() ? ck.undefLabel : CollectionUtils.join(ancestors, SEP_CHILD, new ITransformer<Tuple2<Path, List<FieldPath>>, Object>(){

            @Override
            public Object transformChecked(Tuple2<Path, List<FieldPath>> ancestorFields) {
                List filtered = CollectionUtils.transformAndFilter((Collection)ancestorFields.get1(), new ITransformer<FieldPath, String>(){

                    @Override
                    public String transformChecked(FieldPath input) {
                        return ComboSQLRequest.getFinalValueOf(input, rs);
                    }
                }, IPredicate.notNullPredicate(), new ArrayList());
                return CollectionUtils.join(filtered, ck.fieldSeparator);
            }
        });
        IComboSelectionItem res = ck.getKeepMode() == KeepMode.GRAPH ? new IComboSelectionItem(rs, desc) : (ck.getKeepMode() == KeepMode.ROW ? new IComboSelectionItem(rs.asRow(), desc) : new IComboSelectionItem(rs.getID(), desc));
        if (ck.customizeItem != null) {
            ck.customizeItem.executeChecked(res);
        }
        return res;
    }

    @Override
    protected final TransfFieldExpander getShowAs() {
        return this.exp;
    }

    protected static String getFinalValueOf(FieldPath element, SQLRowValues rs) {
        String result = element.getString(rs);
        return result;
    }

    public final synchronized List<SQLField> getFields() {
        return this.comboFields;
    }

    public final synchronized void setFieldSeparator(String string) {
        this.checkFrozen();
        this.fieldSeparator = string;
    }

    public synchronized String getSeparatorsChars() {
        return SEP_CHILD + this.fieldSeparator;
    }

    public final synchronized KeepMode getKeepMode() {
        return this.keepRows;
    }

    public final void keepRows(boolean b) {
        this.keepRows(b ? KeepMode.ROW : KeepMode.NONE);
    }

    public final synchronized void keepRows(KeepMode mode) {
        this.checkFrozen();
        this.keepRows = mode;
    }

    protected static final class CacheKey {
        private final SQLRowValues graph;
        private final SQLRowValuesListFetcher fetcher;
        private final Where where;
        private final String fieldSeparator;
        private final String undefLabel;
        private final KeepMode keepRows;
        private final IClosure<IComboSelectionItem> customizeItem;
        private final Comparator<? super IComboSelectionItem> itemsOrder;

        public CacheKey(SQLRowValues graph, SQLRowValuesListFetcher f, Where w, String fieldSeparator, String undefLabel, IClosure<IComboSelectionItem> c, KeepMode keepRows, Comparator<? super IComboSelectionItem> itemsOrder) {
            if (!graph.isFrozen()) {
                throw new IllegalArgumentException("Not frozen : " + graph);
            }
            this.graph = graph;
            if (f != null && !f.isFrozen()) {
                throw new IllegalArgumentException("Not frozen : " + f);
            }
            this.fetcher = f;
            this.where = w;
            this.fieldSeparator = fieldSeparator;
            this.undefLabel = undefLabel;
            this.keepRows = keepRows;
            this.customizeItem = c;
            this.itemsOrder = itemsOrder;
        }

        public final KeepMode getKeepMode() {
            return this.keepRows;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fetcher == null ? 0 : this.fetcher.hashCode());
            result = 31 * result + this.fieldSeparator.hashCode();
            result = 31 * result + this.keepRows.hashCode();
            result = 31 * result + (this.undefLabel == null ? 0 : this.undefLabel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.keepRows == other.keepRows && this.fieldSeparator.equals(other.fieldSeparator) && CompareUtils.equals(this.undefLabel, other.undefLabel) && CompareUtils.equals(this.where, other.where) && this.graph.getGraphFirstDifference(other.graph, true) == null && CompareUtils.equals(this.fetcher, other.fetcher) && CompareUtils.equals(this.customizeItem, other.customizeItem) && CompareUtils.equals(this.itemsOrder, other.itemsOrder);
        }
    }

    public static enum KeepMode {
        NONE,
        ROW,
        GRAPH;

    }
}

