/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public class Where {
    public static final Where FALSE = Where.createRaw("1=0", new FieldRef[0]);
    public static final Where TRUE = Where.createRaw("1=1", new FieldRef[0]);
    public static final String NULL_IS_DATA_EQ = new String("===");
    public static final String NULL_IS_DATA_NEQ = new String("IS DISTINCT FROM");
    private static Combiner AndCombiner = new Combiner(){

        @Override
        protected Where combineNotNull(Where where1, Where where2) {
            return where1.and(where2);
        }
    };
    private static Combiner OrCombiner = new Combiner(){

        @Override
        protected Where combineNotNull(Where where1, Where where2) {
            return where1.or(where2);
        }
    };
    private final List<FieldRef> fields;
    private final String clause;

    private static Where combine(Collection<Where> wheres, Combiner c) {
        Where res = null;
        for (Where w : wheres) {
            res = c.combine(res, w);
        }
        return res;
    }

    public static Where and(Collection<Where> wheres) {
        return Where.combine(wheres, AndCombiner);
    }

    public static Where and(SQLTable t, Map<String, ?> fields) {
        ArrayList<Where> res = new ArrayList<Where>(fields.size());
        for (Map.Entry<String, ?> e : fields.entrySet()) {
            res.add(new Where((FieldRef)t.getField(e.getKey()), "=", e.getValue()));
        }
        return Where.and(res);
    }

    public static Where or(Collection<Where> wheres) {
        return Where.combine(wheres, OrCombiner);
    }

    public static Where and(Where where1, Where where2) {
        return AndCombiner.combine(where1, where2);
    }

    public static Where isNull(FieldRef ref) {
        return new Where(ref, "is", (Object)null);
    }

    public static Where isNotNull(FieldRef ref) {
        return new Where(ref, "is not", (Object)null);
    }

    public static Where createRaw(String clause, FieldRef ... refs) {
        return Where.createRaw(clause, Arrays.asList(refs));
    }

    public static Where createRaw(String clause, Collection<? extends FieldRef> refs) {
        if (clause == null) {
            return null;
        }
        return new Where(clause, refs);
    }

    public static Where quote(String pattern, Object ... params) {
        return new Where(SQLSelect.quote(pattern, params), org.apache.commons.collections.CollectionUtils.select(Arrays.asList(params), new InstanceofPredicate(FieldRef.class)));
    }

    private static final String normalizeOperator(String op) {
        String res = op.trim();
        if (res.equals("!=")) {
            res = "<>";
        }
        return res;
    }

    private static final String comparison(FieldRef ref, String op, String y) {
        if (op == NULL_IS_DATA_EQ || op == NULL_IS_DATA_NEQ) {
            return ref.getField().getServer().getSQLSystem().getSyntax().getNullIsDataComparison(ref.getFieldRef(), op == NULL_IS_DATA_EQ, y);
        }
        return String.valueOf(ref.getFieldRef()) + " " + op + " " + y;
    }

    private static final String getInClause(FieldRef field1, boolean in, String inParens) {
        String op = in ? " in (" : " not in (";
        return String.valueOf(field1.getFieldRef()) + op + inParens + ")";
    }

    public Where(FieldRef field1, String op, FieldRef field2) {
        this.fields = Arrays.asList(field1, field2);
        this.clause = Where.comparison(field1, Where.normalizeOperator(op), field2.getFieldRef());
    }

    public Where(FieldRef field1, String op, int scalar) {
        this(field1, op, (Object)scalar);
    }

    public Where(FieldRef ref, String op, Object o) {
        this.fields = Collections.singletonList(ref);
        op = Where.normalizeOperator(op);
        if (o == null) {
            if (op.equals("=")) {
                op = "is";
            } else if (op.equals("<>")) {
                op = "is not";
            }
        }
        this.clause = Where.comparison(ref, op, ref.getField().getType().toString(o));
    }

    public Where(FieldRef field1, Collection<?> values) {
        this(field1, true, values);
    }

    public Where(final FieldRef field1, boolean in, Collection<?> values) {
        if (values.isEmpty()) {
            this.fields = Collections.emptyList();
            this.clause = in ? FALSE.getClause() : TRUE.getClause();
        } else {
            this.fields = Collections.singletonList(field1);
            this.clause = Where.getInClause(field1, in, CollectionUtils.join(values, ",", new ITransformer<Object, String>(){

                @Override
                public String transformChecked(Object input) {
                    return field1.getField().getType().toString(input);
                }
            }));
        }
    }

    public Where(FieldRef field1, boolean in, SQLSelect subQuery) {
        this.fields = Collections.singletonList(field1);
        this.clause = Where.getInClause(field1, in, subQuery.asString());
    }

    public Where(FieldRef ref, Object borneInf, Object borneSup) {
        SQLField field1 = ref.getField();
        this.fields = Collections.singletonList(ref);
        this.clause = String.valueOf(ref.getFieldRef()) + " BETWEEN " + field1.getType().toString(borneInf) + " AND " + field1.getType().toString(borneSup);
    }

    public Where(FieldRef ref, Object borneInf, boolean infInclusive, Object borneSup, boolean supInclusive) {
        this.fields = Collections.singletonList(ref);
        String infClause = new Where(ref, infInclusive ? ">=" : ">", borneInf).getClause();
        String supClause = new Where(ref, supInclusive ? "<=" : "<", borneSup).getClause();
        this.clause = String.valueOf(infClause) + " AND " + supClause;
    }

    private Where(String clause, Collection<? extends FieldRef> refs) {
        this.fields = Collections.unmodifiableList(new ArrayList<FieldRef>(refs));
        this.clause = clause;
    }

    public Where or(Where w) {
        return this.combine(w, "OR");
    }

    public Where and(Where w) {
        return this.combine(w, "AND");
    }

    public Where not() {
        return new Where("NOT (" + this.clause + ")", this.fields);
    }

    private Where combine(Where w, String op) {
        if (w == null) {
            return this;
        }
        ArrayList<FieldRef> fields = new ArrayList<FieldRef>();
        fields.addAll(this.fields);
        fields.addAll(w.fields);
        String clause = "(" + this.clause + ") " + op + " (" + w.clause + ")";
        return new Where(clause, fields);
    }

    public String getClause() {
        return this.clause;
    }

    public List<FieldRef> getFields() {
        return this.fields;
    }

    public String toString() {
        return this.getClause();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Where) {
            Where o = (Where)obj;
            return this.getClause().equals(o.getClause()) && this.getFields().equals(o.getFields());
        }
        return false;
    }

    public int hashCode() {
        return this.getClause().hashCode() + this.getFields().hashCode();
    }

    private static abstract class Combiner {
        private Combiner() {
        }

        public final Where combine(Where w1, Where w2) {
            if (w1 == null) {
                return w2;
            }
            return this.combineNotNull(w1, w2);
        }

        protected abstract Where combineNotNull(Where var1, Where var2);
    }
}

