/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.ResultSetHandler;
import org.jdom2.Element;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.TransactionListener;
import org.openconcerto.sql.model.TransactionPoint;
import org.openconcerto.sql.model.Trigger;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.SQLKey;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateMoveableTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.CopyOnWriteMap;
import org.openconcerto.utils.cc.CustomEquals;
import org.openconcerto.utils.change.CollectionChangeEventCreator;
import org.openconcerto.xml.JDOMUtils;

public final class SQLTable
extends SQLIdentifier
implements SQLData,
TableRef {
    private static final String UNDEF_TABLE_TABLENAME_FIELD = "TABLENAME";
    private static final String UNDEF_TABLE_ID_FIELD = "UNDEFINED_ID";
    public static final String UNDEFINED_ID_POLICY = "undefined ID policy";
    public static final String undefTable = "FWK_UNDEFINED_IDS";
    private static final Map<SQLSchema, Map<String, Number>> UNDEFINED_IDs = new HashMap<SQLSchema, Map<String, Number>>();
    private static final ResultSetHandler UNDEF_RSH = new ResultSetHandler(){

        @Override
        public Object handle(ResultSet rs) throws SQLException {
            HashMap<String, Number> res = new HashMap<String, Number>();
            while (rs.next()) {
                res.put(rs.getString(SQLTable.UNDEF_TABLE_TABLENAME_FIELD), (Number)rs.getObject(SQLTable.UNDEF_TABLE_ID_FIELD));
            }
            return res;
        }
    };
    private static boolean AFTER_TX_DEFAULT = true;
    private String version;
    private final CopyOnWriteMap<String, SQLField> fields;
    private final Set<SQLField> primaryKeys;
    private SQLField primaryKey;
    private boolean primaryKeyOK;
    private Set<SQLField> keys;
    private Map<String, FieldGroup> fieldsGroups;
    private final Map<String, Trigger> triggers;
    private Set<Constraint> constraints;
    private List<ListenerAndConfig> tableModifiedListeners;
    private final ListMap<TransactionPoint, FireState> transactions;
    private final TransactionListener txListener;
    private final Object listenersMutex = new String("tableModifiedListeners mutex");
    private Integer undefinedID;
    private String comment;
    private String type;
    private static final String orderField = "ORDRE";
    private static final String archiveField = "ARCHIVE";
    private static final ThreadLocal<LinkedList<DispatchingState>> events = new ThreadLocal<LinkedList<DispatchingState>>(){

        @Override
        protected LinkedList<DispatchingState> initialValue() {
            return new LinkedList<DispatchingState>();
        }
    };

    private static final Map<String, Number> getUndefIDs(final SQLSchema schema) {
        if (!UNDEFINED_IDs.containsKey(schema)) {
            Map r;
            if (schema.contains(undefTable)) {
                SQLBase b = schema.getBase();
                final SQLTable undefT = schema.getTable(undefTable);
                SQLSelect sel = new SQLSelect().addSelectStar(undefT);
                r = (Map)b.getDataSource().execute(sel.asString(), new IResultSetHandler(UNDEF_RSH, false));
                undefT.addTableModifiedListener(new ListenerAndConfig(new SQLTableModifiedListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void tableModified(SQLTableEvent evt) {
                        Map map = UNDEFINED_IDs;
                        synchronized (map) {
                            UNDEFINED_IDs.remove(schema);
                            undefT.removeTableModifiedListener(this);
                        }
                    }
                }, false));
            } else {
                r = Collections.emptyMap();
            }
            UNDEFINED_IDs.put(schema, r);
        }
        return UNDEFINED_IDs.get(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void removeUndefID(SQLSchema s) {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            UNDEFINED_IDs.remove(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Tuple2<Boolean, Number> getUndefID(SQLSchema b, String tableName) {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            Map<String, Number> map2 = SQLTable.getUndefIDs(b);
            return Tuple2.create(map2.containsKey(tableName), map2.get(tableName));
        }
    }

    private static final SQLCreateMoveableTable getCreateUndefTable(SQLSyntax syntax) {
        SQLCreateMoveableTable createTable = new SQLCreateMoveableTable(syntax, undefTable);
        createTable.addVarCharColumn(UNDEF_TABLE_TABLENAME_FIELD, 250);
        createTable.addColumn(UNDEF_TABLE_ID_FIELD, syntax.getIDType());
        createTable.setPrimaryKey(UNDEF_TABLE_TABLENAME_FIELD);
        return createTable;
    }

    private static final SQLTable getUndefTable(SQLSchema schema, boolean create) throws SQLException {
        SQLTable undefT = schema.getTable(undefTable);
        if (undefT != null || !create) {
            return undefT;
        }
        schema.getDBSystemRoot().getDataSource().execute(SQLTable.getCreateUndefTable(SQLSyntax.get(schema)).asString(schema.getDBRoot().getName()));
        schema.updateVersion();
        return schema.fetchTable(undefTable);
    }

    public static final void setUndefID(SQLSchema schema, String tableName, Integer value) throws SQLException {
        SQLTable.setUndefIDs(schema, Collections.singletonMap(tableName, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int setUndefIDs(SQLSchema schema, Map<String, ? extends Number> values) throws SQLException {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            int res;
            SQLTable undefT = SQLTable.getUndefTable(schema, true);
            SQLType undefType = undefT.getField(UNDEF_TABLE_ID_FIELD).getType();
            ArrayList<List<String>> toInsert = new ArrayList<List<String>>();
            ArrayList<List<String>> toUpdate = new ArrayList<List<String>>();
            Map<String, Number> currentValues = SQLTable.getUndefIDs(schema);
            SQLBase b = schema.getBase();
            SQLSystem system = b.getServer().getSQLSystem();
            for (Map.Entry<String, ? extends Number> e : values.entrySet()) {
                String string = e.getKey();
                Number undefValue = e.getValue();
                Object l = !currentValues.containsKey(string) ? toInsert : (CompareUtils.equals(currentValues.get(string), undefValue) ? null : toUpdate);
                if (l == null) continue;
                String undefSQL = undefValue == null && system == SQLSystem.POSTGRESQL ? "cast( NULL as " + undefType.getTypeName() + ")" : undefType.toString(undefValue);
                l.add(Arrays.asList(b.quoteString(string), undefSQL));
            }
            SQLSyntax syntax = system.getSyntax();
            if (toInsert.size() > 0) {
                SQLRowValues.insertCount(undefT, "(" + SQLSyntax.quoteIdentifiers(Arrays.asList(UNDEF_TABLE_TABLENAME_FIELD, UNDEF_TABLE_ID_FIELD)) + ") " + syntax.getValues(toInsert, 2));
            }
            if (toUpdate.size() > 0) {
                if (system == SQLSystem.H2) {
                    StringBuilder updates = new StringBuilder();
                    for (List list : toUpdate) {
                        UpdateBuilder update = new UpdateBuilder(undefT).set(UNDEF_TABLE_ID_FIELD, (String)list.get(1));
                        update.setWhere(Where.createRaw(String.valueOf(undefT.getField(UNDEF_TABLE_TABLENAME_FIELD).getFieldRef()) + " = " + (String)list.get(0), new FieldRef[0]));
                        updates.append(update.asString());
                        updates.append(";\n");
                    }
                    schema.getDBSystemRoot().getDataSource().execute(updates.toString());
                } else {
                    UpdateBuilder update = new UpdateBuilder(undefT);
                    String string = "newUndef";
                    update.addRawTable(syntax.getConstantTable(toUpdate, "newUndef", Arrays.asList("t", "v")), null);
                    update.setWhere(Where.createRaw(String.valueOf(undefT.getField(UNDEF_TABLE_TABLENAME_FIELD).getFieldRef()) + " = " + new SQLName("newUndef", "t").quote(), new FieldRef[0]));
                    update.set(UNDEF_TABLE_ID_FIELD, new SQLName("newUndef", "v").quote());
                    schema.getDBSystemRoot().getDataSource().execute(update.asString());
                }
            }
            if ((res = toInsert.size() + toUpdate.size()) > 0) {
                undefT.fireTableModified(-1);
            }
            return res;
        }
    }

    public static void setDefaultAfterTransaction(boolean val) {
        AFTER_TX_DEFAULT = val;
    }

    SQLTable(SQLSchema schema, String name) {
        super(schema, name);
        this.tableModifiedListeners = Collections.emptyList();
        this.transactions = new ListMap();
        this.txListener = new TransactionListener(){

            @Override
            public void transactionEnded(TransactionPoint point) {
                SQLTable.this.fireFromTransaction(point);
            }
        };
        this.fields = new CopyOnWriteMap<String, SQLField>(){

            @Override
            public Map<String, SQLField> copy(Map<? extends String, ? extends SQLField> src) {
                return new LinkedHashMap<String, SQLField>(src);
            }
        };
        assert (SQLTable.isOrdered(this.fields));
        this.primaryKeys = new LinkedHashSet<SQLField>();
        this.primaryKey = null;
        this.primaryKeyOK = true;
        this.keys = null;
        this.fieldsGroups = null;
        this.triggers = new HashMap<String, Trigger>();
        this.constraints = new HashSet<Constraint>();
        this.undefinedID = null;
        assert (!this.undefinedIDKnown());
    }

    synchronized void clearNonPersistent() {
        this.triggers.clear();
        this.constraints = new HashSet<Constraint>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFields(Element xml) {
        SQLTable sQLTable = this;
        synchronized (sQLTable) {
            this.version = SQLSchema.getVersion(xml);
        }
        LinkedHashMap<String, SQLField> newFields = new LinkedHashMap<String, SQLField>();
        for (Element elementField : xml.getChildren("field")) {
            SQLField f = SQLField.create(this, elementField);
            newFields.put(f.getName(), f);
        }
        Element primary = xml.getChild("primary");
        ArrayList<String> newPrimaryKeys = new ArrayList<String>();
        for (Element elementField : primary.getChildren("field")) {
            String fieldName = elementField.getAttributeValue("name");
            newPrimaryKeys.add(fieldName);
        }
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLTable sQLTable2 = this;
            synchronized (sQLTable2) {
                Element constraintsElem;
                this.setState(newFields, newPrimaryKeys, null);
                Element triggersElem = xml.getChild("triggers");
                if (triggersElem != null) {
                    for (Element triggerElem : triggersElem.getChildren()) {
                        this.addTrigger(Trigger.fromXML(this, triggerElem));
                    }
                }
                if ((constraintsElem = xml.getChild("constraints")) == null) {
                    this.addConstraint((Constraint)null);
                } else {
                    for (Element elem : constraintsElem.getChildren()) {
                        this.addConstraint(Constraint.fromXML(this, elem));
                    }
                }
                Element commentElem = xml.getChild("comment");
                if (commentElem != null) {
                    this.setComment(commentElem.getText());
                }
                this.setType(xml.getAttributeValue("type"));
            }
        }
    }

    private synchronized void addTrigger(Trigger t) {
        this.triggers.put(t.getName(), t);
    }

    private synchronized void addConstraint(Constraint c) {
        if (c == null) {
            this.constraints = null;
        } else {
            if (this.constraints == null) {
                this.constraints = new HashSet<Constraint>();
            }
            this.constraints.add(c);
        }
    }

    public void fetchFields() throws SQLException {
        this.getBase().fetchTables(TablesMap.createBySchemaFromTable(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fetchFields(DatabaseMetaData metaData, ResultSet rs, String version) throws SQLException {
        if (!this.isUs(rs)) {
            throw new IllegalStateException("rs current row does not describe " + this);
        }
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                this.version = version;
                LinkedHashMap<String, SQLField> newFields = new LinkedHashMap<String, SQLField>();
                boolean hasNext = true;
                while (hasNext && this.isUs(rs)) {
                    SQLField f = SQLField.create(this, rs);
                    newFields.put(f.getName(), f);
                    hasNext = rs.next();
                }
                ArrayList<String> newPrimaryKeys = new ArrayList<String>();
                ResultSet pkRS = metaData.getPrimaryKeys(this.getBase().getMDName(), this.getSchema().getName(), this.getName());
                while (pkRS.next()) {
                    newPrimaryKeys.add(pkRS.getString("COLUMN_NAME"));
                }
                this.setState(newFields, newPrimaryKeys, null);
                return hasNext;
            }
        }
    }

    void emptyFields() {
        this.setState(new LinkedHashMap<String, SQLField>(), Collections.<String>emptyList(), null);
    }

    private boolean isUs(ResultSet rs) throws SQLException {
        String n = rs.getString("TABLE_NAME");
        String s = rs.getString("TABLE_SCHEM");
        return n.equals(this.getName()) && CompareUtils.equals(s, this.getSchema().getName());
    }

    void addTrigger(Map<String, Object> m) {
        this.addTrigger(new Trigger(this, m));
    }

    void addConstraint(Map<String, Object> m) {
        this.addConstraint(m == null ? null : new Constraint(this, m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fetchUndefID() {
        Number id;
        Tuple2<Boolean, Number> currentValue;
        SQLField pk;
        SQLTable sQLTable = this;
        synchronized (sQLTable) {
            pk = this.isRowable() ? this.getKey() : null;
        }
        int res = pk != null ? (!(currentValue = SQLTable.getUndefID(this.getSchema(), this.getName())).get0().booleanValue() ? this.findMinID(pk) : ((id = currentValue.get1()) == null ? -1 : id.intValue())) : -1;
        return res;
    }

    private int findMinID(SQLField pk) {
        String debugUndef = "fwk_sql.debug.undefined_id";
        if (System.getProperty("fwk_sql.debug.undefined_id") != null) {
            Log.get().warning("The system property 'fwk_sql.debug.undefined_id' is deprecated, use the 'undefined ID policy' metadata");
        }
        String policy = this.getSchema().getFwkMetadata(UNDEFINED_ID_POLICY);
        if (Boolean.getBoolean("fwk_sql.debug.undefined_id") || "min".equals(policy)) {
            SQLSelect sel = new SQLSelect(true).addSelect(pk, "min");
            Number undef = (Number)this.getBase().getDataSource().executeScalar(sel.asString());
            if (undef == null) {
                throw new IllegalStateException(this + " is empty, can not infer UNDEFINED_ID");
            }
            String update = SQLSyntax.get(this).getInsertOne(new SQLName(this.getDBRoot().getName(), undefTable), Arrays.asList(UNDEF_TABLE_TABLENAME_FIELD, UNDEF_TABLE_ID_FIELD), this.getBase().quoteString(this.getName()), String.valueOf(undef));
            Log.get().config("the first row (which should be the undefined):\n" + update);
            return undef.intValue();
        }
        if ("inDB".equals(policy)) {
            throw new IllegalStateException("Not in " + new SQLName(this.getDBRoot().getName(), undefTable) + " : " + this.getName());
        }
        if (policy != null && !"nonexistant".equals(policy)) {
            int res = Integer.parseInt(policy);
            if (res < 0) {
                throw new IllegalStateException("ID is not valid : " + res);
            }
            return res;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mutateTo(SQLTable table) {
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                this.clearNonPersistent();
                this.version = table.version;
                this.setState(table.fields, table.getPKsNames(), table.undefinedID);
                for (Trigger t : table.triggers.values()) {
                    this.addTrigger(new Trigger(this, t));
                }
                if (table.constraints == null) {
                    this.constraints = null;
                } else {
                    for (Constraint c : table.constraints) {
                        this.constraints.add(new Constraint(this, c));
                    }
                }
                this.setType(table.getType());
                this.setComment(table.getComment());
            }
        }
    }

    private static <K, V> boolean isOrdered(Map<K, V> m) {
        if (m instanceof CopyOnWriteMap) {
            return SQLTable.isOrdered(((CopyOnWriteMap)m).copy(Collections.emptyMap()));
        }
        return m instanceof LinkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(Map<String, SQLField> fields, List<String> primaryKeys, Integer undef) {
        assert (SQLTable.isOrdered(fields));
        for (SQLField newField : fields.values()) {
            if (newField.getTable().getSQLName().equals(this.getSQLName())) continue;
            throw new IllegalArgumentException(newField + " is in table " + newField.getTable().getSQLName() + " not us: " + this.getSQLName());
        }
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                CollectionChangeEventCreator c = this.createChildrenCreator();
                if (!fields.keySet().containsAll(this.getFieldsName())) {
                    for (String removed : CollectionUtils.substract(this.getFieldsName(), fields.keySet())) {
                        this.fields.remove(removed).dropped();
                    }
                }
                for (SQLField newField : fields.values()) {
                    if (this.getChildrenNames().contains(newField.getName())) {
                        this.getField(newField.getName()).mutateTo(newField);
                        continue;
                    }
                    SQLField fieldToAdd = newField.getTable() != this ? new SQLField(this, newField) : newField;
                    this.fields.put(newField.getName(), fieldToAdd);
                }
                this.primaryKeys.clear();
                for (String pk : primaryKeys) {
                    this.primaryKeys.add(this.getField(pk));
                }
                this.primaryKey = primaryKeys.size() == 1 ? this.getField(primaryKeys.get(0)) : null;
                this.primaryKeyOK = primaryKeys.size() <= 1;
                this.keys = null;
                this.fieldsGroups = null;
                this.undefinedID = undef;
                this.fireChildrenChanged(c);
            }
        }
    }

    synchronized void setType(String type) {
        this.type = type;
    }

    public final synchronized String getType() {
        return this.type;
    }

    synchronized void setComment(String comm) {
        this.comment = comm;
    }

    public final synchronized String getComment() {
        return this.comment;
    }

    public final synchronized Trigger getTrigger(String name) {
        return this.triggers.get(name);
    }

    public final synchronized Map<String, Trigger> getTriggers() {
        return Collections.unmodifiableMap(this.triggers);
    }

    public final synchronized Set<Constraint> getAllConstraints() {
        return this.constraints == null ? null : Collections.unmodifiableSet(this.constraints);
    }

    public final synchronized Set<Constraint> getConstraints() {
        if (this.constraints == null) {
            return null;
        }
        HashSet<Constraint> res = new HashSet<Constraint>();
        for (Constraint c : this.constraints) {
            if (c.getType() != SQLSyntax.ConstraintType.CHECK && c.getType() != SQLSyntax.ConstraintType.UNIQUE) continue;
            res.add(c);
        }
        return res;
    }

    public final synchronized Constraint getConstraint(SQLSyntax.ConstraintType type, List<String> cols) {
        if (this.constraints == null) {
            return null;
        }
        for (Constraint c : this.constraints) {
            if (c.getType() != type || !c.getCols().equals(cols)) continue;
            return c;
        }
        return null;
    }

    public synchronized boolean isRowable() {
        return this.getPrimaryKeys().size() == 1 && Number.class.isAssignableFrom(this.getKey().getType().getJavaType());
    }

    public SQLSchema getSchema() {
        return (SQLSchema)this.getParent();
    }

    public SQLBase getBase() {
        return this.getSchema().getBase();
    }

    final synchronized String getVersion() {
        return this.version;
    }

    @Override
    public synchronized SQLField getKey() {
        if (!this.primaryKeyOK) {
            throw new IllegalStateException(this + " has more than 1 primary key: " + this.getPrimaryKeys());
        }
        return this.primaryKey;
    }

    public synchronized Set<SQLField> getPrimaryKeys() {
        return Collections.unmodifiableSet(this.primaryKeys);
    }

    public final Set<Link> getForeignLinks() {
        return this.getDBSystemRoot().getGraph().getForeignLinks(this);
    }

    public Set<SQLField> getForeignKeys() {
        return this.getDBSystemRoot().getGraph().getForeignKeys(this);
    }

    public Set<String> getForeignKeysNames() {
        return DatabaseGraph.getNames(this.getForeignLinks());
    }

    public Set<List<SQLField>> getForeignKeysFields() {
        return this.getDBSystemRoot().getGraph().getForeignKeysFields(this);
    }

    public Set<SQLField> getForeignKeys(String foreignTable) {
        return this.getForeignKeys(this.getTable(foreignTable));
    }

    public Set<SQLField> getForeignKeys(SQLTable foreignTable) {
        return this.getDBSystemRoot().getGraph().getForeignFields(this, foreignTable);
    }

    public SQLTable getForeignTable(String foreignField) {
        return this.getField(foreignField).getForeignTable();
    }

    public SQLTable findReferentTable(String tableName) {
        return this.getDBSystemRoot().getGraph().findReferentTable(this, tableName, new String[0]);
    }

    public synchronized Set<SQLField> getKeys() {
        if (this.keys == null) {
            this.keys = this.getFields(VirtualFields.KEYS);
        }
        return this.keys;
    }

    public synchronized Map<String, FieldGroup> getFieldGroups() {
        if (this.fieldsGroups == null) {
            LinkedHashMap<String, FieldGroup> res = new LinkedHashMap<String, FieldGroup>();
            for (String field : this.getFieldsName()) {
                res.put(field, new FieldGroup(null, field));
            }
            for (Link l : this.getForeignLinks()) {
                SQLTable.indexKey(res, SQLKey.createForeignKey(l));
            }
            SQLKey pk = SQLKey.createPrimaryKey(this);
            if (pk != null) {
                SQLTable.indexKey(res, pk);
            }
            this.fieldsGroups = Collections.unmodifiableMap(res);
        }
        return this.fieldsGroups;
    }

    private static final void indexKey(Map<String, FieldGroup> m, SQLKey k) {
        FieldGroup group = new FieldGroup(k, null);
        for (String field : k.getFields()) {
            FieldGroup previous = m.put(field, group);
            assert (previous.getKeyType() == null);
        }
    }

    public String toString() {
        return "/" + this.getName() + "/";
    }

    @Override
    public SQLField getField(String fieldName) {
        SQLField res = this.getFieldRaw(fieldName);
        if (res == null) {
            throw new IllegalArgumentException("unknown field " + fieldName + " in " + this.getName() + ". The table " + this.getName() + " contains the followins fields: " + this.getFieldsName());
        }
        return res;
    }

    public SQLField getFieldRaw(String fieldName) {
        return this.fields.get(fieldName);
    }

    public Set<SQLField> getFields() {
        return new HashSet<SQLField>(this.fields.values());
    }

    public final Set<SQLField> getFields(VirtualFields vfs) {
        return this.getFields(vfs.set);
    }

    final Set<SQLField> getFields(Set<VirtualFieldPartition> vf) {
        Set<SQLField> res;
        if (vf.isEmpty()) {
            return Collections.emptySet();
        }
        if (!vf.contains((Object)VirtualFieldPartition.LOCAL_CONTENT)) {
            res = new HashSet<SQLField>();
            for (VirtualFieldPartition v : vf) {
                res.addAll(v.getFields(this));
            }
        } else {
            res = this.getFields();
            VirtualFieldPartition[] virtualFieldPartitionArray = VirtualFieldPartition.values();
            int n = virtualFieldPartitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualFieldPartition v = virtualFieldPartitionArray[n2];
                if (!vf.contains((Object)v)) {
                    res.removeAll(v.getFields(this));
                }
                ++n2;
            }
        }
        return res;
    }

    public final Set<String> getFieldsNames(VirtualFields vfs) {
        HashSet<String> res = new HashSet<String>();
        for (SQLField f : this.getFields(vfs)) {
            res.add(f.getName());
        }
        return res;
    }

    public Set<SQLField> getContentFields() {
        return this.getContentFields(false);
    }

    public synchronized Set<SQLField> getContentFields(boolean includeMetadata) {
        return this.getFields(includeMetadata ? VirtualFields.CONTENT_AND_METADATA : VirtualFields.CONTENT);
    }

    public synchronized Set<SQLField> getLocalContentFields() {
        return this.getFields(VirtualFields.LOCAL_CONTENT);
    }

    public Set<String> getFieldsName() {
        return this.fields.keySet();
    }

    public List<SQLField> getOrderedFields() {
        return new ArrayList<SQLField>(this.fields.values());
    }

    @Override
    public Map<String, SQLField> getChildrenMap() {
        return this.fields.getImmutable();
    }

    public final SQLTable getTable(String name) {
        return this.getDesc(name, SQLTable.class);
    }

    public int getRowCount() {
        return this.getRowCount(true);
    }

    public int getRowCount(boolean includeUndefined) {
        return this.getRowCount(includeUndefined, SQLSelect.ArchiveMode.BOTH);
    }

    public int getRowCount(boolean includeUndefined, SQLSelect.ArchiveMode archiveMode) {
        SQLSelect sel = new SQLSelect(true).addSelectFunctionStar("count").addFrom(this);
        sel.setExcludeUndefined(!includeUndefined);
        sel.setArchivedPolicy(archiveMode);
        Number count = (Number)this.getBase().getDataSource().execute(sel.asString(), new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, false));
        return count.intValue();
    }

    public BigDecimal getMaxOrder() {
        return this.getMaxOrder(true);
    }

    public BigDecimal getMaxOrder(Boolean useCache) {
        SQLField orderField = this.getOrderField();
        if (orderField == null) {
            throw new IllegalStateException(this + " is not ordered");
        }
        SQLSelect sel = new SQLSelect(true).addSelect(orderField, "max");
        try {
            BigDecimal maxOrder = (BigDecimal)this.getBase().getDataSource().execute(sel.asString(), new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, useCache));
            return maxOrder == null ? BigDecimal.ONE.negate() : maxOrder;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(orderField.getSQLName() + " must be " + SQLSyntax.get(this).getOrderDefinition(), e);
        }
    }

    public SQLRow getRow(int ID) {
        SQLRow row = this.getUncheckedRow(ID);
        return row.exists() ? row : null;
    }

    private SQLRow getUncheckedRow(int ID) {
        return new SQLRow(this, ID);
    }

    public SQLRow getValidRow(int ID) {
        SQLRow row = this.getRow(ID);
        return row.isValid() ? row : null;
    }

    public SQLRow checkValidity(int ID) {
        SQLRow row = this.getUncheckedRow(ID);
        return row.isValid() ? null : row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple3<SQLRow, SQLField, SQLRow>> checkIntegrity() {
        Set<SQLField> fks;
        SQLField pk;
        SQLTable sQLTable = this;
        synchronized (sQLTable) {
            block5: {
                if (this.isRowable()) break block5;
                return null;
            }
            pk = this.getKey();
            fks = this.getForeignKeys();
        }
        final ArrayList<Tuple3<SQLRow, SQLField, SQLRow>> inconsistencies = new ArrayList<Tuple3<SQLRow, SQLField, SQLRow>>();
        if (!fks.isEmpty()) {
            SQLSelect sel = new SQLSelect();
            sel.setExcludeUndefined(false);
            sel.addSelect(pk);
            sel.addAllSelect(fks);
            this.getBase().getDataSource().execute(sel.asString(), new ResultSetHandler(){

                @Override
                public Object handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        for (SQLField fk : fks) {
                            SQLRow pb = SQLTable.this.checkValidity(fk.getName(), rs.getInt(fk.getFullName()));
                            if (pb == null) continue;
                            SQLRow row = SQLTable.this.getRow(rs.getInt(pk.getFullName()));
                            inconsistencies.add(Tuple3.create(row, fk, pb));
                        }
                    }
                    return null;
                }
            });
        }
        return inconsistencies;
    }

    public SQLRow checkValidity(String foreignKey, int foreignID) {
        SQLField fk = this.getField(foreignKey);
        SQLTable foreignTable = this.getDBSystemRoot().getGraph().getForeignTable(fk);
        if (foreignTable == null) {
            throw new IllegalArgumentException("Impossible de tester '" + foreignKey + "' avec " + foreignID + " dans " + this + ". Ce n'est pas une clef \u00e9trang\u00e8re.");
        }
        return foreignTable.checkValidity(foreignID);
    }

    public SQLRow checkValidity(String foreignKey, Number foreignID) {
        if (foreignID == null) {
            return null;
        }
        return this.checkValidity(foreignKey, foreignID.intValue());
    }

    public boolean isOrdered() {
        return this.getOrderField() != null;
    }

    public SQLField getOrderField() {
        return this.getFieldRaw(orderField);
    }

    public final int getOrderDecimalDigits() {
        return this.getOrderField().getType().getDecimalDigits();
    }

    public final BigDecimal getOrderULP() {
        return BigDecimal.ONE.scaleByPowerOfTen(-this.getOrderDecimalDigits());
    }

    public boolean isArchivable() {
        return this.getArchiveField() != null;
    }

    public SQLField getArchiveField() {
        return this.getFieldRaw(archiveField);
    }

    public SQLField getCreationDateField() {
        return this.getFieldRaw("CREATION_DATE");
    }

    public SQLField getCreationUserField() {
        return this.getFieldRaw("ID_USER_COMMON_CREATE");
    }

    public SQLField getModifDateField() {
        return this.getFieldRaw("MODIFICATION_DATE");
    }

    public SQLField getModifUserField() {
        return this.getFieldRaw("ID_USER_COMMON_MODIFY");
    }

    public final int getUndefinedID() {
        return this.getUndefinedID(false);
    }

    final synchronized boolean undefinedIDKnown() {
        return this.undefinedID != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Integer getUndefinedID(boolean internal) {
        Integer res = null;
        SQLTable sQLTable = this;
        synchronized (sQLTable) {
            if (this.undefinedID != null) {
                res = this.undefinedID;
            }
        }
        if (res == null) {
            if (!internal && this.getSchema().isFetchAllUndefinedIDs()) {
                for (SQLTable sibling : this.getSchema().getTables()) {
                    Integer siblingRes = sibling.getUndefinedID(true);
                    assert (siblingRes != null);
                    if (sibling != this) continue;
                    res = siblingRes;
                }
            } else {
                res = this.fetchUndefID();
                sQLTable = this;
                synchronized (sQLTable) {
                    this.undefinedID = res;
                }
            }
        }
        assert (this.undefinedIDKnown());
        return res;
    }

    public final Number getUndefinedIDNumber() {
        int res = this.getUndefinedID();
        if (res == -1) {
            return null;
        }
        return res;
    }

    public void addTableModifiedListener(SQLTableModifiedListener l) {
        this.addTableModifiedListener(new ListenerAndConfig(l, AFTER_TX_DEFAULT));
    }

    public void addTableModifiedListener(ListenerAndConfig l) {
        this.addTableModifiedListener(l, false);
    }

    public void addPremierTableModifiedListener(ListenerAndConfig l) {
        this.addTableModifiedListener(l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTableModifiedListener(ListenerAndConfig l, boolean before) {
        Object object = this.listenersMutex;
        synchronized (object) {
            ArrayList<ListenerAndConfig> newListeners = new ArrayList<ListenerAndConfig>(this.tableModifiedListeners.size() + 1);
            if (before) {
                newListeners.add(l);
            }
            newListeners.addAll(this.tableModifiedListeners);
            if (!before) {
                newListeners.add(l);
            }
            this.tableModifiedListeners = Collections.unmodifiableList(newListeners);
        }
    }

    public void removeTableModifiedListener(SQLTableModifiedListener l) {
        this.removeTableModifiedListener(new ListenerAndConfig(l, AFTER_TX_DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableModifiedListener(ListenerAndConfig l) {
        Object object = this.listenersMutex;
        synchronized (object) {
            ArrayList<ListenerAndConfig> newListeners = new ArrayList<ListenerAndConfig>(this.tableModifiedListeners);
            if (newListeners.remove(l)) {
                this.tableModifiedListeners = Collections.unmodifiableList(newListeners);
            }
        }
    }

    public void addTableListener(SQLTableListener l) {
        this.addTableModifiedListener(new BridgeListener(l));
    }

    public void removeTableListener(SQLTableListener l) {
        this.removeTableModifiedListener(new BridgeListener(l));
    }

    public void fireTableModified(int id) {
        this.fire(SQLTableEvent.Mode.ROW_UPDATED, id);
    }

    public void fireRowAdded(int id) {
        this.fire(SQLTableEvent.Mode.ROW_ADDED, id);
    }

    public void fireRowDeleted(int id) {
        this.fire(SQLTableEvent.Mode.ROW_DELETED, id);
    }

    public void fireTableModified(int id, Collection<String> fields) {
        this.fire(new SQLTableEvent(this, id, SQLTableEvent.Mode.ROW_UPDATED, fields));
    }

    private void fire(SQLTableEvent.Mode mode, int id) {
        this.fire(new SQLTableEvent(this, id, mode, null));
    }

    public final void fire(SQLTableEvent evt) {
        this.fireTableModified(evt);
    }

    private static void fireTableModified(DispatchingState newTuple) {
        DispatchingState currentTuple;
        LinkedList<DispatchingState> linkedList = events.get();
        linkedList.addLast(newTuple);
        while ((currentTuple = linkedList.peekFirst()) != null) {
            Iterator iter = (Iterator)currentTuple.get0();
            SQLTableEvent currentEvt = (SQLTableEvent)currentTuple.get1();
            while (iter.hasNext()) {
                SQLTableModifiedListener l = (SQLTableModifiedListener)iter.next();
                l.tableModified(currentEvt);
            }
            linkedList.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableModified(SQLTableEvent evt) {
        Boolean callbackAfterTxListeners;
        FireState fireState;
        if (evt.getTable() != this) {
            throw new IllegalArgumentException("Wrong table : " + this + " ; " + evt);
        }
        TransactionPoint point = evt.getTransactionPoint();
        Object object = this.listenersMutex;
        synchronized (object) {
            fireState = new FireState(this.tableModifiedListeners, evt);
            if (point == null) {
                callbackAfterTxListeners = null;
            } else if (point.isActive()) {
                this.addFireStates(point, Collections.singleton(fireState));
                callbackAfterTxListeners = false;
            } else {
                if (!point.wasCommitted()) {
                    throw new IllegalStateException("Fire after an aborted transaction point");
                }
                if (point.getSavePoint() != null) {
                    this.addFireStates(point, Collections.singleton(fireState));
                    callbackAfterTxListeners = false;
                } else {
                    callbackAfterTxListeners = null;
                }
            }
        }
        SQLTable.fireTableModified(fireState.createDispatchingState(callbackAfterTxListeners, false));
    }

    /*
     * Unable to fully structure code
     */
    private void addFireStates(TransactionPoint point, Collection<FireState> fireStates) {
        if (SQLTable.$assertionsDisabled || Thread.holdsLock(this.listenersMutex)) ** GOTO lbl4
        throw new AssertionError((Object)"Unsafe to access this.transactions");
lbl-1000:
        // 1 sources

        {
            point = point.getPrevious();
lbl4:
            // 2 sources

            ** while (!point.isActive())
        }
lbl5:
        // 1 sources

        if (!this.transactions.containsKey(point)) {
            point.addListener(this.txListener);
        }
        this.transactions.addAll(point, fireStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFromTransaction(TransactionPoint point) {
        List states;
        boolean committed = point.wasCommitted();
        boolean releasedSavePoint = committed && point.getSavePoint() != null;
        Object object = this.listenersMutex;
        synchronized (object) {
            states = (List)this.transactions.remove(point);
            if (releasedSavePoint) {
                this.addFireStates(point, states);
            }
        }
        if (!releasedSavePoint) {
            ListIterator iter = CollectionUtils.getListIterator(states, !committed);
            while (iter.hasNext()) {
                FireState state = (FireState)iter.next();
                SQLTable.fireTableModified(state.createDispatchingState(committed, !committed));
            }
        }
    }

    public synchronized String toXML() {
        StringBuilder sb = new StringBuilder(16000);
        sb.append("<table name=\"");
        sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getName()));
        sb.append("\"");
        String schemaName = this.getSchema().getName();
        if (schemaName != null) {
            sb.append(" schema=\"");
            sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(schemaName));
            sb.append('\"');
        }
        SQLSchema.appendVersionAttr(this.version, sb);
        if (this.getType() != null) {
            sb.append(" type=\"");
            sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getType()));
            sb.append('\"');
        }
        sb.append(">\n");
        if (this.getComment() != null) {
            sb.append("<comment>");
            sb.append(JDOMUtils.OUTPUTTER.escapeElementEntities(this.getComment()));
            sb.append("</comment>\n");
        }
        for (SQLField sQLField : this.fields.values()) {
            sb.append(sQLField.toXML());
        }
        sb.append("<primary>\n");
        for (SQLField sQLField : this.primaryKeys) {
            sb.append(sQLField.toXML());
        }
        sb.append("</primary>\n");
        if (this.triggers.size() > 0) {
            sb.append("<triggers>\n");
            for (Trigger trigger : this.triggers.values()) {
                sb.append(trigger.toXML());
            }
            sb.append("</triggers>\n");
        }
        if (this.constraints != null) {
            sb.append("<constraints>\n");
            for (Constraint constraint : this.constraints) {
                sb.append(constraint.toXML());
            }
            sb.append("</constraints>\n");
        }
        sb.append("</table>");
        return sb.toString();
    }

    @Override
    public SQLTableModifiedListener createTableListener(final SQLDataListener l) {
        return new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                l.dataChanged(evt);
            }
        };
    }

    @Override
    public SQLTable getTable() {
        return this;
    }

    @Override
    public String getAlias() {
        return this.getName();
    }

    @Override
    public String getSQL() {
        return this.getSQLName().quote();
    }

    public boolean equalsDesc(SQLTable o) {
        return this.equalsDesc(o, true) == null;
    }

    public String equalsDesc(SQLTable o, boolean compareName) {
        return this.equalsDesc(o, null, compareName);
    }

    public synchronized String equalsDesc(SQLTable o, SQLSystem otherSystem, boolean compareName) {
        boolean checkComment;
        boolean name;
        if (o == null) {
            return "other table is null";
        }
        boolean bl = name = !compareName || this.getName().equals(o.getName());
        if (!name) {
            return "name unequal : " + this.getName() + " " + o.getName();
        }
        boolean bl2 = checkComment = otherSystem == null || this.getServer().getSQLSystem().isTablesCommentSupported() && otherSystem.isTablesCommentSupported();
        if (checkComment && !CompareUtils.equals(this.getComment(), o.getComment())) {
            return "comment unequal : " + SQLBase.quoteStringStd(this.getComment()) + " != " + SQLBase.quoteStringStd(o.getComment());
        }
        return this.equalsChildren(o, otherSystem);
    }

    private synchronized String equalsChildren(SQLTable o, SQLSystem otherSystem) {
        Set<Constraint> otherConstraints;
        Set<Constraint> thisConstraints;
        if (!this.getChildrenNames().equals(o.getChildrenNames())) {
            return "fields differences: " + this.getChildrenNames() + "\n" + o.getChildrenNames();
        }
        String noLink = this.equalsChildrenNoLink(o, otherSystem);
        if (noLink != null) {
            return noLink;
        }
        Set<Link> thisLinks = this.getForeignLinks();
        Set<Link> oLinks = o.getForeignLinks();
        if (thisLinks.size() != oLinks.size()) {
            return "different number of foreign keys " + thisLinks + " != " + oLinks;
        }
        SQLSystem thisSystem = this.getServer().getSQLSystem();
        for (Link l : thisLinks) {
            Link ol = o.getDBSystemRoot().getGraph().getForeignLink(o, l.getCols());
            if (ol == null) {
                return "no foreign key for " + l.getLabel();
            }
            SQLName thisPath = ((SQLTable)l.getTarget()).getContextualSQLName(this);
            SQLName oPath = ((SQLTable)ol.getTarget()).getContextualSQLName(o);
            if (thisPath.getItemCount() != oPath.getItemCount()) {
                return "unequal path size : " + thisPath + " != " + oPath;
            }
            if (!thisPath.getName().equals(oPath.getName())) {
                return "unequal referenced table name : " + thisPath.getName() + " != " + oPath.getName();
            }
            if (!this.getRule(l.getUpdateRule(), thisSystem, otherSystem).equals((Object)this.getRule(ol.getUpdateRule(), thisSystem, otherSystem))) {
                return "unequal update rule for " + l + ": " + (Object)((Object)l.getUpdateRule()) + " != " + (Object)((Object)ol.getUpdateRule());
            }
            if (this.getRule(l.getDeleteRule(), thisSystem, otherSystem).equals((Object)this.getRule(ol.getDeleteRule(), thisSystem, otherSystem))) continue;
            return "unequal delete rule for " + l + ": " + (Object)((Object)l.getDeleteRule()) + " != " + (Object)((Object)ol.getDeleteRule());
        }
        try {
            Tuple2<Set<Constraint>, Set<Index>> thisConstraintsAndIndexes = this.getConstraintsAndIndexes();
            Tuple2<Set<Constraint>, Set<Index>> otherConstraintsAndIndexes = o.getConstraintsAndIndexes();
            Set<Index> thisIndexesSet = thisConstraintsAndIndexes.get1();
            Set<Index> oIndexesSet = otherConstraintsAndIndexes.get1();
            if (!thisIndexesSet.equals(oIndexesSet)) {
                return "indexes differences: " + thisIndexesSet + "\n" + oIndexesSet;
            }
            thisConstraints = thisConstraintsAndIndexes.get0();
            otherConstraints = otherConstraintsAndIndexes.get0();
        }
        catch (SQLException e) {
            return "couldn't get indexes: " + ExceptionUtils.getStackTrace(e);
        }
        if (!CustomEquals.equals(thisConstraints, otherConstraints, otherSystem == null || otherSystem.equals((Object)thisSystem) ? null : Constraint.getInterSystemHashStrategy())) {
            return "constraints unequal : '" + thisConstraints + "' != '" + otherConstraints + "'";
        }
        return null;
    }

    private final Tuple2<Set<Constraint>, Set<Index>> getConstraintsAndIndexes() throws SQLException {
        HashSet<Index> thisIndexes;
        Set<Constraint> thisConstraints;
        if (this.getServer().getSQLSystem() != SQLSystem.MSSQL) {
            thisConstraints = this.getConstraints();
            thisIndexes = new HashSet<Index>(this.getIndexes(true));
        } else {
            thisConstraints = new HashSet<Constraint>(this.getConstraints());
            thisIndexes = new HashSet();
            for (Index i : this.getIndexes()) {
                Value<String> where = i.getMSUniqueWhere();
                if (!where.hasValue()) {
                    thisIndexes.add(i);
                    continue;
                }
                if (where.getValue() == null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("CONSTRAINT_NAME", i.getName());
                    map.put("CONSTRAINT_TYPE", "UNIQUE");
                    map.put("COLUMN_NAMES", i.getCols());
                    map.put("DEFINITION", null);
                    thisConstraints.add(new Constraint(this, map));
                    continue;
                }
                thisIndexes.add(this.createUniqueIndex(i.getName(), i.getCols(), where.getValue()));
            }
        }
        return Tuple2.create(thisConstraints, thisIndexes);
    }

    private final Link.Rule getRule(Link.Rule r, SQLSystem thisSystem, SQLSystem otherSystem) {
        if (otherSystem == null) {
            return r;
        }
        if (r == Link.Rule.NO_ACTION && (thisSystem == SQLSystem.H2 || otherSystem == SQLSystem.H2)) {
            return Link.Rule.RESTRICT;
        }
        return r;
    }

    public final synchronized String equalsChildrenNoLink(SQLTable o, SQLSystem otherSystem) {
        for (SQLField f : this.getFields()) {
            SQLField oField = o.getField(f.getName());
            boolean isPrimary = this.getPrimaryKeys().contains(f);
            if (isPrimary != o.getPrimaryKeys().contains(oField)) {
                return f + " is a primary not in " + o.getPrimaryKeys();
            }
            String equalsDesc = f.equalsDesc(oField, otherSystem, !isPrimary);
            if (equalsDesc == null) continue;
            return equalsDesc;
        }
        return null;
    }

    public final SQLCreateMoveableTable getCreateTable() {
        return this.getCreateTable(this.getServer().getSQLSystem());
    }

    public final synchronized SQLCreateMoveableTable getCreateTable(SQLSystem system) {
        SQLSyntax syntax = SQLSyntax.get(system);
        SQLCreateMoveableTable res = new SQLCreateMoveableTable(syntax, this.getDBRoot().getName(), this.getName());
        for (SQLField f : this.getOrderedFields()) {
            res.addColumn(f);
        }
        res.setPrimaryKey(this.getPKsNames());
        for (Link l : this.getForeignLinks()) {
            res.addForeignConstraint(l, false);
        }
        if (this.constraints != null) {
            for (Constraint added : this.getConstraints()) {
                if (added.getType() == SQLSyntax.ConstraintType.UNIQUE) {
                    res.addUniqueConstraint(added.getName(), added.getCols());
                    continue;
                }
                throw new UnsupportedOperationException("unsupported constraint: " + added);
            }
        }
        try {
            boolean convertMSIndex = this.getServer().getSQLSystem() == SQLSystem.MSSQL && system != SQLSystem.MSSQL;
            Set<List<SQLField>> foreignKeysFields = this.getForeignKeysFields();
            for (Index i : this.getIndexes(true)) {
                Value<String> msWhere = null;
                if (convertMSIndex && (msWhere = i.getMSUniqueWhere()).hasValue()) {
                    if (msWhere.getValue() != null) {
                        Log.get().warning("MS filter might not be valid in " + (Object)((Object)system) + " : " + msWhere.getValue());
                    }
                    res.addUniqueConstraint(i.getName(), i.getCols(), msWhere.getValue());
                    continue;
                }
                if (system.autoCreatesFKIndex() && foreignKeysFields.contains(i.getFields())) continue;
                if (i.isUnique() && i.getFilter() != null && !system.isIndexFilterConditionSupported()) {
                    res.addUniqueConstraint(i.getName(), i.getCols(), i.getFilter());
                    continue;
                }
                res.addOutsideClause(syntax.getCreateIndex(i));
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("could not get indexes", e);
        }
        if (this.getComment() != null) {
            res.addOutsideClause(syntax.getSetTableComment(this.getComment()));
        }
        return res;
    }

    public final List<String> getPKsNames() {
        return this.getPKsNames(new ArrayList());
    }

    public final synchronized <C extends Collection<String>> C getPKsNames(C pks) {
        for (SQLField f : this.getPrimaryKeys()) {
            pks.add((String)f.getName());
        }
        return pks;
    }

    public final String[] getPKsNamesArray() {
        return this.getPKsNames().toArray(new String[0]);
    }

    public final SetMap<String, Index> getIndexesByField() throws SQLException {
        List<Index> indexes = this.getIndexes();
        SetMap<String, Index> res = new SetMap<String, Index>(indexes.size()){

            @Override
            public Set<Index> createCollection(Collection<? extends Index> v) {
                HashSet<Index> res = new HashSet<Index>(4);
                res.addAll(v);
                return res;
            }
        };
        for (Index i : indexes) {
            for (String col : i.getCols()) {
                res.add(col, i);
            }
        }
        return res;
    }

    public final List<Index> getIndexes(List<String> cols) throws SQLException {
        ArrayList<Index> res = new ArrayList<Index>();
        for (Index i : this.getIndexes()) {
            if (!i.getCols().equals(cols)) continue;
            res.add(i);
        }
        return res;
    }

    public final synchronized List<Index> getIndexes() throws SQLException {
        return this.getIndexes(false);
    }

    protected final synchronized List<Index> getIndexes(boolean normalized) throws SQLException {
        Set<List<String>> uniqConstraints;
        if (this.constraints != null) {
            uniqConstraints = new HashSet();
            for (Constraint c : this.constraints) {
                if (c.getType() != SQLSyntax.ConstraintType.UNIQUE) continue;
                uniqConstraints.add(c.getCols());
            }
        } else {
            uniqConstraints = Collections.emptySet();
        }
        ArrayList<Index> indexes = new ArrayList<Index>();
        Index currentIndex = null;
        for (Map<String, Object> norm : this.getServer().getSQLSystem().getSyntax().getIndexInfo(this)) {
            Index index = new Index(norm);
            short seq = ((Number)norm.get("ORDINAL_POSITION")).shortValue();
            if (seq == 1) {
                if (this.canAdd(currentIndex, uniqConstraints)) {
                    indexes.add(currentIndex);
                }
                currentIndex = index;
                continue;
            }
            currentIndex.add(index);
        }
        if (this.canAdd(currentIndex, uniqConstraints)) {
            indexes.add(currentIndex);
        }
        if (normalized) {
            indexes.addAll(this.getPartialUniqueIndexes());
        }
        return indexes;
    }

    private boolean canAdd(Index currentIndex, Set<List<String>> uniqConstraints) {
        if (currentIndex == null || currentIndex.isPKIndex()) {
            return false;
        }
        return !currentIndex.isUnique() || !uniqConstraints.contains(currentIndex.getCols());
    }

    protected final synchronized List<Index> getPartialUniqueIndexes() throws SQLException {
        ArrayList<Index> indexes;
        block9: {
            SQLSystem thisSystem;
            block8: {
                thisSystem = this.getServer().getSQLSystem();
                indexes = new ArrayList<Index>();
                if (thisSystem != SQLSystem.H2) break block8;
                for (Trigger t : this.triggers.values()) {
                    Matcher matcher = ChangeTable.H2_UNIQUE_TRIGGER_PATTERN.matcher(t.getSQL());
                    if (!matcher.find()) continue;
                    String indexName = ChangeTable.getIndexName(t.getName(), thisSystem);
                    String[] javaCols = ChangeTable.H2_LIST_PATTERN.split(matcher.group(1).trim());
                    ArrayList<String> cols = new ArrayList<String>(javaCols.length);
                    String[] stringArray = javaCols;
                    int n = javaCols.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String javaCol = stringArray[n2];
                        cols.add(StringUtils.unDoubleQuote(javaCol));
                        ++n2;
                    }
                    String where = StringUtils.unDoubleQuote(matcher.group(2).trim());
                    indexes.add(this.createUniqueIndex(indexName, cols, where));
                }
                break block9;
            }
            if (thisSystem != SQLSystem.MYSQL) break block9;
            for (Trigger t : this.triggers.values()) {
                Trigger t2;
                if (!t.getAction().contains(ChangeTable.MYSQL_TRIGGER_EXCEPTION)) continue;
                String indexName = ChangeTable.getIndexName(t.getName(), thisSystem);
                Trigger trigger = t2 = indexName == null ? null : this.triggers.get(String.valueOf(indexName) + ChangeTable.MYSQL_TRIGGER_SUFFIX_2);
                if (t2 == null || !t2.getAction().equals(t.getAction())) continue;
                Matcher matcher = ChangeTable.MYSQL_UNIQUE_TRIGGER_PATTERN.matcher(t.getAction());
                if (!matcher.find()) {
                    throw new IllegalStateException("Couldn't parse " + t.getAction());
                }
                SQLName parsedName = SQLName.parse(matcher.group(1).trim());
                if (!this.getName().equals(parsedName.getName())) {
                    throw new IllegalStateException("Name mismatch : " + this.getSQLName() + " != " + parsedName);
                }
                String[] wheres = ChangeTable.MYSQL_WHERE_PATTERN.split(matcher.group(2).trim());
                String userWhere = wheres[0];
                ArrayList<String> cols = new ArrayList<String>(wheres.length - 1);
                int i = 1;
                while (i < wheres.length) {
                    Matcher eqMatcher = ChangeTable.MYSQL_WHERE_EQ_PATTERN.matcher(wheres[i].trim());
                    if (!eqMatcher.matches()) {
                        throw new IllegalStateException("Invalid where clause " + wheres[i]);
                    }
                    cols.add(SQLName.parse(eqMatcher.group(2).trim()).getName());
                    ++i;
                }
                if (cols.isEmpty()) {
                    throw new IllegalStateException("No columns in " + Arrays.asList(wheres));
                }
                indexes.add(this.createUniqueIndex(indexName, cols, userWhere));
            }
        }
        return indexes;
    }

    private final Index createUniqueIndex(String name, List<String> cols, String where) {
        Index res = new Index(name, cols.get(0), (Boolean)false, where);
        int i = 1;
        while (i < cols.size()) {
            res.addFromMD(cols.get(i));
            ++i;
        }
        return res;
    }

    private final String removeParens(String filter) {
        if (filter != null) {
            filter = filter.trim();
            SQLSystem sys = this.getServer().getSQLSystem();
            if ((sys == SQLSystem.POSTGRESQL || sys == SQLSystem.MSSQL) && filter.startsWith("(") && filter.endsWith(")")) {
                filter = filter.substring(1, filter.length() - 1);
            }
        }
        return filter;
    }

    private static final class BridgeListener
    implements SQLTableModifiedListener {
        private final SQLTableListener l;

        private BridgeListener(SQLTableListener l) {
            this.l = l;
        }

        @Override
        public void tableModified(SQLTableEvent evt) {
            SQLTableEvent.Mode mode = evt.getMode();
            if (mode == SQLTableEvent.Mode.ROW_ADDED) {
                this.l.rowAdded(evt.getTable(), evt.getId());
            } else if (mode == SQLTableEvent.Mode.ROW_UPDATED) {
                this.l.rowModified(evt.getTable(), evt.getId());
            } else if (mode == SQLTableEvent.Mode.ROW_DELETED) {
                this.l.rowDeleted(evt.getTable(), evt.getId());
            }
        }

        public int hashCode() {
            return this.l.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof BridgeListener && this.l.equals(((BridgeListener)obj).l);
        }
    }

    private static class DispatchingState
    extends Tuple2<Iterator<SQLTableModifiedListener>, SQLTableEvent> {
        public DispatchingState(List<SQLTableModifiedListener> listeners, SQLTableEvent evt) {
            super(listeners.iterator(), evt);
        }
    }

    public static final class FieldGroup {
        private final String field;
        private final SQLKey key;

        private FieldGroup(SQLKey key, String field) {
            assert (key == null != (field == null));
            this.key = key;
            this.field = key == null ? field : CollectionUtils.getSole(key.getFields());
        }

        public final SQLKey.Type getKeyType() {
            if (this.key == null) {
                return null;
            }
            return this.key.getType();
        }

        public final SQLKey getKey() {
            return this.key;
        }

        public String getSingleField() {
            return this.field;
        }

        public final List<String> getFields() {
            return this.key == null ? Arrays.asList(this.field) : this.key.getFields();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + (this.key != null ? this.key.toString() : this.field);
        }
    }

    private static class FireState
    extends Tuple2<List<ListenerAndConfig>, SQLTableEvent> {
        public FireState(List<ListenerAndConfig> listeners, SQLTableEvent evt) {
            super(listeners, evt);
        }

        private DispatchingState createDispatchingState(Boolean callbackAfterTxListeners, boolean oppositeEvt) {
            LinkedList<SQLTableModifiedListener> listeners = new LinkedList<SQLTableModifiedListener>();
            for (ListenerAndConfig l : (List)this.get0()) {
                if (callbackAfterTxListeners != null && l.callOnlyAfterTx() != null && callbackAfterTxListeners != l.callOnlyAfterTx()) continue;
                listeners.add(l.getListener());
            }
            return new DispatchingState((List<SQLTableModifiedListener>)listeners, oppositeEvt ? ((SQLTableEvent)this.get1()).opposite() : (SQLTableEvent)this.get1());
        }
    }

    public final class Index
    extends SQLIndex {
        private final List<String> cols;

        Index(Map<String, Object> row) {
            this((String)row.get("INDEX_NAME"), (String)row.get("COLUMN_NAME"), (Boolean)row.get("NON_UNIQUE"), (String)row.get("FILTER_CONDITION"));
        }

        Index(String name, String col, Boolean nonUnique, String filter) {
            super(name, Collections.<String>emptyList(), nonUnique == false, SQLTable.this.removeParens(filter));
            this.cols = new ArrayList<String>();
            this.addFromMD(col);
        }

        public final SQLTable getTable() {
            return SQLTable.this;
        }

        public final List<String> getCols() {
            return this.cols;
        }

        public final List<SQLField> getFields() {
            ArrayList<SQLField> res = new ArrayList<SQLField>(this.getCols().size());
            for (String f : this.getCols()) {
                res.add(this.getTable().getField(f));
            }
            return res;
        }

        private final void add(Index o) {
            assert (o.getAttrs().size() == 1);
            if (!o.getName().equals(this.getName()) || this.isUnique() != o.isUnique()) {
                throw new IllegalStateException("incoherence");
            }
            this.cols.addAll(o.getCols());
            this.addAttr(o.getAttrs().get(0));
        }

        protected void addFromMD(String col) {
            if (this.getTable().contains(col)) {
                this.cols.add(col);
                this.addAttr(SQLBase.quoteIdentifier(col));
            } else {
                this.addAttr(col);
            }
        }

        final boolean isPKIndex() {
            return this.isUnique() && this.getCols().equals(this.getTable().getPKsNames()) && this.getCols().size() == this.getAttrs().size();
        }

        private final Pattern getColPattern(String col) {
            return Pattern.compile("(?i:\\s+AND\\s+)?" + Pattern.quote(new SQLName(col).quoteMS()) + "\\s+(?i)IS\\s+NOT\\s+NULL(\\s+AND\\s+)?");
        }

        final Value<String> getMSUniqueWhere() {
            assert (SQLTable.this.getServer().getSQLSystem() == SQLSystem.MSSQL);
            if (this.isUnique() && this.getFilter() != null) {
                String filter = this.getFilter().trim();
                for (String col : this.getCols()) {
                    Matcher matcher = this.getColPattern(col).matcher(filter);
                    if (matcher.find()) {
                        filter = matcher.replaceFirst("").trim();
                        continue;
                    }
                    return Value.getNone();
                }
                return Value.getSome((filter = filter.trim()).isEmpty() ? null : filter);
            }
            return Value.getNone();
        }
    }

    public static final class ListenerAndConfig {
        private final SQLTableModifiedListener l;
        private final Boolean afterTx;

        public ListenerAndConfig(SQLTableModifiedListener l, Boolean afterTx) {
            if (l == null) {
                throw new NullPointerException("Null listener");
            }
            this.l = l;
            this.afterTx = afterTx;
        }

        public final SQLTableModifiedListener getListener() {
            return this.l;
        }

        public final Boolean callOnlyAfterTx() {
            return this.afterTx;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.afterTx == null ? 0 : this.afterTx.hashCode());
            result = 31 * result + this.l.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListenerAndConfig other = (ListenerAndConfig)obj;
            return CompareUtils.equals(this.afterTx, other.afterTx) && this.l.equals(other.l);
        }
    }

    public static class SQLIndex {
        private static final Pattern NORMALIZE_SPACES = Pattern.compile("\\s+");
        private final String name;
        private final List<String> attrs;
        private final boolean unique;
        private String method;
        private final String filter;

        public SQLIndex(String name, List<String> attributes, boolean unique, String filter) {
            this(name, attributes, false, unique, filter);
        }

        public SQLIndex(String name, List<String> attributes, boolean quoteAll, boolean unique, String filter) {
            this.name = name;
            this.attrs = new ArrayList<String>(attributes.size());
            for (String attr : attributes) {
                this.addAttr(quoteAll ? SQLBase.quoteIdentifier(attr) : attr);
            }
            this.unique = unique;
            this.method = null;
            this.filter = filter == null ? null : NORMALIZE_SPACES.matcher(filter.trim()).replaceAll(" ");
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isUnique() {
            return this.unique;
        }

        public final List<String> getAttrs() {
            return Collections.unmodifiableList(this.attrs);
        }

        protected final void addAttr(String attr) {
            this.attrs.add(attr);
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        public final String getMethod() {
            return this.method;
        }

        public final String getFilter() {
            return this.filter;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName() + " unique: " + this.isUnique() + " cols: " + this.getAttrs() + " filter: " + this.getFilter();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SQLIndex) {
                SQLIndex o = (SQLIndex)obj;
                return this.isUnique() == o.isUnique() && this.getAttrs().equals(o.getAttrs()) && CompareUtils.equals(this.getFilter(), o.getFilter()) && CompareUtils.equals(this.getMethod(), o.getMethod());
            }
            return false;
        }

        public int hashCode() {
            return this.getAttrs().hashCode() + Boolean.valueOf(this.isUnique()).hashCode();
        }
    }

    public static enum VirtualFieldPartition {
        ORDER{

            @Override
            Set<SQLField> getFields(SQLTable t) {
                SQLField orderField = t.getOrderField();
                return orderField == null ? Collections.emptySet() : Collections.singleton(orderField);
            }
        }
        ,
        ARCHIVE{

            @Override
            Set<SQLField> getFields(SQLTable t) {
                SQLField f = t.getArchiveField();
                return f == null ? Collections.emptySet() : Collections.singleton(f);
            }
        }
        ,
        METADATA{

            @Override
            Set<SQLField> getFields(SQLTable t) {
                HashSet<SQLField> res = new HashSet<SQLField>(4);
                res.add(t.getCreationDateField());
                res.add(t.getCreationUserField());
                res.add(t.getModifDateField());
                res.add(t.getModifUserField());
                res.remove(null);
                return res;
            }
        }
        ,
        PRIMARY_KEY{

            @Override
            Set<SQLField> getFields(SQLTable t) {
                return t.getPrimaryKeys();
            }
        }
        ,
        FOREIGN_KEYS{

            @Override
            Set<SQLField> getFields(SQLTable t) {
                return DatabaseGraph.getColsUnion(t.getForeignLinks());
            }
        }
        ,
        LOCAL_CONTENT{

            @Override
            Set<SQLField> getFields(SQLTable t) {
                throw new IllegalStateException((Object)((Object)this) + " is any field not in another set");
            }
        };


        abstract Set<SQLField> getFields(SQLTable var1);
    }

    public static final class VirtualFields {
        public static final VirtualFields ORDER = new VirtualFields(VirtualFieldPartition.ORDER);
        public static final VirtualFields ARCHIVE = new VirtualFields(VirtualFieldPartition.ARCHIVE);
        public static final VirtualFields METADATA = new VirtualFields(VirtualFieldPartition.METADATA);
        public static final VirtualFields PRIMARY_KEY = new VirtualFields(VirtualFieldPartition.PRIMARY_KEY);
        public static final VirtualFields FOREIGN_KEYS = new VirtualFields(VirtualFieldPartition.FOREIGN_KEYS);
        public static final VirtualFields LOCAL_CONTENT = new VirtualFields(VirtualFieldPartition.LOCAL_CONTENT);
        public static final VirtualFields CONTENT = LOCAL_CONTENT.union(FOREIGN_KEYS);
        public static final VirtualFields CONTENT_AND_METADATA = CONTENT.union(METADATA);
        public static final VirtualFields KEYS = PRIMARY_KEY.union(FOREIGN_KEYS);
        public static final VirtualFields NONE = new VirtualFields(EnumSet.noneOf(VirtualFieldPartition.class));
        public static final VirtualFields ALL = new VirtualFields(EnumSet.allOf(VirtualFieldPartition.class));
        private final EnumSet<VirtualFieldPartition> set;

        private VirtualFields(VirtualFieldPartition single) {
            this(EnumSet.of(single));
        }

        private VirtualFields(EnumSet<VirtualFieldPartition> set) {
            if (set == null) {
                throw new NullPointerException("Null set");
            }
            this.set = set;
        }

        public final VirtualFields union(VirtualFields ... other) {
            Object set = this.set.clone();
            VirtualFields[] virtualFieldsArray = other;
            int n = other.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualFields o = virtualFieldsArray[n2];
                ((AbstractCollection)set).addAll(o.set);
                ++n2;
            }
            return new VirtualFields((EnumSet<VirtualFieldPartition>)set);
        }

        public final VirtualFields intersection(VirtualFields ... other) {
            Object set = this.set.clone();
            VirtualFields[] virtualFieldsArray = other;
            int n = other.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualFields o = virtualFieldsArray[n2];
                ((AbstractCollection)set).retainAll(o.set);
                ++n2;
            }
            return new VirtualFields((EnumSet<VirtualFieldPartition>)set);
        }

        public final VirtualFields difference(VirtualFields ... other) {
            Object set = this.set.clone();
            VirtualFields[] virtualFieldsArray = other;
            int n = other.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualFields o = virtualFieldsArray[n2];
                ((AbstractSet)set).removeAll(o.set);
                ++n2;
            }
            return new VirtualFields((EnumSet<VirtualFieldPartition>)set);
        }

        public final VirtualFields complement() {
            if (this == ALL) {
                return NONE;
            }
            if (this == NONE) {
                return ALL;
            }
            return new VirtualFields(EnumSet.complementOf(this.set));
        }

        public int hashCode() {
            int prime = 31;
            return 31 + this.set.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualFields other = (VirtualFields)obj;
            return this.set.equals(other.set);
        }
    }
}

