/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLSyntax;

public abstract class SQLSearchMode {
    public static final SQLSearchMode EQUALS = new SQLSearchMode(){

        @Override
        public String generateSQL(DBRoot r, String term) {
            return " = " + r.getBase().quoteString(term);
        }
    };
    public static final SQLSearchMode CONTAINS = new SQLSearchMode(){

        @Override
        public String generateSQL(DBRoot r, String term) {
            return " like " + r.getBase().quoteString("%" + SQLSyntax.get(r).getLitteralLikePattern(term) + "%");
        }
    };
    public static final SQLSearchMode STARTS_WITH = new SQLSearchMode(){

        @Override
        public String generateSQL(DBRoot r, String term) {
            return " like " + r.getBase().quoteString(String.valueOf(SQLSyntax.get(r).getLitteralLikePattern(term)) + "%");
        }
    };
    public static final SQLSearchMode ENDS_WITH = new SQLSearchMode(){

        @Override
        public String generateSQL(DBRoot r, String term) {
            return " like " + r.getBase().quoteString("%" + SQLSyntax.get(r).getLitteralLikePattern(term));
        }
    };

    public abstract String generateSQL(DBRoot var1, String var2);
}

