/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.HashSet;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;

public final class PolymorphFK {
    public static final String POLY_ID = "_ID";
    public static final String POLY_TABLE = "_TABLE";
    private final SQLTable t;
    private final String tableFName;
    private final String idFName;
    private final String name;

    public static final String tableField2propName(SQLField f) {
        String fName = f.getName();
        if (fName.endsWith(POLY_TABLE)) {
            return fName.substring(0, fName.length() - POLY_TABLE.length());
        }
        return null;
    }

    public static final Set<PolymorphFK> findPolymorphFK(SQLTable t) {
        HashSet<PolymorphFK> res = new HashSet<PolymorphFK>();
        for (SQLField f : t.getFields()) {
            String propName = PolymorphFK.tableField2propName(f);
            if (propName == null || !t.contains(String.valueOf(propName) + POLY_ID)) continue;
            res.add(new PolymorphFK(t, propName));
        }
        return res;
    }

    public PolymorphFK(SQLTable t, String propName) {
        this(t, String.valueOf(propName) + POLY_TABLE, String.valueOf(propName) + POLY_ID, propName);
    }

    public PolymorphFK(SQLTable t, String tableFName, String idFName, String name) {
        this.t = t;
        this.tableFName = tableFName;
        this.idFName = idFName;
        this.name = name;
    }

    public final SQLTable getTable() {
        return this.t;
    }

    public final SQLField getTableField() {
        return this.getTable().getField(this.tableFName);
    }

    public final SQLField getIdField() {
        return this.getTable().getField(this.idFName);
    }

    public final String getName() {
        return this.name;
    }
}

