/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.cc.HashingStrategy;
import org.openconcerto.xml.JDOMUtils;
import org.openconcerto.xml.XMLCodecUtils;

public final class Constraint {
    private final SQLTable t;
    private final String name;
    private final Map<String, Object> m;
    private String xml = null;
    private static final HashingStrategy<Constraint> INTERSYSTEM_STRATEGY = new HashingStrategy<Constraint>(){

        @Override
        public boolean equals(Constraint c1, Constraint c2) {
            return c1.getType().equals((Object)c2.getType()) && c1.getCols().equals(c2.getCols());
        }

        @Override
        public int computeHashCode(Constraint c) {
            int prime = 31;
            int result = 1;
            result = 31 * result + c.getType().hashCode();
            result = 31 * result + c.getCols().hashCode();
            return result;
        }
    };

    public static Constraint fromXML(SQLTable t, Element elem) {
        return new Constraint(t, elem.getAttributeValue("name"), (Map)XMLCodecUtils.decode1(elem.getChildren().get(0)));
    }

    private Constraint(SQLTable t, String name, Map<String, Object> row) {
        this.t = t;
        this.name = name;
        this.m = row;
    }

    Constraint(SQLTable t, Map<String, Object> row) {
        this.t = t;
        this.m = new HashMap<String, Object>(row);
        this.name = (String)this.m.remove("CONSTRAINT_NAME");
        this.m.remove("TABLE_SCHEMA");
        this.m.remove("TABLE_NAME");
    }

    Constraint(SQLTable t, Constraint c) {
        this.t = t;
        this.m = c.m;
        this.name = c.name;
    }

    public final SQLTable getTable() {
        return this.t;
    }

    public final String getName() {
        return this.name;
    }

    public final SQLSyntax.ConstraintType getType() {
        return SQLSyntax.ConstraintType.find((String)this.m.get("CONSTRAINT_TYPE"));
    }

    public final List<String> getCols() {
        return (List)this.m.get("COLUMN_NAMES");
    }

    public synchronized String toXML() {
        if (this.xml == null) {
            this.xml = "<constraint name=\"" + JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getName()) + "\" >" + XMLCodecUtils.encodeSimple(this.m) + "</constraint>";
        }
        return this.xml;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Constraint) {
            Constraint o = (Constraint)obj;
            return this.m.equals(o.m);
        }
        return false;
    }

    public int hashCode() {
        return this.m.hashCode();
    }

    public static final HashingStrategy<Constraint> getInterSystemHashStrategy() {
        return INTERSYSTEM_STRATEGY;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName() + " " + this.m;
    }
}

