/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.ArchivedGraph;
import org.openconcerto.sql.element.JoinSQLElement;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.CustomEquals;
import org.openconcerto.utils.cc.HashingStrategy;
import org.openconcerto.utils.cc.ITransformer;

public final class TreesOfSQLRows {
    private final SQLElement elem;
    private final Set<SQLRow> originalRoots;
    private Map<SQLRow, SQLRowValues> trees;
    private Set<SQLRow> mainRows;
    private Map<SQLRow, SQLRowValues> allRows;
    private LinksToCut externReferences;

    public static final TreesOfSQLRows createFromIDs(SQLElement elem, Collection<? extends Number> ids) {
        ArrayList<SQLRow> rows = new ArrayList<SQLRow>(ids.size());
        for (Number number : ids) {
            rows.add(new SQLRow(elem.getTable(), number.intValue()));
        }
        return new TreesOfSQLRows(elem, rows);
    }

    private static String createRestrictDesc(SQLElement refElem, SQLRowAccessor refVals, SQLElementLink elemLink) {
        String rowDesc = refElem != null ? refElem.getDescription(refVals.asRow()) : refVals.asRow().toString();
        String fieldS = TreesOfSQLRows.getLabel(elemLink, null);
        return TM.getTM().trM("sqlElement.linkCantBeCut", CollectionUtils.createMap("row", refVals.asRow(), "rowDesc", rowDesc, "fieldLabel", fieldS));
    }

    private static String getLabel(SQLElementLink elemLink, Path p) {
        String itemName;
        SQLTable table;
        SQLFieldTranslator translator = Configuration.getInstance().getTranslator();
        if (elemLink != null) {
            assert (p == null || elemLink.getPath().equals(p));
            table = elemLink.getPath().getFirst();
            itemName = elemLink.getName();
        } else {
            assert (p.length() == 1) : "Joins should have an Element : " + p;
            assert (p.getDirection() == Link.Direction.FOREIGN);
            SQLField singleField = p.getStep(0).getSingleField();
            table = singleField.getTable();
            itemName = singleField.getName();
        }
        String fieldLabel = translator.getDescFor(table, itemName).getLabel();
        return fieldLabel != null ? fieldLabel : itemName;
    }

    public TreesOfSQLRows(SQLElement elem, SQLRow row) {
        this(elem, Collections.singleton(row));
    }

    public TreesOfSQLRows(SQLElement elem, Collection<? extends SQLRowAccessor> rows) {
        this.elem = elem;
        this.originalRoots = new HashSet<SQLRow>();
        this.trees = null;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            this.elem.check(sQLRowAccessor);
            this.originalRoots.add(sQLRowAccessor.asRow());
        }
        this.externReferences = null;
    }

    public final SQLElement getElem() {
        return this.elem;
    }

    public final Set<SQLRow> getRows() {
        return this.originalRoots;
    }

    public final Set<SQLRow> getMainRows() {
        return this.mainRows;
    }

    public final Set<SQLRow> getAllRows() {
        return this.allRows.keySet();
    }

    public final boolean containsAll(TreesOfSQLRows o) {
        if (this == o) {
            return true;
        }
        return this.getMainRows().containsAll(o.getMainRows()) && this.getExternReferences().containsAll(o.getExternReferences());
    }

    public final boolean isFetched() {
        return this.externReferences != null;
    }

    private final void checkFetched() {
        if (!this.isFetched()) {
            throw new IllegalStateException("Not yet fetched");
        }
    }

    public final Map<SQLRow, SQLRowValues> fetch(SQLSelect.LockStrength ls) throws SQLException {
        if (this.isFetched()) {
            throw new IllegalStateException("Already fetched");
        }
        Tuple3<Map<SQLRow, SQLRowValues>, Rows, LinksToCut> expand = this.expand(ls);
        this.trees = Collections.unmodifiableMap((Map)expand.get0());
        this.mainRows = Collections.unmodifiableSet(((Rows)expand.get1()).mainRows);
        this.allRows = Collections.unmodifiableMap(((Rows)expand.get1()).vals);
        this.externReferences = expand.get2();
        if (this.hasFetchedLess()) {
            Log.get().fine("Some rows are missing : " + this.trees.keySet() + "\n" + this.getRows());
        }
        return this.getTrees();
    }

    public final boolean hasFetchedLess() {
        Set<SQLRow> rowsFetched = this.trees.keySet();
        assert (this.getRows().containsAll(rowsFetched));
        return !rowsFetched.equals(this.getRows());
    }

    public final Map<SQLRow, SQLRowValues> getTrees() {
        this.checkFetched();
        return this.trees;
    }

    public final Set<SQLRowValuesCluster> getClusters() {
        Set<SQLRowValuesCluster> res = Collections.newSetFromMap(new IdentityHashMap());
        for (SQLRowValues r : this.getTrees().values()) {
            res.add(r.getGraph());
        }
        return res;
    }

    private final Tuple3<Map<SQLRow, SQLRowValues>, Rows, LinksToCut> expand(final SQLSelect.LockStrength ls) throws SQLException {
        HashMap<Integer, SQLRowValues> valsMap = new HashMap<Integer, SQLRowValues>();
        Rows hasBeen = new Rows();
        LinksToCutMutable toCut = new LinksToCutMutable();
        HashMap<SQLRow, SQLRowValues> res = new HashMap<SQLRow, SQLRowValues>();
        final SQLRowValues privateGraph = this.getElem().getPrivateGraph(ArchivedGraph.ARCHIVE_AND_FOREIGNS, false, true);
        NextRows privates = new NextRows(hasBeen, toCut);
        final HashSet<Number> ids = new HashSet<Number>();
        for (SQLRow r : this.getRows()) {
            ids.add(r.getIDNumber());
        }
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(privateGraph);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                input.setLockStrength(ls);
                input.addLockedTable(privateGraph.getTable().getName());
                return input.andWhere(new Where(privateGraph.getTable().getKey(), ids));
            }
        });
        for (SQLRowValues newVals : fetcher.fetch()) {
            SQLRow r = newVals.asRow();
            valsMap.put(newVals.getID(), newVals);
            privates.collect(newVals);
            res.put(r, newVals);
        }
        privates.expand(ls);
        return Tuple3.create(res, hasBeen, new LinksToCut(toCut.getMap()));
    }

    private final void expand(SQLTable t, final Map<Integer, SQLRowValues> valsMap, Rows hasBeen, LinksToCutMutable toCut, boolean ignorePrivateParentRF, final SQLSelect.LockStrength ls) throws SQLException {
        if (valsMap.size() == 0) {
            return;
        }
        SQLElement elem = this.getElem().getElement(t);
        HashSet<Link> ownedLinks = new HashSet<Link>();
        for (SQLElementLink elemLink : elem.getOwnedLinks().getByPath().values()) {
            if (!elemLink.isJoin()) continue;
            ownedLinks.add(elemLink.getPath().getStep(0).getSingleLink());
        }
        HashMap<Link, SQLElementLink> links = new HashMap<Link, SQLElementLink>();
        for (SQLElementLink elemLink : elem.getLinksOwnedByOthers().getByPath().values()) {
            links.put(elemLink.getPath().getStep(-1).getSingleLink(), elemLink);
        }
        NextRows privates = new NextRows(hasBeen, toCut);
        for (Link link : t.getDBSystemRoot().getGraph().getReferentLinks(t)) {
            SQLRowValues graphToFetch;
            if (ownedLinks.contains(link)) continue;
            SQLElementLink elemLink = (SQLElementLink)links.get(link);
            if (elemLink == null) {
                throw new IllegalStateException("Referent link " + link + " missing from " + links);
            }
            Path elemPath = elemLink.getPath();
            assert (elemLink.getOwned() == elem);
            assert (elemPath.getLast() == t);
            Link foreignLink = elemPath.getStep(-1).getSingleLink();
            if (ignorePrivateParentRF && elemLink.getLinkType().equals((Object)SQLElementLink.LinkType.COMPOSITION)) continue;
            final String ffName = foreignLink.getSingleField().getName();
            SQLElement refElem = elemLink.getOwner();
            final Path pathToTableWithFK = elemPath.minusLast();
            SQLElement.ReferenceAction action = elemLink.getAction();
            if (action == null) {
                throw new IllegalStateException("Null action for " + refElem + " " + elemPath);
            }
            if (action == SQLElement.ReferenceAction.CASCADE) {
                if (refElem.isPrivate()) {
                    throw new UnsupportedOperationException("Cannot cascade to private element " + refElem + " from " + elemPath);
                }
                graphToFetch = refElem.getPrivateGraph(ArchivedGraph.ARCHIVE_AND_FOREIGNS, false, true);
            } else {
                graphToFetch = new SQLRowValues(pathToTableWithFK.getFirst());
            }
            graphToFetch.assurePath(pathToTableWithFK).putNulls(foreignLink.getCols());
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(graphToFetch);
            fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    input.setLockStrength(ls);
                    input.addLockedTable(graphToFetch.getTable().getName());
                    return input;
                }
            });
            ListMap<Path, SQLRowValuesListFetcher> fetchers = fetcher.getFetchers(pathToTableWithFK);
            if (fetchers.allValues().size() != 1) {
                throw new IllegalStateException("Fetcher which references " + t + " not found : " + fetchers);
            }
            ((SQLRowValuesListFetcher)fetchers.allValues().iterator().next()).appendSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    FieldRef refField = input.getAlias(pathToTableWithFK.getLast()).getField(ffName);
                    return input.andWhere(new Where(refField, valsMap.keySet()));
                }
            });
            for (SQLRowValues newVals : fetcher.fetch()) {
                SQLRow r = newVals.asRow();
                boolean already = hasBeen.contains(r);
                Collection<SQLRowValues> rowsWithFK = newVals.followPath(pathToTableWithFK, SQLRowValues.CreateMode.CREATE_NONE, false);
                switch (action) {
                    case RESTRICT: {
                        throw new SQLException(TreesOfSQLRows.createRestrictDesc(refElem, newVals, elemLink));
                    }
                    case CASCADE: {
                        if (already) break;
                        privates.collect(newVals);
                        for (SQLRowValues rowWithFK : rowsWithFK) {
                            rowWithFK.putForeign(foreignLink, hasBeen.getValues(rowWithFK.getForeign(foreignLink).asRow()));
                        }
                        break;
                    }
                    case SET_EMPTY: {
                        if (already) break;
                        toCut.add(elemLink, rowsWithFK);
                    }
                }
                if (!already) continue;
                for (SQLRowValues joinRow : rowsWithFK) {
                    boolean linked = hasBeen.tryToLink(joinRow, foreignLink);
                    if (linked) continue;
                    throw new IllegalStateException("Join row not found : " + joinRow);
                }
            }
        }
        privates.expand(ls);
    }

    public final Map<SQLTable, List<SQLRowAccessor>> getDescendantsByTable() {
        ListMap<SQLTable, SQLRowAccessor> res = new ListMap<SQLTable, SQLRowAccessor>();
        Set<SQLRow> roots = this.getRows();
        for (SQLRowValuesCluster c : this.getClusters()) {
            for (SQLRowValues v : c.getItems()) {
                SQLRow r = v.asRow();
                if (roots.contains(r) || !this.getMainRows().contains(r)) continue;
                res.add(v.getTable(), v);
            }
        }
        return res;
    }

    public final LinksToCut getExternReferences() {
        this.checkFetched();
        return this.externReferences;
    }

    static final class LinkToCut
    implements Comparable<LinkToCut> {
        private final SQLElementLink link;
        private final String label;

        protected LinkToCut(SQLElementLink link) {
            if (link == null) {
                throw new NullPointerException("Null link");
            }
            this.link = link;
            this.label = TreesOfSQLRows.getLabel(this.link, null);
        }

        public final Path getPath() {
            return this.link.getPath();
        }

        public final SQLTable getTable() {
            return this.getPath().getFirst();
        }

        public final String getItem() {
            return this.link.getName();
        }

        public final String getLabel() {
            return this.label;
        }

        public int hashCode() {
            int prime = 31;
            return 31 + this.link.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LinkToCut other = (LinkToCut)obj;
            return this.link.equals(other.link);
        }

        @Override
        public int compareTo(LinkToCut o) {
            int compareTable = CompareUtils.compareList(this.getTable().getSQLName().asList(), o.getTable().getSQLName().asList());
            if (compareTable != 0) {
                return compareTable;
            }
            return this.getItem().compareTo(o.getItem());
        }
    }

    public static final class LinksToCut {
        private final CollectionMap2Itf.ListMapItf<SQLElementLink, SQLRowValues> toCut;

        private LinksToCut(CollectionMap2Itf.ListMapItf<SQLElementLink, SQLRowValues> map) {
            map.removeAllEmptyCollections();
            this.toCut = ListMap.unmodifiableMap(map);
        }

        public final CollectionMap2Itf.ListMapItf<SQLElementLink, SQLRowValues> getMap() {
            return this.toCut;
        }

        public final SortedMap<LinkToCut, Integer> countByLink() {
            TreeMap<LinkToCut, Integer> res = new TreeMap<LinkToCut, Integer>();
            for (Map.Entry e : this.getMap().entrySet()) {
                SQLElementLink elemLink = (SQLElementLink)e.getKey();
                res.put(new LinkToCut(elemLink), ((List)e.getValue()).size());
            }
            return res;
        }

        boolean containsAll(LinksToCut o) {
            if (this == o) {
                return true;
            }
            if (!this.getMap().keySet().containsAll(o.getMap().keySet())) {
                return false;
            }
            HashingStrategy<SQLRowAccessor> strategy = SQLRowAccessor.getRowStrategy();
            for (Map.Entry e : this.getMap().entrySet()) {
                List otherRows = (List)o.getMap().get(e.getKey());
                if (otherRows == null) continue;
                Set thisVals = CustomEquals.createSet(strategy, (Collection)e.getValue());
                Set otherVals = CustomEquals.createSet(strategy, otherRows);
                assert (thisVals.size() == ((Collection)e.getValue()).size() && otherVals.size() == ((List)o.getMap().get(e.getKey())).size()) : "There were duplicates";
                if (thisVals.containsAll(otherVals)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class LinksToCutMutable {
        private final ListMap<SQLElementLink, SQLRowValues> toCut = new ListMap(32, CollectionMap2.Mode.NULL_FORBIDDEN, (Boolean)false);

        private LinksToCutMutable() {
        }

        private void add(SQLElementLink link, Collection<SQLRowValues> rowsWithFK) {
            assert (!this.toCut.containsKey(link) || !CollectionUtils.containsAny((Collection)this.toCut.get(link), rowsWithFK)) : "some rows (and their optional joins) already added : " + link + " " + rowsWithFK;
            this.toCut.addAll(link, rowsWithFK);
        }

        private final ListMap<SQLElementLink, SQLRowValues> getMap() {
            return this.toCut;
        }

        private final void restoreLinks(Rows hasBeen) {
            Iterator iter = this.getMap().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                SQLElementLink elemLink = (SQLElementLink)e.getKey();
                Link linkToCut = elemLink.getPath().getStep(-1).getSingleLink();
                Iterator iter2 = ((List)e.getValue()).iterator();
                while (iter2.hasNext()) {
                    SQLRowValues rowWithFK = (SQLRowValues)iter2.next();
                    if (!hasBeen.tryToLink(rowWithFK, linkToCut)) continue;
                    iter2.remove();
                }
                if (!((List)e.getValue()).isEmpty()) continue;
                iter.remove();
            }
        }
    }

    private final class NextRows {
        private final Rows hasBeen;
        private final LinksToCutMutable toCut;
        private final Map<SQLTable, Map<Integer, SQLRowValues>> mainRows;
        private final Map<SQLTable, Map<Integer, SQLRowValues>> privateRows;

        public NextRows(Rows hasBeen, LinksToCutMutable toCut) {
            this.hasBeen = hasBeen;
            this.toCut = toCut;
            this.mainRows = new HashMap<SQLTable, Map<Integer, SQLRowValues>>();
            this.privateRows = new HashMap<SQLTable, Map<Integer, SQLRowValues>>();
        }

        private void collect(SQLRowValues mainRow) {
            for (SQLRowValues privateVals : mainRow.getGraph().getItems()) {
                Map<SQLTable, Map<Integer, SQLRowValues>> m;
                boolean isMainRow;
                assert (!this.hasBeen.contains(privateVals.asRow()));
                SQLElement rowElem = TreesOfSQLRows.this.getElem().getElement(privateVals.getTable());
                boolean bl = isMainRow = privateVals == mainRow;
                if (isMainRow) {
                    assert (!(rowElem instanceof JoinSQLElement));
                    m = this.mainRows;
                } else if (rowElem.isPrivate()) {
                    m = this.privateRows;
                } else {
                    assert (rowElem instanceof JoinSQLElement);
                    m = null;
                }
                this.hasBeen.put(privateVals.asRow(), privateVals, isMainRow);
                if (m == null) continue;
                Map<Integer, SQLRowValues> map = m.get(privateVals.getTable());
                if (map == null) {
                    map = new HashMap<Integer, SQLRowValues>();
                    m.put(privateVals.getTable(), map);
                }
                map.put(privateVals.getID(), privateVals);
            }
        }

        private void expand(SQLSelect.LockStrength ls) throws SQLException {
            this.expand(this.mainRows, false, ls);
            this.expand(this.privateRows, true, ls);
            this.toCut.restoreLinks(this.hasBeen);
        }

        private void expand(Map<SQLTable, Map<Integer, SQLRowValues>> m, boolean privateRows, SQLSelect.LockStrength ls) throws SQLException {
            for (Map.Entry<SQLTable, Map<Integer, SQLRowValues>> e : m.entrySet()) {
                TreesOfSQLRows.this.expand(e.getKey(), e.getValue(), this.hasBeen, this.toCut, privateRows, ls);
            }
        }
    }

    private static final class Rows {
        private final Map<SQLRow, SQLRowValues> vals = new HashMap<SQLRow, SQLRowValues>();
        private final Set<SQLRow> mainRows = new HashSet<SQLRow>();

        private Rows() {
        }

        private boolean contains(SQLRow r) {
            return this.vals.containsKey(r);
        }

        private SQLRowValues getValues(SQLRow r) {
            return this.vals.get(r);
        }

        private void put(SQLRow r, SQLRowValues newVals, boolean isMainRow) {
            assert (newVals.asRow().equals(r));
            if (this.vals.put(r, newVals) != null) {
                throw new IllegalStateException("Row already in : " + newVals);
            }
            if (isMainRow) {
                this.mainRows.add(r);
            }
        }

        private boolean tryToLink(SQLRowValues rowWithFK, Link l) {
            boolean linked;
            SQLRowValues inGraphRow = this.getValues(rowWithFK.asRow());
            boolean bl = linked = inGraphRow != null;
            if (linked) {
                SQLRowValues dest = this.getValues(rowWithFK.getForeign(l).asRow());
                if (dest == null) {
                    throw new IllegalStateException("destination of " + l + " not found for " + rowWithFK);
                }
                inGraphRow.putForeign(l, dest);
            }
            return linked;
        }
    }
}

