/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElementNamesMap;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.VariantKey;
import org.openconcerto.xml.JDOM2Utils;

public class SQLElementNamesFromXML
extends SQLElementNamesMap.ByCode {
    public static final Pattern SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");

    public SQLElementNamesFromXML(Locale locale) {
        super(locale);
    }

    public final void load(InputStream ins) throws JDOMException, IOException {
        Grammar gr = Grammar.getInstance(this.getLocale());
        Document doc = new SAXBuilder().build(ins);
        for (Element elem : doc.getRootElement().getChildren("element")) {
            this.load(gr, elem);
        }
    }

    public final Map.Entry<String, Phrase> createPhrase(Element elem) throws IOException {
        return this.createPhrase(Grammar.getInstance(this.getLocale()), elem);
    }

    private Map.Entry<String, Phrase> createPhrase(Grammar gr, Element elem) throws IOException {
        String base;
        String refid = elem.getAttributeValue("refid");
        if (refid == null) {
            throw new IOException("No refid attribute");
        }
        Element nameElem = elem.getChild("name");
        boolean hasChild = nameElem != null;
        String nameAttr = elem.getAttributeValue("name");
        if (!hasChild && nameAttr == null) {
            Log.get().warning("No name for code : " + refid);
            return null;
        }
        if (hasChild && nameAttr != null) {
            Log.get().warning("Ignoring attribute : " + nameAttr);
        }
        String string = base = hasChild ? nameElem.getAttributeValue("base") : nameAttr;
        if (base == null) {
            throw new IOException("No base for the name of " + refid);
        }
        String nounClassName = hasChild ? nameElem.getAttributeValue("nounClass") : elem.getAttributeValue("nameClass");
        NounClass nounClass = nounClassName == null ? null : gr.getNounClass(nounClassName);
        Phrase res = new Phrase(gr, base, nounClass);
        if (!hasChild) {
            String plural = elem.getAttributeValue("namePlural");
            if (plural != null) {
                res.putVariant(Grammar.PLURAL, plural);
            }
        } else {
            for (Element variantElem : nameElem.getChildren("variant")) {
                String value = variantElem.getAttributeValue("value");
                if (value == null) {
                    this.warning(refid, variantElem, "No value");
                    continue;
                }
                String variantIDs = variantElem.getAttributeValue("refids");
                String variantPattern = variantElem.getAttributeValue("idPattern");
                if (variantIDs == null && variantPattern == null) {
                    this.warning(refid, variantElem, "No ID");
                    continue;
                }
                if (variantIDs != null) {
                    if (variantPattern != null) {
                        this.warning(refid, variantElem, "Ignorig pattern " + variantPattern);
                    }
                    String[] stringArray = SPLIT_PATTERN.split(variantIDs);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String variantID = stringArray[n2];
                        VariantKey variantKey = gr.getVariantKey(variantID);
                        if (variantKey == null) {
                            this.warning(refid, variantElem, "Ignorig " + variantID);
                        } else {
                            res.putVariant(variantKey, value);
                        }
                        ++n2;
                    }
                    continue;
                }
                assert (variantIDs == null && variantPattern != null);
                Pattern p = Pattern.compile(variantPattern);
                for (VariantKey vk : gr.getVariantKeys()) {
                    if (!p.matcher(vk.getID()).matches()) continue;
                    res.putVariant(vk, value);
                }
            }
        }
        return new AbstractMap.SimpleEntry<String, Phrase>(refid, res);
    }

    private void load(Grammar gr, Element elem) throws IOException {
        Map.Entry<String, Phrase> entry = this.createPhrase(gr, elem);
        if (entry != null) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private void warning(String refid, Element variantElem, String msg) {
        Log.get().warning(String.valueOf(msg) + " for variant of " + refid + " : " + JDOM2Utils.output(variantElem));
    }
}

