/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.PolymorphFK;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;

public abstract class RowBacked {
    private final SQLRowAccessor r;
    private final Map<String, PropExtractor> propExtractors;
    private final Map<String, Object> values;

    public RowBacked(SQLRowAccessor r) {
        this.r = r;
        this.propExtractors = new HashMap<String, PropExtractor>();
        this.values = new HashMap<String, Object>();
        for (PolymorphFK f : PolymorphFK.findPolymorphFK(this.getTable())) {
            this.addPolymorphFK(f);
        }
    }

    public final Object get(String propName) {
        Object res;
        if (this.values.containsKey(propName)) {
            return this.values.get(propName);
        }
        if (this.propExtractors.containsKey(propName)) {
            res = this.propExtractors.get(propName).extract(this.getRow());
        } else {
            SQLRowAccessor foreign;
            Object modelObj;
            if (!this.getTable().contains(propName)) {
                throw new IllegalArgumentException(String.valueOf(propName) + " is neither a property of " + this + " nor a field of " + this.getTable());
            }
            res = this.getTable().getForeignKeys().contains(this.getTable().getField(propName)) ? (this.getRow().isForeignEmpty(propName) ? null : ((modelObj = RowBacked.getModelObject(foreign = this.getRow().getForeign(propName))) != null ? modelObj : foreign)) : this.getRow().getObject(propName);
        }
        this.values.put(propName, res);
        return res;
    }

    protected final void putExtractor(String name, PropExtractor extr) {
        this.propExtractors.put(name, extr);
    }

    protected final void addPolymorphFK(String name) {
        this.addPolymorphFK(new PolymorphFK(this.getTable(), name));
    }

    protected final void addPolymorphFK(final PolymorphFK fk) {
        this.putExtractor(fk.getName(), new PropExtractor(){

            @Override
            public Object extract(SQLRowAccessor r) {
                SQLTable foreignT;
                String tableName = r.getString(fk.getTableField().getName());
                SQLTable sQLTable = foreignT = tableName == null ? null : r.getTable().getBase().getTable(tableName);
                if (foreignT == null) {
                    return null;
                }
                int foreignID = r.getInt(fk.getIdField().getName());
                SQLRow foreignR = foreignT.getRow(foreignID);
                if (foreignR == null) {
                    throw new IllegalStateException("incoherent base, fk " + fk + " of " + r);
                }
                return foreignT.getRow(foreignID).getModelObject();
            }
        });
    }

    public final SQLTable getTable() {
        return this.getRow().getTable();
    }

    public final SQLBase getBase() {
        return this.getTable().getBase();
    }

    protected final SQLRowAccessor getRow() {
        return this.r;
    }

    public final SQLRow getSQLRow() {
        return this.getRow().asRow();
    }

    public final int getID() {
        return this.getRow().getID();
    }

    public RowBacked getParent() {
        SQLRowAccessor parent = this.getRow().getForeign(this.getElement().getParentForeignFieldName());
        return (RowBacked)RowBacked.getModelObject(parent);
    }

    private final SQLElement getElement() {
        return RowBacked.getElement(this.getTable());
    }

    private static final SQLElement getElement(SQLTable t) {
        return Configuration.getInstance().getDirectory().getElement(t);
    }

    private static Object getModelObject(SQLRowAccessor r) {
        return RowBacked.getElement(r.getTable()).getModelObject(r);
    }

    protected static abstract class PropExtractor
    implements Transformer {
        protected PropExtractor() {
        }

        @Override
        public final Object transform(Object input) {
            return this.extract((SQLRowAccessor)input);
        }

        public abstract Object extract(SQLRowAccessor var1);
    }
}

