/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.DefaultElementSQLObject;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.RIVPanel;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLComponentItem;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFieldsSet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.request.MutableRowItemView;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.request.RowNotFound;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.request.SQLForeignRowItemView;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.request.SQLRowView;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLSearchableTextCombo;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.sqlobject.itemview.SimpleRowItemView;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.DisplayabilityListener;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.component.text.TextBehaviour;
import org.openconcerto.ui.component.text.TextComponentUtils;
import org.openconcerto.ui.coreanimation.Animator;
import org.openconcerto.ui.valuewrapper.BooleanValueWrapper;
import org.openconcerto.ui.valuewrapper.ValidatedValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapperFactory;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.Transformer;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public abstract class BaseSQLComponent
extends SQLComponent
implements Scrollable,
RIVPanel {
    protected static final String REQ = "required";
    protected static final String DEC = "notdecorated";
    protected static final String SEP = "noseparator";
    private final SQLRowView requete;
    private final Map<String, Boolean> allowEditable;
    private final Set<SQLRowItemView> required;
    private final Set<String> requiredNames;
    private final List<ValidListener> listeners;
    private InteractionMode editable;
    private boolean alwaysEditable;
    private final Set<SQLField> hide;
    private FormLayouter additionalFieldsPanel;
    private boolean displayFieldName;

    public BaseSQLComponent(SQLElement element) {
        super(element);
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BaseSQLComponent.this.requestFocusInWindow();
            }
        });
        this.required = new HashSet<SQLRowItemView>();
        this.requiredNames = this.createRequiredNames();
        this.listeners = new ArrayList<ValidListener>();
        this.hide = new HashSet<SQLField>();
        this.editable = InteractionMode.READ_WRITE;
        this.setNonExistantEditable(false);
        this.requete = new SQLRowView(this.getElement());
        this.requete.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BaseSQLComponent.this.updateChildrenEditable();
                BaseSQLComponent.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }, "readOnlySelection");
        this.allowEditable = new HashMap<String, Boolean>();
        this.displayFieldName = false;
    }

    private final SQLRowView getRequest() {
        return this.requete;
    }

    protected final SQLField getField(String field) {
        return this.getTable().getField(field);
    }

    public Component addView(String field) {
        return this.addView(field, null);
    }

    public Component addView(String field, String spec) {
        return this.addViewJComponent(field, spec);
    }

    private Component addViewJComponent(String field, Object spec) {
        if (this.getElement().getPrivateElement(field) != null) {
            SQLComponent comp = this.getElement().getPrivateElement(field).createDefaultComponent();
            SpecParser parser = SpecParser.create(spec);
            DefaultElementSQLObject dobj = new DefaultElementSQLObject(this, comp);
            dobj.setDecorated(parser.isDecorated());
            dobj.showSeparator(parser.showSeparator());
            return this.addView(dobj, field, (Object)parser);
        }
        return this.addView(BaseSQLComponent.createRowItemView(this.getComp(field, Object.class)), field, spec);
    }

    private static <T, U> ValueWrapper<? extends T> castVW(ValueWrapper<? extends U> vw, Class<U> vwType, Class<T> wantedType) {
        if (wantedType.isAssignableFrom(vwType)) {
            return vw;
        }
        throw new IllegalArgumentException("Value wrapper isn't of the wanted type");
    }

    private <T> ValueWrapper<? extends T> getComp(String field, Class<T> wantedType) {
        ValueWrapper<T> comp;
        if (this.getElement().getPrivateElement(field) != null) {
            throw new IllegalArgumentException("Private fields not supported");
        }
        SQLType type = this.getField(field).getType();
        if (this.getField(field).isKey()) {
            comp = BaseSQLComponent.createSubValueWrapper(new ElementComboBox(), type, wantedType);
        } else if (Boolean.class.isAssignableFrom(type.getJavaType())) {
            final JCheckBox cb = new JCheckBox(" ");
            cb.setOpaque(false);
            JPanel panel = new JPanel(new BorderLayout()){

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    cb.setEnabled(enabled);
                }
            };
            panel.add((Component)cb, "Before");
            comp = BaseSQLComponent.addValidatedValueWrapper(BaseSQLComponent.castVW(new BooleanValueWrapper(panel, cb), Boolean.class, wantedType), type);
        } else {
            comp = Date.class.isAssignableFrom(type.getJavaType()) ? BaseSQLComponent.createSubValueWrapper(new JDate(), type, wantedType) : (String.class.isAssignableFrom(type.getJavaType()) && type.getSize() >= 512 ? BaseSQLComponent.createSubValueWrapper(new SQLSearchableTextCombo(ComboLockedMode.UNLOCKED, true), type, wantedType) : BaseSQLComponent.createSubValueWrapper(new SQLTextCombo(), type, wantedType));
        }
        comp.getComp().setOpaque(false);
        return comp;
    }

    public final void addSQLObject(JComponent obj, String field) {
        this.addSQLObject(obj, field, null);
    }

    public Component addSQLObject(JComponent obj, String field, Object spec) {
        return this.addView(obj, field, spec);
    }

    public void addRequiredSQLObject(JComponent obj, String field, Object spec) {
        this.addSQLObject(obj, field, "required;" + spec);
    }

    public void addRequiredSQLObject(JComponent obj, String field) {
        this.addSQLObject(obj, field, REQ);
    }

    public Component addView(JComponent comp, String fields) {
        return this.addView(comp, fields, null);
    }

    public Component addView(JComponent comp, String fields, Object specObj) {
        SimpleRowItemView<?> rowItemView;
        if (comp instanceof MutableRowItemView) {
            rowItemView = (SimpleRowItemView<?>)((Object)comp);
        } else {
            SQLField field = this.getField(SQLRow.toList(fields).get(0));
            rowItemView = BaseSQLComponent.createRowItemView(comp, field);
        }
        return this.addView(rowItemView, fields, specObj);
    }

    public static SimpleRowItemView<?> createRowItemView(JComponent comp, SQLField field) {
        if (comp == null) {
            throw new NullPointerException("comp for " + field + " is null");
        }
        if (comp instanceof MutableRowItemView) {
            throw new IllegalStateException("Comp is a MutableRowItemView, creating a SimpleRowItemView would ignore its methods : " + comp);
        }
        return BaseSQLComponent.createRowItemView(BaseSQLComponent.createSubValueWrapper(comp, field.getType(), Object.class));
    }

    private static <T> SimpleRowItemView<T> createRowItemView(ValueWrapper<T> vw) {
        if (vw instanceof MutableRowItemView) {
            throw new IllegalStateException("Comp is a MutableRowItemView, creating a SimpleRowItemView would ignore its methods : " + vw);
        }
        return new SimpleRowItemView<T>(vw);
    }

    public static final <T> ValueWrapper<T> createValueWrapper(JComponent comp, SQLType type, Class<T> wantedType) {
        if (!wantedType.equals(type.getJavaType())) {
            throw new ClassCastException("wanted type " + wantedType + " is not " + type);
        }
        ValueWrapper<T> res = ValueWrapperFactory.create(comp, wantedType);
        return BaseSQLComponent.addValidatedValueWrapper(res, type);
    }

    public static final <T> ValueWrapper<? extends T> createSubValueWrapper(JComponent comp, SQLType type, Class<T> wantedSuperType) {
        Class<?> fieldClass = type.getJavaType();
        ValueWrapper<T> res = ValueWrapperFactory.create(comp, fieldClass.asSubclass(wantedSuperType));
        return BaseSQLComponent.addValidatedValueWrapper(res, type);
    }

    private static <T> ValueWrapper<T> addValidatedValueWrapper(ValueWrapper<T> res, final SQLType type) {
        Class<?> fieldClass = type.getJavaType();
        if (String.class.isAssignableFrom(fieldClass)) {
            res = ValidatedValueWrapper.add(res, new ITransformer<T, ValidState>(){

                @Override
                public ValidState transformChecked(T t) {
                    String s = (String)t;
                    boolean ok = s == null || s.length() <= type.getSize();
                    return ok ? ValidState.getTrueInstance() : ValidState.create(ok, TM.tr("sqlComp.stringValueTooLong", s.length() - type.getSize()));
                }
            });
        } else if (BigDecimal.class.isAssignableFrom(fieldClass)) {
            final Integer decimalDigits = type.getDecimalDigits();
            final int intDigits = type.getSize() - decimalDigits;
            final String reason = TM.tr("sqlComp.bdTooHigh", intDigits, decimalDigits);
            res = ValidatedValueWrapper.add(res, new ITransformer<T, ValidState>(){

                @Override
                public ValidState transformChecked(T t) {
                    BigDecimal bd = (BigDecimal)t;
                    return ValidState.create(bd == null || DecimalUtils.intDigits(DecimalUtils.round(bd, decimalDigits)) <= intDigits, reason);
                }
            });
        }
        return res;
    }

    public final <T> SimpleRowItemView<? extends T> createSimpleRowItemView(String fields, Class<T> clazz) {
        return this.createSimpleRowItemView(fields, clazz, Transformer.nopTransformer());
    }

    public final <T> SimpleRowItemView<? extends T> createSimpleRowItemView(String field, Class<T> clazz, ITransformer<? super ValueWrapper<? extends T>, ValueWrapper<? extends T>> init) {
        ValueWrapper<T> vw = this.getComp(field, clazz);
        if (vw instanceof MutableRowItemView) {
            throw new IllegalStateException("Comp is a MutableRowItemView, creating a SimpleRowItemView would ignore its methods : " + vw);
        }
        return this.initRIV(BaseSQLComponent.createRowItemView(init.transformChecked(vw)), field);
    }

    public Component addView(MutableRowItemView rowItemView, String fields, Object specObj) {
        return this.addInitedView(this.initRIV(rowItemView, fields), specObj);
    }

    private final <R extends MutableRowItemView> R initRIV(R rowItemView, String fields) {
        List<String> fieldListS = SQLRow.toList(fields);
        LinkedHashSet<SQLField> fieldList = new LinkedHashSet<SQLField>(fieldListS.size());
        for (String fieldName : fieldListS) {
            fieldList.add(this.getField(fieldName));
        }
        String sqlName = fields;
        rowItemView.init(sqlName, fieldList);
        return rowItemView;
    }

    public Component addInitedView(SQLRowItemView v, Object specObj) {
        JTextComponent textComp;
        SpecParser spec = SpecParser.create(specObj);
        Set<String> reqNames = this.getRequiredNames();
        if (spec.isRequired() || v.getFields().contains(this.getElement().getParentForeignField()) || reqNames == null || reqNames.contains(v.getSQLName())) {
            this.required.add(v);
            if (v instanceof ElementSQLObject) {
                ((ElementSQLObject)v).setRequired(true);
            }
            if (reqNames != null) {
                this.requiredNames.add(v.getSQLName());
            }
        }
        this.getRequest().add(v);
        if (v instanceof SQLComponentItem) {
            ((SQLComponentItem)((Object)v)).added(this, v);
        }
        if (v.getComp() instanceof SQLComponentItem) {
            ((SQLComponentItem)((Object)v.getComp())).added(this, v);
        }
        v.resetValue();
        if (!CollectionUtils.containsAny(this.hide, v.getFields())) {
            if (spec.isAdditional()) {
                if (this.additionalFieldsPanel == null) {
                    Log.get().warning("No additionalFieldsPanel for " + v.getFields() + " : " + v);
                } else {
                    this.additionalFieldsPanel.add(this.getDesc(v), v.getComp());
                }
            } else {
                this.addToUI(v, spec.getWhere());
            }
        }
        if ((textComp = TextComponentUtils.getTextComp(v.getComp())) != null) {
            TextBehaviour.manage(textComp);
        }
        return v.getComp();
    }

    private boolean dontEdit(SQLRowItemView v) {
        Set<String> fieldsNames = new SQLFieldsSet(v.getFields()).getFieldsNames(this.getTable());
        return this.getMode() == SQLComponent.Mode.READ_ONLY || CollectionUtils.containsAny(this.getElement().getReadOnlyFields(), fieldsNames) || this.getMode() != SQLComponent.Mode.INSERTION && CollectionUtils.containsAny(this.getElement().getInsertOnlyFields(), fieldsNames);
    }

    @Override
    protected final void inited() {
        super.inited();
        if (!(this instanceof GroupSQLComponent)) {
            for (Map.Entry entry : this.getElement().getAdditionalFields().entrySet()) {
                SpecParser spec = new SpecParser(null, true);
                JComponent comp = (JComponent)entry.getValue();
                if (comp == null) {
                    this.addViewJComponent((String)entry.getKey(), spec);
                    continue;
                }
                this.addView(comp, (String)entry.getKey(), (Object)spec);
            }
        }
        this.updateChildrenEditable();
        for (SQLRowItemView sQLRowItemView : this.getRequest().getViews()) {
            sQLRowItemView.addEmptyListener(new EmptyListener(){

                @Override
                public void emptyChange(EmptyObj src, boolean newValue) {
                    BaseSQLComponent.this.emptyOrValidChanged((SQLRowItemView)src);
                }
            });
            sQLRowItemView.addValidListener(new ValidListener(){

                @Override
                public void validChange(ValidObject src, ValidState newValue) {
                    BaseSQLComponent.this.emptyOrValidChanged((SQLRowItemView)src);
                }
            });
            this.updateAnimate(sQLRowItemView);
        }
        this.addHierarchyListener(new DisplayabilityListener(){

            @Override
            protected void displayabilityChanged(Component c) {
                BaseSQLComponent.this.getRequest().activate(c.isDisplayable());
            }
        });
        this.getRequest().activate(this.isDisplayable());
        this.fireValidChange();
        this.initDone();
    }

    protected void initDone() {
    }

    private void updateAnimate(SQLRowItemView v) {
        if (v.getComp() != null) {
            Animator.getInstance().animate(v.getComp(), !this.isItemViewValid(v));
        }
    }

    protected void emptyOrValidChanged(SQLRowItemView v) {
        this.fireValidChange();
        this.updateAnimate(v);
    }

    protected void addToUI(SQLRowItemView v, String where) {
    }

    protected final void setAdditionalFieldsPanel(FormLayouter panel) {
        this.additionalFieldsPanel = panel;
    }

    public final void setViewsOrder(Collection<String> names) {
        this.getRequest().setViewsOrder(names);
    }

    public final SQLRowItemView getView(String name) {
        return this.getRequest().getView(name);
    }

    protected final SQLRowItemView getView(Component comp) {
        return this.getRequest().getView(comp);
    }

    public final Map<String, SQLRowItemView> getViews() {
        return this.getRequest().getViewsMap();
    }

    public final List<SQLRowItemView> getViews(Set<SQLField> fields) {
        ArrayList<SQLRowItemView> res = new ArrayList<SQLRowItemView>();
        for (SQLRowItemView v : this.getRequest().getViews()) {
            if (Collections.disjoint(fields, v.getFields())) continue;
            res.add(v);
        }
        return res;
    }

    protected final SQLForeignRowItemView getForeignView(SQLRowItemView v) {
        if (v instanceof SQLForeignRowItemView) {
            return (SQLForeignRowItemView)((Object)v);
        }
        if (v.getComp() instanceof SQLForeignRowItemView) {
            return (SQLForeignRowItemView)((Object)v.getComp());
        }
        throw new IllegalArgumentException("no SQLForeignRowItemView found for " + v);
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.listeners.remove(l);
    }

    protected final synchronized void fireValidChange() {
        ValidState validated = this.getValidState();
        for (ValidListener l : this.listeners) {
            l.validChange(this, validated);
        }
    }

    private boolean isItemViewValid(SQLRowItemView v) {
        return v.getValidState().isValid() && (!this.getRequired().contains(v) || !v.isEmpty());
    }

    @Override
    public synchronized ValidState getValidState() {
        boolean res = true;
        ArrayList<String> pbs = new ArrayList<String>();
        for (SQLRowItemView obj : this.getRequest().getViews()) {
            ValidState state = obj.getValidState();
            if (!state.isValid()) {
                String txt = state.getValidationText();
                String explanation = TM.tr("sqlComp.invalidItem", "'" + this.getDesc(obj) + "'", txt != null ? 1 : 0, txt);
                pbs.add(explanation);
                res = false;
                continue;
            }
            if (!this.getRequired().contains(obj) || !obj.isEmpty()) continue;
            pbs.add(TM.tr("sqlComp.emptyItem", "'" + this.getDesc(obj) + "'"));
            res = false;
        }
        return ValidState.create(res, CollectionUtils.join(pbs, "\n"));
    }

    protected final String getDesc(SQLRowItemView obj) {
        return this.getLabelFor(obj.getSQLName());
    }

    public final String getLabelFor(String itemName) {
        return this.getDesc(itemName, this.getRIVDesc(itemName)).get0();
    }

    protected final Tuple2<String, Boolean> getDesc(String itemName, RowItemDesc desc) {
        boolean emptyLabel;
        boolean bl = emptyLabel = desc.getLabel() == null || desc.getLabel().trim().length() == 0;
        String l = emptyLabel ? itemName : String.valueOf(this.getLabel(itemName, desc)) + (this.displayFieldName ? " [" + itemName + "]" : "");
        return Tuple2.create(l, !emptyLabel);
    }

    protected final void toggleDisplayFieldsNames() {
        this.displayFieldName = !this.displayFieldName;
        this.updateUIAll();
    }

    protected String getLabel(String itemName, RowItemDesc desc) {
        return desc.getLabel();
    }

    @Override
    public final boolean setEditable(InteractionMode mode) {
        boolean changed;
        boolean bl = changed = mode != this.editable;
        if (changed) {
            this.editable = mode;
            this.interactionModeChanged(mode);
        }
        return changed;
    }

    protected void interactionModeChanged(InteractionMode mode) {
        this.updateChildrenEditable();
    }

    private final void updateChildrenEditable() {
        for (SQLRowItemView o : this.getRequest().getViews()) {
            this.updateEditable(o);
        }
    }

    public final InteractionMode getEditable() {
        return this.editable;
    }

    public void allowEditable(String name, boolean b) {
        SQLRowItemView view = this.getView(name);
        if (view == null) {
            throw new IllegalArgumentException("No view named " + name);
        }
        this.allowEditable(view, b);
    }

    public void allowEditable(SQLRowItemView view, boolean b) {
        if (view == null) {
            throw new NullPointerException();
        }
        this.allowEditable.put(view.getSQLName(), b);
        this.updateEditable(view);
    }

    @Override
    protected void modeChanged() {
        super.modeChanged();
        this.updateChildrenEditable();
    }

    private void updateEditable(SQLRowItemView o) {
        InteractionMode mode;
        if (this.getEditable() != InteractionMode.READ_WRITE) {
            mode = this.getEditable();
        } else {
            boolean editable = !this.dontEdit(o) && !this.isSelectionReadOnly() && (this.isNonExistantEditable() || this.getSelectedID() != -1) && this.allowEditable.get(o.getSQLName()) != Boolean.FALSE;
            mode = editable ? InteractionMode.READ_WRITE : InteractionMode.READ_ONLY;
        }
        o.setEditable(mode);
    }

    @Override
    public final void resetValue() {
        this.select(null);
    }

    public final void partialReset() {
        Set<String> names = this.getPartialResetNames();
        if (names == null || names.size() > 0) {
            this.select(null, names);
        }
    }

    @Override
    public final int insert() {
        return this.insert(null);
    }

    @Override
    public int insert(SQLRow order) {
        try {
            if (!UserRightsManager.getCurrentUserRights().canAdd(this.getTable())) {
                throw new SQLException("forbidden");
            }
            if (order == null) {
                return this.getRequest().insert().getID();
            }
            return this.getRequest().insert(order).getID();
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, TM.tr("sqlComp.insertError", new Object[0]), e);
            return -1;
        }
    }

    @Override
    public final SQLRowValues getLastKnownDBVals() {
        return this.getRequest().getLastKnownDBVals();
    }

    @Override
    public final boolean updateLastKnownDBVals(SQLSelect.LockStrength ls) {
        SQLRowValues current = this.getLastKnownDBVals();
        if (current == null) {
            throw new IllegalStateException("No values to update");
        }
        return this.getRequest().setLastKnownDBVals(current, this.getRequest().fetchRow(current.getID(), ls));
    }

    @Override
    public final void select(int id) {
        this.select(this.getRequest().fetchRow(id, SQLSelect.LockStrength.NONE));
    }

    @Override
    public void select(SQLRowAccessor r) {
        this.select(r, null);
    }

    public void select(SQLRowAccessor r, Set<String> views) {
        if (r instanceof SQLRow) {
            ((SQLRow)r).exists();
        }
        try {
            if (r != null && !UserRightsManager.getCurrentUserRights().canView(this.getTable())) {
                throw new IllegalStateException("forbidden");
            }
            this.getRequest().select(r, views);
            this.updateChildrenEditable();
            if (r == null && this.isNonExistantEditable()) {
                this.selectDefaults(views);
            }
        }
        catch (RowNotFound e) {
            this.getTable().fireRowDeleted(e.getRow().getID());
            ExceptionHandler.handle(this, TM.tr("sqlComp.deletedRow", e.getRow()), e);
        }
        catch (IllegalStateException e) {
            ExceptionHandler.handle(this, TM.tr("sqlComp.selectError", r), e);
        }
    }

    private final void selectDefaults(Set<String> views) {
        SQLRowValues defaults = this.createValidDefaults();
        if (defaults != null && defaults.getFields().size() > 0) {
            this.getRequest().select(defaults, views);
        }
    }

    public final void addFillingListener(PropertyChangeListener l) {
        this.getRequest().addListener(l, "filling");
    }

    public final void rmFillingListener(PropertyChangeListener l) {
        this.getRequest().rmListener(l, "filling");
    }

    public final void addSelectionListener(PropertyChangeListener l) {
        this.getRequest().addListener(l, "selectedID");
    }

    public final void rmSelectionListener(PropertyChangeListener l) {
        this.getRequest().rmListener(l, "selectedID");
    }

    @Override
    public void detach() {
        this.getRequest().detach();
    }

    public final boolean isFilling() {
        return this.getRequest().isFilling();
    }

    @Override
    public int getSelectedID() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.getRequest().getSelectedID();
    }

    @Override
    public final boolean isSelectionReadOnly() {
        return this.getRequest().isReadOnlySelection();
    }

    @Override
    public void update() {
        try {
            if (!UserRightsManager.getCurrentUserRights().canModify(this.getTable())) {
                throw new SQLException("forbidden");
            }
            this.getRequest().update();
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, TM.tr("sqlComp.updateError", new Object[0]), e);
        }
    }

    @Override
    public void archive() {
        try {
            if (!UserRightsManager.getCurrentUserRights().canDelete(this.getTable())) {
                throw new SQLException("forbidden");
            }
            if (this.isSelectionReadOnly()) {
                throw new SQLException("read only");
            }
            this.getElement().archive(this.getSelectedID());
            this.resetValue();
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, TM.tr("sqlComp.archiveError", this), e);
        }
    }

    public Set<String> getPartialResetNames() {
        return Collections.emptySet();
    }

    protected final Set<SQLRowItemView> getRequired() {
        return this.required;
    }

    protected final Set<String> getRequiredNames() {
        return this.requiredNames == null ? null : Collections.unmodifiableSet(this.requiredNames);
    }

    protected Set<String> createRequiredNames() {
        return new HashSet<String>(Collections.singleton("DESIGNATION"));
    }

    @Override
    public String toString() {
        return this.getClass() + " on " + this.getTable() + " " + this.getSelectedID();
    }

    @Override
    public final boolean isNonExistantEditable() {
        return this.alwaysEditable;
    }

    @Override
    public final void setNonExistantEditable(boolean alwaysEditable) {
        this.alwaysEditable = alwaysEditable;
    }

    public final RowItemDesc getRIVDesc(String field) {
        Configuration conf = Configuration.getInstance();
        if (conf == null) {
            return SQLFieldTranslator.NULL_DESC;
        }
        return conf.getTranslator().getDescFor(this.getTable(), this.getCode(), this.getElement().getMDPath(), field);
    }

    public final void setRIVDesc(String itemName, RowItemDesc desc) {
        try {
            Configuration.getTranslator(this.getTable()).storeDescFor(this.getTable(), this.getCode(), itemName, desc);
            this.updateUI(itemName, desc);
        }
        catch (SQLException e) {
            ExceptionHandler.handle(this, TM.tr("sqlComp.saveDocError", itemName), e);
        }
    }

    protected void updateUI(String itemName, RowItemDesc desc) {
    }

    protected final void updateUI(String itemName, JComponent label, RowItemDesc desc) {
        this.updateUI(itemName, label, desc, null);
    }

    protected final void updateUI(String itemName, JComponent label, RowItemDesc desc, Color emptyLabelColor) {
        label.setToolTipText(desc.getDocumentation().trim().length() == 0 ? null : desc.getDocumentation());
        Tuple2<String, Boolean> tuple = this.getDesc(itemName, desc);
        String s = tuple.get0();
        if (label instanceof JLabel) {
            ((JLabel)label).setText(s);
        } else if (label instanceof JTextComponent) {
            ((JTextComponent)label).setText(s);
        } else if (label.getBorder() instanceof TitledBorder) {
            ((TitledBorder)label.getBorder()).setTitle(s);
        } else {
            Log.get().warning("Couldn't change label for " + itemName);
        }
        if (emptyLabelColor != null && !tuple.get1().booleanValue()) {
            label.setForeground(emptyLabelColor);
        }
        label.repaint();
    }

    protected final void updateUIAll() {
        for (SQLRowItemView v : this.getRequest().getViews()) {
            String sqlName = v.getSQLName();
            this.updateUI(sqlName, this.getRIVDesc(sqlName));
        }
    }

    public void doNotShow(SQLField f) {
        this.hide.add(f);
    }

    @Override
    public SQLElementDirectory getDirectory() {
        return this.getElement().getDirectory();
    }

    @Override
    public SQLComponent getSQLComponent() {
        return this;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() >= this.getMinimumSize().height;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 15;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        double length = orientation == 1 ? visibleRect.getHeight() : visibleRect.getWidth();
        return (int)(length - 30.0);
    }

    private static interface Spec {
        public boolean isRequired();

        public String getWhere();

        public boolean isAdditional();
    }

    private static final class SpecParser
    implements Spec {
        private boolean isRequired;
        private String where;
        private boolean showSeparator = true;
        private boolean isDecorated = true;
        private final boolean isAdditional;

        public static SpecParser create(Object specObj) {
            SpecParser spec = specObj == null || specObj instanceof String ? new SpecParser((String)specObj) : (SpecParser)specObj;
            return spec;
        }

        public SpecParser(String spec) {
            this(spec, false);
        }

        public SpecParser(String spec, boolean isAdditional) {
            this.isAdditional = isAdditional;
            if (spec == null || spec.length() == 0) {
                this.isRequired = false;
                this.where = null;
            } else {
                String[] specs = spec.split(";");
                if (specs.length > 4) {
                    throw new IllegalArgumentException(spec);
                }
                int i = 0;
                while (i < specs.length) {
                    String sp = specs[i];
                    if (sp.equals(BaseSQLComponent.REQ)) {
                        this.isRequired = true;
                    } else if (sp.equals(BaseSQLComponent.DEC)) {
                        this.isDecorated = false;
                    } else if (sp.equals(BaseSQLComponent.SEP)) {
                        this.showSeparator = false;
                    } else {
                        this.where = sp;
                    }
                    ++i;
                }
            }
        }

        public boolean showSeparator() {
            return this.showSeparator;
        }

        public boolean isDecorated() {
            return this.isDecorated;
        }

        @Override
        public final boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public final String getWhere() {
            return this.where;
        }

        @Override
        public final boolean isAdditional() {
            return this.isAdditional;
        }
    }

    public static interface VWTransformer<T>
    extends ITransformer<ValueWrapper<? extends T>, ValueWrapper<? extends T>> {
    }
}

