/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.cc.ITransformer;

final class ArchivedGraph {
    static final SQLTable.VirtualFields ARCHIVE_AND_FOREIGNS = SQLTable.VirtualFields.ARCHIVE.union(SQLTable.VirtualFields.FOREIGN_KEYS);
    private final SQLElementDirectory dir;
    private final SQLRowValues graph;
    private final Map<SQLRow, SQLRowValues> graphRows;
    private final Set<SQLRow> toExpand;

    ArchivedGraph(SQLElementDirectory dir, SQLRowValues graph) {
        if (dir == null) {
            throw new NullPointerException("Null SQLElementDirectory");
        }
        this.dir = dir;
        this.graph = graph;
        this.graphRows = new HashMap<SQLRow, SQLRowValues>();
        for (SQLRowValues v : this.graph.getGraph().getItems()) {
            SQLRowValues prev = this.graphRows.put(v.asRow(), v);
            if (prev == null) continue;
            throw new IllegalStateException("Duplicated row : " + v.asRow());
        }
        assert (this.isIndexCoherent());
        this.toExpand = new HashSet<SQLRow>(this.graphRows.keySet());
    }

    private boolean isIndexCoherent() {
        return this.graphRows.size() == this.graph.getGraphSize();
    }

    private final SQLElement getElement(SQLTable t) {
        return this.dir.getElement(t);
    }

    private void expandPrivates() {
        SetMap<SQLTable, Number> idsToExpandPrivate = new SetMap<SQLTable, Number>();
        for (SQLRow sQLRow : this.toExpand) {
            idsToExpandPrivate.add(sQLRow.getTable(), sQLRow.getIDNumber());
        }
        for (Map.Entry entry : idsToExpandPrivate.entrySet()) {
            SQLElement elem = this.getElement((SQLTable)entry.getKey());
            Set ids = (Set)entry.getValue();
            SQLRowValues privateGraph = elem.getPrivateGraph(ARCHIVE_AND_FOREIGNS, false, true);
            if (privateGraph.getGraphSize() <= 1) continue;
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(privateGraph, false);
            this.setWhereAndArchivePolicy(fetcher, ids, SQLSelect.ArchiveMode.BOTH);
            List<SQLRowValues> fetchedRows = fetcher.fetch();
            assert (fetchedRows.size() == ids.size());
            for (SQLRowValues valsFetched : fetchedRows) {
                for (SQLRowValues v : new ArrayList<SQLRowValues>(valsFetched.getGraph().getItems())) {
                    SQLRow row = v.asRow();
                    if (v == valsFetched) {
                        SQLRowValues toExpandVals = this.graphRows.get(row);
                        toExpandVals.load(valsFetched, valsFetched.getForeigns().keySet());
                        assert (!valsFetched.hasForeigns());
                        if (valsFetched.hasReferents()) {
                            for (Map.Entry refEntry : new ListMap(valsFetched.getReferentsMap()).entrySet()) {
                                SQLField refField = (SQLField)refEntry.getKey();
                                for (SQLRowValues ref : (Collection)refEntry.getValue()) {
                                    ref.put(refField.getName(), (Object)toExpandVals);
                                }
                            }
                        }
                        assert (valsFetched.getGraphSize() == 1);
                        continue;
                    }
                    this.toExpand.add(row);
                    this.graphRows.put(row, v);
                }
            }
        }
    }

    final SQLRowValues expand() {
        this.expandPrivates();
        while (!this.toExpand.isEmpty()) {
            String fieldName;
            assert (this.isIndexCoherent());
            SetMap<SQLTable, Number> toFetch = new SetMap<SQLTable, Number>();
            SetMap<SQLTable, Number> privateToFetch = new SetMap<SQLTable, Number>();
            ListMap<Object, SQLRowValues> nonEmptyFieldsPointingToPrivates = new ListMap<Object, SQLRowValues>();
            for (SQLRow rowToExpand : this.toExpand) {
                SQLTable t = rowToExpand.getTable();
                for (SQLElementLink sQLElementLink : this.getElement(t).getOwnedLinks().getByPath().values()) {
                    if (sQLElementLink.getLinkType().equals((Object)SQLElementLink.LinkType.COMPOSITION) || !sQLElementLink.getOwned().getTable().isArchivable()) continue;
                    SQLElement elem = sQLElementLink.getOwned();
                    Step lastStep = sQLElementLink.getPath().getStep(-1);
                    assert (lastStep.isForeign().booleanValue());
                    fieldName = lastStep.getSingleField().getName();
                    Collection<SQLRowValues> rowsWithForeign = this.graphRows.get(rowToExpand).followPath(sQLElementLink.getPath().minusLast(), SQLRowValues.CreateMode.CREATE_NONE, false);
                    for (SQLRowValues rowWithForeign : rowsWithForeign) {
                        SetMap<SQLTable, Number> map;
                        if (rowWithForeign.isForeignEmpty(fieldName)) continue;
                        SQLRow foreignRow = rowWithForeign.getForeign(fieldName).asRow();
                        SQLRowValues existingRow = this.graphRows.get(foreignRow);
                        if (existingRow != null) {
                            rowWithForeign.put(fieldName, (Object)existingRow);
                            continue;
                        }
                        if (elem.isPrivate()) {
                            nonEmptyFieldsPointingToPrivates.add(lastStep, rowWithForeign);
                            map = privateToFetch;
                        } else {
                            map = toFetch;
                        }
                        map.add(foreignRow.getTable(), foreignRow.getIDNumber());
                    }
                }
            }
            assert (this.isIndexCoherent());
            Map<SQLRow, SQLRowValues> archivedForeignRows = this.fetch(toFetch);
            HashMap<SQLRow, SQLRowValues> added = new HashMap<SQLRow, SQLRowValues>();
            for (SQLRow rowToExpand : this.toExpand) {
                SQLTable t = rowToExpand.getTable();
                for (SQLElementLink ff3 : this.getElement(t).getOwnedLinks().getByPath().values()) {
                    Step lastStep = ff3.getPath().getStep(-1);
                    assert (lastStep.isForeign().booleanValue());
                    String fieldName2 = lastStep.getSingleField().getName();
                    Collection<SQLRowValues> rowsWithForeign = this.graphRows.get(rowToExpand).followPath(ff3.getPath().minusLast(), SQLRowValues.CreateMode.CREATE_NONE, false);
                    for (SQLRowValues rowWithForeign : rowsWithForeign) {
                        if (rowWithForeign.isForeignEmpty(fieldName2)) continue;
                        SQLRow foreignRow = rowWithForeign.getForeign(fieldName2).asRow();
                        SQLRowValues existingOwnedRow = this.graphRows.get(foreignRow);
                        if (existingOwnedRow != null) {
                            rowWithForeign.put(fieldName2, (Object)existingOwnedRow);
                            continue;
                        }
                        SQLRowValues valsFetched = archivedForeignRows.get(foreignRow);
                        if (valsFetched == null) continue;
                        assert (valsFetched.isArchived()) : "Not archived : " + valsFetched;
                        this.attach(rowWithForeign, lastStep, valsFetched, added, privateToFetch);
                    }
                }
            }
            assert (this.isIndexCoherent());
            Map<SQLRow, SQLRowValues> privateFetched = this.fetch(privateToFetch);
            toFetch.clear();
            for (SQLRow sQLRow : privateFetched.keySet()) {
                SQLRowValues privateRoot = this.getElement(sQLRow.getTable()).fetchPrivateRoot(sQLRow, SQLSelect.ArchiveMode.BOTH);
                toFetch.add(privateRoot.getTable(), ((SQLRowAccessor)privateRoot).getIDNumber());
            }
            Map<SQLRow, SQLRowValues> map = this.fetch(toFetch, SQLSelect.ArchiveMode.BOTH);
            for (Map.Entry e : nonEmptyFieldsPointingToPrivates.entrySet()) {
                Step step = (Step)e.getKey();
                fieldName = step.getSingleField().getName();
                for (SQLRowValues rowWithForeign : (List)e.getValue()) {
                    assert (!rowWithForeign.isForeignEmpty(fieldName));
                    SQLRow foreignRow = rowWithForeign.getForeign(fieldName).asRow();
                    SQLRowValues existingOwnedRow = this.graphRows.get(foreignRow);
                    if (existingOwnedRow != null) {
                        rowWithForeign.put(fieldName, (Object)existingOwnedRow);
                        continue;
                    }
                    SQLRowValues valsFetched = map.get(foreignRow);
                    if (valsFetched == null) continue;
                    assert (valsFetched.isArchived()) : "Not archived : " + valsFetched;
                    this.attach(rowWithForeign, step, valsFetched, added, null);
                }
            }
            this.toExpand.clear();
            this.toExpand.addAll(added.keySet());
        }
        return this.graph;
    }

    private void attach(SQLRowValues existingRow, Step step, SQLRowValues graphToAdd, Map<SQLRow, SQLRowValues> added, SetMap<SQLTable, Number> privateToFetch) {
        assert (existingRow.getGraph() != graphToAdd.getGraph()) : "Already attached";
        assert (this.graphRows.get(existingRow.asRow()) == existingRow);
        assert (!this.graphRows.containsKey(graphToAdd.asRow()));
        for (SQLRowValues v : graphToAdd.getGraph().getItems()) {
            SQLRow row = v.asRow();
            added.put(row, v);
            SQLRowValues prev = this.graphRows.put(row, v);
            assert (prev == null) : "Duplicate " + row + " in " + this.graph.printGraph();
            if (privateToFetch == null) continue;
            privateToFetch.remove(v.getTable(), v.getIDNumber());
        }
        existingRow.put(step, graphToAdd);
        assert (this.isIndexCoherent());
    }

    private void setWhereAndArchivePolicy(final SQLRowValuesListFetcher fetcher, final Set<Number> ids, final SQLSelect.ArchiveMode archiveMode) {
        for (final SQLRowValuesListFetcher f : fetcher.getFetchers(true).allValues()) {
            f.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    if (f == fetcher && ids != null) {
                        input.andWhere(new Where(fetcher.getGraph().getTable().getKey(), ids));
                    }
                    input.setArchivedPolicy(archiveMode);
                    return input;
                }
            });
        }
    }

    private Map<SQLRow, SQLRowValues> fetch(SetMap<SQLTable, Number> toFetch) {
        return this.fetch(toFetch, SQLSelect.ArchiveMode.ARCHIVED);
    }

    private Map<SQLRow, SQLRowValues> fetch(SetMap<SQLTable, Number> toFetch, SQLSelect.ArchiveMode archiveMode) {
        HashMap<SQLRow, SQLRowValues> res = new HashMap<SQLRow, SQLRowValues>();
        for (Map.Entry e : toFetch.entrySet()) {
            Set ids = (Set)e.getValue();
            SQLTable table = (SQLTable)e.getKey();
            SQLElement elem = this.getElement(table);
            SQLRowValuesListFetcher fetcher = !elem.isPrivate() ? SQLRowValuesListFetcher.create(elem.getPrivateGraph(ARCHIVE_AND_FOREIGNS, false, true)) : new SQLRowValuesListFetcher(new SQLRowValues(table).putNulls(table.getFieldsNames(SQLTable.VirtualFields.ARCHIVE)));
            this.setWhereAndArchivePolicy(fetcher, ids, archiveMode);
            for (SQLRowValues fetchedVals : fetcher.fetch()) {
                for (SQLRowValues v : fetchedVals.getGraph().getItems()) {
                    SQLRow r = v.asRow();
                    res.put(r, v);
                    assert (!this.graphRows.containsKey(r)) : "already in graph : " + r;
                }
            }
        }
        return res;
    }
}

