/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.correct;

import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLUtils;

public class SetFFRules
extends Changer<SQLTable> {
    private boolean cascadeNormalFF = false;

    public SetFFRules(DBSystemRoot b) {
        super(b);
    }

    public final SetFFRules setCascadeNormalFF(boolean cascadeNormalFF) {
        this.cascadeNormalFF = cascadeNormalFF;
        return this;
    }

    @Override
    protected void changeImpl(final SQLTable t) throws SQLException {
        if (Configuration.getInstance() == null || Configuration.getInstance().getDirectory() == null) {
            throw new IllegalStateException("no directory");
        }
        SQLElement elem = Configuration.getInstance().getDirectory().getElement(t);
        if (elem == null) {
            return;
        }
        this.getStream().println(t);
        final AlterTable alterTable = new AlterTable(t);
        this.setDeleteRule(t, elem.getParentLink(), alterTable, Link.Rule.CASCADE);
        Link.Rule normalRule = t.getServer().getSQLSystem() != SQLSystem.MYSQL ? Link.Rule.SET_DEFAULT : (this.cascadeNormalFF ? Link.Rule.CASCADE : Link.Rule.NO_ACTION);
        for (SQLElementLink link : elem.getOwnedLinks().getByPath().values()) {
            this.setDeleteRule(t, link, alterTable, link.getLinkType() == SQLElementLink.LinkType.ASSOCIATION && !link.getOwned().isShared() ? normalRule : Link.Rule.NO_ACTION);
        }
        if (!alterTable.isEmpty()) {
            if (this.getSyntax().getSystem() == SQLSystem.MYSQL) {
                SQLUtils.executeAtomic(this.getDS(), new SQLUtils.SQLFactory<Object>(){

                    @Override
                    public Object create() throws SQLException {
                        for (List<String> l : ChangeTable.cat(Collections.singleton(alterTable), t.getDBRoot().getName(), EnumSet.of(ChangeTable.ConcatStep.ADD_FOREIGN))) {
                            for (String sql : l) {
                                SetFFRules.this.getDS().execute(sql);
                            }
                        }
                        return null;
                    }
                });
            } else {
                this.getDS().execute(alterTable.asString());
            }
            this.getStream().println("Done.");
            t.getSchema().updateVersion();
        }
    }

    private void setDeleteRule(SQLTable t, SQLElementLink link, AlterTable alterTable, Link.Rule rule) throws SQLException {
        if (link != null && !link.isJoin()) {
            this.setDeleteRule(t, link.getSingleLink(), alterTable, rule);
        }
    }

    private void setDeleteRule(SQLTable t, Link l, AlterTable alterTable, Link.Rule rule) throws SQLException {
        if (rule != Link.Rule.CASCADE && rule != Link.Rule.NO_ACTION && rule != Link.Rule.SET_DEFAULT) {
            throw new IllegalArgumentException("SET_NULL is usually impossible, RESTRICT means NO_ACTION for MySQL : " + (Object)((Object)rule));
        }
        if (l.getDeleteRule() != rule) {
            alterTable.dropForeignConstraint(l.getName());
            boolean hasIndex = t.getIndexes(l.getCols()).size() > 0;
            alterTable.addForeignConstraint(new ChangeTable.FCSpec(l.getCols(), l.getContextualName(), l.getRefCols(), l.getUpdateRule(), rule), !hasIndex);
            this.getStream().println("Will change " + l + " to " + (Object)((Object)rule));
        }
    }
}

