/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.AlterTable;

public class TextToVarChar
extends Changer<SQLTable> {
    public static final String CHANGE_NULLABLE_AND_DEFAULT = "org.openconcerto.sql.changer.changeNullableAndDefault";
    private static final Pattern textType = Pattern.compile(".*text", 2);
    private EnumSet<SQLField.Properties> toChange = EnumSet.of(SQLField.Properties.TYPE);

    public TextToVarChar(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected EnumSet<SQLSystem> getCompatibleSystems() {
        return EnumSet.of(SQLSystem.MYSQL, SQLSystem.POSTGRESQL, SQLSystem.H2);
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        if (Boolean.getBoolean(CHANGE_NULLABLE_AND_DEFAULT)) {
            this.toChange = EnumSet.allOf(SQLField.Properties.class);
        }
    }

    @Override
    protected void changeImpl(SQLTable t) throws SQLException {
        String modes;
        if (t.getServer().getSQLSystem() == SQLSystem.MYSQL && !(modes = (String)this.getDS().executeScalar("SELECT @@global.sql_mode;")).contains("STRICT_ALL_TABLES") && !modes.contains("STRICT_TRANS_TABLES")) {
            throw new IllegalStateException("must run in STRICT mode (eg TRADITIONAL), current modes: " + modes);
        }
        for (SQLField f : t.getFields()) {
            if (f.getType().getTypeName() == null || f.getType().getType() != 2005 && !textType.matcher(f.getType().getTypeName()).matches()) continue;
            int size = f.getType().getSize();
            if (size > 2048) {
                size = 2048;
            }
            AlterTable alterTable = new AlterTable(t);
            alterTable.alterColumn(f.getName(), this.toChange, " varchar(" + size + ")", "''", false);
            String req = alterTable.asString();
            System.err.println(req);
            this.getDS().execute(req);
        }
    }
}

