/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;

public class OrderToDecimal
extends Changer<SQLTable> {
    public OrderToDecimal(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(SQLTable t) throws SQLException {
        this.getStream().print(String.valueOf(t.getName()) + "... ");
        if (!t.isOrdered()) {
            this.getStream().println("not ordered");
        } else if (this.getSyntax().isOrder(t.getOrderField())) {
            this.getStream().println("already");
        } else {
            String update;
            SQLSystem system = this.getSystemRoot().getServer().getSQLSystem();
            if (system == SQLSystem.MYSQL) {
                update = SQLSelect.quote("ALTER TABLE %f MODIFY COLUMN %n " + this.getSyntax().getOrderDefinition(), t, t.getOrderField());
            } else if (system == SQLSystem.POSTGRESQL) {
                String setDef = this.getSyntax().getOrderDefault() == null ? "ALTER COLUMN %n DROP DEFAULT" : "ALTER COLUMN %n SET DEFAULT " + this.getSyntax().getOrderDefault();
                update = SQLSelect.quote("ALTER TABLE %f ALTER COLUMN %n TYPE " + this.getSyntax().getOrderType() + ", ALTER COLUMN %n DROP NOT NULL , " + setDef, t, t.getOrderField(), t.getOrderField(), t.getOrderField());
            } else {
                throw new IllegalStateException("not implemented for " + (Object)((Object)system));
            }
            this.getDS().execute(update);
            t.getSchema().updateVersion();
            this.getStream().println("done");
        }
    }
}

