/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldMapper;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.utils.FileUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Configuration {
    private static Configuration instance;
    private ExecutorService nonInteractiveSQLExecutor;

    public static File getDefaultConfDir() {
        return new File(System.getProperty("user.home"), ".java/ilm/sql-config/");
    }

    public static SQLFieldTranslator getTranslator(SQLTable t) {
        return Configuration.getInstance().getTranslator();
    }

    public static Configuration getInstance() {
        return instance;
    }

    public static final void setInstance(Configuration instance) {
        Configuration.instance = instance;
    }

    public abstract ShowAs getShowAs();

    public abstract SQLBase getBase();

    public abstract DBRoot getRoot();

    public abstract DBSystemRoot getSystemRoot();

    public abstract SQLFilter getFilter();

    public abstract SQLFieldTranslator getTranslator();

    public abstract SQLElementDirectory getDirectory();

    public abstract FieldMapper getFieldMapper();

    public abstract File getWD();

    public abstract String getAppName();

    public final String getAppID() {
        String appName = this.getAppName();
        if (appName == null || appName.length() == 0) {
            return null;
        }
        return String.valueOf(appName) + this.getAppIDSuffix();
    }

    protected String getAppIDSuffix() {
        return "";
    }

    public File getConfDir() {
        return new File(Configuration.getDefaultConfDir(), this.getAppID());
    }

    public final File getConfDirForRoot() {
        return this.getConfDir(this.getRoot());
    }

    public final File migrateToConfDirForRoot(String name) {
        File oldFile = new File(this.getConfDir(), name);
        File newFile = new File(this.getConfDirForRoot(), name);
        if (oldFile.exists() && !newFile.exists()) {
            try {
                FileUtils.mkdir_p(newFile.getParentFile());
                oldFile.renameTo(newFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                FileUtils.rmR(oldFile);
            }
        }
        return newFile;
    }

    public final File getConfDir(DBStructureItem<?> db) {
        return DBItemFileCache.getDescendant(new File(this.getConfDir(), "dataDepedent"), DBFileCache.getJDBCAncestorNames(db, true));
    }

    public Configuration add(Configuration o) {
        this.getTranslator().putAll(o.getTranslator());
        this.getDirectory().putAll(o.getDirectory());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.nonInteractiveSQLExecutor != null) {
                this.nonInteractiveSQLExecutor.shutdown();
            }
        }
    }

    public Document getXMLConf(long userId, String idTable) throws ParserConfigurationException, SAXException, IOException {
        SQLElement element = this.getDirectory().getElement("FWK_LIST_PREFS");
        SQLTable columnPrefsTable = element.getTable();
        SQLSelect select = new SQLSelect();
        select.addSelectStar(columnPrefsTable);
        select.setWhere(new Where((FieldRef)columnPrefsTable.getField("ID_USER"), "=", (Object)userId).and(new Where((FieldRef)columnPrefsTable.getField("ID_TABLE"), "=", (Object)idTable)));
        List<SQLRow> rqResult = SQLRowListRSH.execute(select);
        if (rqResult != null && !rqResult.isEmpty()) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            return docBuilder.parse(new InputSource(new StringReader(rqResult.get(0).getString("VALUE"))));
        }
        return null;
    }

    public final synchronized Executor getNonInteractiveSQLExecutor() {
        if (this.nonInteractiveSQLExecutor == null) {
            this.nonInteractiveSQLExecutor = this.createNonInteractiveSQLExecutor();
        }
        return this.nonInteractiveSQLExecutor;
    }

    protected ExecutorService createNonInteractiveSQLExecutor() {
        return Executors.newFixedThreadPool(2);
    }
}

