/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.config.MenuAndActions;
import org.openconcerto.erp.config.MenuManager;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.DepLink;
import org.openconcerto.erp.modules.DepSolver;
import org.openconcerto.erp.modules.DepSolverGraph;
import org.openconcerto.erp.modules.DepSolverResult;
import org.openconcerto.erp.modules.DepSolverResultMM;
import org.openconcerto.erp.modules.DependencyGraph;
import org.openconcerto.erp.modules.FactoriesByID;
import org.openconcerto.erp.modules.InstallationState;
import org.openconcerto.erp.modules.JarModuleFactory;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.erp.modules.ModuleElement;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleTableModel;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.erp.modules.ModulesStateChange;
import org.openconcerto.erp.modules.ModulesStateChangeResult;
import org.openconcerto.erp.modules.Solutions;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DirectedEdge;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.DropTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.ThreadFactory;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IdentityHashSet;
import org.openconcerto.utils.i18n.TranslationManager;
import org.openconcerto.xml.XMLCodecUtils;

public class ModuleManager {
    public static final String MODULE_DB_RIGHT = "moduleDBAdmin";
    static final Logger L = Logger.getLogger(ModuleManager.class.getPackage().getName());
    private static ExecutorService exec = null;
    static final Runnable EMPTY_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final long MIN_VERSION = ModuleVersion.MIN.getMerged();
    private static final String MODULE_COLNAME = "MODULE_NAME";
    private static final String MODULE_VERSION_COLNAME = "MODULE_VERSION";
    private static final String TABLE_COLNAME = "TABLE";
    private static final String FIELD_COLNAME = "FIELD";
    private static final String ISKEY_COLNAME = "KEY";
    private static final String FWK_MODULE_TABLENAME = new String("FWK_MODULE_METADATA");
    private static final String FWK_MODULE_DEP_TABLENAME = new String("FWK_MODULE_DEP");
    private static final String NEEDING_MODULE_COLNAME = "ID_MODULE";
    private static final String NEEDED_MODULE_COLNAME = "ID_MODULE_NEEDED";
    private static final String fileMutex = new String("modules");
    private static final Integer TO_INSTALL_VERSION = 1;
    private static ModuleManager instance = null;
    private final FactoriesByID factories;
    private final Map<String, AbstractModule> runningModules;
    private final Map<ModuleReference, IdentityHashMap<SQLElement, SQLElement>> modulesElements;
    private boolean inited = false;
    private final Map<String, ComponentsContext> modulesComponents;
    private final DependencyGraph dependencyGraph;
    private final Map<ModuleFactory, AbstractModule> createdModules;
    private final Object varLock = new String("varLock");
    private DBRoot root = null;
    private SQLPreferences dbPrefs = null;
    private Configuration conf = null;
    private boolean exitAllowed = true;

    private static final synchronized Executor getExec() {
        if (exec == null) {
            exec = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(String.valueOf(ModuleManager.class.getSimpleName()) + " executor thread ", false));
        }
        return exec;
    }

    public static synchronized ModuleManager getInstance() {
        if (instance == null) {
            instance = new ModuleManager();
        }
        return instance;
    }

    static synchronized void resetInstance() {
        if (instance != null) {
            for (String id : instance.getRunningModules().keySet()) {
                instance.stopModuleRecursively(id);
            }
            instance = null;
        }
    }

    private static boolean noDisplayableFrame() {
        final MainFrame mf = MainFrame.getInstance();
        if (mf == null) {
            return true;
        }
        FutureTask<Boolean> f = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !mf.isDisplayable();
            }
        });
        SwingThreadUtils.invoke(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            Log.get().log(Level.WARNING, "Couldn't determine MainFrame displayability", e);
            return true;
        }
    }

    public static synchronized void tearDown() {
        if (exec != null) {
            exec.shutdown();
            exec = null;
        }
    }

    public static String getMDVariant(ModuleFactory f) {
        return ModuleManager.getMDVariant(f.getReference());
    }

    public static String getMDVariant(ModuleReference ref) {
        return ref.getID();
    }

    static final Set<ModuleReference> versionsMapToSet(Map<String, ModuleVersion> versions) {
        HashSet<ModuleReference> res = new HashSet<ModuleReference>(versions.size());
        for (Map.Entry<String, ModuleVersion> e : versions.entrySet()) {
            res.add(new ModuleReference(e.getKey(), e.getValue()));
        }
        return res;
    }

    public ModuleManager() {
        this.factories = new FactoriesByID();
        this.runningModules = new LinkedHashMap<String, AbstractModule>();
        this.dependencyGraph = new DependencyGraph();
        this.createdModules = new LinkedHashMap<ModuleFactory, AbstractModule>();
        this.modulesElements = new HashMap<ModuleReference, IdentityHashMap<SQLElement, SQLElement>>();
        this.modulesComponents = new HashMap<String, ComponentsContext>();
    }

    public final boolean currentUserIsAdmin() {
        return UserRightsManager.getCurrentUserRights().haveRight(MODULE_DB_RIGHT);
    }

    public final boolean canCurrentUser(ModuleAction action, ModuleTableModel.ModuleRow m) {
        if (this.currentUserIsAdmin()) {
            return true;
        }
        if (action == ModuleAction.INSTALL || action == ModuleAction.UNINSTALL) {
            return this.canCurrentUserInstall(action, m.isInstalledRemotely());
        }
        if (action == ModuleAction.START) {
            return true;
        }
        if (action == ModuleAction.STOP) {
            return !m.isAdminRequired();
        }
        throw new IllegalArgumentException("Unknown action " + (Object)((Object)action));
    }

    final boolean canCurrentUserInstall(ModuleAction action, ModuleReference ref, InstallationState state) {
        return this.canCurrentUserInstall(action, state.getRemote().contains(ref));
    }

    private final boolean canCurrentUserInstall(ModuleAction action, boolean installedRemotely) {
        if (this.currentUserIsAdmin()) {
            return true;
        }
        if (action == ModuleAction.INSTALL) {
            return installedRemotely;
        }
        if (action == ModuleAction.UNINSTALL) {
            return !installedRemotely;
        }
        throw new IllegalArgumentException("Illegal action " + (Object)((Object)action));
    }

    public final int addFactories(File dir) {
        if (!dir.exists()) {
            L.warning("Module factory directory not found: " + dir.getAbsolutePath());
            return 0;
        }
        File[] jars = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".jar");
            }
        });
        int i = 0;
        if (jars != null) {
            File[] fileArray = jars;
            int n = jars.length;
            int n2 = 0;
            while (n2 < n) {
                File jar = fileArray[n2];
                try {
                    this.addFactory(new JarModuleFactory(jar));
                    ++i;
                }
                catch (Exception e) {
                    L.warning("Couldn't add " + jar);
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return i;
    }

    public final ModuleFactory addFactoryFromPackage(File jar) throws IOException {
        JarModuleFactory f = new JarModuleFactory(jar);
        this.addFactory(f);
        return f;
    }

    public final String addFactory(ModuleFactory f) {
        ModuleFactory prev = this.factories.add(f);
        if (prev != null) {
            L.info("Changing the factory for " + f.getReference() + "\nfrom\t" + prev + "\nto\t" + f);
        }
        return f.getID();
    }

    public final void addFactories(Collection<ModuleFactory> factories) {
        for (ModuleFactory f : factories) {
            this.addFactory(f);
        }
    }

    public final String addFactoryAndStart(ModuleFactory f, boolean persistent) {
        return this.addFactory(f, true, persistent);
    }

    private final String addFactory(final ModuleFactory f, boolean start, final boolean persistent) {
        this.addFactory(f);
        if (start) {
            L.config("addFactory() invoked start " + (persistent ? "" : "not") + " persistent for " + f);
            this.invoke(new IClosure<ModuleManager>(){

                @Override
                public void executeChecked(ModuleManager input) {
                    try {
                        ModuleManager.this.startModule(f.getReference(), persistent);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(MainFrame.getInstance(), "Unable to start " + f, e);
                    }
                }
            });
        }
        return f.getID();
    }

    public final Map<String, SortedMap<ModuleVersion, ModuleFactory>> getFactories() {
        return this.factories.getMap();
    }

    public final FactoriesByID copyFactories() {
        return new FactoriesByID(this.factories);
    }

    public final void removeFactory(String id) {
        this.factories.remove(id);
    }

    public void invoke(final IClosure<ModuleManager> c) {
        MainFrame.invoke(new Runnable(){

            @Override
            public void run() {
                ModuleManager.getExec().execute(new Runnable(){

                    @Override
                    public void run() {
                        c.executeChecked(ModuleManager.this);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRoot(DBRoot root) {
        Object object = this.varLock;
        synchronized (object) {
            if (this.root != root) {
                if (this.root != null) {
                    throw new IllegalStateException("Root already set");
                }
                this.root = root;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSetup() {
        Object object = this.varLock;
        synchronized (object) {
            return this.getRoot() != null && this.getConf() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setup(DBRoot root, Configuration conf) throws IllegalStateException {
        if (root == null || conf == null) {
            throw new NullPointerException();
        }
        Object object = this.varLock;
        synchronized (object) {
            if (this.isSetup()) {
                throw new IllegalStateException("Already setup");
            }
            assert (this.modulesElements.isEmpty() && this.runningModules.isEmpty() && this.modulesComponents.isEmpty()) : "Modules cannot start without root & conf";
            this.setRoot(root);
            this.conf = conf;
        }
    }

    public final synchronized boolean isInited() {
        return this.inited;
    }

    public final synchronized void init() throws Exception {
        if (!this.isSetup()) {
            throw new IllegalStateException("Not setup");
        }
        SQLPreferences.getPrefTable(this.getRoot());
        List<ModuleReference> requiredModules = this.getDBRequiredModules();
        requiredModules.addAll(this.getAdminRequiredModules());
        File toInstallFile = this.getToInstallFile();
        Set toInstall = Collections.emptySet();
        Set userReferencesToInstall = Collections.emptySet();
        boolean persistent = false;
        ModuleState toInstallTargetState = ModuleState.NOT_CREATED;
        if (toInstallFile.exists()) {
            if (!toInstallFile.canRead() || !toInstallFile.isFile()) {
                L.warning("Couldn't read " + toInstallFile);
            } else {
                XMLDecoder dec = new XMLDecoder(new FileInputStream(toInstallFile));
                try {
                    try {
                        Number version = (Number)dec.readObject();
                        if (version.intValue() != TO_INSTALL_VERSION.intValue()) {
                            throw new Exception("Version mismatch, expected " + TO_INSTALL_VERSION + " found " + version);
                        }
                        Date fileDate = (Date)dec.readObject();
                        Set toInstallUnsafe = (Set)dec.readObject();
                        Set userReferencesToInstallUnsafe = (Set)dec.readObject();
                        toInstallTargetState = (ModuleState)((Object)dec.readObject());
                        persistent = (Boolean)dec.readObject();
                        try {
                            Object extra = dec.readObject();
                            assert (false) : "Extra object " + extra;
                        }
                        catch (ArrayIndexOutOfBoundsException extra) {
                            // empty catch block
                        }
                        Date now = new Date();
                        if (fileDate.compareTo(now) > 0) {
                            L.warning("File is in the future : " + fileDate);
                        } else if (now.getTime() - fileDate.getTime() > 0x6DDD00L) {
                            L.warning("File is too old : " + fileDate);
                        } else {
                            toInstall = toInstallUnsafe;
                            userReferencesToInstall = userReferencesToInstallUnsafe;
                            if (toInstallTargetState.compareTo(ModuleState.REGISTERED) < 0) {
                                L.warning("Forcing state to " + (Object)((Object)ModuleState.REGISTERED));
                            }
                        }
                    }
                    catch (Exception e) {
                        File errorFile = FileUtils.addSuffix(toInstallFile, ".error");
                        errorFile.delete();
                        boolean renamed = toInstallFile.renameTo(errorFile);
                        throw new Exception("Couldn't parse " + toInstallFile + " ; renamed : " + renamed, e);
                    }
                }
                finally {
                    dec.close();
                }
            }
        }
        requiredModules.addAll(toInstall);
        Tuple2<Solutions, ModulesStateChangeResult> modules = this.createModules(requiredModules, NoChoicePredicate.ONLY_INSTALL_ARGUMENTS, ModuleState.REGISTERED);
        if (modules.get1().getNotCreated().size() > 0) {
            throw new Exception("Impossible de cr\u00e9er les modules, not solved : " + modules.get0().getNotSolvedReferences() + " ; not created : " + modules.get1().getNotCreated());
        }
        if (toInstallTargetState.compareTo(ModuleState.STARTED) >= 0) {
            if (persistent) {
                this.setPersistentModules(userReferencesToInstall);
            } else {
                this.createModules(userReferencesToInstall, NoChoicePredicate.NO_CHANGE, ModuleState.STARTED, persistent);
            }
        }
        if (toInstallFile.exists() && !toInstallFile.delete()) {
            throw new IOException("Couldn't delete " + toInstallFile);
        }
        this.inited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setExitAllowed(boolean exitAllowed) {
        Object object = this.varLock;
        synchronized (object) {
            this.exitAllowed = exitAllowed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isExitAllowed() {
        Object object = this.varLock;
        synchronized (object) {
            return this.exitAllowed;
        }
    }

    public final boolean needExit(ModulesStateChange solution) {
        return solution.getReferencesToRemove().size() > 0;
    }

    private Preferences getPrefs() {
        StringBuilder path = new StringBuilder(32);
        for (String item : DBFileCache.getJDBCAncestorNames(this.getRoot(), true)) {
            path.append(StringUtils.getBoundedLengthString(DBItemFileCache.encode(item), 80));
            path.append('/');
        }
        path.setLength(path.length() - 1);
        return Preferences.userNodeForPackage(ModuleManager.class).node(path.toString());
    }

    private Preferences getRunningIDsPrefs() {
        return this.getPrefs().node("toRun");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Preferences getDBPrefs() {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            DBRoot root;
            if (this.dbPrefs == null && (root = this.getRoot()) != null) {
                this.dbPrefs = (SQLPreferences)new SQLPreferences(root).node("modules");
            }
            return this.dbPrefs;
        }
    }

    private final Preferences getRequiredIDsPrefs() {
        return this.getDBPrefs().node("required");
    }

    protected final boolean isModuleInstalledLocally(String id) {
        return this.getLocalVersionFile(id).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ModuleVersion getModuleVersionInstalledLocally(String id) {
        String string = fileMutex;
        synchronized (string) {
            File versionFile = this.getLocalVersionFile(id);
            if (versionFile.exists()) {
                try {
                    return new ModuleVersion(Long.valueOf(FileUtils.read(versionFile)));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Couldn't get installed version of " + id, e);
                }
            }
            return null;
        }
    }

    public final Set<ModuleReference> getModulesInstalledLocally() {
        return ModuleManager.versionsMapToSet(this.getModulesVersionInstalledLocally());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, ModuleVersion> getModulesVersionInstalledLocally() {
        String string = fileMutex;
        synchronized (string) {
            File dir = this.getLocalDirectory();
            if (!dir.isDirectory()) {
                return Collections.emptyMap();
            }
            HashMap<String, ModuleVersion> res = new HashMap<String, ModuleVersion>();
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File d = fileArray[n2];
                String id = d.getName();
                ModuleVersion version = this.getModuleVersionInstalledLocally(id);
                if (version != null) {
                    res.put(id, version);
                }
                ++n2;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setModuleInstalledLocally(ModuleReference f, boolean b) {
        try {
            String string = fileMutex;
            synchronized (string) {
                if (b) {
                    ModuleVersion vers = f.getVersion();
                    vers.checkValidity();
                    File versionFile = this.getLocalVersionFile(f.getID());
                    FileUtils.mkdir_p(versionFile.getParentFile());
                    FileUtils.write(String.valueOf(vers.getMerged()), versionFile);
                } else {
                    FileUtils.rm_R(this.getLocalDirectory(f.getID()));
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't change installed status of " + f, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLTable getInstalledTable(DBRoot r) throws SQLException {
        String string = FWK_MODULE_TABLENAME;
        synchronized (string) {
            SQLCreateTable createTable;
            ArrayList<SQLCreateTable> createTables = new ArrayList<SQLCreateTable>(4);
            if (!r.contains(FWK_MODULE_TABLENAME)) {
                createTable = new SQLCreateTable(r, FWK_MODULE_TABLENAME);
                createTable.setPlain(true);
                createTable.addColumn("ID", createTable.getSyntax().getPrimaryIDDefinitionShort());
                createTable.setPrimaryKey("ID");
                createTable.addVarCharColumn(MODULE_COLNAME, 128);
                createTable.addColumn(TABLE_COLNAME, "varchar(128) NULL");
                createTable.addColumn(FIELD_COLNAME, "varchar(128) NULL");
                createTable.addColumn(ISKEY_COLNAME, "boolean NULL");
                createTable.addColumn(MODULE_VERSION_COLNAME, "bigint NOT NULL");
                createTable.addUniqueConstraint("uniqModule", Arrays.asList(MODULE_COLNAME, TABLE_COLNAME, FIELD_COLNAME));
                createTables.add(createTable);
            } else {
                createTable = null;
            }
            if (!r.contains(FWK_MODULE_DEP_TABLENAME)) {
                ChangeTable.ForeignColSpec fkNeeded;
                ChangeTable.ForeignColSpec fk;
                SQLCreateTable createDepTable = new SQLCreateTable(r, FWK_MODULE_DEP_TABLENAME);
                createDepTable.setPlain(true);
                if (createTable != null) {
                    fk = ChangeTable.ForeignColSpec.fromCreateTable(createTable);
                    fkNeeded = ChangeTable.ForeignColSpec.fromCreateTable(createTable);
                } else {
                    SQLTable moduleT = r.getTable(FWK_MODULE_TABLENAME);
                    fk = ChangeTable.ForeignColSpec.fromTable(moduleT);
                    fkNeeded = ChangeTable.ForeignColSpec.fromTable(moduleT);
                }
                createDepTable.addForeignColumn(fk.setColumnName(NEEDING_MODULE_COLNAME), Link.Rule.CASCADE, Link.Rule.CASCADE);
                createDepTable.addForeignColumn(fkNeeded.setColumnName(NEEDED_MODULE_COLNAME), Link.Rule.CASCADE, Link.Rule.RESTRICT);
                createDepTable.setPrimaryKey(NEEDING_MODULE_COLNAME, NEEDED_MODULE_COLNAME);
                createTables.add(createDepTable);
            }
            r.createTables(createTables);
        }
        return r.getTable(FWK_MODULE_TABLENAME);
    }

    private final SQLTable getDepTable() {
        return this.getRoot().getTable(FWK_MODULE_DEP_TABLENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DBRoot getRoot() {
        Object object = this.varLock;
        synchronized (object) {
            return this.root;
        }
    }

    private SQLDataSource getDS() {
        return this.getRoot().getDBSystemRoot().getDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Configuration getConf() {
        Object object = this.varLock;
        synchronized (object) {
            return this.conf;
        }
    }

    private SQLElementDirectory getDirectory() {
        return this.getConf().getDirectory();
    }

    final File getLocalDirectory() {
        return new File(this.getConf().getConfDir(this.getRoot()), "modules");
    }

    private final File getToInstallFile() {
        return new File(this.getLocalDirectory(), "toInstall");
    }

    protected final File getLocalDirectory(String id) {
        return new File(this.getLocalDirectory(), id);
    }

    private final File getLocalVersionFile(String id) {
        return new File(this.getLocalDirectory(id), "version");
    }

    public final ModuleVersion getDBInstalledModuleVersion(String id) throws SQLException {
        return this.getDBInstalledModules(id).get(id);
    }

    public final Set<ModuleReference> getModulesInstalledRemotely() throws SQLException {
        return this.getDBInstalledModuleRowsByRef(null).keySet();
    }

    public final Map<String, ModuleVersion> getDBInstalledModules() throws SQLException {
        return this.getDBInstalledModules(null);
    }

    private final Where getModuleRowWhere(TableRef installedTable) throws SQLException {
        return Where.isNull(installedTable.getField(TABLE_COLNAME)).and(Where.isNull(installedTable.getField(FIELD_COLNAME)));
    }

    private final List<SQLRow> getDBInstalledModuleRows(String id) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        SQLSelect sel = new SQLSelect().addSelectStar(installedTable);
        sel.setWhere(this.getModuleRowWhere(installedTable));
        if (id != null) {
            sel.andWhere(new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)id));
        }
        return SQLRowListRSH.execute(sel);
    }

    private final ModuleReference getRef(SQLRow r) throws SQLException {
        return new ModuleReference(r.getString(MODULE_COLNAME), new ModuleVersion(r.getLong(MODULE_VERSION_COLNAME)));
    }

    private final Map<String, ModuleVersion> getDBInstalledModules(String id) throws SQLException {
        HashMap<String, ModuleVersion> res = new HashMap<String, ModuleVersion>();
        for (SQLRow r : this.getDBInstalledModuleRows(id)) {
            ModuleReference ref = this.getRef(r);
            res.put(ref.getID(), ref.getVersion());
        }
        return res;
    }

    private final Map<ModuleReference, SQLRow> getDBInstalledModuleRowsByRef(String id) throws SQLException {
        HashMap<ModuleReference, SQLRow> res = new HashMap<ModuleReference, SQLRow>();
        for (SQLRow r : this.getDBInstalledModuleRows(id)) {
            res.put(this.getRef(r), r);
        }
        return res;
    }

    private SQLRow setDBInstalledModule(ModuleReference f, boolean b) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        Where idW = new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)f.getID());
        Where w = idW.and(this.getModuleRowWhere(installedTable));
        if (b) {
            SQLSelect sel = new SQLSelect();
            sel.addSelect(installedTable.getKey());
            sel.setWhere(w);
            Number id = (Number)installedTable.getDBSystemRoot().getDataSource().executeScalar(sel.asString());
            SQLRowValues vals = new SQLRowValues(installedTable);
            vals.put(MODULE_VERSION_COLNAME, f.getVersion().getMerged());
            if (id != null) {
                vals.setID(id);
                return vals.update();
            }
            vals.put(MODULE_COLNAME, f.getID());
            vals.put(TABLE_COLNAME, null);
            vals.put(FIELD_COLNAME, null);
            return vals.insert();
        }
        installedTable.getDBSystemRoot().getDataSource().execute("DELETE FROM " + installedTable.getSQLName().quote() + " WHERE " + w.getClause());
        installedTable.fireTableModified(-1);
        return null;
    }

    public final Tuple2<Set<String>, Set<SQLName>> getCreatedItems(String id) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        SQLSelect sel = new SQLSelect();
        sel.addSelect(installedTable.getKey());
        sel.addSelect(installedTable.getField(TABLE_COLNAME));
        sel.addSelect(installedTable.getField(FIELD_COLNAME));
        sel.setWhere(new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)id).and(Where.isNotNull(installedTable.getField(TABLE_COLNAME))));
        HashSet<String> tables = new HashSet<String>();
        HashSet<SQLName> fields = new HashSet<SQLName>();
        for (SQLRow r : SQLRowListRSH.execute(sel)) {
            String tableName = r.getString(TABLE_COLNAME);
            String fieldName = r.getString(FIELD_COLNAME);
            if (fieldName == null) {
                tables.add(tableName);
                continue;
            }
            fields.add(new SQLName(tableName, fieldName));
        }
        return Tuple2.create(tables, fields);
    }

    private void updateModuleFields(ModuleFactory factory, DepSolverGraph graph, DBContext ctxt) throws SQLException {
        SQLTable t;
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        Where idW = new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)factory.getID());
        ArrayList<Where> dropWheres = new ArrayList<Where>();
        for (String string : ctxt.getRemovedTables()) {
            dropWheres.add(new Where((FieldRef)installedTable.getField(TABLE_COLNAME), "=", (Object)string));
        }
        for (SQLName sQLName : ctxt.getRemovedFieldsFromExistingTables()) {
            dropWheres.add(new Where((FieldRef)installedTable.getField(TABLE_COLNAME), "=", (Object)sQLName.getItem(0)).and(new Where((FieldRef)installedTable.getField(FIELD_COLNAME), "=", (Object)sQLName.getItem(1))));
        }
        if (dropWheres.size() > 0) {
            installedTable.getDBSystemRoot().getDataSource().execute("DELETE FROM " + installedTable.getSQLName().quote() + " WHERE " + Where.or(dropWheres).and(idW).getClause());
        }
        SQLRowValues vals = new SQLRowValues(installedTable);
        vals.put(MODULE_VERSION_COLNAME, factory.getVersion().getMerged());
        vals.put(MODULE_COLNAME, factory.getID());
        for (String string : ctxt.getAddedTables()) {
            vals.put(TABLE_COLNAME, string).put(FIELD_COLNAME, null).insert();
            t = ctxt.getRoot().findTable(string);
            if (t == null) {
                throw new IllegalStateException("Unable to find added table " + string + " in root " + ctxt.getRoot().getName());
            }
            for (SQLField field : t.getFields()) {
                vals.put(TABLE_COLNAME, string).put(FIELD_COLNAME, field.getName()).put(ISKEY_COLNAME, field.isKey()).insert();
            }
            vals.remove(ISKEY_COLNAME);
        }
        for (SQLName sQLName : ctxt.getAddedFieldsToExistingTables()) {
            SQLField field;
            t = ctxt.getRoot().findTable(sQLName.getItem(0));
            field = t.getField(sQLName.getItem(1));
            vals.put(TABLE_COLNAME, t.getName()).put(FIELD_COLNAME, field.getName()).put(ISKEY_COLNAME, field.isKey()).insert();
        }
        vals.remove(ISKEY_COLNAME);
        SQLRow moduleRow = this.setDBInstalledModule(factory.getReference(), true);
        SQLTable sQLTable = this.getDepTable();
        sQLTable.getDBSystemRoot().getDataSource().execute("DELETE FROM " + sQLTable.getSQLName().quote() + " WHERE " + new Where((FieldRef)sQLTable.getField(NEEDING_MODULE_COLNAME), "=", moduleRow.getID()).getClause());
        sQLTable.fireTableModified(-1);
        SQLRowValues vals2 = new SQLRowValues(sQLTable).put(NEEDING_MODULE_COLNAME, moduleRow.getID());
        Map<ModuleReference, SQLRow> moduleRows = this.getDBInstalledModuleRowsByRef(null);
        for (ModuleFactory dep : graph.getDependencies(factory).values()) {
            vals2.put(NEEDED_MODULE_COLNAME, moduleRows.get(dep.getReference()).getID()).insertVerbatim();
        }
    }

    private void removeModuleFields(ModuleReference f) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        Where idW = new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)f.getID());
        installedTable.getDBSystemRoot().getDataSource().execute("DELETE FROM " + installedTable.getSQLName().quote() + " WHERE " + Where.isNotNull(installedTable.getField(TABLE_COLNAME)).and(idW).getClause());
        this.setDBInstalledModule(f, false);
        this.getDepTable().fireTableModified(-1);
    }

    final List<ModuleReference> getDBRequiredModules() throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        AliasedTable installedTableVers = new AliasedTable(installedTable, "vers");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(installedTable.getField(MODULE_COLNAME));
        sel.addJoin("INNER", new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", installedTableVers.getField(MODULE_COLNAME)).and(this.getModuleRowWhere(installedTableVers)));
        sel.addSelect(installedTableVers.getField(MODULE_VERSION_COLNAME));
        Where tableCreated = Where.isNotNull(installedTable.getField(TABLE_COLNAME)).and(Where.isNull(installedTable.getField(FIELD_COLNAME)));
        Where keyCreated = Where.isNotNull(installedTable.getField(FIELD_COLNAME)).and(new Where((FieldRef)installedTable.getField(ISKEY_COLNAME), "=", (Object)Boolean.TRUE));
        sel.setWhere(tableCreated.or(keyCreated));
        sel.addGroupBy(installedTable.getField(MODULE_COLNAME));
        sel.addGroupBy(installedTableVers.getField(MODULE_VERSION_COLNAME));
        List maps = installedTable.getDBSystemRoot().getDataSource().execute(sel.asString());
        ArrayList<ModuleReference> res = new ArrayList<ModuleReference>(maps.size());
        for (Map m : maps) {
            String moduleID = (String)m.get(MODULE_COLNAME);
            ModuleVersion vers = new ModuleVersion(((Number)m.get(MODULE_VERSION_COLNAME)).longValue());
            res.add(new ModuleReference(moduleID, vers));
        }
        L.config("getDBRequiredModules() found " + res);
        return res;
    }

    private void install(final AbstractModule module, final DepSolverGraph graph) throws Exception {
        assert (Thread.holdsLock(this));
        final ModuleFactory factory = module.getFactory();
        final ModuleVersion localVersion = this.getModuleVersionInstalledLocally(factory.getID());
        final ModuleVersion lastInstalledVersion = this.getDBInstalledModuleVersion(factory.getID());
        ModuleVersion moduleVersion = module.getFactory().getVersion();
        final boolean dbOK = moduleVersion.equals(lastInstalledVersion);
        if (!dbOK && !this.currentUserIsAdmin()) {
            throw new IllegalStateException("Not allowed to install " + module.getFactory() + " in the database");
        }
        if (lastInstalledVersion != null && moduleVersion.compareTo(lastInstalledVersion) < 0) {
            throw new IllegalArgumentException("Module older than the one installed in the DB : " + moduleVersion + " < " + lastInstalledVersion);
        }
        if (localVersion != null && moduleVersion.compareTo(localVersion) < 0) {
            throw new IllegalArgumentException("Module older than the one installed locally : " + moduleVersion + " < " + localVersion);
        }
        if (!moduleVersion.equals(localVersion) || !dbOK) {
            File backupDir;
            final File localDir = this.getLocalDirectory(factory.getID());
            if (localDir.exists()) {
                backupDir = FileUtils.addSuffix(localDir, ".backup");
                FileUtils.rm_R(backupDir);
                FileUtils.copyDirectory(localDir, backupDir);
            } else {
                backupDir = null;
                FileUtils.mkdir_p(localDir);
            }
            assert (localDir.exists());
            try {
                SQLUtils.executeAtomic(this.getDS(), new ConnectionHandlerNoSetup<Object, IOException>(){

                    @Override
                    public Object handle(SQLDataSource ds) throws SQLException, IOException {
                        Tuple2<Set<String>, Set<SQLName>> alreadyCreatedItems = ModuleManager.this.getCreatedItems(factory.getID());
                        DBContext ctxt = new DBContext(localDir, localVersion, ModuleManager.this.getRoot(), lastInstalledVersion, alreadyCreatedItems.get0(), alreadyCreatedItems.get1());
                        module.install(ctxt);
                        if (!localDir.exists()) {
                            throw new IOException("Modules shouldn't remove their directory");
                        }
                        if (!dbOK) {
                            ctxt.execute();
                        }
                        ModuleManager.this.updateModuleFields(factory, graph, ctxt);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                File failed;
                if (this.getRoot().getServer().getSQLSystem() == SQLSystem.MYSQL) {
                    L.warning("MySQL cannot rollback DDL statements");
                }
                if ((failed = FileUtils.addSuffix(localDir, ".failed")).exists() && !FileUtils.rmR(failed)) {
                    L.warning("Couldn't remove " + failed);
                }
                if (!localDir.renameTo(failed)) {
                    L.warning("Couldn't move " + localDir + " to " + failed);
                } else {
                    assert (!localDir.exists());
                    if (backupDir != null && !backupDir.renameTo(localDir)) {
                        L.warning("Couldn't restore " + backupDir + " to " + localDir);
                    }
                }
                throw e;
            }
            assert (localDir.exists());
            if (backupDir != null) {
                FileUtils.rm_R(backupDir);
            }
            this.setModuleInstalledLocally(factory.getReference(), true);
        }
        assert (moduleVersion.equals(this.getModuleVersionInstalledLocally(factory.getID())) && moduleVersion.equals(this.getDBInstalledModuleVersion(factory.getID())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSQLElements(AbstractModule module) throws IOException {
        ModuleReference id = module.getFactory().getReference();
        Map<ModuleReference, IdentityHashMap<SQLElement, SQLElement>> map = this.modulesElements;
        synchronized (map) {
            if (!this.modulesElements.containsKey(id)) {
                String mdVariant = ModuleManager.getMDVariant(module.getFactory());
                Set<SQLTable> tablesWithMD = this.loadTranslations(this.getConf().getTranslator(), module, mdVariant);
                SQLElementDirectory dir = this.getDirectory();
                HashMap<SQLTable, SQLElement> beforeElements = new HashMap<SQLTable, SQLElement>(dir.getElementsMap());
                module.setupElements(dir);
                IdentityHashMap<SQLElement, SQLElement> elements = new IdentityHashMap<SQLElement, SQLElement>();
                IdentityHashSet beforeElementsSet = new IdentityHashSet(beforeElements.values());
                IdentityHashSet<SQLElement> afterElementsSet = new IdentityHashSet<SQLElement>(dir.getElements());
                for (SQLElement elem : afterElementsSet) {
                    if (beforeElementsSet.contains(elem)) continue;
                    if (!(elem instanceof ModuleElement)) {
                        L.warning("Module added an element that isn't a ModuleElement : " + elem);
                    }
                    if (beforeElements.containsKey(elem.getTable())) {
                        SQLElement replacedElem = (SQLElement)beforeElements.get(elem.getTable());
                        boolean codeSafe = replacedElem.getClass().isInstance(elem);
                        boolean mngrSafe = this.isMngrSafe(module, replacedElem);
                        if (codeSafe && mngrSafe) {
                            elements.put(elem, replacedElem);
                            continue;
                        }
                        ArrayList<String> pbs = new ArrayList<String>(2);
                        if (!codeSafe) {
                            pbs.add(elem + " isn't a subclass of " + replacedElem);
                        }
                        if (!mngrSafe) {
                            pbs.add(module + " doesn't depend on " + replacedElem);
                        }
                        L.warning("Trying to replace element for " + elem.getTable() + " with " + elem + " but\n" + CollectionUtils.join(pbs, "\n"));
                        dir.addSQLElement(replacedElem);
                        continue;
                    }
                    elements.put(elem, null);
                }
                for (SQLTable tableWithDoc : tablesWithMD) {
                    boolean already;
                    SQLElement sqlElem = this.getDirectory().getElement(tableWithDoc);
                    if (sqlElem == null) {
                        throw new IllegalStateException("Missing element for table with metadata : " + tableWithDoc);
                    }
                    boolean bl = already = sqlElem instanceof ModuleElement && ((ModuleElement)sqlElem).getFactory() == module.getFactory();
                    if (already) continue;
                    sqlElem.addToMDPath(mdVariant);
                }
                this.modulesElements.put(id, elements);
            }
        }
    }

    private boolean isMngrSafe(AbstractModule module, SQLElement replacedElem) {
        boolean mngrSafe;
        ModuleReference moduleForElement = this.getModuleForElement(replacedElem);
        if (moduleForElement == null) {
            mngrSafe = true;
        } else {
            ModuleFactory replacedFactory = this.factories.getFactory(moduleForElement);
            mngrSafe = this.dependencyGraph.containsEdge(module.getFactory(), replacedFactory);
        }
        return mngrSafe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ModuleReference getModuleForElement(SQLElement elem) {
        Map<ModuleReference, IdentityHashMap<SQLElement, SQLElement>> map = this.modulesElements;
        synchronized (map) {
            for (Map.Entry<ModuleReference, IdentityHashMap<SQLElement, SQLElement>> e : this.modulesElements.entrySet()) {
                IdentityHashMap<SQLElement, SQLElement> map2 = e.getValue();
                assert (map2 instanceof IdentityHashMap) : "identity needed but got " + map2.getClass();
                if (!map2.containsKey(elem)) continue;
                return e.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<ModuleReference> getRegisteredModules() {
        Map<ModuleReference, IdentityHashMap<SQLElement, SQLElement>> map = this.modulesElements;
        synchronized (map) {
            return new HashSet<ModuleReference>(this.modulesElements.keySet());
        }
    }

    private void setupComponents(AbstractModule module, Tuple2<Set<String>, Set<SQLName>> alreadyCreatedItems, MenuAndActions ma) throws SQLException {
        assert (SwingUtilities.isEventDispatchThread());
        String id = module.getFactory().getID();
        if (!this.modulesComponents.containsKey(id)) {
            SQLElementDirectory dir = this.getDirectory();
            ComponentsContext ctxt = new ComponentsContext(dir, this.getRoot(), alreadyCreatedItems.get0(), alreadyCreatedItems.get1());
            module.setupComponents(ctxt);
            TranslationManager.getInstance().addTranslationStreamFromClass(module.getClass());
            this.setupMenu(module, ma);
            this.modulesComponents.put(id, ctxt);
        }
    }

    final List<ModuleReference> getAdminRequiredModules() throws IOException {
        return this.getAdminRequiredModules(false);
    }

    final List<ModuleReference> getAdminRequiredModules(boolean refresh) throws IOException {
        Preferences prefs = this.getRequiredIDsPrefs();
        if (refresh) {
            try {
                prefs.sync();
            }
            catch (BackingStoreException e) {
                throw new IOException("Couldn't sync preferences", e);
            }
        }
        List<ModuleReference> res = ModuleManager.getRefs(prefs);
        L.config("getAdminRequiredModules() found " + res);
        return res;
    }

    private final boolean isAdminRequired(ModuleReference ref) {
        long version = ref.getVersion().getMerged();
        assert (version >= MIN_VERSION);
        return version == this.getRequiredIDsPrefs().getLong(ref.getID(), MIN_VERSION - 1L);
    }

    final void setAdminRequiredModules(Set<ModuleReference> refs, boolean required) throws BackingStoreException {
        Set emptySet = Collections.emptySet();
        this.setAdminRequiredModules(required ? refs : emptySet, !required ? refs : emptySet);
    }

    final void setAdminRequiredModules(Set<ModuleReference> requiredRefs, Set<ModuleReference> notRequiredRefs) throws BackingStoreException {
        if (requiredRefs.size() + notRequiredRefs.size() == 0) {
            return;
        }
        if (!this.currentUserIsAdmin()) {
            throw new IllegalStateException("Not allowed to not require " + notRequiredRefs + " and to require " + requiredRefs);
        }
        Preferences prefs = this.getRequiredIDsPrefs();
        ModuleManager.putRefs(prefs, requiredRefs);
        for (ModuleReference ref : notRequiredRefs) {
            prefs.remove(ref.getID());
        }
        prefs.sync();
    }

    public final void startRequiredModules() throws Exception {
        this.startModules(this.getAdminRequiredModules(), NoChoicePredicate.NO_CHANGE, false);
    }

    private static final List<ModuleReference> getRefs(Preferences prefs) throws IOException {
        String[] ids;
        try {
            ids = prefs.keys();
        }
        catch (BackingStoreException e) {
            throw new IOException("Couldn't access preferences", e);
        }
        ArrayList<ModuleReference> refs = new ArrayList<ModuleReference>(ids.length);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            long merged = prefs.getLong(id = stringArray[n2], MIN_VERSION - 1L);
            refs.add(new ModuleReference(id, merged < MIN_VERSION ? null : new ModuleVersion(merged)));
            ++n2;
        }
        return refs;
    }

    private static final void putRefs(Preferences prefs, Collection<ModuleReference> refs) throws BackingStoreException {
        for (ModuleReference ref : refs) {
            prefs.putLong(ref.getID(), ref.getVersion().getMerged());
        }
        prefs.flush();
    }

    public final void startPreviouslyRunningModules() throws Exception {
        List<ModuleReference> ids = ModuleManager.getRefs(this.getRunningIDsPrefs());
        L.config("startPreviouslyRunningModules() found " + ids);
        this.startModules(ids, NoChoicePredicate.ONLY_INSTALL_ARGUMENTS, false);
    }

    public final boolean startModule(String id) throws Exception {
        return this.startModule(id, true);
    }

    public final boolean startModule(String id, boolean persistent) throws Exception {
        return this.startModule(new ModuleReference(id, null), persistent);
    }

    public final boolean startModule(ModuleReference id, boolean persistent) throws Exception {
        return this.startModule(id, NoChoicePredicate.ONLY_INSTALL_ARGUMENTS, persistent);
    }

    public final boolean startModule(ModuleReference id, NoChoicePredicate noChoicePredicate, boolean persistent) throws Exception {
        Set<ModuleReference> notStarted = this.startModules(Collections.singleton(id), noChoicePredicate, persistent);
        boolean res = notStarted.isEmpty();
        assert (res == this.runningModules.containsKey(id.getID()));
        return res;
    }

    public final synchronized Set<ModuleReference> startModules(Collection<ModuleReference> ids, NoChoicePredicate noChoicePredicate, boolean persistent) throws Exception {
        return this.createModules(ids, noChoicePredicate, ModuleState.STARTED, persistent).get1().getNotCreated();
    }

    synchronized Set<ModuleReference> setPersistentModules(Collection<ModuleReference> ids) throws BackingStoreException {
        Map<String, ModuleVersion> modulesInstalled = null;
        HashSet<ModuleReference> toSet = new HashSet<ModuleReference>();
        for (ModuleReference ref : ids) {
            ModuleReference installedRef;
            AbstractModule m = this.runningModules.get(ref.getID());
            if (m != null) {
                installedRef = m.getFactory().getReference();
            } else {
                if (modulesInstalled == null) {
                    modulesInstalled = this.getModulesVersionInstalledLocally();
                }
                installedRef = new ModuleReference(ref.getID(), modulesInstalled.get(ref.getID()));
            }
            if (installedRef.getVersion() == null) continue;
            toSet.add(installedRef);
        }
        ModuleManager.putRefs(this.getRunningIDsPrefs(), toSet);
        return toSet;
    }

    private final Tuple3<FactoriesByID, List<ModuleReference>, SetMap<InvalidRef, ModuleReference>> resolveRefs(Collection<ModuleReference> refs) {
        HashSet<ModuleReference> refsSet = new HashSet<ModuleReference>(refs);
        HashSet<String> nonNullVersions = new HashSet<String>();
        for (ModuleReference ref : refsSet) {
            if (ref.getVersion() == null) continue;
            nonNullVersions.add(ref.getID());
        }
        ArrayList<ModuleFactory> factories = new ArrayList<ModuleFactory>();
        ArrayList<ModuleReference> atLeast1 = new ArrayList<ModuleReference>();
        Iterator iter = refsSet.iterator();
        while (iter.hasNext()) {
            ModuleReference ref = (ModuleReference)iter.next();
            if (ref.getVersion() == null && nonNullVersions.contains(ref.getID())) {
                iter.remove();
                continue;
            }
            List<ModuleFactory> factoriesForRef = this.factories.getFactories(ref);
            int size = factoriesForRef.size();
            if (size <= 0) continue;
            iter.remove();
            atLeast1.add(ref);
            if (size != 1) continue;
            factories.add(factoriesForRef.get(0));
        }
        SetMap<InvalidRef, ModuleReference> invalidRefs = new SetMap<InvalidRef, ModuleReference>(CollectionMap2.Mode.NULL_FORBIDDEN);
        invalidRefs.putCollection(InvalidRef.NO_FACTORY, (Collection<ModuleReference>)refsSet);
        FactoriesByID fByID = this.copyFactories();
        Set<ModuleFactory> conflicts = fByID.getConflicts(factories);
        Collection<ModuleFactory> selfConflicts = CollectionUtils.intersection(factories, conflicts);
        for (ModuleFactory f : selfConflicts) {
            invalidRefs.add(InvalidRef.SELF_CONFLICT, f.getReference());
            atLeast1.remove(f.getReference());
        }
        fByID.removeAll(conflicts);
        fByID.addAll(this.dependencyGraph.vertexSet());
        return Tuple3.create(fByID, atLeast1, invalidRefs);
    }

    private final synchronized DepSolver createSolver(int maxCount, final NoChoicePredicate s, final Collection<ModuleReference> ids) throws Exception {
        final InstallationState installState = new InstallationState(this);
        DepSolver depSolver = new DepSolver().setMaxSuccess(maxCount);
        depSolver.setResultFactory(new DepSolverResult.Factory(){

            @Override
            public DepSolverResult create(DepSolverResult parent, int tryCount, String error, DepSolverGraph graph) {
                DepSolverResultMM res = new DepSolverResultMM((DepSolverResultMM)parent, tryCount, error, graph);
                res.init(ModuleManager.this, installState, s, ids);
                return res;
            }
        });
        depSolver.setResultPredicate(DepSolverResultMM.VALID_PRED);
        return depSolver;
    }

    final synchronized Tuple2<Solutions, ModulesStateChangeResult> createModules(Collection<ModuleReference> ids, NoChoicePredicate s, ModuleState targetState) throws Exception {
        return this.createModules(ids, s, targetState, this.checkPersistentNeeded(targetState));
    }

    private boolean checkPersistentNeeded(ModuleState targetState) {
        if (targetState.compareTo(ModuleState.STARTED) >= 0) {
            throw new IllegalArgumentException("For STARTED the persistent parameter must be supplied");
        }
        return false;
    }

    final synchronized Tuple2<Solutions, ModulesStateChangeResult> createModules(Collection<ModuleReference> ids, NoChoicePredicate s, ModuleState targetState, boolean startPersistent) throws Exception {
        if (s == null) {
            throw new NullPointerException();
        }
        if (ids.size() == 0 || targetState == ModuleState.NOT_CREATED) {
            return Tuple2.create(Solutions.EMPTY, ModulesStateChangeResult.empty());
        }
        DepSolver depSolver = this.createSolver(1, s, ids);
        Solutions solutions = this.getSolutions(depSolver, ids);
        SetMap<InvalidRef, ModuleReference> cannotCreate = solutions.getNotSolvedReferences();
        ModulesStateChangeResult changeRes = cannotCreate != null && !cannotCreate.isEmpty() ? ModulesStateChangeResult.noneCreated(new HashSet<ModuleReference>(ids)) : this.applyChange((DepSolverResultMM)solutions.getSolutions().get(0), targetState, startPersistent);
        return Tuple2.create(solutions, changeRes);
    }

    final synchronized Solutions getSolutions(Collection<ModuleReference> ids, int maxCount) throws Exception {
        return this.getSolutions(this.createSolver(maxCount, null, ids), ids);
    }

    private final synchronized Solutions getSolutions(DepSolver depSolver, Collection<ModuleReference> ids) throws Exception {
        if (ids.size() == 0) {
            return Solutions.EMPTY;
        }
        Tuple3<FactoriesByID, List<ModuleReference>, SetMap<InvalidRef, ModuleReference>> resolvedRefs = this.resolveRefs(ids);
        FactoriesByID pool = (FactoriesByID)resolvedRefs.get0();
        List atLeast1 = (List)resolvedRefs.get1();
        SetMap<InvalidRef, ModuleReference> invalidRefs = resolvedRefs.get2();
        List<Object> solutions = atLeast1.isEmpty() ? Collections.emptyList() : depSolver.solve(pool, this.dependencyGraph, atLeast1);
        if (solutions.size() == 0) {
            invalidRefs.putCollection(InvalidRef.NO_SOLUTION, atLeast1);
        }
        invalidRefs.removeAllEmptyCollections();
        return new Solutions(invalidRefs, solutions.size() == 0 ? Collections.emptyList() : atLeast1, solutions);
    }

    final synchronized ModulesStateChangeResult applyChange(ModulesStateChange change, ModuleState targetState) throws Exception {
        return this.applyChange(change, targetState, this.checkPersistentNeeded(targetState));
    }

    final synchronized ModulesStateChangeResult applyChange(ModulesStateChange change, ModuleState targetState, boolean startPersistent) throws Exception {
        Set<ModuleReference> removed;
        if (change == null || change.getError() != null) {
            return null;
        }
        if (!new InstallationState(this).equals(change.getInstallState())) {
            throw new IllegalStateException("Installation state has changed since getSolutions()");
        }
        Set<ModuleReference> toRemove = change.getReferencesToRemove();
        if (toRemove.size() > 0) {
            Map<String, ModuleVersion> dbVersions = this.getDBInstalledModules();
            removed = new HashSet();
            for (ModuleReference ref : toRemove) {
                if (!this.uninstallUnsafe(ref, !change.forceRemove(), dbVersions)) continue;
                removed.add(ref);
            }
        } else {
            removed = Collections.emptySet();
        }
        if (this.isExitAllowed() && this.needExit(change)) {
            assert (ModuleManager.noDisplayableFrame());
            Set<ModuleReference> toInstall = change.getReferencesToInstall();
            if (toInstall.size() > 0 || targetState.compareTo(ModuleState.INSTALLED) > 0 && change.getUserReferencesToInstall().size() > 0) {
                File f = this.getToInstallFile();
                XMLEncoder xmlEncoder = new XMLEncoder(new FileOutputStream(f));
                try {
                    xmlEncoder.setExceptionListener(XMLCodecUtils.EXCEPTION_LISTENER);
                    xmlEncoder.setPersistenceDelegate(ModuleVersion.class, ModuleVersion.PERSIST_DELEGATE);
                    xmlEncoder.setPersistenceDelegate(ModuleReference.class, ModuleReference.PERSIST_DELEGATE);
                    xmlEncoder.writeObject(TO_INSTALL_VERSION);
                    xmlEncoder.writeObject(new Date());
                    xmlEncoder.writeObject(toInstall);
                    xmlEncoder.writeObject(change.getUserReferencesToInstall());
                    xmlEncoder.writeObject((Object)targetState);
                    xmlEncoder.writeObject(startPersistent);
                    xmlEncoder.close();
                }
                catch (Exception e) {
                    try {
                        xmlEncoder.close();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    f.delete();
                    throw e;
                }
            }
            return ModulesStateChangeResult.onlyRemoved(removed);
        }
        if (targetState.compareTo(ModuleState.CREATED) < 0) {
            return ModulesStateChangeResult.onlyRemoved(removed);
        }
        DepSolverGraph graph = change.getGraph();
        if (graph == null) {
            throw new IllegalArgumentException("target state is " + (Object)((Object)targetState) + " but no graph was provided");
        }
        LinkedHashMap<ModuleReference, AbstractModule> modules = new LinkedHashMap<ModuleReference, AbstractModule>(graph.getFactories().size());
        Set<ModuleReference> cannotCreate = Collections.emptySet();
        ArrayList<AbstractModule> toStart = new ArrayList<AbstractModule>();
        for (ModuleFactory useableFactory : graph.flatten()) {
            String id = useableFactory.getID();
            if (!this.dependencyGraph.containsVertex(useableFactory)) {
                Map<Object, ModuleFactory> dependenciesFactory = graph.getDependencies(useableFactory);
                HashMap<Object, AbstractModule> dependenciesModule = new HashMap<Object, AbstractModule>(dependenciesFactory.size());
                for (Map.Entry<Object, ModuleFactory> e : dependenciesFactory.entrySet()) {
                    AbstractModule module = this.createdModules.get(e.getValue());
                    assert (module != null);
                    dependenciesModule.put(e.getKey(), module);
                }
                AbstractModule createdModule = useableFactory.createModule(this.getLocalDirectory(id), Collections.unmodifiableMap(dependenciesModule));
                modules.put(useableFactory.getReference(), createdModule);
                this.createdModules.put(useableFactory, createdModule);
                boolean added = this.dependencyGraph.addVertex(useableFactory);
                assert (added) : "Module was already in graph : " + useableFactory;
                for (Map.Entry<Object, ModuleFactory> e : dependenciesFactory.entrySet()) {
                    this.dependencyGraph.addEdge(useableFactory, e.getKey(), e.getValue());
                }
            }
            if (this.runningModules.containsKey(id)) continue;
            toStart.add(this.createdModules.get(useableFactory));
        }
        if (targetState.compareTo(ModuleState.INSTALLED) >= 0) {
            for (AbstractModule module : toStart) {
                this.installAndRegister(module, graph);
            }
            if (targetState == ModuleState.STARTED) {
                this.start(toStart);
                if (startPersistent) {
                    this.setPersistentModules(change.getUserReferencesToInstall());
                }
            }
        }
        return new ModulesStateChangeResult(removed, cannotCreate, graph, modules);
    }

    final synchronized void startFactories(List<ModuleFactory> toStart) throws Exception {
        ArrayList<AbstractModule> modules = new ArrayList<AbstractModule>(toStart.size());
        for (ModuleFactory f : toStart) {
            AbstractModule m = this.createdModules.get(f);
            if (m == null) {
                throw new IllegalStateException("Not created : " + f);
            }
            if (this.isModuleRunning(f.getID())) continue;
            modules.add(m);
        }
        this.start(modules);
    }

    private final synchronized void start(List<AbstractModule> toStart) throws Exception {
        if (toStart.size() == 0) {
            return;
        }
        Set<ModuleReference> registeredModules = this.getRegisteredModules();
        for (AbstractModule m : toStart) {
            ModuleReference ref = m.getFactory().getReference();
            if (registeredModules.contains(ref)) continue;
            throw new IllegalStateException("Not installed and registered : " + ref);
        }
        final FutureTask<MenuAndActions> menuAndActions = new FutureTask<MenuAndActions>(new Callable<MenuAndActions>(){

            @Override
            public MenuAndActions call() throws Exception {
                return MenuManager.getInstance().copyMenuAndActions();
            }
        });
        SwingThreadUtils.invoke(menuAndActions);
        for (final AbstractModule module : toStart) {
            final ModuleFactory f = module.getFactory();
            String id = f.getID();
            try {
                assert (!this.runningModules.containsKey(id)) : "Doing a request for nothing";
                final Tuple2<Set<String>, Set<SQLName>> createdItems = this.getCreatedItems(id);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.startModule(module, createdItems, menuAndActions.get());
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ModuleManager.this.startModule(module, createdItems, (MenuAndActions)menuAndActions.get());
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle(MainFrame.getInstance(), "Unable to start " + f, e);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new Exception("Couldn't start module " + module, e);
            }
            this.runningModules.put(id, module);
        }
        SwingThreadUtils.invoke(new Runnable(){

            @Override
            public void run() {
                try {
                    MenuManager.getInstance().setMenuAndActions((MenuAndActions)menuAndActions.get());
                }
                catch (Exception e) {
                    ExceptionHandler.handle(MainFrame.getInstance(), "Unable to update menu", e);
                }
            }
        });
    }

    private final Set<SQLTable> loadTranslations(SQLFieldTranslator trns, AbstractModule module, String mdVariant) throws IOException {
        Locale locale = TM.getInstance().getTranslationsLocale();
        ResourceBundle.Control cntrl = TranslationManager.getControl();
        String baseName = "labels";
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        boolean found = false;
        Locale targetLocale = locale;
        while (targetLocale != null && !found) {
            List<Locale> langs = cntrl.getCandidateLocales("labels", targetLocale);
            ListIterator<Locale> listIterator = CollectionUtils.getListIterator(langs, true);
            while (listIterator.hasNext()) {
                Set<SQLTable> loadedTables;
                Locale lang = listIterator.next();
                String resourceName = cntrl.toResourceName(cntrl.toBundleName("labels", lang), "xml");
                InputStream ins = module.getClass().getResourceAsStream(resourceName);
                if (ins == null) continue;
                L.config("module " + module.getName() + " loading translation from " + resourceName);
                try {
                    loadedTables = trns.load(this.getRoot(), mdVariant, ins).get0();
                }
                finally {
                    ins.close();
                }
                if (loadedTables.size() <= 0) continue;
                res.addAll(loadedTables);
                found |= true;
            }
            targetLocale = cntrl.getFallbackLocale("labels", targetLocale);
        }
        return res;
    }

    private final void installAndRegister(AbstractModule module, DepSolverGraph graph) throws Exception {
        assert (Thread.holdsLock(this));
        assert (!this.isModuleRunning(module.getFactory().getID()));
        try {
            this.install(module, graph);
        }
        catch (Exception e) {
            throw new Exception("Couldn't install module " + module, e);
        }
        try {
            this.registerSQLElements(module);
        }
        catch (Exception e) {
            throw new Exception("Couldn't register module " + module, e);
        }
    }

    private final void startModule(AbstractModule module, Tuple2<Set<String>, Set<SQLName>> createdItems, MenuAndActions menuAndActions) throws Exception {
        assert (SwingUtilities.isEventDispatchThread());
        this.setupComponents(module, createdItems, menuAndActions);
        module.start();
    }

    private final void setupMenu(AbstractModule module, MenuAndActions menuAndActions) {
        module.setupMenu(new MenuContext(menuAndActions, module.getFactory().getID(), this.getDirectory(), this.getRoot()));
    }

    public final synchronized boolean isModuleRunning(String id) {
        return this.runningModules.containsKey(id);
    }

    public final synchronized Map<String, AbstractModule> getRunningModules() {
        return new HashMap<String, AbstractModule>(this.runningModules);
    }

    public final synchronized List<ModuleReference> getRunningDependentModulesRecursively(String id) {
        if (!this.isModuleRunning(id)) {
            return Collections.emptyList();
        }
        ModuleFactory f = this.runningModules.get(id).getFactory();
        return this.getRunningDependentModulesRecursively(f.getReference(), new LinkedList<ModuleReference>());
    }

    private final synchronized List<ModuleReference> getRunningDependentModulesRecursively(ModuleReference ref, List<ModuleReference> res) {
        if (!res.contains(ref) && this.isModuleRunning(ref.getID())) {
            ModuleFactory f = this.runningModules.get(ref.getID()).getFactory();
            TreeSet<ModuleReference> deps = new TreeSet<ModuleReference>(ModuleReference.COMP_ID_ASC_VERSION_DESC);
            for (DirectedEdge e : this.dependencyGraph.incomingEdgesOf(f)) {
                deps.add(((ModuleFactory)e.getSource()).getReference());
            }
            for (ModuleReference dep : deps) {
                this.getRunningDependentModulesRecursively(dep, res);
            }
            res.add(f.getReference());
        }
        return res;
    }

    public final synchronized void stopModuleRecursively(String id) {
        for (ModuleReference ref : this.getRunningDependentModulesRecursively(id)) {
            this.stopModule(ref.getID());
        }
    }

    public final void stopModule(String id) {
        this.stopModule(id, true);
    }

    public final synchronized void stopModule(String id, boolean persistent) {
        if (!this.isModuleRunning(id)) {
            return;
        }
        final ModuleFactory f = this.runningModules.get(id).getFactory();
        if (this.isAdminRequired(f.getReference()) && !this.currentUserIsAdmin()) {
            throw new IllegalStateException("Not allowed to stop a module required by the administrator " + f);
        }
        Set deps = this.dependencyGraph.incomingEdgesOf(f);
        for (DepLink l : deps) {
            if (!this.isModuleRunning(((ModuleFactory)l.getSource()).getID())) continue;
            throw new IllegalArgumentException("Some dependents still running : " + deps);
        }
        final AbstractModule m = this.runningModules.remove(id);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.stopModule(m);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ModuleManager.this.stopModule(m);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle(MainFrame.getInstance(), "Unable to stop " + f, e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't stop module " + m, e);
        }
        final MenuAndActions menuAndActions = MenuManager.getInstance().createBaseMenuAndActions();
        final ArrayList<AbstractModule> modules = new ArrayList<AbstractModule>(this.runningModules.values());
        SwingThreadUtils.invoke(new Runnable(){

            @Override
            public void run() {
                for (AbstractModule m : modules) {
                    ModuleManager.this.setupMenu(m, menuAndActions);
                }
                MenuManager.getInstance().setMenuAndActions(menuAndActions);
            }
        });
        if (persistent) {
            this.getRunningIDsPrefs().remove(m.getFactory().getID());
        }
        assert (!this.isModuleRunning(id));
    }

    private final void stopModule(AbstractModule m) {
        assert (SwingUtilities.isEventDispatchThread());
        m.stop();
        this.tearDownComponents(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterSQLElements(AbstractModule module) {
        ModuleReference id = module.getFactory().getReference();
        Map<ModuleReference, IdentityHashMap<SQLElement, SQLElement>> map = this.modulesElements;
        synchronized (map) {
            if (this.modulesElements.containsKey(id)) {
                IdentityHashMap<SQLElement, SQLElement> elements = this.modulesElements.remove(id);
                SQLElementDirectory dir = this.getDirectory();
                for (Map.Entry<SQLElement, SQLElement> e : elements.entrySet()) {
                    dir.removeSQLElement(e.getKey());
                    if (e.getValue() == null) continue;
                    dir.addSQLElement(e.getValue());
                }
                String mdVariant = ModuleManager.getMDVariant(module.getFactory());
                for (SQLElement elem : this.getDirectory().getElements()) {
                    elem.removeFromMDPath(mdVariant);
                }
                this.getConf().getTranslator().removeDescFor(null, null, mdVariant, null);
            }
        }
    }

    private void tearDownComponents(AbstractModule module) {
        assert (SwingUtilities.isEventDispatchThread());
        String id = module.getFactory().getID();
        if (this.modulesComponents.containsKey(id)) {
            ComponentsContext ctxt = this.modulesComponents.remove(id);
            for (Map.Entry e : ctxt.getFields().entrySet()) {
                for (String fieldName : (Collection)e.getValue()) {
                    ((SQLElement)e.getKey()).removeAdditionalField(fieldName);
                }
            }
            for (Map.Entry e : ctxt.getRowActions().entrySet()) {
                ((SQLElement)e.getKey()).getRowActions().removeAll((Collection)e.getValue());
            }
            TranslationManager.getInstance().removeTranslationStreamFromClass(module.getClass());
        }
    }

    private final List<ModuleReference> getDBDependentModules(ModuleReference ref) throws Exception {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        AliasedTable needingModule = new AliasedTable(installedTable, "needingModule");
        SQLTable depT = this.getDepTable();
        SQLSelect sel = new SQLSelect();
        sel.setWhere(this.getModuleRowWhere(installedTable).and(new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)ref.getID())));
        if (ref.getVersion() != null) {
            sel.andWhere(new Where((FieldRef)installedTable.getField(MODULE_VERSION_COLNAME), "=", (Object)ref.getVersion().getMerged()));
        }
        sel.addBackwardJoin("INNER", depT.getField(NEEDED_MODULE_COLNAME), null);
        sel.addJoin("INNER", new Where((FieldRef)depT.getField(NEEDING_MODULE_COLNAME), "=", needingModule.getKey()));
        sel.addSelect(needingModule.getKey());
        sel.addSelect(needingModule.getField(MODULE_COLNAME));
        sel.addSelect(needingModule.getField(MODULE_VERSION_COLNAME));
        List rows = installedTable.getDBSystemRoot().getDataSource().execute(sel.asString());
        ArrayList<ModuleReference> res = new ArrayList<ModuleReference>(rows.size());
        for (Map row : rows) {
            res.add(this.getRef(new SQLRow(needingModule.getTable(), row)));
        }
        return res;
    }

    private final synchronized Set<ModuleReference> getDependentModules(ModuleReference ref) throws Exception {
        TreeSet<ModuleReference> res = new TreeSet<ModuleReference>(ModuleReference.COMP_ID_ASC_VERSION_DESC);
        res.addAll(this.getDBDependentModules(ref));
        return res;
    }

    public final List<ModuleReference> getDependentModulesRecursively(ModuleReference ref) throws Exception {
        return this.getDependentModulesRecursively(ref, new ArrayList<ModuleReference>());
    }

    private final synchronized List<ModuleReference> getDependentModulesRecursively(ModuleReference ref, List<ModuleReference> res) throws Exception {
        for (ModuleReference depModule : this.getDependentModules(ref)) {
            if (res.contains(depModule)) continue;
            List<ModuleReference> depModules = this.getDependentModulesRecursively(depModule, res);
            assert (!depModules.contains(depModule)) : "cycle with " + depModule;
            res.add(depModule);
        }
        return res;
    }

    final synchronized LinkedHashSet<ModuleReference> getAllOrderedDependentModulesRecursively(Set<ModuleReference> ids) throws Exception {
        LinkedHashSet<ModuleReference> depModules = new LinkedHashSet<ModuleReference>();
        for (ModuleReference id : ids) {
            if (depModules.contains(id)) continue;
            depModules.addAll(this.getDependentModulesRecursively(id));
            depModules.add(id);
        }
        return depModules;
    }

    public final synchronized Set<ModuleReference> uninstall(Set<ModuleReference> ids, boolean recurse) throws Exception {
        return this.uninstall(ids, recurse, false);
    }

    public final synchronized Set<ModuleReference> uninstall(Set<ModuleReference> ids, boolean recurse, boolean force) throws Exception {
        return this.applyChange(this.getUninstallSolution(ids, recurse, force), ModuleState.NOT_CREATED).getRemoved();
    }

    public final synchronized ModulesStateChange getUninstallSolution(Set<ModuleReference> passedRefs, boolean recurse, final boolean force) throws Exception {
        Collection<ModuleReference> depModulesNotRequested;
        Set<Object> toRemove;
        final InstallationState installationState = new InstallationState(this);
        HashSet<ModuleReference> ids = new HashSet<ModuleReference>();
        for (ModuleReference ref : passedRefs) {
            if (ref.getVersion() == null) {
                throw new UnsupportedOperationException("Version needed for " + ref);
            }
            if (!installationState.getLocalOrRemote().contains(ref)) continue;
            ids.add(ref);
        }
        int size = ids.size();
        if (!recurse && size == 1) {
            Set<ModuleReference> depModules = this.getDependentModules((ModuleReference)ids.iterator().next());
            if (depModules.size() > 0) {
                throw new IllegalStateException("Dependent modules not uninstalled : " + depModules);
            }
            toRemove = ids;
        } else {
            toRemove = size > 0 ? this.getAllOrderedDependentModulesRecursively(ids) : Collections.emptySet();
        }
        if (!recurse && size > 1 && !(depModulesNotRequested = CollectionUtils.substract(toRemove, ids)).isEmpty()) {
            throw new IllegalStateException("Dependent modules not uninstalled : " + depModulesNotRequested);
        }
        return new ModulesStateChange(){

            @Override
            public String getError() {
                return null;
            }

            @Override
            public InstallationState getInstallState() {
                return installationState;
            }

            @Override
            public Set<ModuleReference> getUserReferencesToInstall() {
                return Collections.emptySet();
            }

            @Override
            public Set<ModuleReference> getReferencesToRemove() {
                return toRemove;
            }

            @Override
            public boolean forceRemove() {
                return force;
            }

            @Override
            public Set<ModuleReference> getReferencesToInstall() {
                return Collections.emptySet();
            }

            @Override
            public DepSolverGraph getGraph() {
                return null;
            }
        };
    }

    public final void uninstall(ModuleReference ref) throws Exception {
        this.uninstall(ref, false);
    }

    public final synchronized Set<ModuleReference> uninstall(ModuleReference id, boolean recurse) throws Exception {
        return this.uninstall(id, recurse, false);
    }

    public final synchronized Set<ModuleReference> uninstall(ModuleReference id, boolean recurse, boolean force) throws Exception {
        return this.uninstall(Collections.singleton(id), recurse, force);
    }

    private final ModuleVersion filter(ModuleVersion vers, ModuleReference ref) {
        return ref.getVersion() == null || vers != null && vers.equals(ref.getVersion()) ? vers : null;
    }

    private boolean uninstallUnsafe(ModuleReference mref, boolean requireModule, Map<String, ModuleVersion> dbVersions) throws SQLException, Exception {
        AbstractModule module;
        assert (Thread.holdsLock(this));
        final String id = mref.getID();
        if (dbVersions == null) {
            dbVersions = this.getDBInstalledModules();
        }
        final ModuleVersion localVersion = this.filter(this.getModuleVersionInstalledLocally(id), mref);
        final ModuleVersion dbVersion = this.filter(dbVersions.get(id), mref);
        this.getRunningIDsPrefs().remove(id);
        HashSet<ModuleReference> refs = new HashSet<ModuleReference>(2);
        if (localVersion != null) {
            refs.add(new ModuleReference(id, localVersion));
        }
        if (dbVersion != null) {
            refs.add(new ModuleReference(id, dbVersion));
        }
        this.setAdminRequiredModules(refs, false);
        if (localVersion == null && dbVersion == null) {
            return false;
        }
        if (dbVersion != null && !this.currentUserIsAdmin()) {
            throw new IllegalStateException("Not allowed to uninstall " + id + " from the database");
        }
        if (!this.isModuleRunning(id)) {
            if (dbVersion == null) {
                assert (localVersion != null);
                module = null;
            } else {
                SortedMap<ModuleVersion, ModuleFactory> moreRecent;
                SortedMap<ModuleVersion, ModuleFactory> available = this.factories.getVersions(id);
                Object ref = available.containsKey(dbVersion) ? new ModuleReference(id, dbVersion) : ((moreRecent = available.headMap(dbVersion)).size() == 0 ? null : new ModuleReference(id, moreRecent.lastKey()));
                if (ref != null) {
                    assert (((ModuleReference)ref).getVersion().compareTo(dbVersion) >= 0);
                    ModuleFactory f = (ModuleFactory)available.get(((ModuleReference)ref).getVersion());
                    assert (f != null);
                    if (!this.createdModules.containsKey(f)) {
                        this.createModules(Collections.singleton(ref), NoChoicePredicate.NO_CHANGE, ModuleState.CREATED);
                    }
                    module = this.createdModules.get(f);
                } else {
                    module = null;
                }
                if (module == null && requireModule) {
                    String reason = ref == null ? "No version recent enough to uninstall " + dbVersion + " : " + available.keySet() : "Creation of " + ref + " failed (e.g. missing factory, dependency)";
                    throw new IllegalStateException("Couldn't get module " + id + " : " + reason);
                }
            }
        } else {
            if (!localVersion.equals(dbVersion)) {
                L.warning("Someone else has changed the database version while we were running :" + localVersion + " != " + dbVersion);
            }
            module = this.runningModules.get(id);
            assert (localVersion.equals(module.getFactory().getVersion()));
            this.stopModule(id, false);
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(EMPTY_RUNNABLE);
            }
        }
        assert (module == null == (!requireModule || dbVersion == null));
        SQLUtils.executeAtomic(this.getDS(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                DBRoot root = ModuleManager.this.getRoot();
                if (module != null) {
                    module.uninstall(root);
                    ModuleManager.this.unregisterSQLElements(module);
                }
                if (localVersion != null) {
                    ModuleManager.this.setModuleInstalledLocally(new ModuleReference(id, localVersion), false);
                }
                if (dbVersion != null) {
                    Tuple2<Set<String>, Set<SQLName>> createdItems = ModuleManager.this.getCreatedItems(id);
                    ArrayList<ChangeTable> l = new ArrayList<ChangeTable>();
                    Set<String> tableNames = createdItems.get0();
                    for (SQLName field : createdItems.get1()) {
                        SQLField f = root.getDesc(field, SQLField.class);
                        if (tableNames.contains(f.getTable().getName())) continue;
                        l.add(new AlterTable(f.getTable()).dropColumnCascade(f.getName()));
                    }
                    for (String table : tableNames) {
                        l.add(new DropTable(root.getTable(table)));
                    }
                    if (l.size() > 0) {
                        for (String s : ChangeTable.cat(l, root.getName())) {
                            root.getDBSystemRoot().getDataSource().execute(s);
                        }
                        root.getSchema().updateVersion();
                        root.refetch();
                    }
                    ModuleManager.this.removeModuleFields(new ModuleReference(id, dbVersion));
                }
                return null;
            }
        });
        return true;
    }

    public static enum InvalidRef {
        NO_FACTORY,
        SELF_CONFLICT,
        NO_SOLUTION;

    }

    static enum ModuleAction {
        INSTALL,
        START,
        STOP,
        UNINSTALL;

    }

    public static enum ModuleState {
        NOT_CREATED,
        CREATED,
        INSTALLED,
        REGISTERED,
        STARTED;

    }

    static enum NoChoicePredicate {
        NO_CHANGE,
        ONLY_INSTALL_ARGUMENTS,
        ONLY_INSTALL;

    }
}

