/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.modules.AlterTableRestricted;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.DropTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.cc.IClosure;

public final class DBContext {
    private final File dir;
    private final ModuleVersion localVersion;
    private final ModuleVersion lastInstalledVersion;
    private final DBRoot root;
    private final List<ChangeTable<?>> changeTables;
    private final List<AlterTableRestricted> alterTables;
    private final List<IClosure<? super DBRoot>> dm;
    private final Set<String> tables;
    private final SetMap<String, SQLField> fields;

    DBContext(File dir, ModuleVersion localVersion, DBRoot root, ModuleVersion dbVersion, Set<String> tables, Set<SQLName> fields) {
        this.dir = dir;
        this.localVersion = localVersion;
        this.lastInstalledVersion = dbVersion;
        this.root = root;
        this.tables = Collections.unmodifiableSet(tables);
        this.fields = new SetMap();
        for (SQLName f : fields) {
            String tableName = f.getItem(0);
            this.fields.add(tableName, this.root.getTable(tableName).getField(f.getItem(1)));
        }
        this.changeTables = new ArrayList();
        this.alterTables = new ArrayList<AlterTableRestricted>();
        this.dm = new ArrayList<IClosure<? super DBRoot>>();
    }

    public final File getLocalDirectory() {
        return this.dir;
    }

    public final ModuleVersion getLocalVersion() {
        return this.localVersion;
    }

    public final ModuleVersion getLastInstalledVersion() {
        return this.lastInstalledVersion;
    }

    public final DBRoot getRoot() {
        return this.root;
    }

    public final Set<String> getTablesPreviouslyCreated() {
        return this.tables;
    }

    public final Set<SQLField> getFieldsPreviouslyCreated(String tableName) {
        return (Set)this.fields.getNonNull(tableName);
    }

    private final List<String> getSQL() {
        return ChangeTable.cat(this.changeTables, this.root.getName());
    }

    final void execute() throws SQLException {
        List<String> sql = this.getSQL();
        if (sql.size() > 0) {
            for (String string : sql) {
                this.getRoot().getDBSystemRoot().getDataSource().execute(string);
            }
            SQLTable.setUndefIDs(this.getRoot().getSchema(), CollectionUtils.createMap(this.getAddedTables()));
            this.getRoot().getSchema().updateVersion();
            this.getRoot().refetch();
        }
        for (IClosure iClosure : this.dm) {
            iClosure.executeChecked(this.getRoot());
        }
    }

    public final SQLCreateTable getCreateTable(String name) {
        SQLCreateTable res = new SQLCreateTable(this.root, name);
        this.addCreateTable(res);
        return res;
    }

    public final void addCreateTable(SQLCreateTable createTable) {
        if (createTable.getRoot() != this.root) {
            throw new IllegalArgumentException("Not in our root : " + createTable.getRootName());
        }
        String name = createTable.getName();
        if (this.root.contains(name)) {
            throw new IllegalArgumentException("Table already exists : " + name);
        }
        this.changeTables.add(createTable);
    }

    public final AlterTableRestricted getAlterTable(String name) {
        AlterTableRestricted res = new AlterTableRestricted(this, name);
        this.changeTables.add(res.getAlter());
        this.alterTables.add(res);
        return res;
    }

    public final void dropTable(String name) {
        if (!this.getTablesPreviouslyCreated().contains(name)) {
            throw new IllegalArgumentException(String.valueOf(name) + " doesn't belong to this module");
        }
        this.changeTables.add(new DropTable(this.root.getTable(name)));
    }

    public final void manipulateData(IClosure<? super DBRoot> closure) {
        this.dm.add(closure);
    }

    public final void manipulateTable(final String name, final IClosure<SQLTable> closure) {
        this.manipulateData((IClosure<? super DBRoot>)new IClosure<DBRoot>(){

            @Override
            public void executeChecked(DBRoot input) {
                closure.executeChecked(input.getTable(name));
            }
        });
    }

    final List<String> getAddedTables() {
        return new ArrayList<String>(this.getCreateTables().keySet());
    }

    final Map<String, SQLCreateTableBase<?>> getCreateTables() {
        LinkedHashMap res = new LinkedHashMap();
        for (ChangeTable<?> a : this.changeTables) {
            if (!(a instanceof SQLCreateTableBase)) continue;
            res.put(a.getName(), (SQLCreateTableBase)a);
        }
        return res;
    }

    final List<SQLName> getAddedFieldsToExistingTables() {
        ArrayList<SQLName> res = new ArrayList<SQLName>();
        for (AlterTableRestricted a : this.alterTables) {
            for (String f : a.getAddedColumns()) {
                res.add(new SQLName(a.getName(), f));
            }
        }
        return res;
    }

    final List<String> getRemovedTables() {
        ArrayList<String> res = new ArrayList<String>();
        for (ChangeTable<?> a : this.changeTables) {
            if (!(a instanceof DropTable)) continue;
            res.add(a.getName());
        }
        return res;
    }

    final List<SQLName> getRemovedFieldsFromExistingTables() {
        ArrayList<SQLName> res = new ArrayList<SQLName>();
        for (AlterTableRestricted a : this.alterTables) {
            for (String f : a.getRemovedColumns()) {
                res.add(new SQLName(a.getName(), f));
            }
        }
        return res;
    }
}

