/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.SQLJavaEditor;
import org.openconcerto.erp.core.humanresources.payroll.element.PeriodeValiditeSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.element.VariablePayeSQLElement;
import org.openconcerto.erp.preferences.PayeGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;

public class FichePayeModel
extends AbstractTableModel {
    private Vector<SQLRowValues> vectRubrique;
    private Vector<SQLRowValues> vectRowValsToDelete;
    private final Map<String, SQLTable> mapTableSource = new HashMap<String, SQLTable>();
    private int idFiche;
    private String[] title;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tableProfilElt = Configuration.getInstance().getBase().getTable("PROFIL_PAYE_ELEMENT");
    private static final SQLTable tableFichePayeElt = base.getTable("FICHE_PAYE_ELEMENT");
    private static final SQLTable tableFichePaye = base.getTable("FICHE_PAYE");
    private static final SQLTable tableValidite = Configuration.getInstance().getBase().getTable("PERIODE_VALIDITE");
    private SQLJavaEditor javaEdit = new SQLJavaEditor(VariablePayeSQLElement.getMapTree());
    private BigDecimal salBrut;
    private BigDecimal cotPat;
    private BigDecimal cotSal;
    private BigDecimal netImp;
    private BigDecimal netAPayer;
    private BigDecimal csg;
    private BigDecimal csgSansAbattement;
    private Map<Integer, String> mapField;
    private final BigDecimal tauxCSG;

    public FichePayeModel(int idFiche) {
        System.err.println("NEW FICHE PAYE MODEL");
        this.idFiche = idFiche;
        this.vectRubrique = new Vector();
        this.vectRowValsToDelete = new Vector();
        this.title = new String[9];
        this.title[0] = "Libell\u00e9";
        this.title[1] = "Base";
        this.title[2] = "Taux sal.";
        this.title[3] = "Montant sal. \u00e0 ajouter";
        this.title[4] = "Montant sal. \u00e0 d\u00e9duire";
        this.title[5] = "Taux pat.";
        this.title[6] = "Montant pat.";
        this.title[7] = "Impression";
        this.title[8] = "Dans la P\u00e9riode";
        SQLTable tableNet = Configuration.getInstance().getBase().getTable("RUBRIQUE_NET");
        SQLTable tableBrut = Configuration.getInstance().getBase().getTable("RUBRIQUE_BRUT");
        SQLTable tableCotis = Configuration.getInstance().getBase().getTable("RUBRIQUE_COTISATION");
        SQLTable tableComm = Configuration.getInstance().getBase().getTable("RUBRIQUE_COMM");
        this.mapTableSource.put(tableNet.getName(), tableNet);
        this.mapTableSource.put(tableBrut.getName(), tableBrut);
        this.mapTableSource.put(tableCotis.getName(), tableCotis);
        this.mapTableSource.put(tableComm.getName(), tableComm);
        this.mapField = new HashMap<Integer, String>();
        this.mapField.put(new Integer(0), "NOM");
        this.mapField.put(new Integer(1), "NB_BASE");
        this.mapField.put(new Integer(2), "TAUX_SAL");
        this.mapField.put(new Integer(3), "MONTANT_SAL_AJ");
        this.mapField.put(new Integer(4), "MONTANT_SAL_DED");
        this.mapField.put(new Integer(5), "TAUX_PAT");
        this.mapField.put(new Integer(6), "MONTANT_PAT");
        this.mapField.put(new Integer(7), "IMPRESSION");
        this.mapField.put(new Integer(8), "IN_PERIODE");
        SQLPreferences prefs = new SQLPreferences(tableFichePaye.getTable().getDBRoot());
        this.tauxCSG = new BigDecimal(prefs.getDouble(PayeGlobalPreferencePanel.ASSIETTE_CSG, 0.9825));
    }

    private void resetValueFiche() {
        this.salBrut = BigDecimal.ZERO;
        this.cotPat = BigDecimal.ZERO;
        this.cotSal = BigDecimal.ZERO;
        this.netAPayer = BigDecimal.ZERO;
        this.netImp = BigDecimal.ZERO;
        this.csg = BigDecimal.ZERO;
        this.csgSansAbattement = BigDecimal.ZERO;
    }

    public void loadAllElements() {
        System.err.println("Start At " + new Date());
        if (this.idFiche <= 1) {
            System.err.println("Aucune fiche associ\u00e9e");
            return;
        }
        this.resetValueFiche();
        this.vectRubrique = new Vector();
        SQLRow rowFiche = tableFichePaye.getRow(this.idFiche);
        this.javaEdit.setSalarieID(rowFiche.getInt("ID_SALARIE"));
        SQLSelect selAllIDFicheElt = new SQLSelect();
        selAllIDFicheElt.addSelect(tableFichePayeElt.getField("ID"));
        selAllIDFicheElt.addSelect(tableFichePayeElt.getField("POSITION"));
        selAllIDFicheElt.setWhere(new Where((FieldRef)tableFichePayeElt.getField("ID_FICHE_PAYE"), "=", this.idFiche));
        selAllIDFicheElt.setDistinct(true);
        selAllIDFicheElt.addRawOrder("\"FICHE_PAYE_ELEMENT\".\"POSITION\"");
        String reqAllIDFichelElt = selAllIDFicheElt.asString();
        System.err.println("Request " + reqAllIDFichelElt);
        Object[] objIDFicheElt = ((List)base.getDataSource().execute(reqAllIDFichelElt, new ArrayListHandler())).toArray();
        System.err.println(String.valueOf(objIDFicheElt.length) + " elements to load");
        int i = 0;
        while (i < objIDFicheElt.length) {
            SQLRow row = tableFichePayeElt.getRow(Integer.parseInt(((Object[])objIDFicheElt[i])[0].toString()));
            String source = row.getString("SOURCE");
            int idSource = row.getInt("IDSOURCE");
            if (source.trim().length() != 0) {
                if (this.mapTableSource.get(source) != null) {
                    SQLRow rowSource = this.mapTableSource.get(source).getRow(idSource);
                    if (rowSource.getTable().getName().equalsIgnoreCase("RUBRIQUE_BRUT")) {
                        this.loadElementBrut(rowSource, row);
                    }
                    if (rowSource.getTable().getName().equalsIgnoreCase("RUBRIQUE_COTISATION")) {
                        this.loadElementCotisation(rowSource, row);
                    }
                    if (rowSource.getTable().getName().equalsIgnoreCase("RUBRIQUE_NET")) {
                        this.loadElementNet(rowSource, row);
                    }
                    if (rowSource.getTable().getName().equalsIgnoreCase("RUBRIQUE_COMM")) {
                        this.loadElementComm(rowSource, row);
                    }
                } else {
                    System.err.println("Table " + source + " non r\u00e9f\u00e9renc\u00e9e");
                }
            }
            ++i;
        }
        System.err.println(String.valueOf(this.vectRubrique.size()) + " elements ADDed ");
        this.fireTableDataChanged();
        System.err.println("End At " + new Date());
    }

    @Override
    public String getColumnName(int column) {
        return this.title[column];
    }

    @Override
    public int getRowCount() {
        return this.vectRubrique.size();
    }

    @Override
    public int getColumnCount() {
        return this.title.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SQLRowValues row = this.vectRubrique.get(rowIndex);
        Object o = null;
        if (row != null) {
            o = row.getObject(this.mapField.get(new Integer(columnIndex)).toString());
        }
        return o;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<?> cl = tableFichePayeElt.getField(this.mapField.get(new Integer(columnIndex))).getType().getJavaType();
        return cl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containValueAt(int rowIndex, int columnIndex) {
        int idSource;
        if (columnIndex == 0) {
            return true;
        }
        SQLRowValues rowVals = this.vectRubrique.get(rowIndex);
        Object ob = rowVals.getObject("SOURCE");
        String source = ob == null ? "" : ob.toString();
        Object obId = rowVals.getObject("IDSOURCE");
        int n = idSource = obId == null ? 1 : rowVals.getInt("IDSOURCE");
        if (source.trim().length() != 0 && !source.equalsIgnoreCase("RUBRIQUE_COTISATION")) {
            if (columnIndex > 4) {
                return false;
            }
            SQLRow row = this.mapTableSource.get(source).getRow(idSource);
            if (source.equalsIgnoreCase("RUBRIQUE_BRUT")) {
                if (row.getInt("ID_TYPE_RUBRIQUE_BRUT") == 2 && columnIndex == 4) {
                    return false;
                }
                if (row.getInt("ID_TYPE_RUBRIQUE_BRUT") != 3 || columnIndex != 3) return true;
                return false;
            }
            if (!source.equalsIgnoreCase("RUBRIQUE_NET")) return false;
            if (row.getInt("ID_TYPE_RUBRIQUE_NET") == 2 && columnIndex == 4) {
                return false;
            }
            if (row.getInt("ID_TYPE_RUBRIQUE_NET") != 3 || columnIndex != 3) return true;
            return false;
        }
        if (columnIndex != 3) return true;
        return false;
    }

    public void loadFromProfil(int idProfil) {
        System.err.println("Load from profil");
        this.resetValueFiche();
        while (this.vectRubrique.size() > 0) {
            this.vectRowValsToDelete.add(this.vectRubrique.remove(0));
        }
        SQLSelect selAllIDProfilElt = new SQLSelect();
        selAllIDProfilElt.addSelect(tableProfilElt.getField("ID"));
        selAllIDProfilElt.addSelect(tableProfilElt.getField("POSITION"));
        selAllIDProfilElt.setWhere(new Where((FieldRef)tableProfilElt.getField("ID_PROFIL_PAYE"), "=", idProfil));
        selAllIDProfilElt.addRawOrder("\"PROFIL_PAYE_ELEMENT\".\"POSITION\"");
        String reqAllIDProfilElt = selAllIDProfilElt.asString();
        Object[] objIDProfilElt = ((List)Configuration.getInstance().getBase().getDataSource().execute(reqAllIDProfilElt, new ArrayListHandler())).toArray();
        int i = 0;
        while (i < objIDProfilElt.length) {
            SQLRow rowTmp = tableProfilElt.getRow(Integer.parseInt(((Object[])objIDProfilElt[i])[0].toString()));
            String source = rowTmp.getString("SOURCE");
            int idSource = rowTmp.getInt("IDSOURCE");
            if (this.mapTableSource.get(source) != null) {
                SQLRow row = this.mapTableSource.get(source).getRow(idSource);
                if (row.getTable().getName().equalsIgnoreCase("RUBRIQUE_BRUT")) {
                    this.loadElementBrut(row, null);
                }
                if (row.getTable().getName().equalsIgnoreCase("RUBRIQUE_COTISATION")) {
                    this.loadElementCotisation(row, null);
                }
                if (row.getTable().getName().equalsIgnoreCase("RUBRIQUE_NET")) {
                    this.loadElementNet(row, null);
                }
                if (row.getTable().getName().equalsIgnoreCase("RUBRIQUE_COMM")) {
                    this.loadElementComm(row, null);
                }
            } else {
                System.err.println("FichePayeModel.java --> Table non r\u00e9f\u00e9renc\u00e9e dans la Map. Table name : " + source);
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    public String getSourceAt(int rowIndex) {
        return this.vectRubrique.get(rowIndex).getString("SOURCE");
    }

    public int upRow(int rowIndex) {
        if (this.vectRubrique.size() > 1 && rowIndex > 0) {
            System.err.println("UP");
            SQLRowValues tmp = this.vectRubrique.get(rowIndex);
            this.vectRubrique.set(rowIndex, this.vectRubrique.get(rowIndex - 1));
            this.vectRubrique.set(rowIndex - 1, tmp);
            this.fireTableDataChanged();
            return rowIndex - 1;
        }
        System.err.println("can't up!!");
        return rowIndex;
    }

    public int downRow(int rowIndex) {
        if (rowIndex >= 0 && this.vectRubrique.size() > 1 && rowIndex + 1 < this.vectRubrique.size()) {
            System.err.println("DOWN");
            SQLRowValues tmp = this.vectRubrique.get(rowIndex);
            this.vectRubrique.set(rowIndex, this.vectRubrique.get(rowIndex + 1));
            this.vectRubrique.set(rowIndex + 1, tmp);
            this.fireTableDataChanged();
            return rowIndex + 1;
        }
        System.err.println("can't down!!!");
        return rowIndex;
    }

    public void setLastRowAT(int rowIndex) {
        if (rowIndex > 0 && rowIndex < this.vectRubrique.size()) {
            this.vectRubrique.add(rowIndex, this.vectRubrique.remove(this.vectRubrique.size() - 1));
        }
        this.fireTableDataChanged();
    }

    public void setFicheID(int id) {
        this.idFiche = id;
        this.loadAllElements();
    }

    public void addRowAt(SQLRow row, int index) {
        int size = this.vectRubrique.size();
        if (row.getTable().getName().equalsIgnoreCase("RUBRIQUE_BRUT")) {
            this.loadElementBrut(row, null);
        } else if (row.getTable().getName().equalsIgnoreCase("RUBRIQUE_COTISATION")) {
            this.loadElementCotisation(row, null);
        } else if (row.getTable().getName().equalsIgnoreCase("RUBRIQUE_NET")) {
            this.loadElementNet(row, null);
        } else if (row.getTable().getName().equalsIgnoreCase("RUBRIQUE_COMM")) {
            this.loadElementComm(row, null);
        }
        if (size != this.vectRubrique.size()) {
            this.setLastRowAT(index);
        }
        if (!row.getTable().getName().equalsIgnoreCase("RUBRIQUE_COMM")) {
            this.calculValue();
        }
        this.fireTableDataChanged();
    }

    public void removeRow(int rowIndex) {
        if (rowIndex >= 0) {
            SQLRowValues rowVals = this.vectRubrique.remove(rowIndex);
            this.vectRowValsToDelete.add(rowVals);
            if (!rowVals.getString("SOURCE").equalsIgnoreCase("RUBRIQUE_COMM")) {
                this.calculValue();
            }
            this.fireTableDataChanged();
        }
    }

    public void updateFields(int idFiche) {
        SQLRowValues rowVals;
        int i = 0;
        while (i < this.vectRowValsToDelete.size()) {
            rowVals = this.vectRowValsToDelete.get(i);
            if (rowVals.getID() != -1) {
                rowVals.put("ARCHIVE", 1);
                try {
                    rowVals.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        this.vectRowValsToDelete = new Vector();
        i = 0;
        while (i < this.vectRubrique.size()) {
            rowVals = this.vectRubrique.get(i);
            rowVals.put("ID_FICHE_PAYE", idFiche);
            rowVals.put("POSITION", i);
            try {
                rowVals.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void showData() {
        if (this.vectRubrique.size() == 0) {
            System.err.println("Vecteur contains no value.");
        }
        int i = 0;
        while (i < this.vectRubrique.size()) {
            System.err.println(this.vectRubrique.get(i));
            ++i;
        }
    }

    public Object getVectorObjectAt(int index) {
        return this.vectRubrique.get(index);
    }

    private boolean isEltInPeriod(SQLRow rowSource) {
        SQLRow rowFiche = tableFichePaye.getRow(this.idFiche);
        int mois = rowFiche.getInt("ID_MOIS") - 1;
        String ob = PeriodeValiditeSQLElement.mapTranslate().get(mois);
        if (ob == null) {
            return false;
        }
        String moisName = ob.toString();
        SQLRow rowPeriodeValid = tableValidite.getRow(rowSource.getInt("ID_PERIODE_VALIDITE"));
        return rowPeriodeValid.getBoolean(moisName);
    }

    private boolean isEltImprimable(SQLRow rowSource, SQLRowValues row) {
        int impression = rowSource.getInt("ID_IMPRESSION_RUBRIQUE");
        if (impression == 3) {
            return true;
        }
        if (impression == 4) {
            return false;
        }
        if (impression == 2) {
            BigDecimal montantPat;
            BigDecimal montantSalAjOb = row.getBigDecimal("MONTANT_SAL_AJ");
            BigDecimal montantSalAj = montantSalAjOb == null ? BigDecimal.ZERO : montantSalAjOb;
            BigDecimal montantSalDedOb = row.getBigDecimal("MONTANT_SAL_DED");
            BigDecimal montantSalDed = montantSalDedOb == null ? BigDecimal.ZERO : montantSalDedOb;
            BigDecimal montantPatOb = row.getBigDecimal("MONTANT_PAT");
            BigDecimal bigDecimal = montantPat = montantPatOb == null ? BigDecimal.ZERO : montantPatOb;
            return montantSalAj.signum() != 0 || montantSalDed.signum() != 0 || montantPat.signum() != 0;
        }
        return true;
    }

    private boolean loadElement(SQLRowValues rowVals, SQLRow rowSource, SQLRow row) {
        if (row != null) {
            rowVals.loadAbsolutelyAll(row);
        }
        rowVals.put("IN_PERIODE", this.isEltInPeriod(rowSource));
        rowVals.put("SOURCE", rowSource.getTable().getName());
        rowVals.put("IDSOURCE", rowSource.getID());
        Object ob = rowVals.getObject("VALIDE");
        boolean b = ob == null ? false : new Boolean(ob.toString());
        return b;
    }

    private void updateValueFiche() {
        SQLRowValues rowValsFiche = new SQLRowValues(tableFichePaye);
        rowValsFiche.put("SAL_BRUT", this.salBrut);
        rowValsFiche.put("NET_IMP", this.netImp.add(this.salBrut));
        rowValsFiche.put("NET_A_PAYER", this.netAPayer.add(this.salBrut));
        rowValsFiche.put("COT_SAL", this.cotSal);
        rowValsFiche.put("COT_PAT", this.cotPat);
        rowValsFiche.put("CSG", this.salBrut.add(this.csg).multiply(this.tauxCSG).add(this.csgSansAbattement));
        try {
            rowValsFiche.update(this.idFiche);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadElementBrut(SQLRow rowSource, SQLRow row) {
        SQLRowValues rowVals = new SQLRowValues(tableFichePayeElt);
        if (!this.loadElement(rowVals, rowSource, row)) {
            Object baseOb = this.javaEdit.checkFormule(rowSource.getString("BASE"), "BASE");
            Object tauxSalOb = this.javaEdit.checkFormule(rowSource.getString("TAUX"), "TAUX");
            rowVals.put("NOM", rowSource.getString("NOM"));
            rowVals.put("NB_BASE", baseOb == null ? null : new BigDecimal(baseOb.toString()));
            rowVals.put("TAUX_SAL", tauxSalOb == null ? null : new BigDecimal(tauxSalOb.toString()));
        }
        this.calculBrut(rowSource, rowVals);
        boolean b = this.isEltImprimable(rowSource, rowVals);
        rowVals.put("IMPRESSION", b);
        this.vectRubrique.add(rowVals);
    }

    private void calculBrut(SQLRow rowSource, SQLRowValues rowVals) {
        if (rowVals.getBoolean("IN_PERIODE").booleanValue()) {
            Object montantNet;
            BigDecimal montantNetS;
            BigDecimal baseOb = rowVals.getBigDecimal("NB_BASE");
            BigDecimal tauxSalOb = rowVals.getBigDecimal("TAUX_SAL");
            BigDecimal base = baseOb == null ? BigDecimal.ZERO : baseOb;
            BigDecimal tauxSal = tauxSalOb == null ? BigDecimal.ZERO : tauxSalOb;
            String formuleMontant = rowSource.getString("MONTANT");
            BigDecimal montant = BigDecimal.ZERO;
            montant = formuleMontant.trim().length() == 0 ? base.multiply(tauxSal).setScale(2, RoundingMode.HALF_UP) : (montantNetS = (montantNet = this.javaEdit.checkFormule(rowSource.getString("MONTANT"), "MONTANT")) == null ? BigDecimal.ZERO : new BigDecimal(montantNet.toString()));
            if (rowSource.getInt("ID_TYPE_RUBRIQUE_BRUT") == 3) {
                rowVals.put("MONTANT_SAL_DED", montant);
                this.salBrut = this.salBrut.subtract(montant);
            } else {
                rowVals.put("MONTANT_SAL_AJ", montant);
                this.salBrut = this.salBrut.add(montant);
            }
            this.updateValueFiche();
        }
    }

    private void calculNet(SQLRow rowSource, SQLRowValues rowVals) {
        if (rowVals.getBoolean("IN_PERIODE").booleanValue()) {
            BigDecimal baseOb = rowVals.getBigDecimal("NB_BASE");
            BigDecimal tauxSalOb = rowVals.getBigDecimal("TAUX_SAL");
            BigDecimal base = baseOb == null ? BigDecimal.ZERO : baseOb;
            BigDecimal tauxSal = tauxSalOb == null ? BigDecimal.ZERO : tauxSalOb;
            String formuleMontant = rowSource.getString("MONTANT");
            BigDecimal montant = BigDecimal.ZERO;
            if (formuleMontant.trim().length() == 0) {
                montant = base.multiply(tauxSal).setScale(2, RoundingMode.HALF_UP);
            } else {
                Object montantNet = this.javaEdit.checkFormule(rowSource.getString("MONTANT"), "MONTANT");
                if (montantNet != null) {
                    montant = new BigDecimal(montantNet.toString());
                }
            }
            if (rowSource.getInt("ID_TYPE_RUBRIQUE_NET") == 3) {
                rowVals.put("MONTANT_SAL_DED", montant);
                this.netAPayer = this.netAPayer.subtract(montant);
                if (!rowSource.getBoolean("IMPOSABLE").booleanValue()) {
                    this.netImp = this.netImp.subtract(montant);
                }
            } else {
                rowVals.put("MONTANT_SAL_AJ", montant);
                this.netAPayer = this.netAPayer.add(montant);
                if (!rowSource.getBoolean("IMPOSABLE").booleanValue()) {
                    this.netImp = this.netImp.add(montant);
                }
            }
            this.updateValueFiche();
        }
    }

    private void loadElementNet(SQLRow rowSource, SQLRow row) {
        SQLRowValues rowVals = new SQLRowValues(tableFichePayeElt);
        if (!this.loadElement(rowVals, rowSource, row)) {
            Object baseOb = this.javaEdit.checkFormule(rowSource.getString("BASE"), "BASE");
            Object tauxSalOb = this.javaEdit.checkFormule(rowSource.getString("TAUX"), "TAUX");
            rowVals.put("NOM", rowSource.getString("NOM"));
            rowVals.put("NB_BASE", baseOb == null ? null : new BigDecimal(baseOb.toString()));
            rowVals.put("TAUX_SAL", tauxSalOb == null ? null : new BigDecimal(tauxSalOb.toString()));
        }
        this.calculNet(rowSource, rowVals);
        boolean b = this.isEltImprimable(rowSource, rowVals);
        rowVals.put("IMPRESSION", b);
        this.vectRubrique.add(rowVals);
    }

    private void calculCotisation(SQLRow rowSource, SQLRowValues rowVals) {
        if (((Boolean)rowVals.getObject("IN_PERIODE")).booleanValue()) {
            BigDecimal baseOb = rowVals.getBigDecimal("NB_BASE");
            BigDecimal tauxSalOb = rowVals.getBigDecimal("TAUX_SAL");
            BigDecimal tauxPatOb = rowVals.getBigDecimal("TAUX_PAT");
            BigDecimal base = baseOb == null ? BigDecimal.ZERO : baseOb;
            BigDecimal tauxSal = tauxSalOb == null ? BigDecimal.ZERO : tauxSalOb;
            BigDecimal tauxPat = tauxPatOb == null ? BigDecimal.ZERO : tauxPatOb;
            BigDecimal montantSal = base.multiply(tauxSal).movePointLeft(2).setScale(2, RoundingMode.HALF_UP);
            BigDecimal montantPat = base.multiply(tauxPat).movePointLeft(2).setScale(2, RoundingMode.HALF_UP);
            rowVals.put("MONTANT_SAL_DED", montantSal);
            rowVals.put("MONTANT_PAT", montantPat);
            this.netAPayer = this.netAPayer.subtract(montantSal);
            if (!rowSource.getBoolean("IMPOSABLE").booleanValue()) {
                this.netImp = this.netImp.subtract(montantSal);
            }
            if (rowSource.getBoolean("PART_PAT_IMPOSABLE").booleanValue()) {
                this.netImp = this.netImp.add(montantPat);
            }
            if (rowSource.getBoolean("PART_CSG").booleanValue()) {
                this.csg = this.csg.add(montantPat);
            }
            if (rowSource.getBoolean("PART_CSG_SANS_ABATTEMENT").booleanValue()) {
                this.csgSansAbattement = this.csgSansAbattement.add(montantPat);
            }
            this.cotSal = this.cotSal.add(montantSal);
            this.cotPat = this.cotPat.add(montantPat);
            this.updateValueFiche();
        }
    }

    private void loadElementCotisation(final SQLRow rowSource, SQLRow row) {
        SQLRowValues rowVals = new SQLRowValues(tableFichePayeElt);
        if (!this.loadElement(rowVals, rowSource, row)) {
            Object baseOb = this.javaEdit.checkFormule(rowSource.getString("BASE"), "BASE");
            if (!this.javaEdit.isCodeValid()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "La formule BASE pour la rubrique " + rowSource.getString("CODE") + " n'est pas correcte!");
                    }
                });
            }
            Object tauxSalOb = this.javaEdit.checkFormule(rowSource.getString("TX_SAL"), "TX_SAL");
            if (!this.javaEdit.isCodeValid()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "La formule TX_SAL pour la rubrique " + rowSource.getString("CODE") + " n'est pas correcte!");
                    }
                });
            }
            Object tauxPatOb = this.javaEdit.checkFormule(rowSource.getString("TX_PAT"), "TX_PAT");
            if (!this.javaEdit.isCodeValid()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "La formule TX_PAT pour la rubrique " + rowSource.getString("CODE") + " n'est pas correcte!");
                    }
                });
            }
            rowVals.put("NOM", rowSource.getString("NOM"));
            rowVals.put("NB_BASE", baseOb == null ? null : new BigDecimal(baseOb.toString()));
            rowVals.put("TAUX_SAL", tauxSalOb == null ? null : new BigDecimal(tauxSalOb.toString()));
            rowVals.put("TAUX_PAT", tauxPatOb == null ? null : new BigDecimal(tauxPatOb.toString()));
        }
        this.calculCotisation(rowSource, rowVals);
        boolean b = this.isEltImprimable(rowSource, rowVals);
        rowVals.put("IMPRESSION", b);
        this.vectRubrique.add(rowVals);
    }

    public void loadElementComm(SQLRow rowSource, SQLRow row) {
        SQLRowValues rowVals = new SQLRowValues(tableFichePayeElt);
        if (this.loadElement(rowVals, rowSource, row)) {
            this.vectRubrique.add(rowVals);
            return;
        }
        Object baseOb = this.javaEdit.checkFormule(rowSource.getString("NB_BASE"), "BASE");
        Object tauxSalOb = this.javaEdit.checkFormule(rowSource.getString("TAUX_SAL"), "SAL");
        Object tauxPatOb = this.javaEdit.checkFormule(rowSource.getString("TAUX_PAT"), "PAT");
        Object montantPatOb = this.javaEdit.checkFormule(rowSource.getString("MONTANT_PAT"), "MONTANT");
        Object montantAdOb = this.javaEdit.checkFormule(rowSource.getString("MONTANT_SAL_AJ"), "MONTANT");
        Object montantDedOb = this.javaEdit.checkFormule(rowSource.getString("MONTANT_SAL_DED"), "MONTANT");
        rowVals.put("NOM", rowSource.getBoolean("NOM_VISIBLE") != false ? rowSource.getString("NOM") : "");
        rowVals.put("NB_BASE", baseOb == null ? null : new BigDecimal(baseOb.toString()));
        rowVals.put("TAUX_SAL", tauxSalOb == null ? null : new BigDecimal(tauxSalOb.toString()));
        rowVals.put("TAUX_PAT", tauxPatOb == null ? null : new BigDecimal(tauxPatOb.toString()));
        rowVals.put("MONTANT_PAT", montantPatOb == null ? null : new BigDecimal(montantPatOb.toString()));
        rowVals.put("MONTANT_SAL_AJ", montantAdOb == null ? null : new BigDecimal(montantAdOb.toString()));
        rowVals.put("MONTANT_SAL_DED", montantDedOb == null ? null : new BigDecimal(montantDedOb.toString()));
        boolean b = this.isEltImprimable(rowSource, rowVals);
        rowVals.put("IMPRESSION", b);
        this.vectRubrique.add(rowVals);
    }

    private void calculValue() {
        System.err.println("Start calculValue At " + new Date());
        this.resetValueFiche();
        Vector<SQLRowValues> vectTmp = new Vector<SQLRowValues>(this.vectRubrique);
        this.vectRubrique = new Vector();
        int i = 0;
        while (i < vectTmp.size()) {
            SQLRowValues rowVals = vectTmp.get(i);
            String source = rowVals.getString("SOURCE");
            int idSource = rowVals.getInt("IDSOURCE");
            SQLRow row = tableFichePayeElt.getRow(rowVals.getID());
            if (source.trim().length() != 0) {
                if (this.mapTableSource.get(source) != null) {
                    SQLRow rowSource = this.mapTableSource.get(source).getRow(idSource);
                    if (rowSource.getTable().getName().equalsIgnoreCase("RUBRIQUE_BRUT")) {
                        this.loadElementBrut(rowSource, row);
                    }
                    if (rowSource.getTable().getName().equalsIgnoreCase("RUBRIQUE_COTISATION")) {
                        this.loadElementCotisation(rowSource, row);
                    }
                    if (rowSource.getTable().getName().equalsIgnoreCase("RUBRIQUE_NET")) {
                        this.loadElementNet(rowSource, row);
                    }
                    if (rowSource.getTable().getName().equalsIgnoreCase("RUBRIQUE_COMM")) {
                        this.loadElementComm(rowSource, row);
                    }
                } else {
                    System.err.println("Table " + source + " non r\u00e9f\u00e9renc\u00e9e");
                }
            }
            ++i;
        }
        System.err.println(String.valueOf(this.vectRubrique.size()) + " elements ADDed ");
        this.fireTableDataChanged();
        System.err.println("End calculValue At " + new Date());
    }

    public void validElt() {
        System.err.println("Validation des \u00e9l\u00e9ments de la fiche.");
        int i = 0;
        while (i < this.vectRubrique.size()) {
            SQLRowValues rowVals = this.vectRubrique.get(i);
            rowVals.put("VALIDE", true);
            try {
                rowVals.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        System.err.println("Validation termin\u00e9e.");
    }
}

